/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.eclipse.persistence.tools.workbench.ant.taskdefs.ProjectTask;

public abstract class TopLinkTask
extends ProjectTask {
    private String sessionsFile;
    private String sessionName;
    public static final String SESSIONS_XML = "sessions.xml";

    protected TopLinkTask() {
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.sessionsFile = "";
        this.sessionName = "";
    }

    protected String getSessionsFile() {
        return this.sessionsFile;
    }

    public void setSessionsFile(String sessionsFile) {
        this.sessionsFile = sessionsFile;
    }

    protected String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    @Override
    protected void preExecute() throws BuildException {
        super.preExecute();
        if (this.sessionsFile.length() == 0) {
            this.setSessionsFile(SESSIONS_XML);
        } else {
            File sessions = new File(this.sessionsFile);
            String path = sessions.getParent();
            String fileName = sessions.getName();
            this.setSessionsFile(fileName);
            if (path != null) {
                this.setUserClasspath(path);
            }
        }
        if (this.sessionName.length() == 0) {
            throw new BuildException(this.stringRepository.getString("notDefined", "SessionName"));
        }
    }
}

