/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.generation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumnPair;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTypeNames;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.generation.MWRelationshipHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAbstractTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWDirectToFieldMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.relational.MWRelationalProject;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class MWDescriptorGenerator
implements MWTypeNames {
    private volatile MWRelationalProject project;
    private Collection tables;
    private volatile String packageName;
    private volatile boolean generateBidirectionalRelationships;
    private volatile boolean generateEjbs;
    private volatile boolean generateLocalInterfaces;
    private volatile boolean generateRemoteInterfaces;
    private volatile boolean generateMethodAccessors;
    private Collection relationshipsToCreate = new Vector();
    private Map tableToDescriptorDictionary = new HashMap();
    private Map relationshipToMappingDictionary = new HashMap();

    private String defaultInstanceVariableName(MWRelationshipHolder relationshipHolder, MWClass sourceClass, String targetClassShortName) {
        if (!relationshipHolder.isForeignKeyInTargetTable() && relationshipHolder.getReference().columnPairsSize() == 1) {
            String columnName = ((MWColumnPair)relationshipHolder.getReference().columnPairs().next()).getSourceColumn().getName();
            if ((columnName = columnName.replace(' ', '_')).toUpperCase().endsWith("_ID")) {
                columnName = columnName.substring(0, columnName.length() - 3);
            }
            return StringTools.convertAllCapsToCamelBack(columnName, false);
        }
        return StringTools.uncapitalize(targetClassShortName);
    }

    private void ensureBackPointersIncluded() {
        Vector<MWRelationshipHolder> backPointersToCreate = new Vector<MWRelationshipHolder>();
        for (MWRelationshipHolder relHolder : this.relationshipsToCreate) {
            boolean foreignKeyInTargetTable;
            MWReference ref;
            if (!relHolder.isOneToMany() || this.getRelationshipToCreate(ref = relHolder.getReference(), foreignKeyInTargetTable = false) != null) continue;
            MWRelationshipHolder backPointer = new MWRelationshipHolder(ref, foreignKeyInTargetTable);
            backPointer.setOneToOne();
            backPointersToCreate.add(backPointer);
        }
        this.relationshipsToCreate.addAll(backPointersToCreate);
    }

    private void ensureSpecCompliance() {
        for (MWDescriptor mWDescriptor : this.tableToDescriptorDictionary.values()) {
        }
    }

    private void generateBidirectionalRelationships() {
        for (MWRelationshipHolder relationship : this.relationshipsToCreate) {
            MWRelationshipHolder relationshipPartner = this.getRelationshipToCreate(relationship.getReference(), !relationship.isForeignKeyInTargetTable());
            MWAbstractTableReferenceMapping tableRefMapping = (MWAbstractTableReferenceMapping)this.relationshipToMappingDictionary.get(relationship);
            MWAbstractTableReferenceMapping tableRefMappingPartner = (MWAbstractTableReferenceMapping)this.relationshipToMappingDictionary.get(relationshipPartner);
            if (tableRefMappingPartner == null) continue;
            tableRefMapping.setMaintainsBidirectionalRelationship(true);
            tableRefMapping.setRelationshipPartnerMapping(tableRefMappingPartner);
            tableRefMappingPartner.setMaintainsBidirectionalRelationship(true);
            tableRefMappingPartner.setRelationshipPartnerMapping(tableRefMapping);
        }
    }

    public void generateClassesAndDescriptors() {
        this.ensureBackPointersIncluded();
        for (MWTable table : this.tables) {
            MWTableDescriptor descriptor;
            String typeName = table.getShortName();
            typeName = typeName.replace(' ', '_');
            typeName = StringTools.convertAllCapsToCamelBack(typeName);
            String ejbName = ClassTools.shortNameForClassNamed(typeName);
            if (this.packageName != null && this.packageName.length() != 0) {
                typeName = this.packageName + '.' + typeName;
            }
            if (this.getProject().getRepository().typeNamedIgnoreCase(typeName) != null) {
                typeName = this.generateUniqueCaseInsensitiveName(typeName);
            }
            if (this.generateEjbs) {
                typeName = typeName + "EJB";
            }
            MWClass type = this.getProject().typeNamed(typeName);
            type.clear();
            MWDescriptor existingDescriptor = this.getProject().descriptorForType(type);
            if (existingDescriptor != null) {
                this.getProject().removeDescriptor(existingDescriptor);
            }
            type.addZeroArgumentConstructor();
            try {
                descriptor = (MWTableDescriptor)this.getProject().addDescriptorForType(type);
            }
            catch (InterfaceDescriptorCreationException ex) {
                throw new RuntimeException(ex);
            }
            descriptor.setPrimaryTable(table);
            this.tableToDescriptorDictionary.put(table, descriptor);
        }
        this.generateInstanceVariablesAndMappings();
        this.ensureSpecCompliance();
    }

    private void generateDirectMapping(MWTableDescriptor descriptor, MWColumn column) {
        Collection mappings = descriptor.allWritableMappingsForField(column);
        if (!mappings.isEmpty() && !column.isPrimaryKey()) {
            return;
        }
        MWClassAttribute instVar = this.generateInstanceVariable(descriptor, column);
        if (column.isPrimaryKey() && !CollectionTools.contains(((MWRelationalTransactionalPolicy)descriptor.getTransactionalPolicy()).getPrimaryKeyPolicy().primaryKeys(), (Object)column)) {
            ((MWRelationalTransactionalPolicy)descriptor.getTransactionalPolicy()).getPrimaryKeyPolicy().addPrimaryKey(column);
        }
        MWDirectToFieldMapping dtfMapping = (MWDirectToFieldMapping)descriptor.addDirectMapping(instVar);
        dtfMapping.setColumn(column);
    }

    private void generateDirectMappings() {
        for (MWTable table : this.tableToDescriptorDictionary.keySet()) {
            MWTableDescriptor descriptor = (MWTableDescriptor)this.tableToDescriptorDictionary.get(table);
            Iterator fields = table.columns();
            while (fields.hasNext()) {
                this.generateDirectMapping(descriptor, (MWColumn)fields.next());
            }
        }
    }

    private MWClassAttribute generateInstanceVariable(MWTableDescriptor descriptor, String instanceVariableName, MWClass instanceVariableType) {
        return this.retrieveOrGenerateInstanceVariable(descriptor, instanceVariableName, instanceVariableType, 0);
    }

    private MWClassAttribute retrieveOrGenerateInstanceVariable(MWTableDescriptor descriptor, String instanceVariableName, MWClass instanceVariableType, int instanceVariableArrayDepth) {
        MWClassAttribute instanceVariable = this.retrieveAttribute(descriptor, instanceVariableName, instanceVariableType, instanceVariableArrayDepth);
        if (instanceVariable == null) {
            instanceVariable = descriptor.getMWClass().addAttribute(instanceVariableName, instanceVariableType, instanceVariableArrayDepth);
        }
        instanceVariable.getModifier().setPrivate(true);
        return instanceVariable;
    }

    private MWClassAttribute retrieveEjb20Attribute(MWTableDescriptor descriptor, String instanceVariableName, MWClass instanceVariableType, int instanceVariableArrayDepth) {
        MWClassAttribute instanceVariable = descriptor.getMWClass().attributeNamedFromCombinedAll(instanceVariableName);
        if (instanceVariable != null && descriptor.mappingForAttribute(instanceVariable) == null) {
            instanceVariable.setType(instanceVariableType);
            instanceVariable.setDimensionality(instanceVariableArrayDepth);
            instanceVariable.getModifier().setPrivate(true);
            instanceVariable.setEjb20Attribute(true);
        }
        return instanceVariable;
    }

    private MWClassAttribute retrieveAttribute(MWTableDescriptor descriptor, String instanceVariableName, MWClass instanceVariableType, int instanceVariableArrayDepth) {
        MWClassAttribute instanceVariable = descriptor.getMWClass().attributeNamedFromAll(instanceVariableName);
        if (instanceVariable != null && descriptor.mappingForAttribute(instanceVariable) == null) {
            instanceVariable.setType(instanceVariableType);
            instanceVariable.setDimensionality(instanceVariableArrayDepth);
            instanceVariable.getModifier().setPrivate(true);
        }
        return instanceVariable;
    }

    private MWClassAttribute generateInstanceVariable(MWTableDescriptor descriptor, MWColumn column) {
        String ivName = column.getName().replace(' ', '_');
        ivName = StringTools.convertAllCapsToCamelBack(ivName, false);
        ivName = NameTools.uniqueJavaNameFor(ivName, descriptor.getMWClass().attributeNames());
        MWClass instanceVariableType = this.project.typeNamed(column.javaTypeDeclaration().getJavaClassName());
        int instanceVariableArrayDepth = column.javaTypeDeclaration().getArrayDepth();
        MWClassAttribute instanceVariable = this.retrieveOrGenerateInstanceVariable(descriptor, ivName, instanceVariableType, instanceVariableArrayDepth);
        if (this.generateMethodAccessors) {
            instanceVariable.generateAllAccessors();
        }
        return instanceVariable;
    }

    private void generateInstanceVariablesAndMappings() {
        this.generateRelationshipMappings();
        this.generateDirectMappings();
    }

    private MWOneToManyMapping generateOneToManyMapping(MWTableDescriptor sourceDescriptor, MWClassAttribute attribute) {
        MWOneToManyMapping oneToManyMapping = sourceDescriptor.addOneToManyMapping(attribute);
        oneToManyMapping.setUseTransparentIndirection();
        return oneToManyMapping;
    }

    private MWOneToOneMapping generateOneToOneMapping(MWTableDescriptor sourceDescriptor, MWClassAttribute attribute) {
        MWOneToOneMapping oneToOneMapping = sourceDescriptor.addOneToOneMapping(attribute);
        oneToOneMapping.setUseValueHolderIndirection();
        return oneToOneMapping;
    }

    private void generateReferenceMapping(MWRelationshipHolder relationshipHolder) {
        MWTableDescriptor sourceDescriptor = this.getDescriptorForTable(relationshipHolder.getRelationshipSourceTable());
        MWTableDescriptor targetDescriptor = this.getDescriptorForTable(relationshipHolder.getRelationshipTargetTable());
        MWClassAttribute newVariable = this.generateRelationshipInstanceVariable(relationshipHolder, sourceDescriptor, targetDescriptor);
        MWAbstractTableReferenceMapping referenceMapping = relationshipHolder.isOneToOne() ? this.generateOneToOneMapping(sourceDescriptor, newVariable) : this.generateOneToManyMapping(sourceDescriptor, newVariable);
        this.relationshipToMappingDictionary.put(relationshipHolder, referenceMapping);
        referenceMapping.setReferenceDescriptor(targetDescriptor);
        referenceMapping.setReference(relationshipHolder.getReference());
        if (relationshipHolder.isForeignKeyInTargetTable() && referenceMapping.isOneToOneMapping()) {
            Iterator i = relationshipHolder.getReference().columnPairs();
            while (i.hasNext()) {
                ((MWOneToOneMapping)referenceMapping).addTargetForeignKey((MWColumnPair)i.next());
            }
        }
    }

    private void generateRelationshipMappings() {
        for (MWRelationshipHolder relationshipHolder : this.relationshipsToCreate) {
            this.generateReferenceMapping(relationshipHolder);
        }
        if (this.generateBidirectionalRelationships) {
            this.generateBidirectionalRelationships();
        }
    }

    private String generateUniqueCaseInsensitiveName(String typeName) {
        int index = 0;
        boolean notUnique = true;
        String newTypeName = null;
        while (notUnique) {
            newTypeName = typeName + String.valueOf(++index);
            notUnique = this.getProject().getRepository().typeNamedIgnoreCase(newTypeName) != null;
        }
        return newTypeName;
    }

    private MWClassAttribute generateRelationshipInstanceVariable(MWRelationshipHolder relationshipHolder, MWTableDescriptor sourceDescriptor, MWTableDescriptor targetDescriptor) {
        MWClassAttribute attribute;
        MWClass sourceClass = sourceDescriptor.getMWClass();
        String targetClassShortName = targetDescriptor.getMWClass().shortName();
        if (targetClassShortName.endsWith("EJB")) {
            targetClassShortName = targetClassShortName.substring(0, targetClassShortName.length() - 3);
        }
        MWClass targetClass = targetDescriptor.getMWClass();
        String attributeName = this.defaultInstanceVariableName(relationshipHolder, sourceClass, targetClassShortName);
        if (relationshipHolder.isOneToMany()) {
            attributeName = NameTools.uniqueNameFor(attributeName + "Collection", sourceClass.attributeNames());
            MWClass attributeType = this.getCollectionClass();
            attribute = this.generateInstanceVariable(sourceDescriptor, attributeName, attributeType);
            attribute.setItemType(targetClass);
        } else {
            attributeName = NameTools.uniqueJavaNameFor(attributeName, sourceClass.attributeNames());
            MWClass attributeType = this.getValueHolderClass();
            attribute = this.generateInstanceVariable(sourceDescriptor, attributeName, attributeType);
            attribute.setValueType(targetClass);
        }
        if (this.generateMethodAccessors) {
            attribute.generateAllAccessors();
        }
        return attribute;
    }

    private MWClass getCollectionClass() {
        return this.project.typeNamed("java.util.Collection");
    }

    private MWTableDescriptor getDescriptorForTable(MWTable table) {
        return (MWTableDescriptor)this.tableToDescriptorDictionary.get(table);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public MWRelationalProject getProject() {
        return this.project;
    }

    private MWRelationshipHolder getRelationshipToCreate(MWReference reference, boolean foreignKeyInTargetTable) {
        for (MWRelationshipHolder holder : this.relationshipsToCreate) {
            if (holder.getReference() != reference || holder.isForeignKeyInTargetTable() != foreignKeyInTargetTable) continue;
            return holder;
        }
        return null;
    }

    private MWClass getValueHolderClass() {
        return this.project.typeNamed("org.eclipse.persistence.indirection.ValueHolderInterface");
    }

    public void setGenerateBidirectionalRelationships(boolean generateBidirectionalRelationships) {
        this.generateBidirectionalRelationships = generateBidirectionalRelationships;
    }

    public void setGenerateEjbs(boolean generateEjbs) {
        this.generateEjbs = generateEjbs;
    }

    public void setGenerateLocalInterfaces(boolean generateLocalInterfaces) {
        this.generateLocalInterfaces = generateLocalInterfaces;
    }

    public void setGenerateMethodAccessors(boolean generateAccessors) {
        this.generateMethodAccessors = generateAccessors;
    }

    public void setGenerateRemoteInterfaces(boolean generateRemoteInterfaces) {
        this.generateRemoteInterfaces = generateRemoteInterfaces;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setProject(MWRelationalProject project) {
        this.project = project;
    }

    public void setRelationshipsToCreate(Collection relationshipsToCreate) {
        this.relationshipsToCreate = relationshipsToCreate;
    }

    public void setTables(Collection tables) {
        this.tables = tables;
    }

    public boolean shouldGenerateLocalInterfaces() {
        return this.generateLocalInterfaces;
    }

    public boolean shouldGenerateRemoteInterfaces() {
        return this.generateRemoteInterfaces;
    }
}

