/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.ClassNameConversionRequired;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.sessions.Session;

public class ConverterClass
implements Converter,
ClassNameConversionRequired {
    protected boolean isForMapKey;
    protected boolean disableConversion;
    protected Class fieldClassification;
    protected String fieldClassificationName;
    protected String attributeConverterClassName;
    protected AttributeConverter attributeConverter;

    public ConverterClass(String attributeConverterClassName, boolean isForMapKey, String fieldClassificationName, boolean disableConversion) {
        this.isForMapKey = isForMapKey;
        this.disableConversion = disableConversion;
        this.fieldClassificationName = fieldClassificationName;
        this.attributeConverterClassName = attributeConverterClassName;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block13: {
            block12: {
                Class attributeConverterClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            attributeConverterClass = AccessController.doPrivileged(new PrivilegedClassForName(this.attributeConverterClassName, true, classLoader));
                            this.attributeConverter = (AttributeConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeConverterClass));
                            break block12;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception.getException());
                        }
                    }
                    attributeConverterClass = PrivilegedAccessHelper.getClassForName(this.attributeConverterClassName, true, classLoader);
                    this.attributeConverter = (AttributeConverter)PrivilegedAccessHelper.newInstanceFromClass(attributeConverterClass);
                }
                catch (ClassNotFoundException exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
                }
                catch (IllegalAccessException exception) {
                    throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
                }
                catch (InstantiationException exception) {
                    throw ValidationException.errorInstantiatingClass(attributeConverterClass, exception);
                }
            }
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.fieldClassification = AccessController.doPrivileged(new PrivilegedClassForName(this.fieldClassificationName, true, classLoader));
                        break block13;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.fieldClassificationName, exception.getException());
                    }
                }
                this.fieldClassification = PrivilegedAccessHelper.getClassForName(this.fieldClassificationName, true, classLoader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeConverterClassName, exception);
            }
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        try {
            return this.attributeConverter.convertToEntityAttribute(dataValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("wrap_convert_exception", new Object[]{"convertToEntityAttribute", this.attributeConverterClassName, dataValue}), (Throwable)re);
        }
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        try {
            return this.attributeConverter.convertToDatabaseColumn(objectValue);
        }
        catch (RuntimeException re) {
            throw new PersistenceException(ExceptionLocalization.buildMessage("wrap_convert_exception", new Object[]{"convertToDatabaseColumn", this.attributeConverterClassName, objectValue}), (Throwable)re);
        }
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        if (mapping.isDirectToFieldMapping()) {
            DirectToFieldMapping m = (DirectToFieldMapping)mapping;
            if (this.disableConversion) {
                m.setConverter(null);
            } else {
                m.setConverter(this);
                m.setFieldClassification(this.fieldClassification);
                m.setFieldClassificationClassName(this.fieldClassificationName);
            }
        } else if (mapping.isDirectMapMapping() && this.isForMapKey) {
            DirectMapMapping m = (DirectMapMapping)mapping;
            if (this.disableConversion) {
                m.setKeyConverter(null);
            } else {
                m.setKeyConverter(this);
                m.setDirectKeyFieldClassification(this.fieldClassification);
                m.setDirectKeyFieldClassificationName(this.fieldClassificationName);
            }
        } else if (mapping.isDirectCollectionMapping()) {
            DirectCollectionMapping m = (DirectCollectionMapping)mapping;
            if (this.disableConversion) {
                m.setValueConverter(null);
            } else {
                m.setValueConverter(this);
                m.setDirectFieldClassification(this.fieldClassification);
                m.setDirectFieldClassificationName(this.fieldClassificationName);
            }
        }
    }

    @Override
    public boolean isMutable() {
        return false;
    }
}

