/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.PessimisticLockException;
import javax.persistence.PessimisticLockScope;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.persistence.TemporalType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.PersistenceUnitLoadingException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BatchValueHolder;
import org.eclipse.persistence.internal.indirection.QueryBasedValueHolder;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.deployment.JPAInitializer;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.jdbc.DataSourceImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.JpaEntityManagerFactory;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.platform.server.ServerPlatformUtils;
import org.eclipse.persistence.platform.server.was.WebSphere_7_Platform;
import org.eclipse.persistence.platform.server.wls.WebLogic_12_Platform;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.CopyGroup;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.ConnectionWrapper;
import org.eclipse.persistence.testing.framework.DriverWrapper;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AddressType;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Bungalow;
import org.eclipse.persistence.testing.models.jpa.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Canoe;
import org.eclipse.persistence.testing.models.jpa.advanced.ConcreteJob;
import org.eclipse.persistence.testing.models.jpa.advanced.Customer;
import org.eclipse.persistence.testing.models.jpa.advanced.Customizer;
import org.eclipse.persistence.testing.models.jpa.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.advanced.Door;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeeHolder;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeeListener;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.Equipment;
import org.eclipse.persistence.testing.models.jpa.advanced.EquipmentCode;
import org.eclipse.persistence.testing.models.jpa.advanced.Event;
import org.eclipse.persistence.testing.models.jpa.advanced.FormerEmployment;
import org.eclipse.persistence.testing.models.jpa.advanced.GoldBuyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Golfer;
import org.eclipse.persistence.testing.models.jpa.advanced.GolferPK;
import org.eclipse.persistence.testing.models.jpa.advanced.Hinge;
import org.eclipse.persistence.testing.models.jpa.advanced.HugeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Job;
import org.eclipse.persistence.testing.models.jpa.advanced.Lake;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Man;
import org.eclipse.persistence.testing.models.jpa.advanced.NonEntity;
import org.eclipse.persistence.testing.models.jpa.advanced.PartnerLink;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.PlatinumBuyer;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.ReadOnlyIsolated;
import org.eclipse.persistence.testing.models.jpa.advanced.Room;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.advanced.SpecialHugeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.SuperLargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.Vegetable;
import org.eclipse.persistence.testing.models.jpa.advanced.VegetablePK;
import org.eclipse.persistence.testing.models.jpa.advanced.Woman;
import org.eclipse.persistence.testing.models.jpa.advanced.WorldRank;
import org.eclipse.persistence.testing.models.jpa.relationships.CustomerCollection;
import org.eclipse.persistence.testing.tests.feature.TestDataSource;
import org.eclipse.persistence.testing.tests.jpa.advanced.LogWrapper;
import org.eclipse.persistence.testing.tests.jpa.unit.EMFProviderTest;
import org.eclipse.persistence.testing.tests.weaving.SimpleSessionLogWrapper;
import org.eclipse.persistence.tools.schemaframework.SequenceObjectDefinition;
import org.eclipse.persistence.transaction.AbstractSynchronizationListener;
import org.eclipse.persistence.transaction.AbstractTransactionController;
import org.junit.Assert;

public class EntityManagerJUnitTestSuite
extends JUnitTestCase {
    public static final int MAX_FIRST_NAME_FIELD_LENGTH = 255;

    public EntityManagerJUnitTestSuite() {
    }

    public EntityManagerJUnitTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EntityManagerJUnitTestSuite");
        suite.addTestSuite(EMFProviderTest.class);
        suite.addTest((Test)new EntityManagerJUnitTestSuite("testSetup"));
        ArrayList<String> tests = new ArrayList<String>();
        tests.add("testEMFTargetServerEnforcing");
        tests.add("testSettingDetachedObject");
        tests.add("testMultipleExistenceChecksForDetachedObjects");
        tests.add("testMergeOfEntityWithDetachedReferences");
        tests.add("testClearEntityManagerWithoutPersistenceContext");
        tests.add("testDeadConnectionFailover");
        tests.add("testDeadPoolFailover");
        tests.add("testDeleteEmployee");
        tests.add("testDeleteEmployee_with_status_enum_collection_instantiated");
        tests.add("testDeleteMan");
        tests.add("testFindDeleteAllPersist");
        tests.add("testExtendedPersistenceContext");
        tests.add("testRemoveFlushFind");
        tests.add("testRemoveFlushPersistContains");
        tests.add("testTransactionRequired");
        tests.add("testSubString");
        tests.add("testFlushModeOnUpdateQuery");
        tests.add("testAnnotationDefaultLockModeNONEOnUpdateQuery");
        tests.add("testContainsRemoved");
        tests.add("testRefreshRemoved");
        tests.add("testRefreshNotManaged");
        tests.add("testDoubleMerge");
        tests.add("testDescriptorNamedQueryForMultipleQueries");
        tests.add("testDescriptorNamedQuery");
        tests.add("testClearEntityManagerWithoutPersistenceContextSimulateJTA");
        tests.add("testMultipleEntityManagerFactories");
        tests.add("testOneToManyDefaultJoinTableName");
        tests.add("testClosedEmShouldThrowException");
        tests.add("testRollbackOnlyOnException");
        tests.add("testUpdateAllProjectsWithNullTeamLeader");
        tests.add("testUpdateAllLargeProjectsWithNullTeamLeader");
        tests.add("testUpdateAllSmallProjectsWithNullTeamLeader");
        tests.add("testUpdateAllSpecialHugeProjectsWithNullTeamLeader");
        tests.add("testUpdateAllProjectsWithName");
        tests.add("testUpdateAllLargeProjectsWithName");
        tests.add("testUpdateAllSmallProjectsWithName");
        tests.add("testUpdateAllHugeProjectsWithName");
        tests.add("testUpdateAllSpecialHugeProjectsWithName");
        tests.add("testUpdateAllLargeProjects");
        tests.add("testUpdateAllSmallProjects");
        tests.add("testUpdateAllHugeProjects");
        tests.add("testUpdateAllSpecialHugeProjects");
        tests.add("testUpdateUsingTempStorageWithParameter");
        tests.add("testDeleteAllLargeProjectsWithNullTeamLeader");
        tests.add("testDeleteAllHugeProjectsWithNullTeamLeader");
        tests.add("testDeleteAllSpecialHugeProjectsWithNullTeamLeader");
        tests.add("testDeleteAllSmallProjectsWithNullTeamLeader");
        tests.add("testDeleteAllProjectsWithNullTeamLeader");
        tests.add("testDeleteAllPhonesWithNullOwner");
        tests.add("testSetFieldForPropertyAccessWithNewEM");
        tests.add("testSetFieldForPropertyAccessWithRefresh");
        tests.add("testSetFieldForPropertyAccess");
        tests.add("testInitializeFieldForPropertyAccess");
        tests.add("testCascadePersistToNonEntitySubclass");
        tests.add("testCascadeMergeManaged");
        tests.add("testCascadeMergeDetached");
        tests.add("testPrimaryKeyUpdatePKFK");
        tests.add("testPrimaryKeyUpdateSameValue");
        tests.add("testPrimaryKeyUpdate");
        tests.add("testRemoveNull");
        tests.add("testContainsNull");
        tests.add("testPersistNull");
        tests.add("testMergeNull");
        tests.add("testMergeRemovedObject");
        tests.add("testMergeDetachedObject");
        tests.add("testSerializedLazy");
        tests.add("testCloneable");
        tests.add("testLeftJoinOneToOneQuery");
        tests.add("testNullifyAddressIn");
        tests.add("testQueryOnClosedEM");
        tests.add("testIncorrectBatchQueryHint");
        tests.add("testFetchQueryHint");
        tests.add("testBatchQueryHint");
        tests.add("testQueryHints");
        tests.add("testParallelMultipleFactories");
        tests.add("testMultipleFactories");
        tests.add("testPersistenceProperties");
        tests.add("testBeginTransactionCloseCommitTransaction");
        tests.add("testBeginTransactionClose");
        tests.add("testClose");
        tests.add("testPersistOnNonEntity");
        tests.add("testWRITELock");
        tests.add("testOPTIMISTIC_FORCE_INCREMENTLock");
        tests.add("testReadOnlyTransactionalData");
        tests.add("testReadOnlyCachedLazyAssociation");
        tests.add("testReadOnlyCachedLazyAssociationInNestedEmbeddable");
        tests.add("testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh_Flush");
        tests.add("testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh");
        tests.add("testReadTransactionIsolation_OriginalInCache_UpdateAll_Flush");
        tests.add("testReadTransactionIsolation_OriginalInCache_UpdateAll");
        tests.add("testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh_Flush");
        tests.add("testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh");
        tests.add("testReadTransactionIsolation_OriginalInCache_CustomUpdate_Flush");
        tests.add("testReadTransactionIsolation_OriginalInCache_CustomUpdate");
        tests.add("testReadTransactionIsolation_UpdateAll_Refresh_Flush");
        tests.add("testReadTransactionIsolation_UpdateAll_Refresh");
        tests.add("testReadTransactionIsolation_UpdateAll_Flush");
        tests.add("testReadTransactionIsolation_UpdateAll");
        tests.add("testReadTransactionIsolation_CustomUpdate_Refresh_Flush");
        tests.add("testReadTransactionIsolation_CustomUpdate_Refresh");
        tests.add("testReadTransactionIsolation_CustomUpdate_Flush");
        tests.add("testReadTransactionIsolation_CustomUpdate");
        tests.add("testClearInTransaction");
        tests.add("testClearWithFlush");
        tests.add("testClear");
        tests.add("testEMFClose");
        tests.add("testCheckVersionOnMerge");
        tests.add("testFindWithNullPk");
        tests.add("testFindWithWrongTypePk");
        tests.add("testPersistManagedNoException");
        tests.add("testPersistManagedException");
        tests.add("testPersistRemoved");
        tests.add("testREADLock");
        tests.add("testOPTIMISTICLock");
        tests.add("testBatchWriteOPTIMISTICLock");
        tests.add("testPESSIMISTIC_READLock");
        tests.add("testPESSIMISTIC_WRITELock");
        tests.add("testPESSIMISTIC_READLockWithNoChanges");
        tests.add("testPESSIMISTIC_WRITELockWithNoChanges");
        tests.add("testPESSIMISTIC_READ_TIMEOUTLock");
        tests.add("testPESSIMISTIC_WRITE_TIMEOUTLock");
        tests.add("testPESSIMISTIC_ExtendedScope");
        tests.add("testRefreshOPTIMISTICLock");
        tests.add("testRefreshPESSIMISTIC_READLock");
        tests.add("testRefreshPESSIMISTIC_WRITELock");
        tests.add("testIgnoreRemovedObjectsOnDatabaseSync");
        tests.add("testIdentityOutsideTransaction");
        tests.add("testIdentityInsideTransaction");
        tests.add("testDatabaseSyncNewObject");
        tests.add("testSetRollbackOnly");
        tests.add("testFlushModeEmCommitQueryAuto");
        tests.add("testFlushModeEmCommit");
        tests.add("testFlushModeEmCommitQueryCommit");
        tests.add("testFlushModeEmAutoQueryAuto");
        tests.add("testFlushModeEmAuto");
        tests.add("testFlushModeEmAutoQueryCommit");
        tests.add("testCacheUsage");
        tests.add("testSequencePreallocationUsingCallbackTest");
        tests.add("testForceSQLExceptionFor219097");
        tests.add("testRefreshInvalidateDeletedObject");
        tests.add("testClearWithFlush2");
        tests.add("testEMFWrapValidationException");
        tests.add("testEMDefaultTxType");
        tests.add("testMergeNewObject");
        tests.add("testMergeNewObject2");
        tests.add("testMergeNewObject3_UseSequencing");
        tests.add("testMergeNewObject3_DontUseSequencing");
        tests.add("testCreateEntityManagerFactory");
        tests.add("testCreateEntityManagerFactory2");
        tests.add("testPessimisticLockHintStartsTransaction");
        tests.add("testManyToOnePersistCascadeOnFlush");
        tests.add("testDiscoverNewReferencedObject");
        tests.add("testBulkDeleteThenMerge");
        tests.add("testNativeSequences");
        tests.add("testGetReference");
        tests.add("testGetReferenceUpdate");
        tests.add("testGetReferenceUsedInUpdate");
        tests.add("testBadGetReference");
        tests.add("testClassInstanceConverter");
        tests.add("test210280EntityManagerFromPUwithSpaceInNameButNotInPath");
        tests.add("test210280EntityManagerFromPUwithSpaceInPathButNotInName");
        tests.add("test210280EntityManagerFromPUwithSpaceInNameAndPath");
        tests.add("testNewObjectNotCascadePersist");
        tests.add("testConnectionPolicy");
        tests.add("testConverterIn");
        tests.add("testExceptionForPersistNonEntitySubclass");
        tests.add("testEnabledPersistNonEntitySubclass");
        tests.add("testCloneEmbeddable");
        tests.add("testCloseOnCommit");
        tests.add("testPersistOnCommit");
        tests.add("testFlushMode");
        tests.add("testEmbeddedNPE");
        tests.add("testCollectionAddNewObjectUpdate");
        tests.add("testEMCloseAndOpen");
        tests.add("testEMFactoryCloseAndOpen");
        tests.add("testPostAcquirePreReleaseEvents_InternalConnectionPool");
        tests.add("testPostAcquirePreReleaseEvents_ExternalConnectionPool");
        tests.add("testNoPersistOnCommit");
        tests.add("testNoPersistOnCommitProperties");
        tests.add("testForUOWInSharedCacheWithBatchQueryHint");
        tests.add("testNoPersistOnFlushProperties");
        tests.add("testUOWReferenceInExpressionCache");
        tests.add("testIsLoadedWithReference");
        tests.add("testIsLoadedWithoutReference");
        tests.add("testIsLoadedWithoutReferenceAttribute");
        tests.add("testGenerateSessionNameFromConnectionProperties");
        tests.add("testLockWithJoinedInheritanceStrategy");
        tests.add("testPreupdateEmbeddable");
        tests.add("testFindReadOnlyIsolated");
        tests.add("testInheritanceQuery");
        tests.add("testNullBasicMap");
        tests.add("testFlushClearFind");
        tests.add("testFlushClearFindNoCascadedLock");
        tests.add("testFlushClearQueryPk");
        tests.add("testFlushClearQueryNonPK");
        tests.add("testNestedBatchQueryHint");
        tests.add("testSequenceObjectDefinition");
        tests.add("testTemporalOnClosedEm");
        tests.add("testTransientMapping");
        tests.add("testUpdateAllProjects");
        tests.add("testUpdateUsingTempStorage");
        tests.add("testWeaving");
        tests.add("testRefreshForFlush");
        tests.add("testRefreshForCommit");
        tests.add("testRefreshLazyRelationship");
        tests.add("testNonRefreshLazyRelationship");
        tests.add("testChangeFlushChangeRefresh");
        tests.add("testChangeRecordKeepOldValue_Simple");
        tests.add("testChangeRecordKeepOldValue_TwoStep");
        tests.add("testSetNewAggregate");
        tests.add("testSetNewNestedAggregate");
        tests.add("testSetStartTime");
        tests.add("testObjectReferencedInBothEmAndSharedCache_AggregateObjectMapping");
        tests.add("testObjectReferencedInBothEmAndSharedCache_ObjectReferenceMappingVH");
        tests.add("testCharFieldDefaultNullValue");
        tests.add("testMergeNewReferencingOldChanged");
        tests.add("testApplicationManagedInServer");
        tests.add("testAddAndDeleteSameObject");
        tests.add("testDeleteAllProjects");
        tests.add("testEMFBuiltWithSession");
        tests.add("testLazyOneToOneFetchInitialization");
        tests.add("testProxyFetchDuringCommit");
        tests.add("testSequenceObjectWithSchemaName");
        tests.add("testSharedExpressionInQueries");
        tests.add("testNestedBatchQueryHints");
        tests.add("testReplaceElementCollection");
        tests.add("testProviderPropertySetting");
        tests.add("testBeginTransactionOnClosedEM");
        tests.add("testUpdateDetachedEntityWithRelationshipCascadeRefresh");
        tests.add("testForNPEInCloning");
        tests.add("testCopy");
        tests.add("testServerDetectionLogging");
        if (!EntityManagerJUnitTestSuite.isJPA10()) {
            tests.add("testDetachNull");
            tests.add("testDetachRemovedObject");
            tests.add("testLockingLeftJoinOneToOneQuery");
            tests.add("testLockingLeftJoinOneToOneQuery2");
            tests.add("testGetProperties");
            tests.add("testDetachNonEntity");
            tests.add("testFindWithProperties");
            tests.add("testDetachManagedObject");
            tests.add("testDetachNonManagedObject");
            tests.add("testPESSIMISTIC_FORCE_INCREMENTLock");
            tests.add("testGetLockModeType");
            tests.add("testGetEntityManagerFactory");
            tests.add("testConnectionPolicySetProperty");
            tests.add("testUnWrapClass");
            tests.add("testIsLoaded");
            tests.add("testIsLoadedAttribute");
            tests.add("testGetIdentifier");
            tests.add("testGetHints");
            tests.add("testPESSIMISTIC_FORCE_INCREMENTLockOnNonVersionedEntity");
            tests.add("testSelectEmbeddable");
            tests.add("testNonPooledConnection");
            tests.add("testExclusiveIsolatedLeaksConnectionOnClear");
            tests.add("testSetTargetQueryOneToMany");
            tests.add("testNestedFetchQueryHints");
            tests.add("testInheritanceFetchJoinSecondCall");
        }
        Collections.sort(tests);
        for (String test : tests) {
            suite.addTest((Test)new EntityManagerJUnitTestSuite(test));
        }
        if (!EntityManagerJUnitTestSuite.isJPA10()) {
            suite.addTest((Test)new EntityManagerJUnitTestSuite("testCascadeDetach"));
        }
        suite.addTest((Test)new EntityManagerJUnitTestSuite("testDeleteEverything"));
        return suite;
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
        if (EntityManagerJUnitTestSuite.getServerSession().getPlatform().isPostgreSQL()) {
            EntityManagerJUnitTestSuite.getServerSession().getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    public void testProviderPropertySetting() {
        if (!EntityManagerJUnitTestSuite.isOnServer()) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("javax.persistence.provider", "org.unknown.Provider");
            try {
                Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), properties);
            }
            catch (PersistenceException ex) {
                EntityManagerJUnitTestSuite.assertTrue((String)"Wrong exception thrown when provider class set through properties.", (boolean)ex.getMessage().contains("No Persistence provider for"));
                return;
            }
            EntityManagerJUnitTestSuite.fail((String)"EclipseLink ignored persistence provider class provided through properties.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForceSQLExceptionFor219097() {
        boolean exceptionThrown = false;
        EntityManager em = this.createEntityManager(Collections.emptyMap());
        this.beginTransaction(em);
        Employee emp = new Employee();
        StringBuffer firstName = new StringBuffer("firstName_maxfieldLength_");
        for (int i = 0; i < 355; ++i) {
            firstName.append("0");
        }
        emp.setFirstName(firstName.toString());
        em.persist((Object)emp);
        try {
            this.commitTransaction(em);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof UnsupportedOperationException) {
                exceptionThrown = true;
                EntityManagerJUnitTestSuite.fail((String)(cause.getClass() + " Exception was thrown in error instead of expected SQLException."));
            } else {
                exceptionThrown = true;
            }
        }
        finally {
            this.closeEntityManager(em);
        }
        if (!exceptionThrown && !this.getDatabaseSession().getPlatform().isSybase()) {
            EntityManagerJUnitTestSuite.fail((String)"An expected SQLException was not thrown.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshNotManaged() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("testRefreshNotManaged");
        try {
            em.refresh((Object)emp);
            EntityManagerJUnitTestSuite.fail((String)"entityManager.refresh(notManagedObject) didn't throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            EntityManagerJUnitTestSuite.fail((String)("entityManager.refresh(notManagedObject) threw a wrong exception: " + exception.getMessage()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testEMFClose() {
        String errorMsg = "";
        EntityManagerFactoryImpl em = new EntityManagerFactoryImpl((AbstractSession)JUnitTestCase.getServerSession());
        try {
            em.close();
        }
        catch (RuntimeException ex) {
            errorMsg = "EMFClose: " + ex.getMessage() + ";";
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testRefreshOPTIMISTICLock() {
        if (!EntityManagerJUnitTestSuite.isOnServer()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            Employee employee = null;
            try {
                employee = new Employee();
                employee.setFirstName("Billy");
                employee.setLastName("Madsen");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            EntityManager em2 = this.createEntityManager();
            PersistenceException optimisticLockException = null;
            this.beginTransaction(em);
            try {
                em.refresh((Object)employee, LockModeType.OPTIMISTIC);
                this.beginTransaction(em2);
                try {
                    Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                    employee2.setFirstName("Tilly");
                    this.commitTransaction(em2);
                }
                catch (RuntimeException ex) {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em2);
                }
                try {
                    em.flush();
                }
                catch (PersistenceException exception) {
                    if (exception instanceof OptimisticLockException) {
                        optimisticLockException = exception;
                    }
                    throw exception;
                }
                this.rollbackTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            try {
                this.beginTransaction(em);
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                em.remove((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, OPTIMISTIC) is used.", (optimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshPESSIMISTIC_READLock() {
        if (!EntityManagerJUnitTestSuite.isOnServer() && this.isSelectForUpateNoWaitSupported()) {
            EntityManager em = this.createEntityManager();
            Department dept = null;
            try {
                this.beginTransaction(em);
                dept = new Department();
                dept.setName("Pessimistic Department");
                em.persist((Object)dept);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            PersistenceException pessimisticLockException = null;
            try {
                block16: {
                    this.beginTransaction(em);
                    dept = (Department)em.find(Department.class, (Object)dept.getId());
                    em.lock((Object)dept, LockModeType.PESSIMISTIC_READ);
                    dept.setName("New Pessimistic Department");
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        Department dept2 = (Department)em2.find(Department.class, (Object)dept.getId());
                        HashMap<String, Integer> properties = new HashMap<String, Integer>();
                        properties.put("javax.persistence.lock.timeout", 0);
                        em2.refresh((Object)dept2, LockModeType.PESSIMISTIC_READ, properties);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof PessimisticLockException) {
                            pessimisticLockException = ex;
                            break block16;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, PESSIMISTIC) is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshPESSIMISTIC_WRITELock() {
        if (!EntityManagerJUnitTestSuite.isOnServer() && this.isSelectForUpateNoWaitSupported()) {
            EntityManager em = this.createEntityManager();
            Department dept = null;
            try {
                this.beginTransaction(em);
                dept = new Department();
                dept.setName("Pessimistic Department");
                em.persist((Object)dept);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            PersistenceException pessimisticLockException = null;
            try {
                block16: {
                    this.beginTransaction(em);
                    dept = (Department)em.find(Department.class, (Object)dept.getId());
                    em.lock((Object)dept, LockModeType.PESSIMISTIC_WRITE);
                    dept.setName("New Pessimistic Department");
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        Department dept2 = (Department)em2.find(Department.class, (Object)dept.getId());
                        HashMap<String, Integer> properties = new HashMap<String, Integer>();
                        properties.put("javax.persistence.lock.timeout", 0);
                        em2.refresh((Object)dept2, LockModeType.PESSIMISTIC_WRITE, properties);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof PessimisticLockException) {
                            pessimisticLockException = ex;
                            break block16;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, PESSIMISTIC) is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    public void testRefreshRemoved() {
        Employee emp;
        String firstName = "testRefreshRemoved";
        EntityManager em = this.createEntityManager();
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (Employee)result.get(0);
        } else {
            emp = new Employee();
            emp.setFirstName(firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            if (!EntityManagerJUnitTestSuite.getServerSession().getPlatform().isSymfoware()) {
                em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            } else {
                em.createNativeQuery("DELETE FROM CMP3_EMPLOYEE WHERE F_NAME = '" + firstName + "'").executeUpdate();
            }
            em.refresh((Object)emp);
            EntityManagerJUnitTestSuite.fail((String)"entityManager.refresh(removedObject) didn't throw exception");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            this.rollbackTransaction(em);
        }
        catch (Exception exception) {
            this.rollbackTransaction(em);
            EntityManagerJUnitTestSuite.fail((String)("entityManager.refresh(removedObject) threw a wrong exception: " + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshInvalidateDeletedObject() {
        EntityManager em1 = this.createEntityManager();
        EntityManager em2 = this.createEntityManager();
        Address address = new Address();
        address.setCity("Kanata");
        try {
            boolean isIsolated = ((EntityManagerImpl)em1).getServerSession().getClassDescriptorForAlias("Address").isIsolated();
            if (isIsolated) {
                throw new Exception("This test should use non-isolated cache setting class descriptor for test.");
            }
            this.beginTransaction(em1);
            em1.persist((Object)address);
            this.commitTransaction(em1);
            em1 = this.createEntityManager();
            this.beginTransaction(em1);
            address = (Address)em1.find(Address.class, (Object)address.getID());
            em2 = this.createEntityManager();
            this.beginTransaction(em2);
            em2.createNativeQuery("DELETE FROM CMP3_ADDRESS where ADDRESS_ID = ?1").setParameter(1, (Object)address.getID()).executeUpdate();
            this.commitTransaction(em2);
            em1.refresh((Object)address);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.isTransactionActive(em1)) {
                this.rollbackTransaction(em1);
            }
        }
        this.beginTransaction(em1);
        address = (Address)em1.find(Address.class, (Object)address.getID());
        this.commitTransaction(em1);
        EntityManagerJUnitTestSuite.assertNull((String)"The deleted object is still valid in share cache", (Object)address);
    }

    public void testCacheUsage() {
        EntityManager em = this.createEntityManager();
        Employee emp = new Employee();
        emp.setFirstName("Mark");
        try {
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e").getResultList();
        this.commitTransaction(em);
        Object obj = EntityManagerJUnitTestSuite.getServerSession().getIdentityMapAccessor().getFromIdentityMap(result.get(0));
        EntityManagerJUnitTestSuite.assertTrue((String)"Failed to load the object into the shared cache when there were no changes in the UOW", (obj != null ? 1 : 0) != 0);
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw exception;
        }
    }

    public void testContainsRemoved() {
        Employee emp;
        String firstName = "testContainsRemoved";
        EntityManager em = this.createEntityManager();
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (Employee)result.get(0);
        } else {
            emp = new Employee();
            emp.setFirstName(firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        boolean containsRemoved = true;
        try {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            containsRemoved = em.contains((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException t) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw t;
        }
        EntityManagerJUnitTestSuite.assertFalse((String)"entityManager.contains(removedObject)==true ", (boolean)containsRemoved);
    }

    public void testFlushModeEmAutoQueryCommit() {
        this.internalTestFlushMode(FlushModeType.AUTO, FlushModeType.COMMIT);
    }

    public void testFlushModeEmAuto() {
        this.internalTestFlushMode(FlushModeType.AUTO, null);
    }

    public void testFlushModeEmAutoQueryAuto() {
        this.internalTestFlushMode(FlushModeType.AUTO, FlushModeType.AUTO);
    }

    public void testFlushModeEmCommitQueryCommit() {
        this.internalTestFlushMode(FlushModeType.COMMIT, FlushModeType.COMMIT);
    }

    public void testFlushModeEmCommit() {
        this.internalTestFlushMode(FlushModeType.COMMIT, null);
    }

    public void testFlushModeEmCommitQueryAuto() {
        this.internalTestFlushMode(FlushModeType.COMMIT, FlushModeType.AUTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestFlushMode(FlushModeType emFlushMode, FlushModeType queryFlushMode) {
        boolean shouldHaveFlushed;
        String firstName = "testFlushMode";
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        this.clearCache();
        FlushModeType emFlushModeOriginal = em.getFlushMode();
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        boolean flushed = true;
        Employee result = null;
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName like '" + firstName + "'");
            if (queryFlushMode != null) {
                query.setFlushMode(queryFlushMode);
            }
            emFlushModeOriginal = em.getFlushMode();
            em.setFlushMode(emFlushMode);
            em.persist((Object)emp);
            result = (Employee)query.getSingleResult();
            result.toString();
        }
        catch (NoResultException ex) {
            flushed = false;
        }
        finally {
            this.rollbackTransaction(em);
            em.setFlushMode(emFlushModeOriginal);
        }
        if (queryFlushMode != null) {
            shouldHaveFlushed = queryFlushMode == FlushModeType.AUTO;
        } else {
            boolean bl = shouldHaveFlushed = emFlushMode == FlushModeType.AUTO;
        }
        if (shouldHaveFlushed != flushed) {
            if (flushed) {
                EntityManagerJUnitTestSuite.fail((String)"Flushed to database");
            } else {
                EntityManagerJUnitTestSuite.fail((String)"Failed to flush to database");
            }
        }
    }

    public void testFlushModeOnUpdateQuery() {
        String firstName = "testFlushModeOnUpdateQuery";
        EntityManager em = this.createEntityManager();
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        try {
            try {
                this.beginTransaction(em);
                Query readQuery = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.phoneNumbers IS EMPTY and e.firstName like '" + firstName + "'");
                Query updateQuery = null;
                updateQuery = EntityManagerJUnitTestSuite.getServerSession().getPlatform().isSymfoware() ? em.createNativeQuery("UPDATE CMP3_EMPLOYEE SET VERSION = (VERSION + 1) WHERE F_NAME LIKE '" + firstName + "' AND EMP_ID in (SELECT EMP_ID FROM CMP3_SALARY)") : em.createQuery("UPDATE Employee e set e.salary = 100 where e.firstName like '" + firstName + "'");
                updateQuery.setFlushMode(FlushModeType.AUTO);
                em.persist((Object)emp);
                updateQuery.executeUpdate();
                if (EntityManagerJUnitTestSuite.getServerSession().getPlatform().isSymfoware()) {
                    updateQuery = em.createNativeQuery("UPDATE CMP3_SALARY SET SALARY = 100 WHERE EMP_ID IN (SELECT EMP_ID FROM CMP3_EMPLOYEE WHERE F_NAME LIKE '" + firstName + "')");
                    updateQuery.setFlushMode(FlushModeType.AUTO);
                    updateQuery.executeUpdate();
                }
                Employee result = (Employee)readQuery.getSingleResult();
                result.toString();
            }
            catch (EntityNotFoundException ex) {
                this.rollbackTransaction(em);
                EntityManagerJUnitTestSuite.fail((String)"Failed to flush to database");
            }
            em.refresh((Object)emp);
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                if (ex instanceof QueryException && ((QueryException)ex).getErrorCode() == 6180) {
                    return;
                }
                EntityManagerJUnitTestSuite.fail((String)("Wrong exception: " + ex));
            }
            throw ex;
        }
        EntityManagerJUnitTestSuite.assertTrue((String)"Failed to flush to Database", (emp.getSalary() == 100 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotationDefaultLockModeNONEOnUpdateQuery() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testAnnotationDefaultLockModeNONEOnUpdateQuery skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.createNamedQuery("UpdateEmployeeQueryWithLockModeNONE").executeUpdate();
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("Update query failed: " + e.getMessage()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetRollbackOnly() {
        EntityManager em;
        block21: {
            em = this.createEntityManager();
            this.beginTransaction(em);
            Employee emp = null;
            Employee emp2 = null;
            try {
                emp = new Employee();
                emp.setFirstName("Bob");
                emp.setLastName("Fisher");
                em.persist((Object)emp);
                emp2 = new Employee();
                emp2.setFirstName("Anthony");
                emp2.setLastName("Walace");
                em.persist((Object)emp2);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            List result = em.createQuery("SELECT e FROM Employee e where e.id = " + emp.getId() + " or e.id = " + emp2.getId()).getResultList();
            emp = (Employee)result.get(0);
            emp.toString();
            emp2 = (Employee)result.get(1);
            String newName = "" + System.currentTimeMillis();
            emp2.setFirstName(newName);
            em.flush();
            emp2.setLastName("Whatever");
            emp2.setVersion(Integer.valueOf(0));
            try {
                em.flush();
            }
            catch (Exception ex) {
                if (EntityManagerJUnitTestSuite.isOnServer()) break block21;
                em.clear();
                try {
                    String eName = (String)em.createQuery("SELECT e.firstName FROM Employee e where e.id = " + emp2.getId()).getSingleResult();
                    EntityManagerJUnitTestSuite.assertTrue((String)"Failed to keep txn open for set RollbackOnly", (boolean)eName.equals(newName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            if (EntityManagerJUnitTestSuite.isOnServer()) {
                EntityManagerJUnitTestSuite.assertTrue((String)"Failed to mark txn rollback only", (!this.isTransactionActive(em) ? 1 : 0) != 0);
            } else {
                EntityManagerJUnitTestSuite.assertTrue((String)"Failed to mark txn rollback only", (boolean)em.getTransaction().getRollbackOnly());
            }
        }
        finally {
            try {
                this.commitTransaction(em);
            }
            catch (RollbackException ex) {
                return;
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof javax.transaction.RollbackException) {
                    return;
                }
                if (ex.getCause() instanceof RollbackException) {
                    return;
                }
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        EntityManagerJUnitTestSuite.fail((String)"Failed to throw rollback exception");
    }

    public void testSubString() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testSubString skipped for this platform, Symfoware doesn't allow dynamic parameter as first argument of SUBSTRING. (bug 304897)");
            return;
        }
        String firstName = "testSubString";
        EntityManager em = this.createEntityManager();
        List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            Employee emp = (Employee)result.get(0);
        } else {
            Employee emp = new Employee();
            emp.setFirstName(firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
        }
        int firstIndex = 1;
        int lastIndex = firstName.length();
        List employees = em.createQuery("SELECT object(e) FROM Employee e where e.firstName = substring(:p1, :p2, :p3)").setParameter("p1", (Object)firstName).setParameter("p2", (Object)new Integer(firstIndex)).setParameter("p3", (Object)new Integer(lastIndex)).getResultList();
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        EntityManagerJUnitTestSuite.assertFalse((String)"employees.isEmpty()==true ", (boolean)employees.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewObjectNotCascadePersist() {
        IllegalStateException exception = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Golfer g = new Golfer();
        WorldRank wr = new WorldRank();
        g.setWorldRank(wr);
        em.persist((Object)g);
        try {
            em.flush();
        }
        catch (IllegalStateException ex) {
            exception = ex;
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"Failed to throw IllegalStateException see bug: 237279 ", (Object)exception);
    }

    public void testDatabaseSyncNewObject() {
        block2: {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                LargeProject project = new LargeProject();
                em.persist((Object)project);
                project.setName("Blah");
                project.setTeamLeader(new Employee());
                project.getTeamLeader().addProject((Project)project);
                em.flush();
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em);
                if (!(ex instanceof IllegalStateException)) break block2;
                return;
            }
        }
        EntityManagerJUnitTestSuite.fail((String)"Failed to throw illegal argument when finding unregistered new object cascading on database sync");
    }

    public void testTransactionRequired() {
        String firstName = "testTransactionRequired";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        String noException = "";
        String wrongException = "";
        try {
            this.createEntityManager().flush();
            noException = noException + " flush;";
        }
        catch (TransactionRequiredException transactionRequiredException) {
        }
        catch (RuntimeException ex) {
            wrongException = wrongException + " flush: " + ex.getMessage() + ";";
        }
        String errorMsg = "";
        if (noException.length() > 0) {
            errorMsg = "No exception thrown: " + noException;
        }
        if (wrongException.length() > 0) {
            if (errorMsg.length() > 0) {
                errorMsg = errorMsg + " ";
            }
            errorMsg = errorMsg + "Wrong exception thrown: " + wrongException;
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testIdentityInsideTransaction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Query query = em.createQuery("SELECT e FROM PhoneNumber e");
        List phoneNumbers = query.getResultList();
        for (PhoneNumber phoneNumber : phoneNumbers) {
            Employee emp = phoneNumber.getOwner();
            Collection numbers = emp.getPhoneNumbers();
            EntityManagerJUnitTestSuite.assertTrue((boolean)numbers.contains(phoneNumber));
        }
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testIdentityOutsideTransaction() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM PhoneNumber e");
        List phoneNumbers = query.getResultList();
        for (PhoneNumber phoneNumber : phoneNumbers) {
            Employee emp = phoneNumber.getOwner();
            Collection numbers = emp.getPhoneNumbers();
            EntityManagerJUnitTestSuite.assertTrue((boolean)numbers.contains(phoneNumber));
        }
        this.closeEntityManager(em);
    }

    public void testIgnoreRemovedObjectsOnDatabaseSync() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Query phoneQuery = em.createQuery("Select p from PhoneNumber p where p.owner.lastName like 'Dow%'");
        Query empQuery = em.createQuery("Select e FROM Employee e where e.lastName like 'Dow%'");
        try {
            Employee emp = new Employee();
            emp.setLastName("Dowder");
            PhoneNumber phone = new PhoneNumber("work", "613", "5555555");
            emp.addPhoneNumber(phone);
            phone = new PhoneNumber("home", "613", "4444444");
            emp.addPhoneNumber(phone);
            Address address = new Address("SomeStreet", "somecity", "province", "country", "postalcode");
            emp.setAddress(address);
            em.persist((Object)emp);
            em.flush();
            emp = new Employee();
            emp.setLastName("Dows");
            phone = new PhoneNumber("work", "613", "2222222");
            emp.addPhoneNumber(phone);
            phone = new PhoneNumber("home", "613", "1111111");
            emp.addPhoneNumber(phone);
            address = new Address("street1", "city1", "province1", "country1", "postalcode1");
            emp.setAddress(address);
            em.persist((Object)emp);
            em.flush();
            List emps = empQuery.getResultList();
            List phones = phoneQuery.getResultList();
            Iterator iterator = phones.iterator();
            while (iterator.hasNext()) {
                em.remove(iterator.next());
            }
            em.flush();
            iterator = emps.iterator();
            while (iterator.hasNext()) {
                em.remove(iterator.next());
            }
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        try {
            em.flush();
        }
        catch (IllegalStateException ex) {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            try {
                phoneQuery = em.createQuery("Select p from PhoneNumber p where p.owner.lastName like 'Dow%'");
                empQuery = em.createQuery("Select e from Employee e where e.lastName like 'Dow%'");
                List emps = empQuery.getResultList();
                List phones = phoneQuery.getResultList();
                Iterator iterator = phones.iterator();
                while (iterator.hasNext()) {
                    em.remove(iterator.next());
                }
                iterator = emps.iterator();
                while (iterator.hasNext()) {
                    em.remove(iterator.next());
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException re) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw re;
            }
            EntityManagerJUnitTestSuite.fail((String)"Failed to ignore the removedobject when cascading on database sync");
        }
        this.commitTransaction(em);
    }

    public void testREADLock() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = null;
        try {
            employee = new Employee();
            employee.setFirstName("Mark");
            employee.setLastName("Madsen");
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManager em2 = this.createEntityManager();
        PersistenceException optimisticLockException = null;
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.lock((Object)employee, LockModeType.READ);
            em2.getTransaction().begin();
            try {
                Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                employee2.setFirstName("Michael");
                em2.getTransaction().commit();
                em2.close();
            }
            catch (RuntimeException ex) {
                em2.getTransaction().rollback();
                em2.close();
                throw ex;
            }
            try {
                em.flush();
            }
            catch (PersistenceException exception) {
                if (exception instanceof OptimisticLockException) {
                    optimisticLockException = exception;
                }
                throw exception;
            }
            this.rollbackTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        if (optimisticLockException == null) {
            EntityManagerJUnitTestSuite.fail((String)"Proper exception not thrown when EntityManager.lock(object, READ) is used.");
        }
    }

    public void testOPTIMISTIC_FORCE_INCREMENTLock() {
        if (!EntityManagerJUnitTestSuite.isOnServer()) {
            Employee employee;
            EntityManager em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                employee = new Employee();
                employee.setFirstName("Philip");
                employee.setLastName("Madsen");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            RollbackException optimisticLockException = null;
            try {
                this.beginTransaction(em);
                employee = (Employee)em.find(Employee.class, (Object)employee.getId(), LockModeType.OPTIMISTIC_FORCE_INCREMENT);
                EntityManager em2 = this.createEntityManager();
                try {
                    this.beginTransaction(em2);
                    Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                    employee2.setFirstName("Tulip");
                    this.commitTransaction(em2);
                }
                catch (RuntimeException ex) {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em2);
                }
                this.commitTransaction(em);
            }
            catch (RollbackException exception) {
                if (exception.getCause() instanceof OptimisticLockException) {
                    optimisticLockException = exception;
                }
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            this.beginTransaction(em);
            try {
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                em.remove((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, WRITE) is used.", (optimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBatchWriteOPTIMISTICLock() {
        boolean old = this.getDatabaseSession().getPlatform().usesBatchWriting();
        this.getDatabaseSession().getPlatform().setUsesBatchWriting(true);
        try {
            this.testOPTIMISTICLock();
        }
        finally {
            this.getDatabaseSession().getPlatform().setUsesBatchWriting(old);
        }
    }

    public void testOPTIMISTICLock() {
        if (!EntityManagerJUnitTestSuite.isOnServer()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            Employee employee = null;
            try {
                employee = new Employee();
                employee.setFirstName("Harry");
                employee.setLastName("Madsen");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            EntityManager em2 = this.createEntityManager();
            PersistenceException optimisticLockException = null;
            this.beginTransaction(em);
            try {
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                em.lock((Object)employee, LockModeType.OPTIMISTIC);
                this.beginTransaction(em2);
                try {
                    Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                    employee2.setFirstName("Michael");
                    this.commitTransaction(em2);
                }
                catch (RuntimeException ex) {
                    if (this.isTransactionActive(em2)) {
                        this.rollbackTransaction(em2);
                    }
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em2);
                }
                try {
                    em.flush();
                }
                catch (PersistenceException exception) {
                    if (exception instanceof OptimisticLockException) {
                        optimisticLockException = exception;
                    }
                    throw exception;
                }
                this.rollbackTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            try {
                this.beginTransaction(em);
                employee = (Employee)em.find(Employee.class, (Object)employee.getId());
                em.remove((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, OPTIMISTIC) is used.", (optimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSIMISTIC_READLock() {
        if (!EntityManagerJUnitTestSuite.isOnServer() && this.isSelectForUpateNoWaitSupported()) {
            EntityManager em = this.createEntityManager();
            Department dept = null;
            try {
                this.beginTransaction(em);
                dept = new Department();
                dept.setName("Pessimistic Department");
                em.persist((Object)dept);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            PersistenceException pessimisticLockException = null;
            try {
                block16: {
                    this.beginTransaction(em);
                    dept = (Department)em.find(Department.class, (Object)dept.getId());
                    em.lock((Object)dept, LockModeType.PESSIMISTIC_READ);
                    dept.setName("New Pessimistic Department");
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        Department dept2 = (Department)em2.find(Department.class, (Object)dept.getId());
                        HashMap<String, Integer> properties = new HashMap<String, Integer>();
                        properties.put("javax.persistence.lock.timeout", 0);
                        em2.lock((Object)dept2, LockModeType.PESSIMISTIC_READ, properties);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof PessimisticLockException) {
                            pessimisticLockException = ex;
                            break block16;
                        }
                        throw ex;
                    }
                    finally {
                        this.rollbackTransaction(em2);
                        this.closeEntityManager(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, PESSIMISTIC) is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSIMISTIC_WRITELock() {
        if (!EntityManagerJUnitTestSuite.isOnServer() && this.isSelectForUpateNoWaitSupported()) {
            EntityManager em = this.createEntityManager();
            Department dept = null;
            try {
                this.beginTransaction(em);
                dept = new Department();
                dept.setName("Pessimistic Department");
                em.persist((Object)dept);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            PersistenceException pessimisticLockException = null;
            try {
                block16: {
                    this.beginTransaction(em);
                    dept = (Department)em.find(Department.class, (Object)dept.getId());
                    em.lock((Object)dept, LockModeType.PESSIMISTIC_WRITE);
                    dept.setName("New Pessimistic Department");
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        Department dept2 = (Department)em2.find(Department.class, (Object)dept.getId());
                        HashMap<String, Integer> properties = new HashMap<String, Integer>();
                        properties.put("javax.persistence.lock.timeout", 0);
                        em2.lock((Object)dept2, LockModeType.PESSIMISTIC_WRITE, properties);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof PessimisticLockException) {
                            pessimisticLockException = ex;
                            break block16;
                        }
                        throw ex;
                    }
                    finally {
                        this.rollbackTransaction(em2);
                        this.closeEntityManager(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when EntityManager.lock(object, PESSIMISTIC) is used.", (pessimisticLockException == null ? 1 : 0) != 0);
        }
    }

    public void testPESSIMISTIC_FORCE_INCREMENTLock() {
        if (!this.isSelectForUpateSupported()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        Employee employee = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            employee = new Employee();
            employee.setFirstName("Guillaume");
            employee.setLastName("Aujet");
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        Integer version1 = employee.getVersion();
        try {
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
            this.commitTransaction(em);
            EntityManagerJUnitTestSuite.assertTrue((String)"The version was not updated on the pessimistic lock.", (version1 < employee.getVersion() ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPESSIMISTIC_READLockWithNoChanges() {
        if (EntityManagerJUnitTestSuite.isOnServer() || !this.isSelectForUpateSupported()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        Employee employee = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            employee = new Employee();
            employee.setFirstName("Black");
            employee.setLastName("Crappie");
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        Integer version1 = employee.getVersion();
        try {
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_READ);
            this.commitTransaction(em);
            EntityManagerJUnitTestSuite.assertTrue((String)"The version was updated on the pessimistic lock.", (version1.intValue() == employee.getVersion().intValue() ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPESSIMISTIC_WRITELockWithNoChanges() {
        if (EntityManagerJUnitTestSuite.isOnServer() || !this.isSelectForUpateSupported()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        Employee employee = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            employee = new Employee();
            employee.setFirstName("Black");
            employee.setLastName("Crappie");
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        Integer version1 = employee.getVersion();
        try {
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_WRITE);
            this.commitTransaction(em);
            EntityManagerJUnitTestSuite.assertTrue((String)"The version was updated on the pessimistic lock.", (version1.intValue() == employee.getVersion().intValue() ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSIMISTIC_READ_TIMEOUTLock() {
        ServerSession session = JUnitTestCase.getServerSession();
        if (!EntityManagerJUnitTestSuite.isOnServer() && session.getPlatform().isOracle()) {
            EntityManager em = this.createEntityManager();
            List result = em.createQuery("Select employee from Employee employee").getResultList();
            Employee employee = (Employee)result.get(0);
            PersistenceException lockTimeOutException = null;
            try {
                block14: {
                    this.beginTransaction(em);
                    employee = (Employee)em.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_READ);
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        HashMap<String, Integer> properties = new HashMap<String, Integer>();
                        properties.put("javax.persistence.lock.timeout", 5);
                        Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_READ, properties);
                        employee2.setFirstName("Invalid Lock Employee");
                        this.commitTransaction(em2);
                    }
                    catch (PersistenceException ex) {
                        if (this.isTransactionActive(em2)) {
                            this.rollbackTransaction(em2);
                        }
                        if (ex instanceof LockTimeoutException) {
                            lockTimeOutException = ex;
                            break block14;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManager(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (lockTimeOutException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSIMISTIC_WRITE_TIMEOUTLock() {
        ServerSession session = JUnitTestCase.getServerSession();
        if (!EntityManagerJUnitTestSuite.isOnServer() && session.getPlatform().isOracle()) {
            EntityManager em = this.createEntityManager();
            List result = em.createQuery("Select employee from Employee employee").getResultList();
            Employee employee = (Employee)result.get(0);
            PersistenceException lockTimeOutException = null;
            try {
                block14: {
                    this.beginTransaction(em);
                    employee = (Employee)em.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_WRITE);
                    EntityManager em2 = this.createEntityManager();
                    try {
                        this.beginTransaction(em2);
                        HashMap<String, Integer> properties = new HashMap<String, Integer>();
                        properties.put("javax.persistence.lock.timeout", 5);
                        Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_WRITE, properties);
                        employee2.setFirstName("Invalid Lock Employee");
                        this.commitTransaction(em2);
                    }
                    catch (PersistenceException ex) {
                        if (this.isTransactionActive(em2)) {
                            this.rollbackTransaction(em2);
                        }
                        if (ex instanceof LockTimeoutException) {
                            lockTimeOutException = ex;
                            break block14;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManager(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"Proper exception not thrown when Query with LockModeType.PESSIMISTIC is used.", (lockTimeOutException == null ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSIMISTIC_FORCE_INCREMENTLockOnNonVersionedEntity() {
        Department dept = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            dept = new Department();
            em.persist((Object)dept);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        try {
            this.beginTransaction(em);
            dept = (Department)em.find(Department.class, (Object)dept.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
            this.rollbackTransaction(em);
            EntityManagerJUnitTestSuite.fail((String)"An Expected javax.persistence.PersistenceException was not thrown");
        }
        catch (PersistenceException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testLockWithJoinedInheritanceStrategy() throws InterruptedException {
        if (EntityManagerJUnitTestSuite.getServerSession().getPlatform().isMaxDB()) {
            return;
        }
        if (!EntityManagerJUnitTestSuite.isOnServer() && this.isSelectForUpateNoWaitSupported()) {
            Employee emp = null;
            LargeProject largeProject = null;
            EntityManager em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                emp = new Employee();
                largeProject = new LargeProject();
                largeProject.setName("Large Project");
                largeProject.setBudget(50000.0);
                emp.addProject((Project)largeProject);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            try {
                this.beginTransaction(em);
                emp = (Employee)em.find(Employee.class, (Object)emp.getId());
                final Project lp1 = (Project)emp.getProjects().iterator().next();
                em.lock((Object)lp1, LockModeType.PESSIMISTIC_WRITE);
                lp1.setName("Lock In Additional Table ");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        EntityManager em2 = EntityManagerJUnitTestSuite.this.createEntityManager();
                        try {
                            EntityManagerJUnitTestSuite.this.beginTransaction(em2);
                            LargeProject lp2 = (LargeProject)em2.find(LargeProject.class, (Object)lp1.getId());
                            HashMap<String, Integer> properties = new HashMap<String, Integer>();
                            properties.put("javax.persistence.lock.timeout", 0);
                            em2.lock((Object)lp2, LockModeType.PESSIMISTIC_WRITE, properties);
                        }
                        catch (PersistenceException ex) {
                            if (!(ex instanceof PessimisticLockException)) {
                                throw ex;
                            }
                        }
                        finally {
                            EntityManagerJUnitTestSuite.this.rollbackTransaction(em2);
                            EntityManagerJUnitTestSuite.this.closeEntityManager(em2);
                        }
                    }
                };
                Thread t2 = new Thread(runnable);
                t2.start();
                Thread.sleep(3000L);
                boolean hanging = t2.isAlive();
                if (hanging) {
                    t2.interrupt();
                }
                this.commitTransaction(em);
                EntityManagerJUnitTestSuite.assertFalse((String)"pessimistic lock with nowait on entity with joined inheritance causes concurrent thread to wait", (boolean)hanging);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        EntityManagerJUnitTestSuite.warning((String)"Can't run this test because SELECT FOR UPDATE NO WAIT is not supported on this platform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPESSIMISTIC_ExtendedScope() {
        ServerSession session = JUnitTestCase.getServerSession();
        if (EntityManagerJUnitTestSuite.isOnServer() || !this.isSelectForUpateSupported() || !this.isPessimisticWriteLockSupported()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        ServerSession ss = ((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession();
        boolean shouldSpawnThread = !this.isSelectForUpateNoWaitSupported();
        long timeToWait = 1000L;
        String errorMsg = "";
        LockModeType lockMode = LockModeType.PESSIMISTIC_WRITE;
        Employee emp = new Employee();
        emp.setFirstName("PESSIMISTIC");
        emp.setLastName("ExtendedScope");
        emp.addResponsibility("0");
        emp.addResponsibility("1");
        SmallProject smallProject = new SmallProject();
        smallProject.setName("SmallExtendedScope");
        emp.addProject((Project)smallProject);
        LargeProject largeProject = new LargeProject();
        largeProject.setName("LargeExtendedScope");
        largeProject.setBudget(5000.0);
        emp.addProject((Project)largeProject);
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        int id = emp.getId();
        int smallProjId = smallProject.getId();
        this.clearCache();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.persistence.lock.scope", PessimisticLockScope.EXTENDED);
        String forUpdateClause = session.getPlatform().getSelectForUpdateString();
        if (this.isSelectForUpateNoWaitSupported()) {
            properties.put("javax.persistence.lock.timeout", 0);
            forUpdateClause = session.getPlatform().getSelectForUpdateNoWaitString();
        }
        String lockingClauseAfterWhereClause = "";
        String lockingClauseBeforeWhereClause = "";
        if (session.getPlatform().shouldPrintLockingClauseAfterWhereClause()) {
            lockingClauseAfterWhereClause = forUpdateClause;
        } else {
            lockingClauseBeforeWhereClause = forUpdateClause;
        }
        boolean[] isObjectCached = new boolean[]{false, true};
        String[] testModeArray1 = new String[]{"query", "find", "lock", "refresh"};
        String[] testModeArray2 = new String[]{"query", "find", "update_name", "update_salary", "remove_project", "remove_respons", "update_project", "update_respons", "lock", "refresh"};
        if (EntityManagerJUnitTestSuite.usesSOP()) {
            testModeArray2 = new String[]{"query", "find", "update_name", "update_salary", "remove_project", "update_project", "lock", "refresh"};
        }
        for (int i = 0; i < testModeArray1.length; ++i) {
            String testMode1 = testModeArray1[i];
            for (int k = 0; k < isObjectCached.length; ++k) {
                boolean isObjCached = isObjectCached[k];
                for (int j = 0; j < testModeArray2.length; ++j) {
                    String testMode2 = testModeArray2[j];
                    boolean isExceptionExpected = !testMode2.equals("update_project");
                    EntityManager em1 = this.createEntityManager();
                    if (isObjCached) {
                        ss.log(1, "query", "testPESSIMISTIC_ExtendedScope: bring object into cache", (Object[])null, null, false);
                        em1.find(Employee.class, (Object)id);
                    }
                    try {
                        String localErrorMsg;
                        Employee emp1;
                        this.beginTransaction(em1);
                        ss.log(1, "query", "testPESSIMISTIC_ExtendedScope: testMode1 = " + testMode1, (Object[])null, null, false);
                        if (testMode1.equals("query")) {
                            Query query1 = em1.createQuery("SELECT emp FROM Employee emp WHERE emp.id = " + id).setLockMode(lockMode).setHint("javax.persistence.lock.scope", (Object)PessimisticLockScope.EXTENDED);
                            if (this.isSelectForUpateNoWaitSupported()) {
                                query1.setHint("javax.persistence.lock.timeout", (Object)0);
                            }
                            emp1 = (Employee)query1.getSingleResult();
                        } else if (testMode1.equals("find")) {
                            emp1 = (Employee)em1.find(Employee.class, (Object)id, lockMode, properties);
                        } else {
                            emp1 = (Employee)em1.find(Employee.class, (Object)id);
                            if (testMode1.equals("lock")) {
                                em1.lock((Object)emp1, lockMode, properties);
                            } else if (testMode1.equals("refresh")) {
                                em1.refresh((Object)emp1, lockMode, properties);
                            } else {
                                EntityManagerJUnitTestSuite.fail((String)("Unknown testMode1 = " + testMode1));
                            }
                        }
                        Thread transactionKiller = null;
                        EntityManager em2 = this.createEntityManager();
                        try {
                            Employee emp2;
                            this.beginTransaction(em2);
                            ss.log(1, "query", "testPESSIMISTIC_ExtendedScope: testMode2 = " + testMode2, (Object[])null, null, false);
                            if (shouldSpawnThread) {
                                transactionKiller = new TransactionKiller(em1, timeToWait);
                                transactionKiller.start();
                            }
                            if (testMode2.equals("query")) {
                                Query query2 = em2.createQuery("SELECT emp FROM Employee emp WHERE emp.id = " + id).setLockMode(lockMode).setHint("javax.persistence.lock.scope", (Object)PessimisticLockScope.EXTENDED);
                                if (this.isSelectForUpateNoWaitSupported()) {
                                    query2.setHint("javax.persistence.lock.timeout", (Object)0);
                                }
                                emp2 = (Employee)query2.getSingleResult();
                            } else if (testMode2.equals("find")) {
                                emp2 = (Employee)em2.find(Employee.class, (Object)id, lockMode, properties);
                            } else if (testMode2.equals("update_name")) {
                                em2.createNativeQuery("SELECT L_NAME FROM CMP3_EMPLOYEE" + lockingClauseBeforeWhereClause + " WHERE EMP_ID = " + id + lockingClauseAfterWhereClause).getSingleResult();
                            } else if (testMode2.equals("update_salary")) {
                                em2.createNativeQuery("SELECT SALARY FROM CMP3_SALARY" + lockingClauseBeforeWhereClause + " WHERE EMP_ID = " + id + lockingClauseAfterWhereClause).getSingleResult();
                            } else if (testMode2.equals("remove_project")) {
                                em2.createNativeQuery("SELECT PROJECTS_PROJ_ID FROM CMP3_EMP_PROJ" + lockingClauseBeforeWhereClause + " WHERE EMPLOYEES_EMP_ID = " + id + lockingClauseAfterWhereClause).getResultList();
                            } else if (testMode2.equals("remove_respons")) {
                                em2.createNativeQuery("SELECT EMP_ID FROM CMP3_RESPONS" + lockingClauseBeforeWhereClause + " WHERE EMP_ID = " + id + lockingClauseAfterWhereClause).getResultList();
                            } else if (testMode2.equals("update_project")) {
                                em2.createNativeQuery("SELECT PROJ_NAME FROM CMP3_PROJECT" + lockingClauseBeforeWhereClause + " WHERE PROJ_ID = " + smallProjId + lockingClauseAfterWhereClause).getSingleResult();
                            } else if (testMode2.equals("update_respons")) {
                                em2.createNativeQuery("SELECT DESCRIPTION FROM CMP3_RESPONS" + lockingClauseBeforeWhereClause + " WHERE EMP_ID = " + id + lockingClauseAfterWhereClause).getResultList();
                            } else {
                                emp2 = (Employee)em2.find(Employee.class, (Object)id);
                                if (testMode2.equals("lock")) {
                                    em2.lock((Object)emp2, lockMode, properties);
                                } else if (testMode2.equals("refresh")) {
                                    em2.refresh((Object)emp2, lockMode, properties);
                                } else {
                                    EntityManagerJUnitTestSuite.fail((String)("Unknown testMode2 = " + testMode2));
                                }
                            }
                            boolean hasKilledTransaction = false;
                            if (transactionKiller != null) {
                                ((TransactionKiller)transactionKiller).shouldKillTransaction = false;
                                try {
                                    transactionKiller.join();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                hasKilledTransaction = ((TransactionKiller)transactionKiller).hasKilledTransaction;
                            }
                            if (isExceptionExpected && !hasKilledTransaction) {
                                localErrorMsg = testMode1 + (isObjCached ? " cached " : " ") + testMode2 + ": Exception was expected.";
                                ss.log(1, "query", localErrorMsg, (Object[])null, null, false);
                                errorMsg = errorMsg + '\n' + localErrorMsg;
                            }
                        }
                        catch (Exception ex) {
                            if (transactionKiller != null) {
                                ((TransactionKiller)transactionKiller).shouldKillTransaction = false;
                                try {
                                    transactionKiller.join();
                                }
                                catch (InterruptedException localErrorMsg2) {
                                    // empty catch block
                                }
                            }
                            if (!isExceptionExpected) {
                                localErrorMsg = testMode1 + (isObjCached ? " cached " : " ") + testMode2 + ": Unexpected exception: " + ex.getMessage();
                                ss.log(1, "query", localErrorMsg, (Object[])null, null, false);
                                errorMsg = errorMsg + '\n' + localErrorMsg;
                            }
                        }
                        finally {
                            if (this.isTransactionActive(em2)) {
                                this.rollbackTransaction(em2);
                            }
                            this.closeEntityManager(em2);
                        }
                    }
                    finally {
                        if (this.isTransactionActive(em1)) {
                            this.rollbackTransaction(em1);
                        }
                        this.closeEntityManager(em1);
                    }
                    this.clearCache();
                }
            }
        }
        em = this.createEntityManager();
        emp = (Employee)em.find(Employee.class, (Object)id);
        try {
            this.beginTransaction(em);
            Iterator it = emp.getProjects().iterator();
            while (it.hasNext()) {
                Project project = (Project)it.next();
                it.remove();
                em.remove((Object)project);
            }
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testPersistRemoved() {
        String firstName = "testPesistRemoved";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        String errorMsg = "";
        for (int i = 0; i < 32; ++i) {
            boolean doTransaction;
            int j = i;
            boolean doRollback = j % 2 == 0;
            boolean doThirdFlush = (j /= 2) % 2 == 0;
            boolean doSecondFlush = (j /= 2) % 2 == 0;
            boolean doFirstFlush = (j /= 2) % 2 == 0;
            boolean bl = doTransaction = (j /= 2) % 2 == 0;
            if (doTransaction && doFirstFlush) continue;
            String msg = "";
            if (doTransaction) {
                msg = "Transaction ";
            }
            if (doFirstFlush) {
                msg = msg + "firstFlush ";
            }
            if (doSecondFlush) {
                msg = msg + "secondFlush ";
            }
            if (doThirdFlush) {
                msg = msg + "thirdFlush ";
            }
            if (doRollback) {
                msg = msg + "RolledBack ";
            }
            String localErrorMsg = msg;
            boolean exceptionWasThrown = false;
            Integer empId = null;
            this.beginTransaction(em);
            try {
                emp = new Employee();
                emp.setFirstName(firstName);
                em.persist((Object)emp);
                if (doTransaction) {
                    this.commitTransaction(em);
                    empId = emp.getId();
                    this.beginTransaction(em);
                } else if (doFirstFlush) {
                    em.flush();
                }
                if (doTransaction) {
                    emp = (Employee)em.find(Employee.class, (Object)empId);
                }
                em.remove((Object)emp);
                if (doSecondFlush) {
                    em.flush();
                }
                em.persist((Object)emp);
                if (doThirdFlush) {
                    em.flush();
                }
            }
            catch (RuntimeException ex) {
                this.rollbackTransaction(em);
                localErrorMsg = localErrorMsg + " " + ex.getMessage() + ";";
                exceptionWasThrown = true;
            }
            boolean employeeShouldExist = doTransaction || !doRollback;
            boolean employeeExists = false;
            try {
                if (!exceptionWasThrown) {
                    List resultList;
                    Employee employeeReadFromCache;
                    if (doRollback) {
                        this.rollbackTransaction(em);
                    } else {
                        this.commitTransaction(em);
                    }
                    if (doTransaction && (employeeReadFromCache = (Employee)em.find(Employee.class, (Object)empId)) == null) {
                        localErrorMsg = localErrorMsg + " employeeReadFromCache == null;";
                    }
                    boolean bl2 = employeeExists = (resultList = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList()).size() > 0;
                    if (employeeShouldExist) {
                        if (resultList.size() > 1) {
                            localErrorMsg = localErrorMsg + " resultList.size() > 1";
                        }
                        if (!employeeExists) {
                            localErrorMsg = localErrorMsg + " employeeReadFromDB == null;";
                        }
                    } else if (resultList.size() > 0) {
                        localErrorMsg = localErrorMsg + " employeeReadFromDB != null;";
                    }
                }
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            if (employeeExists || exceptionWasThrown) {
                em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
                    for (Object oldData : q.getResultList()) {
                        em.remove(oldData);
                    }
                    this.commitTransaction(em);
                }
                catch (RuntimeException ex) {
                    this.rollbackTransaction(em);
                    throw ex;
                }
            }
            if (msg.equals(localErrorMsg)) continue;
            errorMsg = errorMsg + "i=" + Integer.toString(i) + ": " + localErrorMsg + " ";
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testPersistManagedException() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("PersistManagedException");
        em.persist((Object)emp);
        em.flush();
        Integer id = emp.getId();
        emp = new Employee();
        emp.setId(id);
        boolean caughtException = false;
        try {
            em.persist((Object)emp);
        }
        catch (EntityExistsException e) {
            caughtException = true;
        }
        this.rollbackTransaction(em);
        EntityManagerJUnitTestSuite.assertTrue((String)"EntityExistsException was not thrown for an existing Employee.", (boolean)caughtException);
    }

    public void testPersistManagedNoException() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        em.persist((Object)emp);
        em.flush();
        Integer id = emp.getId();
        Address address = new Address();
        emp.setAddress(address);
        boolean caughtException = false;
        try {
            em.persist((Object)emp);
        }
        catch (EntityExistsException e) {
            caughtException = true;
        }
        emp = (Employee)em.find(Employee.class, (Object)id);
        em.remove((Object)emp);
        this.commitTransaction(em);
        EntityManagerJUnitTestSuite.assertFalse((String)"EntityExistsException was thrown for a registered Employee.", (boolean)caughtException);
    }

    public void testDetachManagedObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("beforePersist");
        em.persist((Object)emp);
        Integer id = emp.getId();
        this.commitTransaction(em);
        this.beginTransaction(em);
        em.detach((Object)emp);
        EntityManagerJUnitTestSuite.assertFalse((String)"could not detach managed object", (boolean)em.contains((Object)emp));
        emp = (Employee)em.find(Employee.class, (Object)id);
        em.remove((Object)emp);
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadeDetach() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.createQuery("Select e from Employee e where e.managedEmployees is not empty").getResultList().get(0);
            emp.getManagedEmployees().size();
            em.detach((Object)emp);
            EntityManagerJUnitTestSuite.assertFalse((String)"Did not cascade detach", (boolean)em.contains(emp.getManagedEmployees().iterator().next()));
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testDetachNonManagedObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("beforePersist");
        boolean caughtException = false;
        em.detach((Object)emp);
        em.persist((Object)emp);
        em.remove((Object)emp);
        this.commitTransaction(em);
        EntityManagerJUnitTestSuite.assertFalse((String)"Cannot_detach_Object Exception was thrown for a non-managed Entity", (boolean)caughtException);
    }

    public void testRemoveFlushPersistContains() {
        String firstName = "testRemoveFlushPersistContains";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean contains = false;
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            em.flush();
            em.persist((Object)emp);
            contains = em.contains((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerJUnitTestSuite.assertTrue((String)"contains==false", (boolean)contains);
    }

    public void testRemoveFlushFind() {
        String firstName = "testRemoveFlushFind";
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean foundAfterFlush = true;
        boolean foundBeforeFlush = true;
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            Employee empFound = (Employee)em.find(Employee.class, (Object)emp.getId());
            foundBeforeFlush = empFound != null;
            em.flush();
            empFound = (Employee)em.find(Employee.class, (Object)emp.getId());
            foundAfterFlush = empFound != null;
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManagerJUnitTestSuite.assertFalse((String)"removed object found", (boolean)foundBeforeFlush);
        EntityManagerJUnitTestSuite.assertFalse((String)"removed object found after flush", (boolean)foundAfterFlush);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteEmployee() {
        Employee employee = new Employee();
        employee.addPhoneNumber(new PhoneNumber("home", "123", "4567"));
        employee.addPhoneNumber(new PhoneNumber("fax", "456", "4567"));
        employee.addResponsibility("work hard");
        employee.addResponsibility("write code");
        employee.addProject(new Project());
        employee.setWorkWeek(new HashSet());
        employee.getWorkWeek().add(Employee.Weekdays.MONDAY);
        employee.getWorkWeek().add(Employee.Weekdays.TUESDAY);
        QuerySQLTracker counter = new QuerySQLTracker((Session)EntityManagerJUnitTestSuite.getServerSession());
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            counter.getSqlStatements().clear();
            em.remove((Object)employee);
            this.commitTransaction(em);
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 13) {
                EntityManagerJUnitTestSuite.fail((String)("Only 13 sql statements should have occured:" + counter.getSqlStatements().size()));
            }
            this.beginTransaction(em);
            this.verifyDelete(employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            if (counter != null) {
                counter.remove();
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteEverything() {
        EntityManager em = this.createEntityManager();
        try {
            EmployeePopulator employeePopulator = new EmployeePopulator();
            employeePopulator.buildExamples();
            employeePopulator.employeeExample1().setManager(employeePopulator.employeeExample1());
            employeePopulator.employeeExample2().setManager(employeePopulator.employeeExample3());
            employeePopulator.employeeExample3().setManager(employeePopulator.employeeExample2());
            em.clear();
            this.clearCache();
            employeePopulator.persistExample((Session)this.getDatabaseSession());
            this.beginTransaction(em);
            em.setFlushMode(FlushModeType.COMMIT);
            for (Object each : em.createQuery("Select e from Employee e").getResultList()) {
                em.remove(each);
            }
            for (Object each : em.createQuery("Select p from Project p").getResultList()) {
                em.remove(each);
            }
            for (Object each : em.createQuery("Select d from ADV_DEPT d").getResultList()) {
                em.remove(each);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
            employeePopulator = new EmployeePopulator();
            employeePopulator.buildExamples();
            employeePopulator.persistExample((Session)this.getDatabaseSession());
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.setFlushMode(FlushModeType.COMMIT);
            for (Object each : em.createQuery("Select e from Employee e").getResultList()) {
                em.remove(each);
            }
            for (Object each : em.createQuery("Select p from Project p").getResultList()) {
                em.remove(each);
            }
            for (Object each : em.createQuery("Select d from ADV_DEPT d").getResultList()) {
                em.remove(each);
            }
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteEmployee_with_status_enum_collection_instantiated() {
        Employee employee = new Employee();
        PhoneNumber homePhone = new PhoneNumber("home", "123", "4567");
        PhoneNumber faxPhone = new PhoneNumber("fax", "456", "4567");
        employee.addPhoneNumber(homePhone);
        employee.addPhoneNumber(faxPhone);
        employee.addResponsibility("work hard");
        employee.addResponsibility("write code");
        employee.addProject(new Project());
        employee.setWorkWeek(new HashSet());
        employee.getWorkWeek().add(Employee.Weekdays.MONDAY);
        employee.getWorkWeek().add(Employee.Weekdays.TUESDAY);
        employee.setStatus(Employee.EmployeeStatus.PART_TIME);
        homePhone.addStatus(PhoneNumber.PhoneStatus.ASSIGNED);
        QuerySQLTracker counter = new QuerySQLTracker((Session)EntityManagerJUnitTestSuite.getServerSession());
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.getPhoneNumbers();
            counter.getSqlStatements().clear();
            em.remove((Object)employee);
            this.commitTransaction(em);
            if (this.isWeavingEnabled() && counter.getSqlStatements().size() > 13) {
                EntityManagerJUnitTestSuite.fail((String)("Only 13 sql statements should have occured: " + counter.getSqlStatements().size()));
            }
            this.beginTransaction(em);
            this.verifyDelete(employee);
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            if (counter != null) {
                counter.remove();
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteMan() {
        EntityManager em = this.createEntityManager();
        QuerySQLTracker counter = null;
        try {
            this.beginTransaction(em);
            Man man = new Man();
            em.persist((Object)man);
            Woman woman = new Woman();
            em.persist((Object)woman);
            PartnerLink link = new PartnerLink();
            em.persist((Object)link);
            man.setPartnerLink(link);
            link.setMan(man);
            woman.setPartnerLink(link);
            link.setWoman(woman);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            counter = new QuerySQLTracker((Session)EntityManagerJUnitTestSuite.getServerSession());
            em = this.createEntityManager();
            this.beginTransaction(em);
            man = (Man)em.find(Man.class, (Object)man.getId());
            woman = (Woman)em.find(Woman.class, (Object)woman.getId());
            woman.setPartnerLink(null);
            counter.getSqlStatements().clear();
            em.remove((Object)man);
            this.commitTransaction(em);
            if (counter.getSqlStatements().size() > 2) {
                EntityManagerJUnitTestSuite.fail((String)"Only 2 delete should have occured.");
            }
            this.beginTransaction(em);
            this.verifyDelete(man);
            this.commitTransaction(em);
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindWithWrongTypePk() {
        EntityManager em = this.createEntityManager();
        try {
            em.find(Employee.class, (Object)"1");
        }
        catch (IllegalArgumentException ilEx) {
            return;
        }
        catch (Exception ex) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception thrown: " + ex.getMessage()));
            return;
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindWithNullPk() {
        EntityManager em = this.createEntityManager();
        try {
            em.find(Employee.class, null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when null PK used in find operation.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindWithProperties() {
        Employee employee = new Employee();
        employee.setFirstName("Marc");
        HashMap<String, String> queryhints = new HashMap<String, String>();
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)employee);
            em.flush();
            int empId = employee.getId();
            Employee e1 = (Employee)em.find(Employee.class, (Object)empId);
            e1.setFirstName("testfind");
            queryhints.put("eclipselink.refresh", "TRUE");
            Employee e2 = (Employee)em.find(Employee.class, (Object)empId, queryhints);
            EntityManagerJUnitTestSuite.assertFalse((boolean)e2.getFirstName().equals("testfind"));
            em.flush();
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testCheckVersionOnMerge() {
        Employee employee = new Employee();
        employee.setFirstName("Marc");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)employee);
            this.commitTransaction(em);
            em.clear();
            this.beginTransaction(em);
            Employee empClone = (Employee)em.find(Employee.class, (Object)employee.getId());
            empClone.setFirstName("Guy");
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityManagerJUnitTestSuite.fail((String)("Exception caught during test setup " + ex));
        }
        try {
            this.beginTransaction(em);
            em.merge((Object)employee);
            this.commitTransaction(em);
        }
        catch (OptimisticLockException e) {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            return;
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception thrown: " + ex.getMessage()));
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown");
    }

    public void testClear() {
        Employee employee = new Employee();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
            em.clear();
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean cleared = !em.contains((Object)employee);
        this.closeEntityManager(em);
        EntityManagerJUnitTestSuite.assertTrue((String)"EntityManager not properly cleared", (boolean)cleared);
    }

    public void testCloseOnCommit() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.persistence-context.close-on-commit", "true");
        EntityManager em = this.createEntityManager(properties);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Douglas");
            emp.setLastName("McRae");
            em.persist((Object)emp);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(emp);
            this.closeEntityManager(em);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setFirstName("Joe");
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(emp);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
    }

    public void testPersistOnCommit() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.persistence-context.persist-on-commit", "false");
        EntityManager em = this.createEntityManager(properties);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Douglas");
            emp.setLastName("McRae");
            em.persist((Object)emp);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(emp);
            this.closeEntityManager(em);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            Address address = new Address();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setAddress(address);
            em.persist((Object)address);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(emp);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
    }

    public void testNoPersistOnCommit() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setLastName("SomeName");
        Address addr = new Address();
        addr.setCity("Douglas");
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(employee);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            ((RepeatableWriteUnitOfWork)JpaHelper.getEntityManager((EntityManager)em).getUnitOfWork()).setDiscoverUnregisteredNewObjectsWithoutPersist(true);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.setAddress(addr);
            addr.getEmployees().add(employee);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(employee);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.clearCache();
            this.beginTransaction(em);
            ((RepeatableWriteUnitOfWork)JpaHelper.getEntityManager((EntityManager)em).getUnitOfWork()).setDiscoverUnregisteredNewObjectsWithoutPersist(true);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.getAddress().setCountry("country");
            employee.getAddress().getEmployees().size();
            employee.setAddress((Address)null);
            em.remove((Object)employee);
            this.commitTransaction(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            EntityManagerJUnitTestSuite.assertNull((String)"Employee Not Deleted", (Object)employee);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
        finally {
            try {
                em = this.createEntityManager();
                this.clearCache();
                this.beginTransaction(em);
                em.remove(em.find(Address.class, (Object)addr.getID()));
                this.commitTransaction(em);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public void testNoPersistOnCommitProperties() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(JUnitTestCaseHelper.getDatabaseProperties());
        properties.put("eclipselink.persistence-context.commit-without-persist-rules", "true");
        EntityManager em = this.createEntityManager(properties);
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setLastName("SomeName");
        Address addr = new Address();
        addr.setCity("Douglas");
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(employee);
            this.closeEntityManager(em);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.setAddress(addr);
            addr.getEmployees().add(employee);
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(employee);
            this.closeEntityManager(em);
            em = this.createEntityManager(properties);
            this.clearCache();
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.getAddress().setCountry("country");
            employee.getAddress().getEmployees().size();
            employee.setAddress((Address)null);
            em.remove((Object)employee);
            this.commitTransaction(em);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            EntityManagerJUnitTestSuite.assertNull((String)"Employee Not Deleted", (Object)employee);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
        finally {
            try {
                em = this.createEntityManager();
                this.clearCache();
                this.beginTransaction(em);
                em.remove(em.find(Address.class, (Object)addr.getID()));
                this.commitTransaction(em);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public void testNoPersistOnFlushProperties() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(JUnitTestCaseHelper.getDatabaseProperties());
        properties.put("eclipselink.persistence-context.commit-without-persist-rules", "true");
        EntityManager em = this.createEntityManager(properties);
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setLastName("SomeName");
        Address addr = new Address();
        addr.setCity("Douglas");
        try {
            em.persist((Object)employee);
            em.flush();
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(employee);
            this.closeEntityManager(em);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.setAddress(addr);
            addr.getEmployees().add(employee);
            em.flush();
            this.commitTransaction(em);
            this.verifyObjectInCacheAndDatabase(employee);
            this.closeEntityManager(em);
            em = this.createEntityManager(properties);
            this.clearCache();
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            employee.getAddress().setCountry("country");
            employee.getAddress().getEmployees().size();
            employee.setAddress((Address)null);
            em.remove((Object)employee);
            this.commitTransaction(em);
            em = this.createEntityManager(properties);
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            EntityManagerJUnitTestSuite.assertNull((String)"Employee Not Deleted", (Object)employee);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
        finally {
            try {
                em = this.createEntityManager();
                this.clearCache();
                this.beginTransaction(em);
                em.remove(em.find(Address.class, (Object)addr.getID()));
                this.commitTransaction(em);
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public void testFlushMode() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.persistence-context.flush-mode", "COMMIT");
        EntityManager em = this.createEntityManager(properties);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("testFlushMode");
            emp.setLastName("McRae");
            em.persist((Object)emp);
            Query query = em.createQuery("Select e from Employee e where e.firstName = 'testFlushMode'");
            if (query.getResultList().size() > 0) {
                EntityManagerJUnitTestSuite.fail((String)"Query triggered flush.");
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw exception;
        }
    }

    public void testClearWithFlush() {
        boolean updated;
        boolean cleared;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Douglas");
            emp.setLastName("McRae");
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.clearCache();
        EntityManager localEm = this.createEntityManager();
        this.beginTransaction(localEm);
        Employee emp = null;
        String originalName = "";
        boolean reset = false;
        try {
            Query query = localEm.createQuery("Select e FROM Employee e where e.firstName is not null");
            emp = (Employee)query.getResultList().get(0);
            originalName = emp.getFirstName();
            emp.setFirstName("Bobster");
            localEm.flush();
            localEm.clear();
            this.commitTransaction(localEm);
            cleared = !localEm.contains((Object)emp);
            emp = (Employee)localEm.find(Employee.class, (Object)emp.getId());
            updated = emp.getFirstName().equals("Bobster");
            this.closeEntityManager(localEm);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(localEm)) {
                this.rollbackTransaction(localEm);
            }
            this.closeEntityManager(localEm);
            throw exception;
        }
        finally {
            localEm = this.createEntityManager();
            this.beginTransaction(localEm);
            emp = (Employee)localEm.find(Employee.class, (Object)emp.getId());
            emp.setFirstName(originalName);
            this.commitTransaction(localEm);
            emp = (Employee)localEm.find(Employee.class, (Object)emp.getId());
            reset = emp.getFirstName().equals(originalName);
            this.closeEntityManager(localEm);
        }
        EntityManagerJUnitTestSuite.assertTrue((String)"EntityManager not properly cleared", (boolean)cleared);
        EntityManagerJUnitTestSuite.assertTrue((String)"flushed data not merged", (boolean)updated);
        EntityManagerJUnitTestSuite.assertTrue((String)"unable to reset", (boolean)reset);
    }

    public void testClearWithFlush2() {
        String errorMsg;
        block32: {
            Employee employee_4_New;
            Employee manager_InCache;
            Employee manager_New;
            String firstName = "testClearWithFlush2";
            EntityManager em = this.createEntityManager();
            int employee_1_NotInCache_id = 0;
            int employee_2_NotInCache_id = 0;
            int manager_NotInCache_id = 0;
            this.beginTransaction(em);
            try {
                Employee employee_1_NotInCache = new Employee();
                employee_1_NotInCache.setFirstName(firstName);
                employee_1_NotInCache.setLastName("Employee_1_NotInCache");
                Employee employee_2_NotInCache = new Employee();
                employee_2_NotInCache.setFirstName(firstName);
                employee_2_NotInCache.setLastName("Employee_2_NotInCache");
                Employee manager_NotInCache = new Employee();
                manager_NotInCache.setFirstName(firstName);
                manager_NotInCache.setLastName("Manager_NotInCache");
                manager_NotInCache.addManagedEmployee(employee_1_NotInCache);
                em.persist((Object)manager_NotInCache);
                em.persist((Object)employee_1_NotInCache);
                em.persist((Object)employee_2_NotInCache);
                this.commitTransaction(em);
                employee_1_NotInCache_id = employee_1_NotInCache.getId();
                employee_2_NotInCache_id = employee_2_NotInCache.getId();
                manager_NotInCache_id = manager_NotInCache.getId();
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            this.clearCache();
            em = this.createEntityManager();
            int employee_1_InCache_id = 0;
            int employee_2_InCache_id = 0;
            int manager_InCache_id = 0;
            this.beginTransaction(em);
            try {
                Employee employee_1_InCache = new Employee();
                employee_1_InCache.setFirstName(firstName);
                employee_1_InCache.setLastName("Employee_1_InCache");
                Employee employee_2_InCache = new Employee();
                employee_2_InCache.setFirstName(firstName);
                employee_2_InCache.setLastName("Employee_2_InCache");
                Employee manager_InCache2 = new Employee();
                manager_InCache2.setFirstName(firstName);
                manager_InCache2.setLastName("Manager_InCache");
                manager_InCache2.addManagedEmployee(employee_1_InCache);
                em.persist((Object)manager_InCache2);
                em.persist((Object)employee_1_InCache);
                em.persist((Object)employee_2_InCache);
                this.commitTransaction(em);
                employee_1_InCache_id = employee_1_InCache.getId();
                employee_2_InCache_id = employee_2_InCache.getId();
                manager_InCache_id = manager_InCache2.getId();
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            em = this.createEntityManager();
            int employee_1_New_id = 0;
            int employee_2_New_id = 0;
            int employee_3_New_id = 0;
            int employee_4_New_id = 0;
            int manager_New_id = 0;
            this.beginTransaction(em);
            try {
                Employee employee_1_New = new Employee();
                employee_1_New.setFirstName(firstName);
                employee_1_New.setLastName("Employee_1_New");
                em.persist((Object)employee_1_New);
                employee_1_New_id = employee_1_New.getId();
                Employee employee_2_New = new Employee();
                employee_2_New.setFirstName(firstName);
                employee_2_New.setLastName("Employee_2_New");
                em.persist((Object)employee_2_New);
                employee_2_New_id = employee_2_New.getId();
                Employee employee_3_New = new Employee();
                employee_3_New.setFirstName(firstName);
                employee_3_New.setLastName("Employee_3_New");
                em.persist((Object)employee_3_New);
                employee_3_New_id = employee_3_New.getId();
                Employee employee_4_New2 = new Employee();
                employee_4_New2.setFirstName(firstName);
                employee_4_New2.setLastName("Employee_4_New");
                em.persist((Object)employee_4_New2);
                employee_4_New_id = employee_4_New2.getId();
                manager_New = new Employee();
                manager_New.setFirstName(firstName);
                manager_New.setLastName("Manager_New");
                em.persist((Object)manager_New);
                manager_New_id = manager_New.getId();
                Employee employee_1_NotInCache = (Employee)em.find(Employee.class, (Object)employee_1_NotInCache_id);
                employee_1_NotInCache.setLastName(employee_1_NotInCache.getLastName() + "_Updated");
                Employee employee_2_NotInCache = (Employee)em.find(Employee.class, (Object)employee_2_NotInCache_id);
                employee_2_NotInCache.setLastName(employee_2_NotInCache.getLastName() + "_Updated");
                Employee manager_NotInCache = (Employee)em.find(Employee.class, (Object)manager_NotInCache_id);
                manager_NotInCache.setLastName(manager_NotInCache.getLastName() + "_Updated");
                Employee employee_1_InCache = (Employee)em.find(Employee.class, (Object)employee_1_InCache_id);
                employee_1_InCache.setLastName(employee_1_InCache.getLastName() + "_Updated");
                Employee employee_2_InCache = (Employee)em.find(Employee.class, (Object)employee_2_InCache_id);
                employee_2_InCache.setLastName(employee_2_InCache.getLastName() + "_Updated");
                Employee manager_InCache3 = (Employee)em.find(Employee.class, (Object)manager_InCache_id);
                manager_InCache3.setLastName(manager_InCache3.getLastName() + "_Updated");
                manager_NotInCache.addManagedEmployee(employee_1_New);
                manager_InCache3.addManagedEmployee(employee_2_New);
                manager_New.addManagedEmployee(employee_3_New);
                manager_New.addManagedEmployee(employee_2_NotInCache);
                manager_New.addManagedEmployee(employee_2_InCache);
                em.flush();
                em.clear();
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            errorMsg = "";
            em = this.createEntityManager();
            Employee manager_NotInCache = (Employee)em.find(Employee.class, (Object)manager_NotInCache_id);
            if (!manager_NotInCache.getLastName().endsWith("_Updated")) {
                errorMsg = errorMsg + "manager_NotInCache lastName NOT updated; ";
            }
            for (Employee emp : manager_NotInCache.getManagedEmployees()) {
                if (emp.getId() == employee_1_NotInCache_id) {
                    if (emp.getLastName().endsWith("_Updated")) continue;
                    errorMsg = errorMsg + "employee_1_NotInCache lastName NOT updated; ";
                    continue;
                }
                if (emp.getId() == employee_1_New_id) {
                    if (emp.getLastName().endsWith("_New")) continue;
                    errorMsg = errorMsg + "employee_1_New lastName wrong; ";
                    continue;
                }
                errorMsg = errorMsg + "manager_NotInCache has unexpected employee: lastName = " + emp.getLastName();
            }
            if (manager_NotInCache.getManagedEmployees().size() != 2) {
                errorMsg = errorMsg + "manager_NotInCache.getManagedEmployees().size() != 2; size = " + manager_NotInCache.getManagedEmployees().size();
            }
            if (!(manager_InCache = (Employee)em.find(Employee.class, (Object)manager_InCache_id)).getLastName().endsWith("_Updated")) {
                errorMsg = errorMsg + "manager_InCache lastName NOT updated; ";
            }
            for (Employee emp : manager_InCache.getManagedEmployees()) {
                if (emp.getId() == employee_1_InCache_id) {
                    if (emp.getLastName().endsWith("_Updated")) continue;
                    errorMsg = errorMsg + "employee_1_InCache lastName NOT updated; ";
                    continue;
                }
                if (emp.getId() == employee_2_New_id) {
                    if (emp.getLastName().endsWith("_New")) continue;
                    errorMsg = errorMsg + "employee_2_New lastName wrong; ";
                    continue;
                }
                errorMsg = errorMsg + "manager_InCache has unexpected employee: lastName = " + emp.getLastName();
            }
            if (manager_InCache.getManagedEmployees().size() != 2) {
                errorMsg = errorMsg + "manager_InCache.getManagedEmployees().size() != 2; size = " + manager_InCache.getManagedEmployees().size();
            }
            if (!(manager_New = (Employee)em.find(Employee.class, (Object)manager_New_id)).getLastName().endsWith("_New")) {
                errorMsg = errorMsg + "manager_New lastName wrong; ";
            }
            for (Employee emp : manager_New.getManagedEmployees()) {
                if (emp.getId() == employee_2_NotInCache_id) {
                    if (emp.getLastName().endsWith("_Updated")) continue;
                    errorMsg = errorMsg + "employee_2_NotInCache_id lastName NOT updated; ";
                    continue;
                }
                if (emp.getId() == employee_2_InCache_id) {
                    if (emp.getLastName().endsWith("_Updated")) continue;
                    errorMsg = errorMsg + "employee_2_InCache_id lastName NOT updated; ";
                    continue;
                }
                if (emp.getId() == employee_3_New_id) {
                    if (emp.getLastName().endsWith("_New")) continue;
                    errorMsg = errorMsg + "employee_3_New lastName wrong; ";
                    continue;
                }
                errorMsg = errorMsg + "manager_New has unexpected employee: lastName = " + emp.getLastName();
            }
            if (manager_New.getManagedEmployees().size() != 3) {
                errorMsg = errorMsg + "manager_InCache.getManagedEmployees().size() != 3; size = " + manager_InCache.getManagedEmployees().size();
            }
            if (!(employee_4_New = (Employee)em.find(Employee.class, (Object)employee_4_New_id)).getLastName().endsWith("_New")) {
                errorMsg = errorMsg + "employee_4_New lastName wrong; ";
            }
            this.closeEntityManager(em);
            em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                List list = em.createQuery("Select e from Employee e where e.firstName = '" + firstName + "'").getResultList();
                for (Employee e : list) {
                    if (e.getManager() != null) {
                        e.getManager().removeManagedEmployee(e);
                        e.setManager(null);
                    }
                    em.remove((Object)e);
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                if (errorMsg.length() != 0) break block32;
                throw ex;
            }
        }
        this.clearCache();
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testClearInTransaction() {
        Employee emp;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            emp = new Employee();
            emp.setFirstName("Tommy");
            emp.setLastName("Marsh");
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        emp = null;
        String originalName = "";
        try {
            Query query = em.createQuery("Select e FROM Employee e where e.firstName is not null");
            emp = (Employee)query.getResultList().get(0);
            originalName = emp.getFirstName();
            emp.setFirstName("Bobster");
            em.clear();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        boolean cleared = !em.contains((Object)emp);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        this.closeEntityManager(em);
        EntityManagerJUnitTestSuite.assertTrue((String)"EntityManager not properly cleared", (boolean)cleared);
        EntityManagerJUnitTestSuite.assertTrue((String)"Employee was updated although EM was cleared", (boolean)emp.getFirstName().equals(originalName));
    }

    public void testExtendedPersistenceContext() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        String firstName = "testExtendedPersistenceContext";
        int originalSalary = 0;
        Employee empNew = new Employee();
        empNew.setFirstName(firstName);
        empNew.setLastName("new");
        empNew.setSalary(originalSalary);
        Employee empToBeRemoved = new Employee();
        empToBeRemoved.setFirstName(firstName);
        empToBeRemoved.setLastName("toBeRemoved");
        empToBeRemoved.setSalary(originalSalary);
        Employee empToBeRefreshed = new Employee();
        empToBeRefreshed.setFirstName(firstName);
        empToBeRefreshed.setLastName("toBeRefreshed");
        empToBeRefreshed.setSalary(originalSalary);
        Employee empToBeMerged = new Employee();
        empToBeMerged.setFirstName(firstName);
        empToBeMerged.setLastName("toBeMerged");
        empToBeMerged.setSalary(originalSalary);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.persist((Object)empToBeRemoved);
            em.persist((Object)empToBeRefreshed);
            em.persist((Object)empToBeMerged);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        try {
            Employee empToBeRefreshedFound3;
            Employee empToBeRemovedFound3;
            Employee empToBeRefreshedFound2;
            Employee empToBeRemovedFound2;
            Employee empToBeRefreshedFound;
            Employee empToBeRemovedFound;
            em.persist((Object)empNew);
            Employee empToBeRemovedExtended = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId());
            em.remove((Object)empToBeRemovedExtended);
            Employee empToBeRefreshedExtended = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId());
            int newSalary = 100;
            this.beginTransaction(em);
            empToBeRefreshed = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId());
            empToBeRefreshed.setSalary(newSalary);
            this.commitTransaction(em);
            em.refresh((Object)empToBeRefreshedExtended);
            Employee empToBeMergedExtended = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            empToBeMerged.setSalary(newSalary);
            em.merge((Object)empToBeMerged);
            this.beginTransaction(em);
            this.commitTransaction(em);
            if (!em.contains((Object)empNew)) {
                EntityManagerJUnitTestSuite.fail((String)"empNew gone from extended PersistenceContext after transaction committed");
            }
            if (em.contains((Object)empToBeRemovedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRemovedExtended still in extended PersistenceContext after transaction committed");
            }
            if (!em.contains((Object)empToBeRefreshedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshedExtended gone from extended PersistenceContext after transaction committed");
            } else if (empToBeRefreshedExtended.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshedExtended still has the original salary after transaction committed");
            }
            if (!em.contains((Object)empToBeMergedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMergedExtended gone from extended PersistenceContext after transaction committed");
            } else if (empToBeMergedExtended.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMergedExtended still has the original salary after transaction committed");
            }
            this.clearCache();
            Employee empNewFound = (Employee)em.find(Employee.class, (Object)empNew.getId());
            if (empNewFound == null) {
                EntityManagerJUnitTestSuite.fail((String)"empNew not in the db after transaction committed");
            }
            if ((empToBeRemovedFound = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId())) != null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRemoved is still in the db after transaction committed");
            }
            if ((empToBeRefreshedFound = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId())) == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshed not in the db after transaction committed");
            } else if (empToBeRefreshedFound.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshed still has the original salary in the db after transaction committed");
            }
            Employee empToBeMergedFound = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            if (empToBeMergedFound == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMerged not in the db after transaction committed");
            } else if (empToBeMergedFound.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMerged still has the original salary in the db after transaction committed");
            }
            em.persist((Object)empToBeRemoved);
            em.remove((Object)empNew);
            this.beginTransaction(em);
            empToBeRefreshed = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId());
            empToBeRefreshed.setSalary(originalSalary);
            this.commitTransaction(em);
            em.refresh((Object)empToBeRefreshedExtended);
            empToBeMergedFound.setSalary(originalSalary);
            em.merge((Object)empToBeMergedFound);
            this.beginTransaction(em);
            this.commitTransaction(em);
            if (em.contains((Object)empNew)) {
                EntityManagerJUnitTestSuite.fail((String)"empNew not gone from extended PersistenceContext after the second transaction committed");
            }
            if (!em.contains((Object)empToBeRemoved)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRemoved is not in extended PersistenceContext after the second transaction committed");
            }
            if (!em.contains((Object)empToBeRefreshedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshedExtended gone from extended PersistenceContext after the second transaction committed");
            } else if (empToBeRefreshedExtended.getSalary() != originalSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshedExtended still doesn't have the original salary after the second transaction committed");
            }
            if (!em.contains((Object)empToBeMergedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMergedExtended gone from extended PersistenceContext after the second transaction committed");
            } else if (empToBeMergedExtended.getSalary() != originalSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMergedExtended doesn't have the original salary after the second transaction committed");
            }
            this.clearCache();
            Employee empNewFound2 = (Employee)em.find(Employee.class, (Object)empNew.getId());
            if (empNewFound2 != null) {
                EntityManagerJUnitTestSuite.fail((String)"empNew still in the db after the second transaction committed");
            }
            if ((empToBeRemovedFound2 = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId())) == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRemoved is not in the db after the second transaction committed");
            }
            if ((empToBeRefreshedFound2 = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId())) == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshed not in the db after the second transaction committed");
            } else if (empToBeRefreshedFound2.getSalary() != originalSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshed doesn't have the original salary in the db after the second transaction committed");
            }
            Employee empToBeMergedFound2 = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            if (empToBeMergedFound2 == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMerged not in the db after the second transaction committed");
            } else if (empToBeMergedFound2.getSalary() != originalSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMerged doesn't have the original salary in the db after the second transaction committed");
            }
            this.beginTransaction(em);
            em.persist((Object)empNew);
            em.remove((Object)empToBeRemoved);
            em2.getTransaction().begin();
            try (EntityManager em2 = this.createEntityManager();){
                empToBeRefreshed = (Employee)em2.find(Employee.class, (Object)empToBeRefreshed.getId());
                empToBeRefreshed.setSalary(newSalary);
                em2.getTransaction().commit();
            }
            em.refresh((Object)empToBeRefreshedExtended);
            empToBeMergedFound2.setSalary(newSalary);
            em.merge((Object)empToBeMergedFound2);
            em.flush();
            this.rollbackTransaction(em);
            if (em.contains((Object)empNew)) {
                EntityManagerJUnitTestSuite.fail((String)"empNew is still in extended PersistenceContext after the third transaction rolled back");
            }
            if (em.contains((Object)empToBeRemoved)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRemoved is still in extended PersistenceContext after the third transaction rolled back");
            }
            if (em.contains((Object)empToBeRefreshedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshedExtended is still in extended PersistenceContext after the third transaction rolled back");
            } else if (empToBeRefreshedExtended.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshedExtended still has the original salary after third transaction rolled back");
            }
            if (em.contains((Object)empToBeMergedExtended)) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMergedExtended is still in extended PersistenceContext after the third transaction rolled back");
            } else if (empToBeMergedExtended.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMergedExtended still has the original salary after third transaction rolled back");
            }
            this.clearCache();
            Employee empNewFound3 = (Employee)em.find(Employee.class, (Object)empNew.getId());
            if (empNewFound3 != null) {
                EntityManagerJUnitTestSuite.fail((String)"empNew is in the db after the third transaction rolled back");
            }
            if ((empToBeRemovedFound3 = (Employee)em.find(Employee.class, (Object)empToBeRemoved.getId())) == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRemoved not in the db after the third transaction rolled back");
            }
            if ((empToBeRefreshedFound3 = (Employee)em.find(Employee.class, (Object)empToBeRefreshed.getId())) == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshed not in the db after the third transaction rolled back");
            } else if (empToBeRefreshedFound3.getSalary() != newSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeRefreshed has the original salary in the db after the third transaction rolled back");
            }
            Employee empToBeMergedFound3 = (Employee)em.find(Employee.class, (Object)empToBeMerged.getId());
            if (empToBeMergedFound3 == null) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMerged not in the db after the third transaction rolled back");
            } else if (empToBeMergedFound3.getSalary() != originalSalary) {
                EntityManagerJUnitTestSuite.fail((String)"empToBeMerged still doesn't have the original salary in the db after the third transaction rolled back");
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadOnlyTransactionalData() {
        if (EntityManagerJUnitTestSuite.isOnServer() || this.getPlatform().isH2() || this.getPlatform().isDerby() || this.getPlatform().isSymfoware() || this.getPlatform().isSQLServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        em.getTransaction().begin();
        Employee emp = new Employee("Bob", String.valueOf(System.currentTimeMillis()));
        em.persist((Object)emp);
        em.flush();
        try {
            Employee employee = (Employee)em.createQuery("Select e from Employee e where e.lastName = :lName").setHint("eclipselink.read-only", (Object)true).setParameter("lName", (Object)emp.getLastName()).getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        em.getTransaction().rollback();
        em.clear();
        EntityManagerJUnitTestSuite.assertNull((String)"Uncommitted Data loaded into cache", (Object)em.find(Employee.class, (Object)emp.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyCachedLazyAssociation() {
        EntityManager em = this.createEntityManager();
        Integer empId = null;
        Employee emp = null;
        try {
            Address address;
            try {
                this.beginTransaction(em);
                emp = new Employee();
                emp.setFirstName("Mark");
                emp.setLastName("Dowder");
                PhoneNumber phone = new PhoneNumber("work", "613", "5555555");
                emp.addPhoneNumber(phone);
                PhoneNumber newPhone = new PhoneNumber("home", "613", "4444444");
                emp.addPhoneNumber(newPhone);
                address = new Address("SomeStreet", "somecity", "province", "country", "postalcode");
                emp.setAddress(address);
                em.persist((Object)emp);
                em.flush();
                this.commitTransaction(em);
                empId = emp.getId();
                em.getEntityManagerFactory().getCache().evictAll();
                EntityManagerJUnitTestSuite.getServerSession().getIdentityMapAccessor().initializeIdentityMaps();
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            Employee employee = (Employee)em.find(Employee.class, (Object)empId);
            Assert.assertNotNull((String)"No Employee retrieved", (Object)employee);
            employee.getAddress();
            Employee cachedEmployee = (Employee)em.createNamedQuery("findEmployeeByPK", Employee.class).setParameter("id", (Object)empId).setHint("eclipselink.read-only", (Object)"True").getSingleResult();
            Assert.assertNotNull((String)"Employee not found", (Object)cachedEmployee);
            address = cachedEmployee.getAddress();
            Assert.assertNotNull((String)"Address of employee not retrieved", (Object)address);
        }
        finally {
            if (empId != null) {
                this.beginTransaction(em);
                em.remove(em.merge((Object)emp));
                this.commitTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyCachedLazyAssociationInNestedEmbeddable() {
        EntityManager em = this.createEntityManager();
        Integer empId = null;
        Employee emp = null;
        try {
            FormerEmployment formerEmployment;
            try {
                this.beginTransaction(em);
                emp = new Employee();
                emp.setFirstName("Mike");
                emp.setLastName("Dowder");
                Address address = new Address("Street", "City", "Province", "Country", "PostalCode");
                EmploymentPeriod employmentPeriod = new EmploymentPeriod(new java.sql.Date(System.currentTimeMillis()), new java.sql.Date(System.currentTimeMillis()));
                formerEmployment = new FormerEmployment("Former company", employmentPeriod);
                employmentPeriod.setCompanyAddress(address);
                emp.setFormerEmployment(formerEmployment);
                em.persist((Object)emp);
                em.flush();
                this.commitTransaction(em);
                empId = emp.getId();
                em.getEntityManagerFactory().getCache().evictAll();
                EntityManagerJUnitTestSuite.getServerSession().getIdentityMapAccessor().initializeIdentityMaps();
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            Employee employee = (Employee)em.find(Employee.class, (Object)empId);
            Assert.assertNotNull((String)"No Employee retrieved", (Object)employee);
            employee.getFormerEmployment().getPeriod().getCompanyAddress();
            Employee cachedEmployee = (Employee)em.createNamedQuery("findEmployeeByPK", Employee.class).setParameter("id", (Object)empId).setHint("eclipselink.read-only", (Object)"True").getSingleResult();
            Assert.assertNotNull((String)"Employee not found", (Object)cachedEmployee);
            formerEmployment = employee.getFormerEmployment();
            Assert.assertNotNull((String)"Former employment details not retrieved", (Object)formerEmployment);
            EmploymentPeriod employmentPeriod = formerEmployment.getPeriod();
            Assert.assertNotNull((String)"Former employment period not retrieved", (Object)employmentPeriod);
            Address address = employmentPeriod.getCompanyAddress();
            Assert.assertNotNull((String)"Former employment address not retrieved", (Object)address);
        }
        finally {
            if (empId != null) {
                this.beginTransaction(em);
                em.remove(em.merge((Object)emp));
                this.commitTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testReadTransactionIsolation_CustomUpdate() {
        this.internalTestReadTransactionIsolation(false, false, false, false);
    }

    public void testReadTransactionIsolation_CustomUpdate_Flush() {
        this.internalTestReadTransactionIsolation(false, false, false, true);
    }

    public void testReadTransactionIsolation_CustomUpdate_Refresh() {
        this.internalTestReadTransactionIsolation(false, false, true, false);
    }

    public void testReadTransactionIsolation_CustomUpdate_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(false, false, true, true);
    }

    public void testReadTransactionIsolation_UpdateAll() {
        this.internalTestReadTransactionIsolation(false, true, false, false);
    }

    public void testReadTransactionIsolation_UpdateAll_Flush() {
        this.internalTestReadTransactionIsolation(false, true, false, true);
    }

    public void testReadTransactionIsolation_UpdateAll_Refresh() {
        this.internalTestReadTransactionIsolation(false, true, true, false);
    }

    public void testReadTransactionIsolation_UpdateAll_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(false, true, true, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate() {
        this.internalTestReadTransactionIsolation(true, false, false, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate_Flush() {
        this.internalTestReadTransactionIsolation(true, false, false, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh() {
        this.internalTestReadTransactionIsolation(true, false, true, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_CustomUpdate_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(true, false, true, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll() {
        this.internalTestReadTransactionIsolation(true, true, false, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll_Flush() {
        this.internalTestReadTransactionIsolation(true, true, false, true);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh() {
        this.internalTestReadTransactionIsolation(true, true, true, false);
    }

    public void testReadTransactionIsolation_OriginalInCache_UpdateAll_Refresh_Flush() {
        this.internalTestReadTransactionIsolation(true, true, true, true);
    }

    protected void internalTestReadTransactionIsolation(boolean shouldOriginalBeInParentCache, boolean shouldUpdateAll, boolean shouldRefresh, boolean shouldFlush) {
        if (shouldUpdateAll && JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("A testReadTransactionIsolation test skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String firstName = "testReadTransactionIsolation";
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.clearCache();
        em.clear();
        String lastNameOriginal = "Original";
        int salaryOriginal = 0;
        Employee employee = new Employee();
        employee.setFirstName(firstName);
        employee.setLastName(lastNameOriginal);
        employee.setSalary(salaryOriginal);
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        if (!shouldOriginalBeInParentCache) {
            this.clearCache();
        }
        em.clear();
        Employee employeeUOW = null;
        int salaryNew = 100;
        String lastNameNew = "New";
        this.beginTransaction(em);
        Query selectQuery = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'");
        try {
            if (shouldRefresh) {
                String lastNameAlternative = "Alternative";
                int salaryAlternative = 50;
                employeeUOW = (Employee)selectQuery.getSingleResult();
                employeeUOW.setLastName(lastNameAlternative);
                employeeUOW.setSalary(salaryAlternative);
            }
            int nUpdated = shouldUpdateAll ? em.createQuery("UPDATE Employee e set e.lastName = '" + lastNameNew + "' where e.firstName like '" + firstName + "'").setFlushMode(FlushModeType.AUTO).executeUpdate() : em.createNativeQuery("UPDATE CMP3_EMPLOYEE SET L_NAME = '" + lastNameNew + "', VERSION = VERSION + 1 WHERE F_NAME LIKE '" + firstName + "'").setFlushMode(FlushModeType.AUTO).executeUpdate();
            EntityManagerJUnitTestSuite.assertTrue((String)("nUpdated==" + nUpdated + "; 1 was expected"), (nUpdated == 1 ? 1 : 0) != 0);
            if (shouldFlush) {
                selectQuery.setFlushMode(FlushModeType.AUTO);
            } else {
                selectQuery.setFlushMode(FlushModeType.COMMIT);
            }
            if (shouldRefresh) {
                selectQuery.setHint("eclipselink.refresh", (Object)Boolean.TRUE);
                employeeUOW = (Employee)selectQuery.getSingleResult();
                selectQuery.setHint("eclipselink.refresh", (Object)Boolean.FALSE);
            } else {
                employeeUOW = (Employee)selectQuery.getSingleResult();
            }
            EntityManagerJUnitTestSuite.assertTrue((String)("employeeUOW.getLastName()==" + employeeUOW.getLastName() + "; " + lastNameNew + " was expected"), (boolean)employeeUOW.getLastName().equals(lastNameNew));
            employeeUOW.setSalary(salaryNew);
            employeeUOW = (Employee)selectQuery.getSingleResult();
            EntityManagerJUnitTestSuite.assertTrue((String)("employeeUOW.getSalary()==" + employeeUOW.getSalary() + "; " + salaryNew + " was expected"), (employeeUOW.getSalary() == salaryNew ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (Throwable ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                int expectedExceptionCode = shouldUpdateAll ? 6180 : 6181;
                if (ex instanceof PersistenceException) {
                    if (ex.getCause() instanceof QueryException && ((QueryException)ex.getCause()).getErrorCode() == expectedExceptionCode) {
                        return;
                    }
                    EntityManagerJUnitTestSuite.fail((String)("Wrong cause of PersistenceException: " + ex.getCause()));
                } else {
                    EntityManagerJUnitTestSuite.fail((String)"PersistenceException was expected");
                }
            }
            if (Error.class.isAssignableFrom(ex.getClass())) {
                throw (Error)ex;
            }
            throw (RuntimeException)ex;
        }
        Employee employeeFoundAfterTransaction = (Employee)em.find(Employee.class, (Object)employeeUOW.getId());
        EntityManagerJUnitTestSuite.assertTrue((String)("employeeFoundAfterTransaction().getLastName()==" + employeeFoundAfterTransaction.getLastName() + "; " + lastNameNew + " was expected"), (boolean)employeeFoundAfterTransaction.getLastName().equals(lastNameNew));
        EntityManagerJUnitTestSuite.assertTrue((String)("employeeFoundAfterTransaction().getSalary()==" + employeeFoundAfterTransaction.getSalary() + "; " + salaryNew + " was expected"), (employeeFoundAfterTransaction.getSalary() == salaryNew ? 1 : 0) != 0);
        EntityManager em2 = this.createEntityManager();
        employeeFoundAfterTransaction = (Employee)em2.find(Employee.class, (Object)employeeUOW.getId());
        EntityManagerJUnitTestSuite.assertTrue((String)("employeeFoundAfterTransaction().getLastName()==" + employeeFoundAfterTransaction.getLastName() + "; " + lastNameNew + " was expected"), (boolean)employeeFoundAfterTransaction.getLastName().equals(lastNameNew));
        EntityManagerJUnitTestSuite.assertTrue((String)("employeeFoundAfterTransaction().getSalary()==" + employeeFoundAfterTransaction.getSalary() + "; " + salaryNew + " was expected"), (employeeFoundAfterTransaction.getSalary() == salaryNew ? 1 : 0) != 0);
        this.closeEntityManager(em2);
        this.beginTransaction(em);
        try {
            Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
            for (Object oldData : q.getResultList()) {
                em.remove(oldData);
            }
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.clearCache();
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindDeleteAllPersist() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testFindDeleteAllPersist skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String firstName = "testFindDeleteAllPersist";
        Employee empWithAddress = new Employee();
        empWithAddress.setFirstName(firstName);
        empWithAddress.setLastName("WithAddress");
        empWithAddress.setAddress(new Address());
        Employee empWithoutAddress = new Employee();
        empWithoutAddress.setFirstName(firstName);
        empWithoutAddress.setLastName("WithoutAddress");
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            em.persist((Object)empWithAddress);
            em.persist((Object)empWithoutAddress);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.clearCache();
        em.clear();
        this.beginTransaction(em);
        try {
            Employee empWithAddressFound = (Employee)em.find(Employee.class, (Object)empWithAddress.getId());
            empWithAddressFound.toString();
            Employee empWithoutAddressFound = (Employee)em.find(Employee.class, (Object)empWithoutAddress.getId());
            empWithoutAddressFound.toString();
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "' and e.address IS NULL").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        em.clear();
        this.beginTransaction(em);
        try {
            Employee newEmpWithoutAddress = new Employee();
            newEmpWithoutAddress.setFirstName(firstName);
            newEmpWithoutAddress.setLastName("newWithoutAddress");
            newEmpWithoutAddress.setId(empWithoutAddress.getId());
            em.persist((Object)newEmpWithoutAddress);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            Employee newEmpWithAddress = new Employee();
            newEmpWithAddress.setFirstName(firstName);
            newEmpWithAddress.setLastName("newWithAddress");
            newEmpWithAddress.setId(empWithAddress.getId());
            em.persist((Object)newEmpWithAddress);
            EntityManagerJUnitTestSuite.fail((String)"EntityExistsException was expected");
        }
        catch (EntityExistsException entityExistsException) {
        }
        finally {
            this.rollbackTransaction(em);
        }
        this.beginTransaction(em);
        em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testWRITELock() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        Employee employee = new Employee();
        employee.setFirstName("Mark");
        employee.setLastName("Madsen");
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        EntityManager em2 = this.createEntityManager();
        RollbackException optimisticLockException = null;
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.lock((Object)employee, LockModeType.WRITE);
            em2.getTransaction().begin();
            try {
                Employee employee2 = (Employee)em2.find(Employee.class, (Object)employee.getId());
                employee2.setFirstName("Michael");
                em2.getTransaction().commit();
            }
            catch (RuntimeException ex) {
                em2.getTransaction().rollback();
                em2.close();
                throw ex;
            }
            this.commitTransaction(em);
        }
        catch (RollbackException exception) {
            if (exception.getCause() instanceof OptimisticLockException) {
                optimisticLockException = exception;
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        if (optimisticLockException == null) {
            EntityManagerJUnitTestSuite.fail((String)"Proper exception not thrown when EntityManager.lock(object, WRITE) is used.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMFWrapValidationException() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        try (EntityManagerFactory factory = null;){
            factory = Persistence.createEntityManagerFactory((String)"broken-PU", (Map)JUnitTestCaseHelper.getDatabaseProperties());
            EntityManager em = factory.createEntityManager();
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMDefaultTxType() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        try (EntityManagerFactory factory = null;){
            factory = Persistence.createEntityManagerFactory((String)"default1", (Map)JUnitTestCaseHelper.getDatabaseProperties());
            EntityManager em = factory.createEntityManager();
            em.close();
        }
        Assert.assertTrue((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistOnNonEntity() {
        boolean testPass = false;
        Object nonEntity = new Object();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist(nonEntity);
        }
        catch (IllegalArgumentException e) {
            testPass = true;
        }
        finally {
            this.rollbackTransaction(em);
        }
        Assert.assertTrue((boolean)testPass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDetachNonEntity() {
        boolean testPass = false;
        Object nonEntity = new Object();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.detach(nonEntity);
        }
        catch (IllegalArgumentException e) {
            testPass = true;
        }
        finally {
            this.rollbackTransaction(em);
        }
        Assert.assertTrue((boolean)testPass);
    }

    public void testClose() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        if (!em.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"Created EntityManager is not open");
        }
        this.closeEntityManager(em);
        if (em.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"Closed EntityManager is still open");
        }
    }

    public void testBeginTransactionClose() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            this.closeEntityManager(em);
            if (em.isOpen()) {
                EntityManagerJUnitTestSuite.fail((String)"Closed EntityManager is still open before transaction complete");
            }
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            if (em.isOpen()) {
                this.closeEntityManager(em);
            }
            throw ex;
        }
        this.rollbackTransaction(em);
        if (em.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"Closed EntityManager is still open after transaction rollback");
        }
    }

    public void testBeginTransactionCloseCommitTransaction() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        String firstName = "testBeginTrCloseCommitTr";
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = '" + firstName + "'");
        for (Object oldData : q.getResultList()) {
            em.remove(oldData);
        }
        this.commitTransaction(em);
        Employee employee = new Employee();
        employee.setFirstName(firstName);
        this.beginTransaction(em);
        try {
            em.persist((Object)employee);
            this.closeEntityManager(em);
            if (em.isOpen()) {
                EntityManagerJUnitTestSuite.fail((String)"Closed EntityManager is still open before transaction complete");
            }
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            if (em.isOpen()) {
                this.closeEntityManager(em);
            }
            throw ex;
        }
        this.commitTransaction(em);
        if (em.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"Closed EntityManager is still open after transaction commit");
        }
        em = this.createEntityManager();
        RuntimeException exception = null;
        Employee persistedEmployee = null;
        try {
            persistedEmployee = (Employee)em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getSingleResult();
            persistedEmployee.toString();
        }
        catch (RuntimeException runtimeException) {
            exception = runtimeException;
        }
        this.beginTransaction(em);
        em.remove(persistedEmployee);
        this.commitTransaction(em);
        if (exception != null) {
            if (exception instanceof EntityNotFoundException) {
                EntityManagerJUnitTestSuite.fail((String)"object has not been persisted");
            } else {
                throw exception;
            }
        }
    }

    public void testBeginTransactionOnClosedEM() {
        if (EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.isJTA()) {
            return;
        }
        IllegalStateException expected = null;
        EntityManager em = this.createEntityManager();
        EntityTransaction transaction = em.getTransaction();
        em.close();
        try {
            transaction.begin();
        }
        catch (IllegalStateException ise) {
            expected = ise;
        }
    }

    public void testPersistenceProperties() {
        IdValidation addressIdValidation;
        IdValidation employeeIdValidation;
        int numAddressCalls;
        int numEmployeeCalls;
        int numProjectCalls;
        int numSessionCalls;
        Class departmentCacheType;
        Class addressCacheType;
        Class employeeCacheType;
        Class defaultCacheType;
        int departmentCacheSize;
        int addressCacheSize;
        int employeeCacheSize;
        int defaultCacheSize;
        String sessionName;
        int batchSize;
        int readMax;
        int readMin;
        int writeMax;
        int writeInitial;
        int writeMin;
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        ServerSession ss = ((EntityManagerImpl)em).getServerSession();
        boolean isReadShared = ss.getReadConnectionPool() instanceof ReadConnectionPool;
        if (isReadShared != Boolean.parseBoolean((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.read-connections.shared"))) {
            EntityManagerJUnitTestSuite.fail((String)"isReadShared is wrong");
        }
        if ((writeMin = ss.getDefaultConnectionPool().getMinNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.write-connections.min"))) {
            EntityManagerJUnitTestSuite.fail((String)"writeMin is wrong");
        }
        if ((writeInitial = ss.getDefaultConnectionPool().getInitialNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.write-connections.initial"))) {
            EntityManagerJUnitTestSuite.fail((String)"writeInitial is wrong");
        }
        if ((writeMax = ss.getDefaultConnectionPool().getMaxNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.write-connections.max"))) {
            EntityManagerJUnitTestSuite.fail((String)"writeMax is wrong");
        }
        if ((readMin = ss.getReadConnectionPool().getMinNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.read-connections.min"))) {
            EntityManagerJUnitTestSuite.fail((String)"readMin is wrong");
        }
        if ((readMax = ss.getReadConnectionPool().getMaxNumberOfConnections()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.read-connections.max"))) {
            EntityManagerJUnitTestSuite.fail((String)"readMax is wrong");
        }
        if ((batchSize = ss.getPlatform().getMaxBatchWritingSize()) != Integer.parseInt((String)JUnitTestCaseHelper.propertiesMap.get("eclipselink.jdbc.batch-writing.size"))) {
            EntityManagerJUnitTestSuite.fail((String)"batchSize is wrong");
        }
        if (!(sessionName = ss.getName()).equals("default-session")) {
            EntityManagerJUnitTestSuite.fail((String)("sessionName is wrong: " + sessionName));
        }
        if ((defaultCacheSize = ss.getDescriptor(Project.class).getIdentityMapSize()) != 500) {
            EntityManagerJUnitTestSuite.fail((String)("defaultCacheSize is wrong: " + defaultCacheSize));
        }
        if ((employeeCacheSize = ss.getDescriptor(Employee.class).getIdentityMapSize()) != 550) {
            EntityManagerJUnitTestSuite.fail((String)("employeeCacheSize is wrong: " + employeeCacheSize));
        }
        if ((addressCacheSize = ss.getDescriptor(Address.class).getIdentityMapSize()) != 555) {
            EntityManagerJUnitTestSuite.fail((String)("addressCacheSize is wrong: " + addressCacheSize));
        }
        if ((departmentCacheSize = ss.getDescriptor(Department.class).getIdentityMapSize()) != 777) {
            EntityManagerJUnitTestSuite.fail((String)("departmentCacheSize is wrong: " + departmentCacheSize));
        }
        if (!Helper.getShortClassName((Class)(defaultCacheType = ss.getDescriptor(Project.class).getIdentityMapClass())).equals("FullIdentityMap")) {
            EntityManagerJUnitTestSuite.fail((String)("defaultCacheType is wrong: " + Helper.getShortClassName((Class)defaultCacheType)));
        }
        if (!Helper.getShortClassName((Class)(employeeCacheType = ss.getDescriptor(Employee.class).getIdentityMapClass())).equals("WeakIdentityMap")) {
            EntityManagerJUnitTestSuite.fail((String)("employeeCacheType is wrong: " + Helper.getShortClassName((Class)employeeCacheType)));
        }
        if (!Helper.getShortClassName((Class)(addressCacheType = ss.getDescriptor(Address.class).getIdentityMapClass())).equals("HardCacheWeakIdentityMap")) {
            EntityManagerJUnitTestSuite.fail((String)("addressCacheType is wrong: " + Helper.getShortClassName((Class)addressCacheType)));
        }
        if (!Helper.getShortClassName((Class)(departmentCacheType = ss.getDescriptor(Department.class).getIdentityMapClass())).equals("SoftCacheWeakIdentityMap")) {
            EntityManagerJUnitTestSuite.fail((String)("departmentCacheType is wrong: " + Helper.getShortClassName((Class)departmentCacheType)));
        }
        if ((numSessionCalls = Customizer.getNumberOfCallsForSession((String)ss.getName())) == 0) {
            EntityManagerJUnitTestSuite.fail((String)"session customizer hasn't been called");
        }
        if ((numProjectCalls = Customizer.getNumberOfCallsForClass((String)Project.class.getName())) == 0) {
            EntityManagerJUnitTestSuite.fail((String)"Project customizer hasn't been called");
        }
        if ((numEmployeeCalls = Customizer.getNumberOfCallsForClass((String)Employee.class.getName())) == 0) {
            EntityManagerJUnitTestSuite.fail((String)"Employee customizer hasn't been called");
        }
        if ((numAddressCalls = Customizer.getNumberOfCallsForClass((String)Address.class.getName())) == 0) {
            EntityManagerJUnitTestSuite.fail((String)"Address customizer hasn't been called");
        }
        if ((employeeIdValidation = ss.getDescriptor(Employee.class).getIdValidation()) != IdValidation.ZERO) {
            EntityManagerJUnitTestSuite.fail((String)"employeeIdValidation is wrong, IdValidation.ZERO assigned through PrimaryKey annotation was expected");
        }
        if ((addressIdValidation = ss.getDescriptor(Address.class).getIdValidation()) != IdValidation.NEGATIVE) {
            EntityManagerJUnitTestSuite.fail((String)"addressIdValidation is wrong, IdValidation.NEGATIVE set as a default value in persistence.xml was expected");
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLockModeType() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testGetLockModeType skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        if (this.isSelectForUpateSupported()) {
            EntityManager em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                Employee emp = new Employee();
                Employee emp1 = new Employee();
                Employee emp2 = new Employee();
                Employee emp3 = new Employee();
                Employee emp4 = new Employee();
                Employee emp5 = new Employee();
                Employee emp6 = new Employee();
                Employee emp7 = new Employee();
                emp.setFirstName("Douglas");
                emp.setLastName("McRae");
                emp1.setFirstName("kaul");
                emp1.setLastName("Jeet");
                emp2.setFirstName("Schwatz");
                emp2.setLastName("Jonathan");
                emp3.setFirstName("Anil");
                emp3.setLastName("Gadre");
                emp4.setFirstName("Anil");
                emp4.setLastName("Gaur");
                emp5.setFirstName("Eliot");
                emp5.setLastName("Morrison");
                emp6.setFirstName("Edward");
                emp6.setLastName("Bratt");
                emp7.setFirstName("TJ");
                emp7.setLastName("Thomas");
                em.persist((Object)emp);
                em.persist((Object)emp1);
                em.persist((Object)emp2);
                em.persist((Object)emp3);
                em.persist((Object)emp4);
                em.persist((Object)emp5);
                em.persist((Object)emp6);
                em.persist((Object)emp7);
                this.commitTransaction(em);
                this.beginTransaction(em);
                emp = (Employee)em.find(Employee.class, (Object)emp.getId());
                emp1 = (Employee)em.find(Employee.class, (Object)emp1.getId());
                emp2 = (Employee)em.find(Employee.class, (Object)emp2.getId());
                emp3 = (Employee)em.find(Employee.class, (Object)emp3.getId());
                emp4 = (Employee)em.find(Employee.class, (Object)emp4.getId());
                emp5 = (Employee)em.find(Employee.class, (Object)emp5.getId());
                emp6 = (Employee)em.find(Employee.class, (Object)emp6.getId());
                emp7 = (Employee)em.find(Employee.class, (Object)emp7.getId());
                em.lock((Object)emp, LockModeType.OPTIMISTIC);
                LockModeType lt = em.getLockMode((Object)emp);
                em.lock((Object)emp1, LockModeType.OPTIMISTIC_FORCE_INCREMENT);
                LockModeType lt1 = em.getLockMode((Object)emp1);
                em.lock((Object)emp5, LockModeType.READ);
                LockModeType lt5 = em.getLockMode((Object)emp5);
                em.lock((Object)emp6, LockModeType.WRITE);
                LockModeType lt6 = em.getLockMode((Object)emp6);
                em.lock((Object)emp7, LockModeType.NONE);
                LockModeType lt7 = em.getLockMode((Object)emp7);
                EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.OPTIMISTIC, (Object)lt);
                EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT, (Object)lt1);
                EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.OPTIMISTIC, (Object)lt5);
                EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.OPTIMISTIC_FORCE_INCREMENT, (Object)lt6);
                EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.NONE, (Object)lt7);
                if (!EntityManagerJUnitTestSuite.getServerSession().getPlatform().isHANA()) {
                    em.lock((Object)emp2, LockModeType.PESSIMISTIC_READ);
                    LockModeType lt2 = em.getLockMode((Object)emp2);
                    em.lock((Object)emp3, LockModeType.PESSIMISTIC_WRITE);
                    LockModeType lt3 = em.getLockMode((Object)emp3);
                    em.lock((Object)emp4, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
                    LockModeType lt4 = em.getLockMode((Object)emp4);
                    EntityManagerJUnitTestSuite.assertTrue((String)"Did not return correct LockModeType", (lt2 == LockModeType.PESSIMISTIC_WRITE || lt2 == LockModeType.PESSIMISTIC_READ ? 1 : 0) != 0);
                    EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.PESSIMISTIC_WRITE, (Object)lt3);
                    EntityManagerJUnitTestSuite.assertEquals((String)"Did not return correct LockModeType", (Object)LockModeType.PESSIMISTIC_FORCE_INCREMENT, (Object)lt4);
                }
            }
            catch (UnsupportedOperationException use) {
                return;
            }
            finally {
                this.rollbackTransaction(em);
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetProperties() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Map m1 = em.getProperties();
            m1.remove("eclipselink.weaving");
        }
        catch (UnsupportedOperationException use) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when entityManager's properties are attempted to change.");
    }

    public void testUOWReferenceInExpressionCache() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager manager = this.createEntityManager();
        ((JpaEntityManager)manager).getUnitOfWork().getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
        DescriptorQueryManager queryManager = ((JpaEntityManager)manager).getUnitOfWork().getDescriptor(Employee.class).getQueryManager();
        queryManager.setExpressionQueryCacheMaxSize(queryManager.getExpressionQueryCacheMaxSize());
        ReadAllQuery query = new ReadAllQuery();
        query.setIsExecutionClone(true);
        query.setReferenceClass(Employee.class);
        ((JpaEntityManager)manager).getUnitOfWork().executeQuery((DatabaseQuery)query);
        this.closeEntityManager(manager);
        EntityManagerJUnitTestSuite.assertNull((String)"ExpressionCache has query that references a RWUOW", (Object)queryManager.getCachedExpressionQuery((DatabaseQuery)query).getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnWrapClass() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            EntityManagerImpl emi = (EntityManagerImpl)em.getDelegate();
            ServerSession session = emi.getServerSession();
            UnitOfWork uow = emi.getUnitOfWork();
            EntityManagerImpl jem = emi;
            ServerSession session1 = (ServerSession)em.unwrap(Session.class);
            EntityManagerJUnitTestSuite.assertEquals((String)"Does not return server session", (Object)session, (Object)session1);
            UnitOfWork uow1 = (UnitOfWork)em.unwrap(UnitOfWork.class);
            EntityManagerJUnitTestSuite.assertEquals((String)"Does not return unit of work", (Object)uow, (Object)uow1);
            JpaEntityManager jem1 = (JpaEntityManager)em.unwrap(JpaEntityManager.class);
            EntityManagerJUnitTestSuite.assertEquals((String)"Does not return underlying entitymanager", (Object)jem, (Object)jem1);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testMultipleFactories() {
        this.getEntityManagerFactory();
        this.closeEntityManagerFactory();
        boolean isOpen = this.getEntityManagerFactory().isOpen();
        if (!isOpen) {
            EntityManagerJUnitTestSuite.fail((String)"Close factory 1; open factory 2 - it's not open");
        } else {
            this.getEntityManagerFactory().createEntityManager().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testApplicationManagedInServer() {
        EntityManagerFactoryImpl factory;
        if (EntityManagerJUnitTestSuite.getServerPlatform().isWeblogic()) {
            WebLogic_12_Platform webLogic12Platform;
            HashMap<String, String> properties = new HashMap<String, String>();
            String applicationId = "eclipselink-advanced-model";
            ServerPlatform serverPlatform = EntityManagerJUnitTestSuite.getServerSession().getServerPlatform();
            if (serverPlatform.usesPartitions() && !(webLogic12Platform = (WebLogic_12_Platform)serverPlatform).isGlobalRuntime()) {
                applicationId = applicationId + "$" + webLogic12Platform.getPartitionName();
            }
            properties.put("weblogic.application-id", applicationId);
            factory = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)"default", properties);
        } else {
            factory = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)"default");
        }
        try {
            if (this.getDatabaseSession() != factory.getServerSession()) {
                EntityManagerJUnitTestSuite.fail((String)("Application managed persistence unit is not the same as the container managed session.  Deployment is broken." + this.getDatabaseSession().getName() + " != " + factory.getServerSession().getName()));
            }
        }
        finally {
            factory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleExistenceChecksForDetachedObjects() {
        EntityManager em = this.createEntityManager();
        Department dept1 = new Department("Dept1");
        Department dept2 = new Department("Dept2");
        Department dept3 = new Department("DetachedDept");
        Employee emp = new Employee("Bob", "Bob");
        try {
            List results = em.createQuery("Select a from Address a").getResultList();
            this.beginTransaction(em);
            em.persist((Object)emp);
            em.persist((Object)dept1);
            em.persist((Object)dept2);
            this.commitTransaction(em);
            em.clear();
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setDepartment(dept2);
            em.flush();
            em.persist((Object)dept3);
            emp.setDepartment(dept3);
            em.flush();
            emp.setDepartment(dept1);
            em.flush();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.verifyObjectInCacheAndDatabase(emp);
        }
        finally {
            try {
                em = this.createEntityManager();
                this.beginTransaction(em);
                em.remove(em.find(Department.class, (Object)dept1.getId()));
                em.remove(em.find(Department.class, (Object)dept2.getId()));
                em.remove(em.find(Department.class, (Object)dept3.getId()));
                em.remove(em.find(Employee.class, (Object)emp.getId()));
                this.commitTransaction(em);
            }
            catch (Exception exception) {}
        }
    }

    public void testParallelMultipleFactories() {
        EntityManagerFactory factory3;
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManagerFactory factory1 = Persistence.createEntityManagerFactory((String)"default", (Map)JUnitTestCaseHelper.getDatabaseProperties());
        factory1.createEntityManager();
        EntityManagerFactory factory2 = Persistence.createEntityManagerFactory((String)"default", (Map)JUnitTestCaseHelper.getDatabaseProperties());
        factory2.createEntityManager();
        factory1.close();
        if (factory1.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"after factory1.close() factory1 is not closed");
        }
        if (!factory2.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"after factory1.close() factory2 is closed");
        }
        factory2.close();
        if (factory2.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"after factory2.close() factory2 is not closed");
        }
        if (!(factory3 = Persistence.createEntityManagerFactory((String)"default", (Map)JUnitTestCaseHelper.getDatabaseProperties())).isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"factory3 is closed");
        }
        factory3.createEntityManager();
        factory3.close();
        if (factory3.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"after factory3.close() factory3 is open");
        }
    }

    public void testQueryHints() {
        EntityManager em = (EntityManager)this.getEntityManagerFactory().createEntityManager().getDelegate();
        Query query = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = 'testQueryHints'");
        query.setHint("eclipselink.read-only", (Object)false);
        ObjectLevelReadQuery olrQuery = (ObjectLevelReadQuery)((JpaQuery)query).getDatabaseQuery();
        EntityManagerJUnitTestSuite.assertTrue((boolean)olrQuery.shouldIgnoreBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)true);
        olrQuery = (ObjectLevelReadQuery)((EJBQueryImpl)query).getDatabaseQuery();
        EntityManagerJUnitTestSuite.assertTrue((String)"Binding not set.", (boolean)olrQuery.shouldBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"");
        EntityManagerJUnitTestSuite.assertTrue((String)"Binding not set.", (boolean)olrQuery.shouldIgnoreBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"Binding not set.", (boolean)olrQuery.shouldBindAllParameters());
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"");
        EntityManagerJUnitTestSuite.assertTrue((String)"Binding not set.", (boolean)olrQuery.shouldIgnoreBindAllParameters());
        query.setHint("eclipselink.cache-usage", (Object)"DoNotCheckCache");
        EntityManagerJUnitTestSuite.assertTrue((String)"Cache usage not set.", (olrQuery.getCacheUsage() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
        EntityManagerJUnitTestSuite.assertTrue((String)"Cache usage not set.", (boolean)olrQuery.shouldCheckCacheOnly());
        query.setHint("eclipselink.cache-usage", (Object)"ConformResultsInUnitOfWork");
        EntityManagerJUnitTestSuite.assertTrue((String)"Cache usage not set.", (boolean)olrQuery.shouldConformResultsInUnitOfWork());
        query.setHint("eclipselink.cache-usage.indirection-policy", (Object)"Trigger");
        EntityManagerJUnitTestSuite.assertTrue((String)"INDIRECTION_POLICY not set.", (olrQuery.getInMemoryQueryIndirectionPolicyState() == 1 ? 1 : 0) != 0);
        query.setHint("eclipselink.cache-usage", (Object)"");
        EntityManagerJUnitTestSuite.assertTrue((String)"Cache usage not set.", (boolean)olrQuery.shouldCheckDescriptorForCacheUsage());
        query.setHint("eclipselink.pessimistic-lock", (Object)"Lock");
        EntityManagerJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 1 ? 1 : 0) != 0);
        query.setHint("eclipselink.pessimistic-lock", (Object)"NoLock");
        EntityManagerJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.pessimistic-lock", (Object)"LockNoWait");
        EntityManagerJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 2 ? 1 : 0) != 0);
        query.setHint("eclipselink.pessimistic-lock", (Object)"");
        EntityManagerJUnitTestSuite.assertTrue((String)"Lock not set.", (olrQuery.getLockMode() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh", (Object)false);
        EntityManagerJUnitTestSuite.assertFalse((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        query.setHint("eclipselink.refresh", (Object)true);
        EntityManagerJUnitTestSuite.assertTrue((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        EntityManagerJUnitTestSuite.assertTrue((String)"CascadeByMapping not set.", (boolean)olrQuery.shouldCascadeByMapping());
        query.setHint("eclipselink.refresh", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        query.setHint("eclipselink.refresh", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        EntityManagerJUnitTestSuite.assertTrue((String)"CascadeByMapping not set.", (boolean)olrQuery.shouldCascadeByMapping());
        query.setHint("eclipselink.refresh", (Object)"");
        EntityManagerJUnitTestSuite.assertFalse((String)"Refresh not set.", (boolean)olrQuery.shouldRefreshIdentityMapResult());
        query.setHint("eclipselink.read-only", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"Read-only not set.", (boolean)olrQuery.isReadOnly());
        query.setHint("eclipselink.read-only", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"Read-only not set.", (boolean)olrQuery.isReadOnly());
        query.setHint("eclipselink.read-only", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"Read-only not set.", (boolean)olrQuery.isReadOnly());
        query.setHint("eclipselink.maintain-cache", (Object)true);
        EntityManagerJUnitTestSuite.assertTrue((String)"MAINTAIN_CACHE set.", (boolean)olrQuery.shouldMaintainCache());
        query.setHint("eclipselink.maintain-cache", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"MAINTAIN_CACHE not set.", (boolean)olrQuery.shouldMaintainCache());
        query.setHint("eclipselink.maintain-cache", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"MAINTAIN_CACHE not set.", (boolean)olrQuery.shouldMaintainCache());
        query.setHint("eclipselink.maintain-cache", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"MAINTAIN_CACHE not set.", (boolean)olrQuery.shouldMaintainCache());
        query.setHint("eclipselink.prepare", (Object)true);
        EntityManagerJUnitTestSuite.assertTrue((String)"PREPARE set.", (boolean)olrQuery.shouldPrepare());
        query.setHint("eclipselink.prepare", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"PREPARE not set.", (boolean)olrQuery.shouldPrepare());
        query.setHint("eclipselink.prepare", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"PREPARE not set.", (boolean)olrQuery.shouldPrepare());
        query.setHint("eclipselink.prepare", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"PREPARE not set.", (boolean)olrQuery.shouldPrepare());
        query.setHint("eclipselink.jdbc.cache-statement", (Object)true);
        EntityManagerJUnitTestSuite.assertTrue((String)"CACHE_STATMENT set.", (boolean)olrQuery.shouldCacheStatement());
        query.setHint("eclipselink.jdbc.cache-statement", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"CACHE_STATMENT not set.", (boolean)olrQuery.shouldCacheStatement());
        query.setHint("eclipselink.jdbc.cache-statement", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"CACHE_STATMENT not set.", (boolean)olrQuery.shouldCacheStatement());
        query.setHint("eclipselink.jdbc.cache-statement", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"CACHE_STATMENT not set.", (boolean)olrQuery.shouldCacheStatement());
        query.setHint("eclipselink.flush", (Object)true);
        EntityManagerJUnitTestSuite.assertTrue((String)"FLUSH set.", (boolean)olrQuery.getFlushOnExecute());
        query.setHint("eclipselink.flush", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"FLUSH not set.", (boolean)olrQuery.getFlushOnExecute());
        query.setHint("eclipselink.flush", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"FLUSH not set.", (boolean)olrQuery.getFlushOnExecute());
        query.setHint("eclipselink.flush", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"FLUSH not set.", (boolean)olrQuery.getFlushOnExecute());
        query.setHint("eclipselink.jdbc.native-connection", (Object)true);
        EntityManagerJUnitTestSuite.assertTrue((String)"NATIVE_CONNECTION set.", (boolean)olrQuery.isNativeConnectionRequired());
        query.setHint("eclipselink.jdbc.native-connection", (Object)"false");
        EntityManagerJUnitTestSuite.assertFalse((String)"NATIVE_CONNECTION not set.", (boolean)olrQuery.isNativeConnectionRequired());
        query.setHint("eclipselink.jdbc.native-connection", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"NATIVE_CONNECTION not set.", (boolean)olrQuery.isNativeConnectionRequired());
        query.setHint("eclipselink.jdbc.native-connection", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"NATIVE_CONNECTION not set.", (boolean)olrQuery.isNativeConnectionRequired());
        query.setHint("eclipselink.sql.hint", (Object)"/* use the index man */");
        EntityManagerJUnitTestSuite.assertTrue((String)"HINT not set.", (boolean)olrQuery.getHintString().equals("/* use the index man */"));
        query.setHint("eclipselink.cursor", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().isCursoredStreamPolicy());
        query.setHint("eclipselink.cursor", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"CURSOR set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().isCursoredStreamPolicy());
        query.setHint("eclipselink.cursor.initial-size", (Object)"100");
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().isCursoredStreamPolicy());
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR_INITIAL_SIZE not set.", (((CursoredStreamPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getInitialReadSize() == 100 ? 1 : 0) != 0);
        query.setHint("eclipselink.cursor.initial-size", (Object)200);
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR_INITIAL_SIZE not set.", (((CursoredStreamPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getInitialReadSize() == 200 ? 1 : 0) != 0);
        query.setHint("eclipselink.cursor", (Object)Boolean.FALSE);
        query.setHint("eclipselink.cursor.page-size", (Object)"100");
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().isCursoredStreamPolicy());
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR_PAGE_SIZE not set.", (((CursoredStreamPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getPageSize() == 100 ? 1 : 0) != 0);
        query.setHint("eclipselink.cursor.page-size", (Object)200);
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR_PAGE_SIZE not set.", (((CursoredStreamPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getPageSize() == 200 ? 1 : 0) != 0);
        query.setHint("eclipselink.cursor", (Object)Boolean.FALSE);
        query.setHint("eclipselink.cursor.size-sql", (Object)"Select Count(*) from Employee");
        EntityManagerJUnitTestSuite.assertTrue((String)"CURSOR_SIZE not set.", (boolean)((CursoredStreamPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getSizeQuery().getSQLString().equals("Select Count(*) from Employee"));
        query.setHint("eclipselink.cursor.scrollable", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"SCROLLABLE_CURSOR not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().isScrollableCursorPolicy());
        query.setHint("eclipselink.cursor.scrollable", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"SCROLLABLE_CURSOR set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().isScrollableCursorPolicy());
        query.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)"Reverse");
        EntityManagerJUnitTestSuite.assertTrue((String)"RESULT_SET_TYPE not set.", (((ScrollableCursorPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getResultSetType() == 1001 ? 1 : 0) != 0);
        query.setHint("eclipselink.cursor.scrollable.result-set-concurrency", (Object)"Updatable");
        EntityManagerJUnitTestSuite.assertTrue((String)"RESULT_SET_CONCURRENCY not set.", (((ScrollableCursorPolicy)((ReadAllQuery)olrQuery).getContainerPolicy()).getResultSetConcurrency() == 1008 ? 1 : 0) != 0);
        query.setHint("eclipselink.exclusive-connection", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"EXCLUSIVE_CONNECTION not set.", (boolean)olrQuery.shouldUseExclusiveConnection());
        query.setHint("eclipselink.inheritance.outer-join", (Object)Boolean.TRUE);
        EntityManagerJUnitTestSuite.assertTrue((String)"INHERITANCE_OUTER_JOIN not set.", (boolean)olrQuery.shouldOuterJoinSubclasses());
        query.setHint("eclipselink.history.as-of", (Object)"1973/10/11 12:00:00");
        EntityManagerJUnitTestSuite.assertTrue((String)"AS_OF not set.", (olrQuery.getAsOfClause() != null ? 1 : 0) != 0);
        query.setHint("eclipselink.history.as-of.scn", (Object)"12345");
        EntityManagerJUnitTestSuite.assertTrue((String)"AS_OF_SCN not set.", (((Number)olrQuery.getAsOfClause().getValue()).intValue() == 12345 ? 1 : 0) != 0);
        query.setHint("eclipselink.fetch-group.default", (Object)Boolean.FALSE);
        EntityManagerJUnitTestSuite.assertFalse((String)"FETCH_GROUP_DEFAULT not set.", (boolean)olrQuery.shouldUseDefaultFetchGroup());
        query.setHint("eclipselink.fetch-group.name", (Object)"nameAndCity");
        EntityManagerJUnitTestSuite.assertTrue((String)"FETCH_GROUP_NAME not set.", (boolean)olrQuery.getFetchGroupName().equals("nameAndCity"));
        query.setHint("eclipselink.fetch-group.attribute", (Object)"firstName");
        query.setHint("eclipselink.fetch-group.attribute", (Object)"lastName");
        EntityManagerJUnitTestSuite.assertTrue((String)"FETCH_GROUP_ATTRIBUTE not set.", (boolean)olrQuery.getFetchGroup().containsAttribute("firstName"));
        EntityManagerJUnitTestSuite.assertTrue((String)"FETCH_GROUP_ATTRIBUTE not set.", (boolean)olrQuery.getFetchGroup().containsAttribute("lastName"));
        FetchGroup fetchGroup = new FetchGroup();
        fetchGroup.addAttribute("id");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        EntityManagerJUnitTestSuite.assertTrue((String)"FETCH_GROUP not set.", (olrQuery.getFetchGroup() == fetchGroup ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.timeout", (Object)new Integer(100));
        EntityManagerJUnitTestSuite.assertTrue((String)"Timeout not set.", (olrQuery.getQueryTimeout() == 100 ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.fetch-size", (Object)new Integer(101));
        EntityManagerJUnitTestSuite.assertTrue((String)"Fetch-size not set.", (olrQuery.getFetchSize() == 101 ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.max-rows", (Object)new Integer(103));
        EntityManagerJUnitTestSuite.assertTrue((String)"Max-rows not set.", (olrQuery.getMaxRows() == 103 ? 1 : 0) != 0);
        query.setHint("eclipselink.jdbc.first-result", (Object)new Integer(123));
        EntityManagerJUnitTestSuite.assertTrue((String)"JDBC_FIRST_RESULT not set.", (olrQuery.getFirstResult() == 123 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"NoCascading");
        EntityManagerJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 1 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"CascadeByMapping");
        EntityManagerJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 6 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"CascadeAllParts");
        EntityManagerJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 3 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"CascadePrivateParts");
        EntityManagerJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 2 ? 1 : 0) != 0);
        query.setHint("eclipselink.refresh.cascade", (Object)"");
        EntityManagerJUnitTestSuite.assertTrue((olrQuery.getCascadePolicy() == 6 ? 1 : 0) != 0);
        query.setHint("eclipselink.result-collection-type", ArrayList.class);
        EntityManagerJUnitTestSuite.assertTrue((String)"ArrayList not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().getContainerClass().equals(ArrayList.class));
        query.setHint("eclipselink.result-collection-type", (Object)"java.util.Vector");
        EntityManagerJUnitTestSuite.assertTrue((String)"Vector not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().getContainerClass().equals(Vector.class));
        query.setHint("eclipselink.result-collection-type", (Object)"org.eclipse.persistence.testing.models.jpa.relationships.CustomerCollection");
        EntityManagerJUnitTestSuite.assertTrue((String)"CustomerCollection not set.", (boolean)((ReadAllQuery)olrQuery).getContainerPolicy().getContainerClass().equals(CustomerCollection.class));
        query.setHint("eclipselink.query-type", (Object)"ReadObject");
        EntityManagerJUnitTestSuite.assertTrue((String)"QUERY_TYPE not set.", (boolean)((JpaQuery)query).getDatabaseQuery().getClass().equals(ReadObjectQuery.class));
        query.setHint("eclipselink.query-type", (Object)"Report");
        EntityManagerJUnitTestSuite.assertTrue((String)"QUERY_TYPE not set.", (boolean)((JpaQuery)query).getDatabaseQuery().getClass().equals(ReportQuery.class));
        query.setHint("eclipselink.query-type", (Object)"DataModify");
        EntityManagerJUnitTestSuite.assertTrue((String)"QUERY_TYPE not set.", (boolean)((JpaQuery)query).getDatabaseQuery().getClass().equals(DataModifyQuery.class));
        query.setHint("eclipselink.query-type", (Object)"org.eclipse.persistence.queries.ValueReadQuery");
        EntityManagerJUnitTestSuite.assertTrue((String)"QUERY_TYPE not set.", (boolean)((JpaQuery)query).getDatabaseQuery().getClass().equals(ValueReadQuery.class));
        query.setHint("eclipselink.query-type", (Object)"ReadAll");
        EntityManagerJUnitTestSuite.assertTrue((String)"QUERY_TYPE not set.", (boolean)((JpaQuery)query).getDatabaseQuery().getClass().equals(ReadAllQuery.class));
        query.setHint("eclipselink.query-type", (Object)"Report");
        query.setHint("eclipselink.result-type", (Object)"Map");
        EntityManagerJUnitTestSuite.assertTrue((String)"RESULT_TYPE not set.", (((ReportQuery)((JpaQuery)query).getDatabaseQuery()).getReturnType() == 0 ? 1 : 0) != 0);
        query.setHint("eclipselink.result-type", (Object)"Array");
        EntityManagerJUnitTestSuite.assertTrue((String)"RESULT_TYPE not set.", (((ReportQuery)((JpaQuery)query).getDatabaseQuery()).getReturnType() == 5 ? 1 : 0) != 0);
        query.setHint("eclipselink.result-type", (Object)"Value");
        EntityManagerJUnitTestSuite.assertTrue((String)"RESULT_TYPE not set.", (((ReportQuery)((JpaQuery)query).getDatabaseQuery()).getReturnType() == 2 ? 1 : 0) != 0);
        query.setHint("eclipselink.query-type", (Object)"DataRead");
        query.setHint("eclipselink.result-type", (Object)"Map");
        query.setHint("eclipselink.result-type", (Object)"Array");
        query.setHint("eclipselink.result-type", (Object)"Value");
        this.closeEntityManager(em);
    }

    public void testBatchQueryHint() {
        int id1 = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee manager = new Employee();
        manager.setFirstName("Marvin");
        manager.setLastName("Malone");
        PhoneNumber number = new PhoneNumber("cell", "613", "888-8888");
        manager.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-8880");
        manager.addPhoneNumber(number);
        em.persist((Object)manager);
        id1 = manager.getId();
        Employee emp = new Employee();
        emp.setFirstName("Melvin");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9888");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0880");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("David");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9988");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0980");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        em.flush();
        em.clear();
        JpaQuery query = (JpaQuery)em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
        query.setHint("eclipselink.batch", (Object)"e.phoneNumbers");
        query.setHint("eclipselink.batch", (Object)"e.manager.phoneNumbers");
        query.setHint("eclipselink.batch.type", (Object)"IN");
        query.setHint("eclipselink.batch.size", (Object)"10");
        ReadAllQuery raq = (ReadAllQuery)query.getDatabaseQuery();
        List expressions = raq.getBatchReadAttributeExpressions();
        EntityManagerJUnitTestSuite.assertTrue((expressions.size() == 2 ? 1 : 0) != 0);
        Expression exp = (Expression)expressions.get(0);
        EntityManagerJUnitTestSuite.assertTrue((boolean)exp.isQueryKeyExpression());
        EntityManagerJUnitTestSuite.assertTrue((boolean)exp.getName().equals("phoneNumbers"));
        exp = (Expression)expressions.get(1);
        EntityManagerJUnitTestSuite.assertTrue((boolean)exp.isQueryKeyExpression());
        EntityManagerJUnitTestSuite.assertTrue((boolean)exp.getName().equals("phoneNumbers"));
        List resultList = query.getResultList();
        emp = (Employee)resultList.get(0);
        emp.getPhoneNumbers().hashCode();
        emp.getManager().getPhoneNumbers().hashCode();
        emp = (Employee)resultList.get(1);
        emp.getPhoneNumbers().hashCode();
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchQueryHint() {
        int id1 = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee manager = new Employee();
            manager.setFirstName("Marvin");
            manager.setLastName("Malone");
            PhoneNumber number = new PhoneNumber("cell", "613", "888-8888");
            manager.addPhoneNumber(number);
            number = new PhoneNumber("home", "613", "888-8880");
            manager.addPhoneNumber(number);
            em.persist((Object)manager);
            id1 = manager.getId();
            Employee emp = new Employee();
            emp.setFirstName("Melvin");
            emp.setLastName("Malone");
            emp.setManager(manager);
            manager.addManagedEmployee(emp);
            number = new PhoneNumber("cell", "613", "888-9888");
            emp.addPhoneNumber(number);
            number = new PhoneNumber("home", "613", "888-0880");
            emp.addPhoneNumber(number);
            em.persist((Object)emp);
            emp = new Employee();
            emp.setFirstName("David");
            emp.setLastName("Malone");
            emp.setManager(manager);
            manager.addManagedEmployee(emp);
            number = new PhoneNumber("cell", "613", "888-9988");
            emp.addPhoneNumber(number);
            number = new PhoneNumber("home", "613", "888-0980");
            emp.addPhoneNumber(number);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            JpaQuery query = (JpaQuery)em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.left-join-fetch", (Object)"e.manager");
            ReadAllQuery raq = (ReadAllQuery)query.getDatabaseQuery();
            List expressions = raq.getJoinedAttributeExpressions();
            EntityManagerJUnitTestSuite.assertTrue((expressions.size() == 1 ? 1 : 0) != 0);
            Expression exp = (Expression)expressions.get(0);
            EntityManagerJUnitTestSuite.assertTrue((boolean)exp.getName().equals("manager"));
            query.setHint("eclipselink.join-fetch", (Object)"e.manager.phoneNumbers");
            EntityManagerJUnitTestSuite.assertTrue((expressions.size() == 2 ? 1 : 0) != 0);
            List resultList = query.getResultList();
            emp = (Employee)resultList.get(0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedFetchQueryHints() {
        EntityManager em = this.createEntityManager();
        String errorMsg = "";
        if (EntityManagerJUnitTestSuite.isJTA()) {
            this.beginTransaction(em);
        }
        try {
            Query query1 = em.createQuery("SELECT e FROM Employee e");
            query1.setHint("eclipselink.join-fetch", (Object)"e.manager");
            query1.setHint("eclipselink.join-fetch", (Object)"e.manager.projects");
            query1.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers");
            query1.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers.dealers");
            query1.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            query1.getResultList();
            errorMsg = errorMsg + this.verifyJoinAttributeExpressions("query1", query1);
            Query query2 = em.createQuery("SELECT e FROM Employee e");
            query2.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers");
            query2.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers.dealers");
            query2.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            query2.getResultList();
            errorMsg = errorMsg + this.verifyJoinAttributeExpressions("query2", query2);
            Query query3 = em.createQuery("SELECT e FROM Employee e");
            query3.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers.dealers");
            query3.setHint("eclipselink.join-fetch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            query3.getResultList();
            errorMsg = errorMsg + this.verifyJoinAttributeExpressions("query3", query3);
            Query query4 = em.createQuery("SELECT e FROM Employee e");
            query4.setHint("eclipselink.left-join-fetch", (Object)"e.manager");
            query4.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects");
            query4.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers");
            query4.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers.dealers");
            query4.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            query4.getResultList();
            errorMsg = errorMsg + this.verifyJoinAttributeExpressions("query4", query4);
            Query query5 = em.createQuery("SELECT e FROM Employee e");
            query5.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers");
            query5.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers.dealers");
            query5.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            query5.getResultList();
            errorMsg = errorMsg + this.verifyJoinAttributeExpressions("query5", query5);
            Query query6 = em.createQuery("SELECT e FROM Employee e");
            query6.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers.dealers");
            query6.setHint("eclipselink.left-join-fetch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            query6.getResultList();
            errorMsg = errorMsg + this.verifyJoinAttributeExpressions("query6", query6);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    protected String verifyJoinAttributeExpressions(String queryName, Query query) {
        String[] names = new String[]{"manager", "projects", "teamMembers", "dealers", "phoneNumbers"};
        ReadAllQuery readAllQuery = (ReadAllQuery)query.unwrap(ReadAllQuery.class);
        List joinExpressions = readAllQuery.getJoinedAttributeManager().getJoinedAttributeExpressions();
        boolean ok = true;
        if (joinExpressions.size() != names.length) {
            ok = false;
        } else {
            ExpressionBuilder baseExp = readAllQuery.getExpressionBuilder();
            for (int i = 0; i <= names.length - 1 && ok; ++i) {
                QueryKeyExpression exp = (QueryKeyExpression)joinExpressions.get(i);
                if (baseExp != exp.getBaseExpression()) {
                    ok = false;
                }
                if (!exp.getName().equals(names[i])) {
                    if (i == names.length - 2) {
                        names[names.length - 2] = "phoneNumbers";
                        names[names.length - 1] = "dealers";
                        if (!exp.getName().equals(names[i])) {
                            ok = false;
                        }
                    } else {
                        ok = false;
                    }
                }
                if (i > 2) continue;
                baseExp = exp;
            }
        }
        String errorMsg = "";
        if (!ok) {
            errorMsg = queryName + ":\n" + joinExpressions + "\n";
        }
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNestedBatchQueryHints() {
        String errorMsg = "";
        this.clearCache();
        ServerSession session = EntityManagerJUnitTestSuite.getServerSession();
        QuerySQLTracker counter = new QuerySQLTracker((Session)session);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            int nEmployees = 2;
            int nProjects = 2;
            int nTeamMembers = 2;
            int nDealers = 2;
            int nPhones = 2;
            boolean useLargeProject = false;
            ArrayList<Employee> employees = new ArrayList<Employee>(nEmployees);
            ArrayList<Employee> teamMembers = new ArrayList<Employee>(nEmployees * nProjects * nTeamMembers);
            for (int i = 0; i < nEmployees; ++i) {
                String iStr = Integer.toString(i);
                Employee emp = new Employee("Employee_NestedBatchQueryHint", iStr);
                employees.add(emp);
                Employee manager = new Employee("Manager_NestedBatchQueryHint", iStr);
                manager.addManagedEmployee(emp);
                for (int j = 0; j < nProjects; ++j) {
                    String jStr = Integer.toString(j);
                    Object project = useLargeProject ? new LargeProject() : new SmallProject();
                    useLargeProject = !useLargeProject;
                    project.setName(iStr + jStr);
                    manager.addProject((Project)project);
                    project.addTeamMember(manager);
                    for (int k = 0; k < nTeamMembers; ++k) {
                        String lStr;
                        int l;
                        String kStr = Integer.toString(k);
                        String teamMemberLastName = iStr + jStr + kStr;
                        Employee teamMember = new Employee("TeamMember_NestedBatchQueryHint", teamMemberLastName);
                        teamMembers.add(teamMember);
                        teamMember.addProject((Project)project);
                        project.addTeamMember(teamMember);
                        for (l = 0; l < nDealers; ++l) {
                            lStr = Integer.toString(l);
                            Dealer dealer = new Dealer(lStr, teamMemberLastName);
                            teamMember.addDealer(dealer);
                        }
                        for (l = 0; l < nPhones; ++l) {
                            lStr = Integer.toString(l);
                            PhoneNumber phone = new PhoneNumber(lStr, teamMemberLastName, lStr + lStr + lStr + lStr + lStr + lStr + lStr);
                            teamMember.addPhoneNumber(phone);
                        }
                    }
                }
            }
            for (Employee emp : employees) {
                em.persist((Object)emp);
            }
            for (Employee emp : teamMembers) {
                em.persist((Object)emp);
            }
            em.flush();
            em.clear();
            Query query1 = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = 'Employee_NestedBatchQueryHint' ORDER BY e.lastName");
            query1.setHint("eclipselink.batch", (Object)"e.manager");
            query1.setHint("eclipselink.batch", (Object)"e.manager.projects");
            query1.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers");
            query1.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers.dealers");
            query1.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            errorMsg = errorMsg + this.verifyBatchReading("query1", query1, counter, employees, session);
            em.clear();
            Query query2 = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = 'Employee_NestedBatchQueryHint' ORDER BY e.lastName");
            query2.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers");
            query2.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers.dealers");
            query2.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            errorMsg = errorMsg + this.verifyBatchReading("query2", query2, counter, employees, session);
            em.clear();
            Query query3 = em.createQuery("SELECT e FROM Employee e WHERE e.firstName = 'Employee_NestedBatchQueryHint' ORDER BY e.lastName");
            query3.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers.dealers");
            query3.setHint("eclipselink.batch", (Object)"e.manager.projects.teamMembers.phoneNumbers");
            errorMsg = errorMsg + this.verifyBatchReading("query3", query3, counter, employees, session);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            counter.remove();
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    protected String verifyBatchReading(String queryName, Query query, QuerySQLTracker counter, List<Employee> originalEmployees, ServerSession session) {
        List employees = query.getResultList();
        Employee employee = (Employee)employees.get(0);
        Project project = (Project)employee.getManager().getProjects().iterator().next();
        Employee teamMember = null;
        for (Employee currentTeamMember : project.getTeamMembers()) {
            if (!currentTeamMember.getFirstName().equals("TeamMember_NestedBatchQueryHint")) continue;
            teamMember = currentTeamMember;
            break;
        }
        teamMember.getDealers().size();
        teamMember.getPhoneNumbers().size();
        counter.getSqlStatements().clear();
        for (Employee emp : employees) {
            Employee manager = emp.getManager();
            for (Project proj : manager.getProjects()) {
                for (Employee currentTeamMember : proj.getTeamMembers()) {
                    if (currentTeamMember == manager) continue;
                    currentTeamMember.getDealers().size();
                    currentTeamMember.getPhoneNumbers().size();
                }
            }
        }
        String errorMsg = "";
        if (counter.getSqlStatements().size() > 0) {
            errorMsg = counter.getSqlStatements() + "\n";
        }
        if (employees.size() != originalEmployees.size()) {
            errorMsg = errorMsg + "employees.size() = " + employees.size() + "; originalEmployees.size() = " + originalEmployees.size() + "\n";
        } else {
            for (int i = 0; i < employees.size(); ++i) {
                if (!session.compareObjects((Object)originalEmployees.get(i), employees.get(i))) {
                    errorMsg = errorMsg + "Original and read employee are not equal: original = " + originalEmployees.get(i).getLastName() + "; read = " + ((Employee)employees.get(i)).getLastName() + "\n";
                }
                if (!session.compareObjects((Object)originalEmployees.get(i).getManager(), (Object)((Employee)employees.get(i)).getManager())) {
                    errorMsg = errorMsg + "Original and read employee.getManager() are not equal: original = " + originalEmployees.get(i).getManager().getLastName() + "; read = " + ((Employee)employees.get(i)).getManager().getLastName() + "\n";
                }
                Collection projects = ((Employee)employees.get(i)).getManager().getProjects();
                Collection originalProjects = originalEmployees.get(i).getManager().getProjects();
                for (Project originalProj : originalProjects) {
                    boolean foundEqualName = false;
                    for (Project proj : projects) {
                        if (!originalProj.getName().equals(proj.getName())) continue;
                        foundEqualName = true;
                        if (session.compareObjects((Object)originalProj, (Object)proj)) break;
                        errorMsg = errorMsg + "Original and read projects are not equal for name: " + originalProj.getName() + "\n";
                        break;
                    }
                    if (foundEqualName) continue;
                    errorMsg = errorMsg + "No read project has name " + originalProj.getName() + "\n";
                }
            }
        }
        if (errorMsg.length() > 0) {
            errorMsg = queryName + ":\n" + errorMsg;
        }
        return errorMsg;
    }

    public void testIncorrectBatchQueryHint() {
        Query query;
        EntityManager em = this.createEntityManager();
        QueryException exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.batch", (Object)"e");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect BATCH query hint.", (Object)((Object)exception));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6144 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.batch", (Object)"e.abcdef");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect BATCH query hint.", (Object)((Object)exception));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6143 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.batch", (Object)"e.firstName");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"No exception was thrown when an incorrect relationship was navigated in a BATCH query hint.", (Object)((Object)exception));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6142 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.join-fetch", (Object)"e");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect FETCH query hint.", (Object)((Object)exception));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6144 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.join-fetch", (Object)"e.abcdef");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"No exception was thrown on an incorrect FETCH query hint.", (Object)((Object)exception));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6143 ? 1 : 0) != 0);
        exception = null;
        try {
            query = em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
            query.setHint("eclipselink.join-fetch", (Object)"e.firstName");
            query.getResultList();
        }
        catch (QueryException exc) {
            exception = exc;
        }
        EntityManagerJUnitTestSuite.assertNotNull((String)"No exception was thrown when an incorrect relationship was navigated in a FETCH query hint.", (Object)((Object)exception));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Exception thrown", (exception.getErrorCode() == 6142 ? 1 : 0) != 0);
    }

    public void testQueryOnClosedEM() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        boolean exceptionWasThrown = false;
        EntityManager em = this.createEntityManager();
        Query q = em.createQuery("SELECT e FROM Employee e ");
        this.closeEntityManager(em);
        if (em.isOpen()) {
            EntityManagerJUnitTestSuite.fail((String)"Closed EntityManager is still open");
        }
        try {
            q.getResultList();
        }
        catch (IllegalStateException e) {
            exceptionWasThrown = true;
        }
        if (!exceptionWasThrown) {
            EntityManagerJUnitTestSuite.fail((String)"Query on Closed EntityManager did not throw an exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullifyAddressIn() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testNullifyAddressIn skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("UPDATE Employee e SET e.address = null WHERE e.address.country IN ('Canada', 'US')").executeUpdate();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testLeftJoinOneToOneQuery() {
        EntityManager em = this.createEntityManager();
        List results = em.createQuery("SELECT a FROM Employee e LEFT JOIN e.address a").getResultList();
        results.toString();
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockingLeftJoinOneToOneQuery() {
        List results = this.createEntityManager().createQuery("SELECT m, e FROM Employee e LEFT JOIN e.manager m").getResultList();
        if (!results.isEmpty()) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            em.createQuery("SELECT m, e FROM Employee e LEFT JOIN e.manager m").setLockMode(LockModeType.OPTIMISTIC_FORCE_INCREMENT).getResultList();
            this.commitTransaction(em);
            this.beginTransaction(em);
            try {
                for (Object[] result : results) {
                    Employee employeeBefore;
                    Employee managerBefore = (Employee)result[0];
                    if (managerBefore != null) {
                        int managerVersionBefore = managerBefore.getVersion();
                        Employee managerAfter = (Employee)em.find(Employee.class, (Object)managerBefore.getId());
                        int managerVersionAfter = managerAfter.getVersion();
                        EntityManagerJUnitTestSuite.assertTrue((String)"The manager version was not updated on the locking query.", (managerVersionAfter - managerVersionBefore == 1 ? 1 : 0) != 0);
                    }
                    if ((employeeBefore = (Employee)result[1]) == null) continue;
                    int employeeVersionBefore = employeeBefore.getVersion();
                    Employee employeeAfter = (Employee)em.find(Employee.class, (Object)employeeBefore.getId());
                    int employeeVersionAfter = employeeAfter.getVersion();
                    EntityManagerJUnitTestSuite.assertTrue((String)"The employee version was not updated on the locking query.", (employeeVersionAfter - employeeVersionBefore == 1 ? 1 : 0) != 0);
                }
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockingLeftJoinOneToOneQuery2() {
        List results = this.createEntityManager().createQuery("SELECT a FROM Employee e LEFT JOIN e.address a").getResultList();
        if (results != null) {
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            em.createQuery("SELECT a FROM Employee e LEFT JOIN e.address a").setLockMode(LockModeType.OPTIMISTIC_FORCE_INCREMENT).getResultList();
            this.commitTransaction(em);
            this.beginTransaction(em);
            try {
                for (Address address : results) {
                    if (address == null) continue;
                    int versionBefore = address.getVersion();
                    Address addressAfter = (Address)em.find(Address.class, (Object)address.getID());
                    int versionAfter = addressAfter.getVersion();
                    EntityManagerJUnitTestSuite.assertTrue((String)"The version on an address was not updated on the locking query.", (versionAfter - versionBefore == 1 ? 1 : 0) != 0);
                }
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    public void testCloneable() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setFirstName("Owen");
        employee.setLastName("Hargreaves");
        employee.getAddress();
        Employee clone = employee.clone();
        Address address = new Address();
        address.setCity("Munich");
        clone.setAddress(address);
        clone.getAddress();
        em.persist((Object)clone);
        if (employee.getAddress() == clone.getAddress()) {
            EntityManagerJUnitTestSuite.fail((String)"Changing clone address changed original.");
        }
        this.commitTransaction(em);
        this.clearCache();
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)clone.getId());
        clone = employee.clone();
        address = new Address();
        address.setCity("Not Munich");
        clone.setAddress(address);
        clone.getAddress();
        if (employee.getAddress() == clone.getAddress()) {
            EntityManagerJUnitTestSuite.fail((String)"Changing clone address changed original.");
        }
        if (employee.getAddress() == null) {
            EntityManagerJUnitTestSuite.fail((String)"Changing clone address reset original to null.");
        }
        if (clone.getAddress() != address) {
            EntityManagerJUnitTestSuite.fail((String)"Changing clone did not work.");
        }
        this.commitTransaction(em);
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)clone.getId());
        clone = employee.clone();
        clone.setId(null);
        em.persist((Object)clone);
        this.commitTransaction(em);
        if (clone.getId() == null) {
            EntityManagerJUnitTestSuite.fail((String)"Clone was not persisted.");
        }
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)clone.getId());
        em.remove((Object)employee);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testSerializedLazy() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Owen");
        emp.setLastName("Hargreaves");
        emp.setId(Integer.valueOf(40));
        Address address = new Address();
        address.setCity("Munich");
        emp.setAddress(address);
        em.persist((Object)emp);
        em.flush();
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        String ejbqlString = "SELECT e FROM Employee e WHERE e.firstName = 'Owen' and e.lastName = 'Hargreaves'";
        List result = em.createQuery(ejbqlString).getResultList();
        emp = (Employee)result.get(0);
        ValidationException exception = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteStream);
            stream.writeObject(emp);
            stream.flush();
            byte[] arr = byteStream.toByteArray();
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
            ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
            emp = (Employee)inObjStream.readObject();
            emp.getAddress();
        }
        catch (ValidationException e) {
            if (e.getErrorCode() == 7242) {
                exception = e;
            } else {
                EntityManagerJUnitTestSuite.fail((String)("An unexpected exception was thrown while testing serialization of ValueHolders: " + e.toString()));
            }
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("An unexpected exception was thrown while testing serialization of ValueHolders: " + e.toString()));
        }
        if (this.isWeavingEnabled()) {
            EntityManagerJUnitTestSuite.assertNotNull((String)("The correct exception was not thrown while traversing an uninstantiated lazy relationship on a serialized object: " + (Object)((Object)exception)), (Object)((Object)exception));
        }
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        em.remove((Object)emp);
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSequenceObjectDefinition() {
        EntityManager em = this.createEntityManager();
        ServerSession ss = EntityManagerJUnitTestSuite.getServerSession();
        if (!ss.getLogin().getPlatform().supportsSequenceObjects() || EntityManagerJUnitTestSuite.isOnServer()) {
            this.closeEntityManager(em);
            return;
        }
        String seqName = "testSequenceObjectDefinition";
        try {
            this.internalTestSequenceObjectDefinition(10, 1, seqName, em, ss);
            this.internalTestSequenceObjectDefinition(10, 5, seqName + "1", em, ss);
            this.internalTestSequenceObjectDefinition(10, 15, seqName + "2", em, ss);
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestSequenceObjectDefinition(int preallocationSize, int startValue, String seqName, EntityManager em, ServerSession ss) {
        Query query;
        NativeSequence sequence = new NativeSequence(seqName, preallocationSize, startValue, false);
        sequence.onConnect((org.eclipse.persistence.internal.databaseaccess.Platform)ss.getPlatform());
        SequenceObjectDefinition def = new SequenceObjectDefinition((Sequence)sequence);
        try {
            String createStr = def.buildCreationWriter((AbstractSession)ss, (Writer)new StringWriter()).toString();
            this.beginTransaction(em);
            query = em.createNativeQuery(createStr);
            query.setHint("eclipselink.jdbc.batch-writing", (Object)false);
            query.executeUpdate();
            this.commitTransaction(em);
            Vector seqValues = sequence.getGeneratedVector(null, (AbstractSession)ss);
            int firstSequenceValue = ((Number)seqValues.elementAt(0)).intValue();
            if (firstSequenceValue != startValue) {
                EntityManagerJUnitTestSuite.fail((String)(seqName + " sequence with preallocationSize = " + preallocationSize + " and startValue = " + startValue + " produced wrong firstSequenceValue =" + firstSequenceValue));
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            sequence.onDisconnect((org.eclipse.persistence.internal.databaseaccess.Platform)ss.getPlatform());
            if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
                return;
            }
            String dropStr = def.buildDeletionWriter((AbstractSession)ss, (Writer)new StringWriter()).toString();
            this.beginTransaction(em);
            query = em.createNativeQuery(dropStr);
            query.setHint("eclipselink.jdbc.batch-writing", (Object)false);
            query.executeUpdate();
            this.commitTransaction(em);
        }
    }

    public void testMergeDetachedObject() {
        Department detachedDepartment;
        this.clearCache();
        EntityManager em = this.createEntityManager();
        Query query = em.createNamedQuery("findAllSQLDepartments");
        List departments = query.getResultList();
        if (departments.isEmpty()) {
            this.beginTransaction(em);
            detachedDepartment = new Department();
            detachedDepartment.setName("Department X");
            em.persist((Object)detachedDepartment);
            this.commitTransaction(em);
        } else {
            detachedDepartment = (Department)departments.iterator().next();
        }
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Crazy");
        emp.setLastName("Kid");
        emp.setId(Integer.valueOf(41));
        emp.setDepartment(detachedDepartment);
        em.persist((Object)emp);
        this.commitTransaction(em);
        try {
            em.createNamedQuery("findAllSQLDepartments").getResultList();
        }
        catch (NullPointerException e) {
            EntityManagerJUnitTestSuite.assertTrue((String)"The detached department caused a null pointer on the query execution.", (boolean)false);
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeRemovedObject() {
        Employee emp = new Employee();
        emp.setFirstName("testMergeRemovedObjectEmployee");
        emp.setId(Integer.valueOf(42));
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.beginTransaction(em);
        em.remove(em.find(Employee.class, (Object)emp.getId()));
        try {
            em.merge((Object)emp);
            EntityManagerJUnitTestSuite.fail((String)"No exception thrown when merging a removed entity is attempted.");
        }
        catch (IllegalArgumentException re) {
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.beginTransaction(em);
            em.remove(em.find(Employee.class, (Object)emp.getId()));
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDetachRemovedObject() {
        Employee emp = new Employee();
        emp.setFirstName("testDetachRemovedObjectEmployee");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.beginTransaction(em);
        em.remove(em.find(Employee.class, (Object)emp.getId()));
        this.commitTransaction(em);
        this.beginTransaction(em);
        EntityManagerImpl em1 = (EntityManagerImpl)em.getDelegate();
        try {
            em.detach((Object)emp);
            UnitOfWork uow = em1.getUnitOfWork();
            UnitOfWorkImpl uowImpl = (UnitOfWorkImpl)uow;
            boolean afterClear = uowImpl.getDeletedObjects().containsKey(emp);
            EntityManagerJUnitTestSuite.assertFalse((String)"exception thrown when detaching a removed entity is attempted.", (boolean)afterClear);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeNewObject() {
        Employee emp = new Employee();
        emp.setFirstName("testMergeNewObjectEmployee");
        emp.setAddress(new Address("45 O'Connor", "Ottawa", "Ont", "Canada", "K1P1A4"));
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee managedEmp = (Employee)em.merge((Object)emp);
            EntityManagerJUnitTestSuite.assertNotNull((String)"merged Employee doesn't have its ID generated", (Object)managedEmp.getId());
            EntityManagerJUnitTestSuite.assertNotNull((String)"merged Employee cannot be found using find", (Object)em.find(Employee.class, (Object)managedEmp.getId()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeNewObject2() {
        Equipment equip = new Equipment();
        equip.setDescription("New Equipment");
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Equipment managedEquip = (Equipment)em.merge((Object)equip);
            EntityManagerJUnitTestSuite.assertTrue((String)"merged Equipment doesn't have its ID generated", (managedEquip.getId() != 0 ? 1 : 0) != 0);
            EntityManagerJUnitTestSuite.assertNotNull((String)"merged Equipment cannot be found using find", (Object)em.find(Equipment.class, (Object)managedEquip.getId()));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    public void testMergeNewObject3_UseSequencing() {
        this.internalTestMergeNewObject3(true);
    }

    public void testMergeNewObject3_DontUseSequencing() {
        this.internalTestMergeNewObject3(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestMergeNewObject3(boolean shouldUseSequencing) {
        int id = 0;
        if (!shouldUseSequencing) {
            Employee emp = new Employee();
            EntityManager em = this.createEntityManager();
            this.beginTransaction(em);
            em.persist((Object)emp);
            this.commitTransaction(em);
            id = emp.getId();
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        String firstName = "testMergeNewObjectEmployee3";
        Employee manager = new Employee();
        manager.setFirstName(firstName);
        manager.setLastName("Manager");
        if (!shouldUseSequencing) {
            manager.setId(Integer.valueOf(id++));
        }
        Employee employee = new Employee();
        employee.setFirstName(firstName);
        employee.setLastName("Employee");
        if (!shouldUseSequencing) {
            employee.setId(Integer.valueOf(id++));
        }
        manager.addManagedEmployee(employee);
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Employee managedEmp = (Employee)em.merge((Object)manager);
            managedEmp.toString();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.merge(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when entityManager.merge(null) attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when entityManager.persist(null) attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContainsNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.contains(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when entityManager.contains(null) attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDetachNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.detach(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when entityManager.detach(null) attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(null);
        }
        catch (IllegalArgumentException iae) {
            return;
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Wrong exception type thrown: " + e.getClass()));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when entityManager.remove(null) attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateEntityManagerFactory() {
        if (EntityManagerJUnitTestSuite.isOnServer() && this.isWeavingEnabled()) {
            return;
        }
        try (EntityManagerFactory factory = null;){
            Persistence.createEntityManagerFactory((String)"default", (Map)JUnitTestCaseHelper.getDatabaseProperties());
            factory = Persistence.createEntityManagerFactory((String)"default", null);
            factory = Persistence.createEntityManagerFactory((String)"default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateEntityManagerFactory2() {
        if (EntityManagerJUnitTestSuite.getServerSession().getServerPlatform() != null && EntityManagerJUnitTestSuite.getServerSession().getServerPlatform() instanceof WebSphere_7_Platform) {
            EntityManagerJUnitTestSuite.warning((String)"The test <testCreateEntityManagerFactory2> is not supported on WebSphere, because the ejb3.0 spec doesn't say that the PersistenceException must throw at this situation, just EclipseLink's implementation beyond the spec. So this test should not run on WebSphere 7.0.0.5");
            return;
        }
        PersistenceProvider provider = new PersistenceProvider();
        try (EntityManagerFactory emf = null;){
            try {
                emf = provider.createEntityManagerFactory("default123", null);
            }
            catch (Exception e) {
                EntityManagerJUnitTestSuite.fail((String)("Exception is not expected, but thrown:" + e));
            }
            EntityManagerJUnitTestSuite.assertNull((Object)emf);
            try {
                emf = Persistence.createEntityManagerFactory((String)"default123");
                EntityManagerJUnitTestSuite.fail((String)"PersistenceException is expected");
            }
            catch (Exception e) {
                EntityManagerJUnitTestSuite.assertTrue((String)"The exception should be a PersistenceException", (boolean)(e instanceof PersistenceException));
            }
        }
    }

    public void testPrimaryKeyUpdate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Groucho");
        emp.setLastName("Marx");
        em.persist((Object)emp);
        Integer id = emp.getId();
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp = (Employee)em.merge((Object)emp);
        emp.setId(Integer.valueOf(id + 1));
        try {
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            Throwable persistenceException;
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            for (persistenceException = exception; persistenceException != null && !(persistenceException instanceof ValidationException); persistenceException = persistenceException.getCause()) {
            }
            if (persistenceException instanceof ValidationException) {
                ValidationException ve = (ValidationException)persistenceException;
                if (ve.getErrorCode() == 7251) {
                    return;
                }
                AssertionFailedError failure = new AssertionFailedError("Wrong error code for ValidationException: " + ve.getErrorCode());
                failure.initCause((Throwable)ve);
                throw failure;
            }
            AssertionFailedError failure = new AssertionFailedError("ValiationException expected, thrown: " + exception);
            failure.initCause((Throwable)exception);
            throw failure;
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when primary key update attempted.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrimaryKeyUpdateSameValue() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Harpo");
        emp.setLastName("Marx");
        em.persist((Object)emp);
        Integer id = emp.getId();
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp.setId(id);
        try {
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("Unexpected exception thrown: " + e.getClass()));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testPrimaryKeyUpdatePKFK() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Groucho");
        emp.setLastName("Marx");
        em.persist((Object)emp);
        Employee emp2 = new Employee();
        emp2.setFirstName("Harpo");
        emp2.setLastName("Marx");
        em.persist((Object)emp2);
        PhoneNumber phone = new PhoneNumber("home", "415", "0007");
        emp.addPhoneNumber(phone);
        em.persist((Object)phone);
        this.commitTransaction(em);
        this.beginTransaction(em);
        phone = (PhoneNumber)em.merge((Object)phone);
        emp2 = (Employee)em.merge((Object)emp2);
        phone.setOwner(emp2);
        try {
            this.commitTransaction(em);
        }
        catch (Exception exception) {
            Throwable persistenceException;
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            for (persistenceException = exception; persistenceException != null && !(persistenceException instanceof ValidationException); persistenceException = persistenceException.getCause()) {
            }
            if (persistenceException instanceof ValidationException) {
                ValidationException ve = (ValidationException)persistenceException;
                if (ve.getErrorCode() == 7251) {
                    return;
                }
                AssertionFailedError failure = new AssertionFailedError("Wrong error code for ValidationException: " + ve.getErrorCode());
                failure.initCause((Throwable)ve);
                throw failure;
            }
            AssertionFailedError failure = new AssertionFailedError("ValiationException expected, thrown: " + exception);
            failure.initCause((Throwable)exception);
            throw failure;
        }
        finally {
            this.closeEntityManager(em);
        }
        EntityManagerJUnitTestSuite.fail((String)"No exception thrown when primary key update attempted.");
    }

    public void testCascadeMergeDetached() {
        Project p1 = new Project();
        p1.setName("Project1");
        Project p2 = new Project();
        p1.setName("Project2");
        Employee e1 = new Employee();
        e1.setFirstName("Employee1");
        Employee e2 = new Employee();
        e2.setFirstName("Employee2");
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)p1);
            em.persist((Object)p2);
            em.persist((Object)e1);
            em.persist((Object)e2);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
        p1.setTeamLeader(e1);
        e1.addManagedEmployee(e2);
        e2.addProject(p2);
        p2.addTeamMember(e2);
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Project mp1 = (Project)em.merge((Object)p1);
            EntityManagerJUnitTestSuite.assertTrue((boolean)em.contains((Object)mp1));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp1 != p1 ? 1 : 0) != 0);
            Employee me1 = mp1.getTeamLeader();
            EntityManagerJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me1));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me1 != e1 ? 1 : 0) != 0);
            Employee me2 = (Employee)me1.getManagedEmployees().iterator().next();
            EntityManagerJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me2));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me2 != e2 ? 1 : 0) != 0);
            Project mp2 = (Project)me2.getProjects().iterator().next();
            EntityManagerJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)mp2));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp2 != p2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
    }

    public void testCascadeMergeManaged() {
        Project p1 = new Project();
        p1.setName("Project1");
        Project p2 = new Project();
        p1.setName("Project2");
        Employee e1 = new Employee();
        e1.setFirstName("Employee1");
        Employee e2 = new Employee();
        e2.setFirstName("Employee2");
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.persist((Object)p1);
            em.persist((Object)p2);
            em.persist((Object)e1);
            em.persist((Object)e2);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Project mp1 = (Project)em.merge((Object)p1);
            EntityManagerJUnitTestSuite.assertTrue((boolean)em.contains((Object)mp1));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp1 != p1 ? 1 : 0) != 0);
            mp1.setTeamLeader(e1);
            mp1 = (Project)em.merge((Object)mp1);
            Employee me1 = mp1.getTeamLeader();
            EntityManagerJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me1));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me1 != e1 ? 1 : 0) != 0);
            me1.addManagedEmployee(e2);
            me1 = (Employee)em.merge((Object)me1);
            Employee me2 = (Employee)me1.getManagedEmployees().iterator().next();
            EntityManagerJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)me2));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (me2 != e2 ? 1 : 0) != 0);
            me2.addProject(p2);
            p2.addTeamMember(me2);
            me2 = (Employee)em.merge((Object)me2);
            Project mp2 = (Project)me2.getProjects().iterator().next();
            EntityManagerJUnitTestSuite.assertTrue((String)"Cascade merge failed", (boolean)em.contains((Object)mp2));
            EntityManagerJUnitTestSuite.assertTrue((String)"Managed instance and detached instance must not be same", (mp2 != p2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException re) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw re;
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCascadePersistToNonEntitySubclass() {
        EntityManager em = this.createEntityManager();
        InheritancePolicy ip = EntityManagerJUnitTestSuite.getServerSession().getDescriptor(Project.class).getInheritancePolicy();
        boolean describesNonPersistentSubclasses = ip.getDescribesNonPersistentSubclasses();
        ip.setDescribesNonPersistentSubclasses(true);
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Albert");
        emp.setLastName("Einstein");
        SuperLargeProject s1 = new SuperLargeProject("Super 1");
        ArrayList<SuperLargeProject> projects = new ArrayList<SuperLargeProject>();
        projects.add(s1);
        emp.setProjects(projects);
        em.persist((Object)emp);
        try {
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("Persist operation was not cascaded to related non-entity, thrown: " + e));
        }
        finally {
            ip.setDescribesNonPersistentSubclasses(describesNonPersistentSubclasses);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInitializeFieldForPropertyAccess() {
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddressField(address);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)employee);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        int id = employee.getId();
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
            address = employee.getAddress();
            EntityManagerJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
            EntityManagerJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Shawshank"));
        }
        finally {
            employee.setAddress((Address)null);
            em.remove((Object)address);
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
    }

    public void testSetFieldForPropertyAccess() {
        EntityManager em = this.createEntityManager();
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddress(address);
        Employee manager = new Employee();
        manager.setFirstName("Bobby");
        manager.setLastName("Dufresne");
        employee.setManager(manager);
        this.beginTransaction(em);
        em.persist((Object)employee);
        this.commitTransaction(em);
        int id = employee.getId();
        int addressId = address.getID();
        int managerId = manager.getId();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        employee.getAddress();
        address = new Address();
        address.setCity("Metropolis");
        employee.setAddress(address);
        manager = new Employee();
        manager.setFirstName("Metro");
        manager.setLastName("Dufresne");
        employee.setManagerField(manager);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        address = employee.getAddress();
        manager = employee.getManager();
        EntityManagerJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Metropolis"));
        EntityManagerJUnitTestSuite.assertTrue((String)"The manager was not persisted.", (employee.getManager() != null ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"The manager was not correctly persisted.", (boolean)employee.getManager().getFirstName().equals("Metro"));
        Address initialAddress = (Address)em.find(Address.class, (Object)new Integer(addressId));
        Employee initialManager = (Employee)em.find(Employee.class, (Object)new Integer(managerId));
        employee.setAddress((Address)null);
        employee.setManager((Employee)null);
        em.remove((Object)address);
        em.remove((Object)employee);
        em.remove((Object)manager);
        em.remove((Object)initialAddress);
        em.remove((Object)initialManager);
        this.commitTransaction(em);
    }

    public void testSetFieldForPropertyAccessWithRefresh() {
        EntityManager em = this.createEntityManager();
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddress(address);
        Employee manager = new Employee();
        manager.setFirstName("Bobby");
        manager.setLastName("Dufresne");
        employee.setManager(manager);
        this.beginTransaction(em);
        em.persist((Object)employee);
        this.commitTransaction(em);
        int id = employee.getId();
        int addressId = address.getID();
        int managerId = manager.getId();
        this.beginTransaction(em);
        employee = (Employee)em.getReference(Employee.class, (Object)employee.getId());
        em.refresh((Object)employee);
        employee.getAddress();
        address = new Address();
        address.setCity("Metropolis");
        employee.setAddress(address);
        manager = new Employee();
        manager.setFirstName("Metro");
        manager.setLastName("Dufresne");
        employee.setManagerField(manager);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        address = employee.getAddress();
        manager = employee.getManager();
        EntityManagerJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Metropolis"));
        EntityManagerJUnitTestSuite.assertTrue((String)"The manager was not persisted.", (employee.getManager() != null ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"The manager was not correctly persisted.", (boolean)employee.getManager().getFirstName().equals("Metro"));
        Address initialAddress = (Address)em.find(Address.class, (Object)new Integer(addressId));
        Employee initialManager = (Employee)em.find(Employee.class, (Object)new Integer(managerId));
        employee.setAddress((Address)null);
        employee.setManager((Employee)null);
        em.remove((Object)address);
        em.remove((Object)employee);
        em.remove((Object)manager);
        em.remove((Object)initialAddress);
        em.remove((Object)initialManager);
        this.commitTransaction(em);
    }

    public void testSetFieldForPropertyAccessWithNewEM() {
        EntityManager em = this.createEntityManager();
        Employee employee = new Employee();
        employee.setFirstName("Andy");
        employee.setLastName("Dufresne");
        Employee manager = new Employee();
        manager.setFirstName("Bobby");
        manager.setLastName("Dufresne");
        employee.setManager(manager);
        Address address = new Address();
        address.setCity("Shawshank");
        employee.setAddress(address);
        this.beginTransaction(em);
        em.persist((Object)employee);
        this.commitTransaction(em);
        int id = employee.getId();
        int addressId = address.getID();
        int managerId = manager.getId();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        employee.getAddress();
        employee.getManager();
        address = new Address();
        address.setCity("Metropolis");
        employee.setAddress(address);
        manager = new Employee();
        manager.setFirstName("Metro");
        manager.setLastName("Dufresne");
        employee.setManagerField(manager);
        try {
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)new Integer(id));
        address = employee.getAddress();
        manager = employee.getManager();
        EntityManagerJUnitTestSuite.assertTrue((String)"The address was not persisted.", (employee.getAddress() != null ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"The address was not correctly persisted.", (boolean)employee.getAddress().getCity().equals("Metropolis"));
        EntityManagerJUnitTestSuite.assertTrue((String)"The manager was not persisted.", (employee.getManager() != null ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"The manager was not correctly persisted.", (boolean)employee.getManager().getFirstName().equals("Metro"));
        Address initialAddress = (Address)em.find(Address.class, (Object)new Integer(addressId));
        Employee initialManager = (Employee)em.find(Employee.class, (Object)new Integer(managerId));
        employee.setAddress((Address)null);
        employee.setManager((Employee)null);
        em.remove((Object)address);
        em.remove((Object)employee);
        em.remove((Object)manager);
        em.remove((Object)initialAddress);
        em.remove((Object)initialManager);
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteAllPhonesWithNullOwner() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM PhoneNumber ph WHERE ph.owner IS NULL").executeUpdate();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testDeleteAllProjectsWithNullTeamLeader() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.internalDeleteAllProjectsWithNullTeamLeader(Project.class);
    }

    public void testDeleteAllSmallProjectsWithNullTeamLeader() {
        this.internalDeleteAllProjectsWithNullTeamLeader(SmallProject.class);
    }

    public void testDeleteAllLargeProjectsWithNullTeamLeader() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllLargeProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.internalDeleteAllProjectsWithNullTeamLeader(LargeProject.class);
    }

    public void testDeleteAllHugeProjectsWithNullTeamLeader() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllLargeProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.internalDeleteAllProjectsWithNullTeamLeader(HugeProject.class);
    }

    public void testDeleteAllSpecialHugeProjectsWithNullTeamLeader() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllSpecialHugeProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        this.internalDeleteAllProjectsWithNullTeamLeader(SpecialHugeProject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDeleteAllProjectsWithNullTeamLeader(Class cls) {
        String name = "testDeleteAllProjectsWithNull";
        List projectsToRemove = null;
        String className = cls.getSimpleName();
        Employee teamLead = new Employee();
        teamLead.setLastName(name);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("DELETE FROM Project p WHERE p.name = '" + name + "'").executeUpdate();
            em.flush();
            em.persist((Object)teamLead);
            int projectTypes = this.createProjectsWithName(name, teamLead, em);
            em.flush();
            projectsToRemove = em.createQuery("SELECT p FROM " + className + " p WHERE p.name = '" + name + "' AND p.teamLeader IS NULL").getResultList();
            int leftOverWOTL = projectTypes - projectsToRemove.size();
            em.clear();
            em.createQuery("DELETE FROM " + className + " p WHERE p.name = '" + name + "' AND p.teamLeader IS NULL").executeUpdate();
            List result = em.createQuery("SELECT OBJECT(p) FROM Project p WHERE p.name = '" + name + "'AND p.teamLeader IS NULL").getResultList();
            for (Project proj : result) {
                if (!cls.isInstance(proj)) continue;
                EntityManagerJUnitTestSuite.fail((String)("Target Class " + className + ": object with null teamLeader of wrong type left: " + proj.getClass().getName()));
            }
            EntityManagerJUnitTestSuite.assertEquals((String)("Target Class " + className + ": wrong number of projects left.  "), (int)leftOverWOTL, (int)result.size());
            result = em.createQuery("SELECT OBJECT(p) FROM " + className + " p WHERE p.name = '" + name + "'").getResultList();
            if (result.isEmpty()) {
                EntityManagerJUnitTestSuite.fail((String)("Target Class " + className + ": all objects were removed instead of just ones with null teamLeaders."));
            }
            boolean foundClasses = true;
            if (result.size() != projectsToRemove.size()) {
                EntityManagerJUnitTestSuite.fail((String)("Target Class " + className + ": objects left does not match expected result size: " + result.size()));
            } else {
                for (Project proj : result) {
                    if (!cls.isInstance(proj) || proj.getTeamLeader() != null) continue;
                    EntityManagerJUnitTestSuite.fail((String)("Target Class " + cls + ": " + proj.getClass().getName() + " left with null TeamLeader"));
                }
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testUpdateUsingTempStorage() {
        this.internalUpdateUsingTempStorage(false);
    }

    public void testUpdateUsingTempStorageWithParameter() {
        this.internalUpdateUsingTempStorage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalUpdateUsingTempStorage(boolean useParameter) {
        String error;
        EntityManager em;
        String firstName;
        block37: {
            if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
                EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testUpdateUsingTempStorage* skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
                return;
            }
            if (JUnitTestCase.getServerSession().getPlatform().isPervasive()) {
                EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testUpdateUsingTempStorage* skipped for this platform. Pervasive does not support dynamic parameters in the Select list.");
                return;
            }
            firstName = "testUpdateUsingTempStorage";
            int n = 3;
            em = this.createEntityManager();
            try {
                this.beginTransaction(em);
                em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
                em.createQuery("DELETE FROM Address a WHERE a.country = '" + firstName + "'").executeUpdate();
                for (int i = 1; i <= n; ++i) {
                    Employee emp = new Employee();
                    emp.setFirstName(firstName);
                    emp.setLastName(Integer.toString(i));
                    emp.setSalary(i * 100);
                    emp.setRoomNumber(i);
                    Address address = new Address();
                    address.setCountry(firstName);
                    address.setCity(Integer.toString(i));
                    emp.setAddress(address);
                    em.persist((Object)emp);
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            em = this.createEntityManager();
            this.beginTransaction(em);
            int nUpdated = 0;
            try {
                nUpdated = useParameter ? em.createQuery("UPDATE Employee e set e.salary = e.roomNumber, e.roomNumber = e.salary, e.address = :address where e.firstName = '" + firstName + "'").setParameter("address", null).executeUpdate() : em.createQuery("UPDATE Employee e set e.salary = e.roomNumber, e.roomNumber = e.salary, e.address = null where e.firstName = '" + firstName + "'").executeUpdate();
                this.commitTransaction(em);
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
            error = null;
            em = this.createEntityManager();
            try {
                List result = em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.firstName = '" + firstName + "'").getResultList();
                int nReadBack = result.size();
                if (n != nUpdated) {
                    error = "n = " + n + ", but nUpdated =" + nUpdated + ";";
                }
                if (n != nReadBack) {
                    error = " n = " + n + ", but nReadBack =" + nReadBack + ";";
                }
                for (int i = 0; i < nReadBack; ++i) {
                    Employee emp = (Employee)result.get(i);
                    if (emp.getAddress() != null) {
                        error = " Employee " + emp.getLastName() + " still has address;";
                    }
                    int ind = Integer.valueOf(emp.getLastName());
                    if (emp.getSalary() != ind) {
                        error = " Employee " + emp.getLastName() + " has wrong salary " + emp.getSalary() + ";";
                    }
                    if (emp.getRoomNumber() == ind * 100) continue;
                    error = " Employee " + emp.getLastName() + " has wrong roomNumber " + emp.getRoomNumber() + ";";
                }
            }
            catch (RuntimeException ex) {
                if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                    if (ex instanceof PersistenceException) {
                        if (ex.getCause() instanceof QueryException && ((QueryException)ex.getCause()).getErrorCode() == 6180) {
                        } else {
                            EntityManagerJUnitTestSuite.fail((String)("Wrong cause of PersistenceException: " + ex.getCause()));
                        }
                    } else {
                        EntityManagerJUnitTestSuite.fail((String)"PersistenceException was expected");
                    }
                    break block37;
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            em.createQuery("DELETE FROM Address a WHERE a.country = '" + firstName + "'").executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
        if (error != null) {
            EntityManagerJUnitTestSuite.fail((String)error);
        }
    }

    protected int createProjectsWithName(String name, Employee teamLeader, EntityManager em) {
        Project p = new Project();
        p.setName(name);
        em.persist((Object)p);
        SmallProject sp = new SmallProject();
        sp.setName(name);
        em.persist((Object)sp);
        LargeProject lp = new LargeProject();
        lp.setName(name);
        em.persist((Object)lp);
        HugeProject hp = new HugeProject();
        hp.setName(name);
        em.persist((Object)hp);
        SpecialHugeProject shp = new SpecialHugeProject();
        shp.setName(name);
        em.persist((Object)shp);
        if (teamLeader != null) {
            Project pWTL = new Project();
            pWTL.setName(name);
            pWTL.setTeamLeader(teamLeader);
            em.persist((Object)pWTL);
            SmallProject spWTL = new SmallProject();
            spWTL.setName(name);
            spWTL.setTeamLeader(teamLeader);
            em.persist((Object)spWTL);
            LargeProject lpWTL = new LargeProject();
            lpWTL.setName(name);
            lpWTL.setTeamLeader(teamLeader);
            em.persist((Object)lpWTL);
            HugeProject hpWTL = new HugeProject();
            hpWTL.setName(name);
            hpWTL.setTeamLeader(teamLeader);
            em.persist((Object)hpWTL);
            SpecialHugeProject shpWTL = new SpecialHugeProject();
            shpWTL.setName(name);
            shpWTL.setTeamLeader(teamLeader);
            em.persist((Object)shpWTL);
        }
        return 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteProjectsWithName(String name) {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.createQuery("DELETE FROM Project p WHERE p.name = '" + name + "'").executeUpdate();
            this.commitTransaction(em);
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    public void testUpdateAllSmallProjects() {
        this.internalTestUpdateAllProjects(SmallProject.class);
    }

    public void testUpdateAllLargeProjects() {
        this.internalTestUpdateAllProjects(LargeProject.class);
    }

    public void testUpdateAllHugeProjects() {
        this.internalTestUpdateAllProjects(HugeProject.class);
    }

    public void testUpdateAllSpecialHugeProjects() {
        this.internalTestUpdateAllProjects(SpecialHugeProject.class);
    }

    public void testUpdateAllProjects() {
        this.internalTestUpdateAllProjects(Project.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestUpdateAllProjects(Class cls) {
        Project p;
        EntityManager em;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*Projects skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String className = Helper.getShortClassName((Class)cls);
        String name = "testUpdateAllProjects";
        String newName = "testUpdateAllProjectsNEW";
        HashMap<Integer, String> map = null;
        boolean ok = false;
        try {
            String errorMsg;
            block39: {
                em = this.createEntityManager();
                List projects = em.createQuery("SELECT OBJECT(p) FROM Project p").getResultList();
                map = new HashMap<Integer, String>(projects.size());
                for (int i = 0; i < projects.size(); ++i) {
                    Project p2 = (Project)projects.get(i);
                    map.put(p2.getId(), p2.getName());
                }
                this.beginTransaction(em);
                try {
                    this.createProjectsWithName(name, null, em);
                    this.commitTransaction(em);
                }
                finally {
                    this.closeEntityManagerAndTransaction(em);
                }
                em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    em.createQuery("UPDATE " + className + " p set p.name = '" + newName + "'").executeUpdate();
                    this.commitTransaction(em);
                }
                finally {
                    this.closeEntityManagerAndTransaction(em);
                }
                em = this.createEntityManager();
                errorMsg = "";
                try {
                    projects = em.createQuery("SELECT OBJECT(p) FROM Project p").getResultList();
                    for (int i = 0; i < projects.size(); ++i) {
                        p = (Project)projects.get(i);
                        String readName = p.getName();
                        if (cls.isInstance(p)) {
                            if (newName.equals(readName)) continue;
                            errorMsg = errorMsg + "haven't updated name: " + p + "; ";
                            continue;
                        }
                        if (!newName.equals(readName)) continue;
                        errorMsg = errorMsg + "have updated name: " + p + "; ";
                    }
                }
                catch (RuntimeException ex) {
                    if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                        if (ex instanceof PersistenceException) {
                            if (ex.getCause() instanceof QueryException && ((QueryException)ex.getCause()).getErrorCode() == 6180) {
                            } else {
                                EntityManagerJUnitTestSuite.fail((String)("Wrong cause of PersistenceException: " + ex.getCause()));
                            }
                        } else {
                            EntityManagerJUnitTestSuite.fail((String)"PersistenceException was expected");
                        }
                        break block39;
                    }
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            if (errorMsg.length() > 0) {
                EntityManagerJUnitTestSuite.fail((String)errorMsg);
            } else {
                ok = true;
            }
        }
        finally {
            block42: {
                try {
                    if (map != null) {
                        em = this.createEntityManager();
                        this.beginTransaction(em);
                        Query query = em.createQuery("SELECT OBJECT(p) FROM Project p");
                        if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                            query.setHint("eclipselink.serialized-object", (Object)"false");
                        }
                        List projects = query.getResultList();
                        try {
                            for (int i = 0; i < projects.size(); ++i) {
                                p = (Project)projects.get(i);
                                String oldName = (String)map.get(((Project)projects.get(i)).getId());
                                p.setName(oldName);
                            }
                            this.commitTransaction(em);
                        }
                        finally {
                            this.closeEntityManagerAndTransaction(em);
                        }
                    }
                    this.deleteProjectsWithName(newName);
                }
                catch (RuntimeException ex) {
                    if (!ok) break block42;
                    throw ex;
                }
            }
        }
    }

    public void testUpdateAllSmallProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(SmallProject.class);
    }

    public void testUpdateAllLargeProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(LargeProject.class);
    }

    public void testUpdateAllHugeProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(HugeProject.class);
    }

    public void testUpdateAllSpecialHugeProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(SpecialHugeProject.class);
    }

    public void testUpdateAllProjectsWithName() {
        this.internalTestUpdateAllProjectsWithName(Project.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestUpdateAllProjectsWithName(Class cls) {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*ProjectsWithName skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String className = Helper.getShortClassName((Class)cls);
        String name = "testUpdateAllProjects";
        String newName = "testUpdateAllProjectsNEW";
        boolean ok = false;
        try {
            String errorMsg;
            block30: {
                this.deleteProjectsWithName(name);
                this.deleteProjectsWithName(newName);
                EntityManager em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    this.createProjectsWithName(name, null, em);
                    this.commitTransaction(em);
                }
                finally {
                    this.closeEntityManagerAndTransaction(em);
                }
                em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    em.createQuery("UPDATE " + className + " p set p.name = '" + newName + "' WHERE p.name = '" + name + "'").executeUpdate();
                    this.commitTransaction(em);
                }
                finally {
                    this.closeEntityManagerAndTransaction(em);
                }
                em = this.createEntityManager();
                errorMsg = "";
                try {
                    List projects = em.createQuery("SELECT OBJECT(p) FROM Project p WHERE p.name = '" + newName + "' OR p.name = '" + name + "'").getResultList();
                    for (int i = 0; i < projects.size(); ++i) {
                        Project p = (Project)projects.get(i);
                        String readName = p.getName();
                        if (cls.isInstance(p)) {
                            if (readName.equals(newName)) continue;
                            errorMsg = errorMsg + "haven't updated name: " + p + "; ";
                            continue;
                        }
                        if (!readName.equals(newName)) continue;
                        errorMsg = errorMsg + "have updated name: " + p + "; ";
                    }
                }
                catch (RuntimeException ex) {
                    if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                        if (ex instanceof PersistenceException) {
                            if (ex.getCause() instanceof QueryException && ((QueryException)ex.getCause()).getErrorCode() == 6180) {
                            } else {
                                EntityManagerJUnitTestSuite.fail((String)("Wrong cause of PersistenceException: " + ex.getCause()));
                            }
                        } else {
                            EntityManagerJUnitTestSuite.fail((String)"PersistenceException was expected");
                        }
                        break block30;
                    }
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            if (errorMsg.length() > 0) {
                EntityManagerJUnitTestSuite.fail((String)errorMsg);
            } else {
                ok = true;
            }
        }
        finally {
            block32: {
                try {
                    this.deleteProjectsWithName(name);
                    this.deleteProjectsWithName(newName);
                }
                catch (RuntimeException ex) {
                    if (!ok) break block32;
                    throw ex;
                }
            }
        }
    }

    public void testUpdateAllSmallProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(SmallProject.class);
    }

    public void testUpdateAllLargeProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(LargeProject.class);
    }

    public void testUpdateAllProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(Project.class);
    }

    public void testUpdateAllSpecialHugeProjectsWithNullTeamLeader() {
        this.internalTestUpdateAllProjectsWithNullTeamLeader(SpecialHugeProject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalTestUpdateAllProjectsWithNullTeamLeader(Class cls) {
        EntityManager em;
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*ProjectsWithNullTeamLeader skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isPervasive()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testUpdateAll*ProjectsWithNullTeamLeader skipped for this platform.");
            return;
        }
        String className = Helper.getShortClassName((Class)cls);
        String name = "testUpdateAllProjects";
        String newName = "testUpdateAllProjectsNEW";
        Employee empTemp = null;
        boolean ok = false;
        try {
            String errorMsg;
            block42: {
                this.deleteProjectsWithName(name);
                this.deleteProjectsWithName(newName);
                em = this.createEntityManager();
                Employee emp = null;
                List employees = em.createQuery("SELECT OBJECT(e) FROM Employee e").getResultList();
                if (employees.size() > 0) {
                    emp = (Employee)employees.get(0);
                } else {
                    this.beginTransaction(em);
                    try {
                        emp = new Employee();
                        emp.setFirstName(name);
                        emp.setLastName("TeamLeader");
                        em.persist((Object)emp);
                        this.commitTransaction(em);
                        empTemp = emp;
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em);
                    }
                }
                em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    this.createProjectsWithName(name, emp, em);
                    this.commitTransaction(em);
                }
                finally {
                    this.closeEntityManagerAndTransaction(em);
                }
                em = this.createEntityManager();
                this.beginTransaction(em);
                try {
                    em.createQuery("UPDATE " + className + " p set p.name = '" + newName + "' WHERE p.name = '" + name + "' AND p.teamLeader IS NULL").executeUpdate();
                    this.commitTransaction(em);
                }
                finally {
                    this.closeEntityManagerAndTransaction(em);
                }
                em = this.createEntityManager();
                errorMsg = "";
                try {
                    List projects = em.createQuery("SELECT OBJECT(p) FROM Project p WHERE p.name = '" + newName + "' OR p.name = '" + name + "'").getResultList();
                    for (int i = 0; i < projects.size(); ++i) {
                        Project p = (Project)projects.get(i);
                        String readName = p.getName();
                        if (cls.isInstance(p) && p.getTeamLeader() == null) {
                            if (readName.equals(newName)) continue;
                            errorMsg = errorMsg + "haven't updated name: " + p + "; ";
                            continue;
                        }
                        if (!readName.equals(newName)) continue;
                        errorMsg = errorMsg + "have updated name: " + p + "; ";
                    }
                }
                catch (RuntimeException ex) {
                    if (EntityManagerJUnitTestSuite.usesSOP() && !EntityManagerJUnitTestSuite.isSOPRecoverable()) {
                        if (ex instanceof PersistenceException) {
                            if (ex.getCause() instanceof QueryException && ((QueryException)ex.getCause()).getErrorCode() == 6180) {
                            } else {
                                EntityManagerJUnitTestSuite.fail((String)("Wrong cause of PersistenceException: " + ex.getCause()));
                            }
                        } else {
                            EntityManagerJUnitTestSuite.fail((String)"PersistenceException was expected");
                        }
                        break block42;
                    }
                    throw ex;
                }
                finally {
                    this.closeEntityManager(em);
                }
            }
            if (errorMsg.length() > 0) {
                EntityManagerJUnitTestSuite.fail((String)errorMsg);
            } else {
                ok = true;
            }
        }
        finally {
            block44: {
                try {
                    this.deleteProjectsWithName(name);
                    this.deleteProjectsWithName(newName);
                    if (empTemp == null) break block44;
                    em = this.createEntityManager();
                    this.beginTransaction(em);
                    try {
                        em.createQuery("DELETE FROM Employee e WHERE e.id = '" + empTemp.getId() + "'").executeUpdate();
                        this.commitTransaction(em);
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em);
                    }
                }
                catch (RuntimeException ex) {
                    if (!ok) break block44;
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRollbackOnlyOnException() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)"");
            emp.toString();
            EntityManagerJUnitTestSuite.fail((String)"IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException ex) {
            if (EntityManagerJUnitTestSuite.isOnServer()) {
                EntityManagerJUnitTestSuite.assertTrue((String)"Transaction is not roll back only", (boolean)this.getRollbackOnly(em));
            } else {
                EntityManagerJUnitTestSuite.assertTrue((String)"Transaction is not roll back only", (boolean)em.getTransaction().getRollbackOnly());
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testClosedEmShouldThrowException() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        this.closeEntityManager(em);
        String errorMsg = "";
        try {
            em.clear();
            errorMsg = errorMsg + "; em.clear() didn't throw exception";
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.clear() threw wrong exception: " + ex.getMessage();
        }
        try {
            this.closeEntityManager(em);
            errorMsg = errorMsg + "; closeEntityManager(em) didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; closeEntityManager(em) threw wrong exception: " + ex.getMessage();
        }
        try {
            em.contains(null);
            errorMsg = errorMsg + "; em.contains() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.contains threw() wrong exception: " + ex.getMessage();
        }
        try {
            em.getDelegate();
            errorMsg = errorMsg + "; em.getDelegate() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.getDelegate() threw wrong exception: " + ex.getMessage();
        }
        try {
            em.getReference(Employee.class, (Object)new Integer(1));
            errorMsg = errorMsg + "; em.getReference() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.getReference() threw wrong exception: " + ex.getMessage();
        }
        try {
            em.joinTransaction();
            errorMsg = errorMsg + "; em.joinTransaction() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.joinTransaction() threw wrong exception: " + ex.getMessage();
        }
        try {
            em.lock(null, null);
            errorMsg = errorMsg + "; em.lock() didn't throw exception";
        }
        catch (IllegalStateException ex) {
        }
        catch (RuntimeException ex) {
            errorMsg = errorMsg + "; em.lock() threw wrong exception: " + ex.getMessage();
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testOneToManyDefaultJoinTableName() {
        Department dept = new Department();
        Employee manager = new Employee();
        dept.addManager(manager);
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            em.persist((Object)dept);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testMultipleEntityManagerFactories() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        this.closeEntityManagerFactory();
        EntityManagerFactory factory1 = this.getEntityManagerFactory();
        EntityManagerFactory factory2 = Persistence.createEntityManagerFactory((String)"default", (Map)JUnitTestCaseHelper.getDatabaseProperties());
        factory2.createEntityManager();
        factory2.close();
        try {
            factory1.createEntityManager();
        }
        catch (PersistenceException ex) {
            EntityManagerJUnitTestSuite.fail((String)("factory1.createEM threw exception: " + ex.getMessage()));
            factory1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearEntityManagerWithoutPersistenceContext() {
        EntityManager em = this.createEntityManager();
        try {
            em.clear();
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClearEntityManagerWithoutPersistenceContextSimulateJTA() {
        EntityManager em = this.createEntityManager();
        ServerSession ss = EntityManagerJUnitTestSuite.getServerSession();
        this.closeEntityManager(em);
        boolean hasExternalTransactionController = ss.hasExternalTransactionController();
        if (!hasExternalTransactionController) {
            ss.setExternalTransactionController((ExternalTransactionController)new DummyExternalTransactionController());
        }
        try {
            this.testClearEntityManagerWithoutPersistenceContext();
        }
        finally {
            if (!hasExternalTransactionController) {
                ss.setExternalTransactionController(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDescriptorNamedQuery() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equal(builder.getParameter("fName"));
        exp = exp.and(builder.get("lastName").equal(builder.getParameter("lName")));
        query.setSelectionCriteria(exp);
        query.addArgument("fName", String.class);
        query.addArgument("lName", String.class);
        EntityManager em = this.createEntityManager();
        ServerSession session = EntityManagerJUnitTestSuite.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        descriptor.getQueryManager().addQuery("findByFNameLName", (DatabaseQuery)query);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Melvin");
            emp.setLastName("Malone");
            em.persist((Object)emp);
            em.flush();
            Query ejbQuery = ((JpaEntityManager)em.getDelegate()).createDescriptorNamedQuery("findByFNameLName", Employee.class);
            List results = ejbQuery.setParameter("fName", (Object)"Melvin").setParameter("lName", (Object)"Malone").getResultList();
            EntityManagerJUnitTestSuite.assertTrue((String)("returned collection size was " + results.size()), (results.size() == 1 ? 1 : 0) != 0);
            emp = (Employee)results.get(0);
            EntityManagerJUnitTestSuite.assertTrue((boolean)emp.getFirstName().equals("Melvin"));
            EntityManagerJUnitTestSuite.assertTrue((boolean)emp.getLastName().equals("Malone"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        descriptor.getQueryManager().removeQuery("findByFNameLName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDescriptorNamedQueryForMultipleQueries() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.get("firstName").equal(builder.getParameter("fName"));
        exp = exp.and(builder.get("lastName").equal(builder.getParameter("lName")));
        query.setSelectionCriteria(exp);
        query.addArgument("fName", String.class);
        query.addArgument("lName", String.class);
        ReadAllQuery query2 = new ReadAllQuery(Employee.class);
        EntityManager em = this.createEntityManager();
        ServerSession session = EntityManagerJUnitTestSuite.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        descriptor.getQueryManager().addQuery("findEmployees", (DatabaseQuery)query);
        descriptor.getQueryManager().addQuery("findEmployees", (DatabaseQuery)query2);
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Melvin");
            emp.setLastName("Malone");
            em.persist((Object)emp);
            em.flush();
            Vector<Class<String>> args = new Vector<Class<String>>(2);
            args.addElement(String.class);
            args.addElement(String.class);
            Query ejbQuery = ((JpaEntityManager)em.getDelegate()).createDescriptorNamedQuery("findEmployees", Employee.class, args);
            List results = ejbQuery.setParameter("fName", (Object)"Melvin").setParameter("lName", (Object)"Malone").getResultList();
            EntityManagerJUnitTestSuite.assertTrue((results.size() == 1 ? 1 : 0) != 0);
            emp = (Employee)results.get(0);
            EntityManagerJUnitTestSuite.assertTrue((boolean)emp.getFirstName().equals("Melvin"));
            EntityManagerJUnitTestSuite.assertTrue((boolean)emp.getLastName().equals("Malone"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        descriptor.getQueryManager().removeQuery("findEmployees");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDoubleMerge() {
        EntityManager em = this.createEntityManager();
        Employee employee = new Employee();
        employee.setId(Integer.valueOf(44));
        employee.setVersion(Integer.valueOf(0));
        employee.setFirstName("Alfie");
        Employee employee2 = new Employee();
        employee2.setId(Integer.valueOf(44));
        employee2.setVersion(Integer.valueOf(0));
        employee2.setFirstName("Phillip");
        Employee result = null;
        try {
            this.beginTransaction(em);
            result = (Employee)em.merge((Object)employee);
            result = (Employee)em.merge((Object)employee2);
            EntityManagerJUnitTestSuite.assertTrue((String)"The firstName was not merged properly", (boolean)result.getFirstName().equals(employee2.getFirstName()));
            em.flush();
        }
        catch (PersistenceException e) {
            EntityManagerJUnitTestSuite.fail((String)"A double merge of an object with the same key, caused two inserts instead of one.");
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testPessimisticLockHintStartsTransaction() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        if (!this.isSelectForUpateSupported()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isHANA()) {
            return;
        }
        EntityManagerImpl em = (EntityManagerImpl)this.createEntityManager();
        this.beginTransaction((EntityManager)em);
        Query query = em.createNamedQuery("findAllEmployeesByFirstName");
        query.setHint("eclipselink.pessimistic-lock", (Object)"Lock");
        query.setParameter("firstname", (Object)"Sarah");
        List results = query.getResultList();
        results.toString();
        EntityManagerJUnitTestSuite.assertTrue((String)"The extended persistence context is not in a transaction after a pessmimistic lock query", (boolean)em.getActivePersistenceContext((Object)em.getTransaction()).getParent().isInTransaction());
        this.rollbackTransaction((EntityManager)em);
    }

    public void testWeaving() {
        if (this.isWeavingEnabled()) {
            this.internalTestWeaving(new Employee(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), true);
            this.internalTestWeaving(new FormerEmployment(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Address(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new PhoneNumber(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new EmploymentPeriod(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Buyer(), false, this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new GoldBuyer(), false, this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new PlatinumBuyer(), false, this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Department(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Golfer(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new GolferPK(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new SmallProject(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new LargeProject(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Man(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Woman(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Vegetable(), false, this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new VegetablePK(), false, this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new WorldRank(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new Equipment(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new EquipmentCode(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
            this.internalTestWeaving(new PartnerLink(), this.isWeavingForChangeTrackingEnabled(), this.isWeavingForFetchGroupsEnabled(), false);
        }
    }

    public void internalTestWeaving(Object object, boolean changeTracking, boolean fetchGroups, boolean indirection) {
        ClassDescriptor descriptor;
        if (!(object instanceof PersistenceWeaved)) {
            EntityManagerJUnitTestSuite.fail((String)("Object not weaved:" + object));
        }
        if (indirection && !(object instanceof PersistenceWeavedLazy)) {
            EntityManagerJUnitTestSuite.fail((String)("Object not weaved for indirection:" + object));
        }
        if (changeTracking && !(object instanceof ChangeTracker)) {
            EntityManagerJUnitTestSuite.fail((String)("Object not weaved for ChangeTracker:" + object));
        }
        if (!(descriptor = EntityManagerJUnitTestSuite.getServerSession().getDescriptor(object)).isAggregateDescriptor()) {
            if (changeTracking != descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                EntityManagerJUnitTestSuite.fail((String)("Descriptor not set to use change tracking policy correctly:" + object));
            }
            if (!(object instanceof PersistenceEntity)) {
                EntityManagerJUnitTestSuite.fail((String)("Object not weaved for PersistenceEntity:" + object));
            }
            if (fetchGroups && !(object instanceof FetchGroupTracker)) {
                EntityManagerJUnitTestSuite.fail((String)("Object not weaved for FetchGroupTracker:" + object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManyToOnePersistCascadeOnFlush() {
        boolean pass = false;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            String firstName = "testManyToOneContains";
            Address address = new Address();
            address.setCountry(firstName);
            Employee employee = new Employee();
            employee.setFirstName(firstName);
            em.persist((Object)employee);
            employee.setAddress(address);
            em.flush();
            pass = em.contains((Object)address);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        if (!pass) {
            EntityManagerJUnitTestSuite.fail((String)"em.contains(address) returned false");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOverwrittingAndOverLoadingMethods() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Address address = new Address();
            address.setCity("Ottawa");
            Employee employee = new Employee();
            employee.setAddress(address);
            LargeProject project = new LargeProject();
            project.setTeamLeader(employee);
            em.persist((Object)employee);
            em.persist((Object)project);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            employee = (Employee)em.find(Employee.class, (Object)employee.getId());
            project = (LargeProject)em.find(LargeProject.class, (Object)project.getId());
            if (employee.getAddress("Home") == null || !employee.getAddress("Home").getCity().equals("Ottawa")) {
                EntityManagerJUnitTestSuite.fail((String)"Get address did not work.");
            }
            employee.setAddress("Toronto");
            if (!employee.getAddress().getCity().equals("Toronto")) {
                EntityManagerJUnitTestSuite.fail((String)"Set address did not work.");
            }
            if (project.getTeamLeader() != employee) {
                EntityManagerJUnitTestSuite.fail((String)("Get team leader did not work, team is: " + project.getTeamLeader() + " but should be:" + employee));
            }
            em.remove((Object)employee.getAddress());
            em.remove((Object)employee);
            em.remove((Object)project);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDiscoverNewReferencedObject() {
        Employee manager;
        String firstName = "testDiscoverNewReferencedObject";
        EntityManager em = this.createEntityManager();
        int employeeId = 0;
        this.beginTransaction(em);
        try {
            Employee employee = new Employee();
            employee.setFirstName(firstName);
            employee.setLastName("Employee");
            em.persist((Object)employee);
            this.commitTransaction(em);
            employeeId = employee.getId();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        int managerId = 0;
        this.beginTransaction(em);
        try {
            Employee manager2 = new Employee();
            manager2.setFirstName(firstName);
            manager2.setLastName("Manager");
            PhoneNumber phoneNumber1 = new PhoneNumber("home", "613", "1111111");
            manager2.addPhoneNumber(phoneNumber1);
            PhoneNumber phoneNumber2 = new PhoneNumber("work", "613", "2222222");
            manager2.addPhoneNumber(phoneNumber2);
            Employee employee = (Employee)em.find(Employee.class, (Object)employeeId);
            manager2.addManagedEmployee(employee);
            this.commitTransaction(em);
            managerId = manager2.getId();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        String errorMsg = "";
        em = this.createEntityManager();
        try {
            manager = (Employee)em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.id = " + managerId).setHint("eclipselink.refresh", (Object)"true").getSingleResult();
            if (manager == null) {
                errorMsg = "Manager hasn't been written into the db";
            } else if (manager.getPhoneNumbers().size() != 2) {
                errorMsg = "Manager has a wrong number of Phones = " + manager.getPhoneNumbers().size() + "; should be 2";
            }
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            if (managerId != 0) {
                manager = (Employee)em.find(Employee.class, (Object)managerId);
                em.remove((Object)manager);
            } else if (employeeId != 0) {
                Employee employee = (Employee)em.find(Employee.class, (Object)employeeId);
                em.remove((Object)employee);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBulkDeleteThenMerge() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testBulkDeleteThenMerge skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        String firstName = "testBulkDeleteThenMerge";
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName(firstName);
        emp.setLastName("Original");
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        int id = emp.getId();
        em = this.createEntityManager();
        this.beginTransaction(em);
        em.createQuery("DELETE FROM Employee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
        this.commitTransaction(em);
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        emp = new Employee();
        emp.setId(Integer.valueOf(id));
        emp.setFirstName(firstName);
        emp.setLastName("New");
        em.merge((Object)emp);
        try {
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
        String errorMsg = "";
        em = this.createEntityManager();
        emp = (Employee)em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.id = " + id).getSingleResult();
        if (emp == null) {
            errorMsg = "Cache: Employee is not found; ";
        } else if (!emp.getLastName().equals("New")) {
            errorMsg = "Cache: wrong lastName = " + emp.getLastName() + "; should be New; ";
        }
        emp = (Employee)em.createQuery("SELECT OBJECT(e) FROM Employee e WHERE e.id = " + id).setHint("eclipselink.refresh", (Object)Boolean.TRUE).getSingleResult();
        if (emp == null) {
            errorMsg = errorMsg + "DB: Employee is not found";
        } else {
            if (!emp.getLastName().equals("New")) {
                errorMsg = "DB: wrong lastName = " + emp.getLastName() + "; should be New";
            }
            this.beginTransaction(em);
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
        this.closeEntityManager(em);
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testNativeSequences() {
        boolean isSequenceObject;
        ServerSession ss = JUnitTestCase.getServerSession();
        boolean doesPlatformSupportIdentity = ss.getPlatform().supportsIdentity();
        boolean doesPlatformSupportSequenceObjects = ss.getPlatform().supportsSequenceObjects();
        String errorMsg = "";
        boolean isIdentity = ss.getPlatform().getSequence("SEQ_GEN_IDENTITY").shouldAcquireValueAfterInsert();
        if (doesPlatformSupportIdentity != isIdentity) {
            errorMsg = "SEQ_GEN_IDENTITY: doesPlatformSupportIdentity = " + doesPlatformSupportIdentity + ", but isIdentity = " + isIdentity + "; ";
        }
        boolean bl = isSequenceObject = !ss.getPlatform().getSequence("ADDRESS_SEQ").shouldAcquireValueAfterInsert();
        if (doesPlatformSupportSequenceObjects != isSequenceObject) {
            errorMsg = errorMsg + "ADDRESS_SEQ: doesPlatformSupportSequenceObjects = " + doesPlatformSupportSequenceObjects + ", but isSequenceObject = " + isSequenceObject;
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testSequencePreallocationUsingCallbackTest() {
        ServerSession ss = EntityManagerJUnitTestSuite.getServerSession();
        String seqName = ss.getDescriptor(Employee.class).getSequenceNumberName();
        Sequence sequence = EntityManagerJUnitTestSuite.getServerSession().getLogin().getSequence(seqName);
        if (sequence.getPreallocationSize() < 2) {
            EntityManagerJUnitTestSuite.fail((String)"setup failure: the test requires sequence preallocation size greater than 1");
        }
        if (sequence.shouldAcquireValueAfterInsert()) {
            EntityManagerJUnitTestSuite.fail((String)"setup failure: the test requires sequence that acquires value before insert, like TableSequence");
        }
        if (!sequence.shouldUseTransaction()) {
            EntityManagerJUnitTestSuite.fail((String)"setup failure: the test requires sequence that uses transaction, like TableSequence");
        }
        EntityManagerJUnitTestSuite.getServerSession().getSequencingControl().initializePreallocated(seqName);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp1 = new Employee();
        emp1.setFirstName("testSequencePreallocation");
        emp1.setLastName("1");
        em.persist((Object)emp1);
        int assignedSequenceNumber = emp1.getId();
        this.commitTransaction(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp2 = new Employee();
        emp2.setFirstName("testSequencePreallocation");
        emp2.setLastName("2");
        em.persist((Object)emp2);
        int nextSequenceNumber = emp2.getId();
        this.rollbackTransaction(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        emp1 = (Employee)em.find(Employee.class, (Object)assignedSequenceNumber);
        em.remove((Object)emp1);
        this.commitTransaction(em);
        if (assignedSequenceNumber + 1 != nextSequenceNumber) {
            EntityManagerJUnitTestSuite.fail((String)("Transaction that assigned sequence number committed, assignedSequenceNumber = " + assignedSequenceNumber + ", but nextSequenceNumber = " + nextSequenceNumber + "(" + Integer.toString(assignedSequenceNumber + 1) + " was expected)"));
        }
    }

    protected Employee createEmployee(String name) {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = new Employee();
        employee.setFirstName(name);
        em.persist((Object)employee);
        this.commitTransaction(em);
        return employee;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetEntityManagerFactory() {
        Employee emp = new Employee();
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            emp.setFirstName("test");
            em.persist((Object)emp);
            this.commitTransaction(em);
            EntityManagerFactory emf = em.getEntityManagerFactory();
            if (emf == null) {
                EntityManagerJUnitTestSuite.fail((String)"Factory is null.");
            }
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testGetReference() {
        Employee employee = this.createEmployee("testGetReference");
        int id = employee.getId();
        int version = employee.getVersion();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.getReference(Employee.class, (Object)id);
        if (!employee.getFirstName().equals("testGetReference")) {
            EntityManagerJUnitTestSuite.fail((String)"getReference returned the wrong object");
        }
        this.commitTransaction(em);
        if (employee.getVersion() != version) {
            EntityManagerJUnitTestSuite.fail((String)"fetched object was updated");
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.getReference(Employee.class, (Object)id);
        if (employee instanceof FetchGroupTracker && ((FetchGroupTracker)employee)._persistence_isAttributeFetched("firstName")) {
            EntityManagerJUnitTestSuite.fail((String)"getReference fetched object.");
        }
        if (!employee.getFirstName().equals("testGetReference")) {
            EntityManagerJUnitTestSuite.fail((String)"getReference returned the wrong object");
        }
        this.commitTransaction(em);
        if (employee.getVersion() != version) {
            EntityManagerJUnitTestSuite.fail((String)"fetched object was updated");
        }
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, (Object)id);
        if (!employee.getFirstName().equals("testGetReference")) {
            EntityManagerJUnitTestSuite.fail((String)"find returned the wrong object");
        }
        this.commitTransaction(em);
        this.clearCache();
        ArrayList<Integer> key = new ArrayList<Integer>();
        key.add(id);
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.getReference(Employee.class, key);
        if (!employee.getFirstName().equals("testGetReference")) {
            EntityManagerJUnitTestSuite.fail((String)"getReference returned the wrong object");
        }
        this.commitTransaction(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.find(Employee.class, key);
        if (!employee.getFirstName().equals("testGetReference")) {
            EntityManagerJUnitTestSuite.fail((String)"find returned the wrong object");
        }
        this.commitTransaction(em);
    }

    public void testGetReferenceUpdate() {
        int id = this.createEmployee("testGetReference").getId();
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = (Employee)em.getReference(Employee.class, (Object)id);
        employee.setFirstName("changed");
        this.commitTransaction(em);
        this.verifyObjectInCacheAndDatabase(employee);
    }

    public void testCollectionAddNewObjectUpdate() {
        int id = this.createEmployee("testCollectionAddNew").getId();
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee employee = (Employee)em.find(Employee.class, (Object)id);
        SmallProject project = new SmallProject();
        employee.getProjects().add(project);
        project.getTeamMembers().add(employee);
        this.commitTransaction(em);
        if (em.contains((Object)employee)) {
            this.verifyObject(project);
            this.verifyObject(employee);
        }
        this.clearCache();
        if (em.contains((Object)employee)) {
            this.verifyObject(project);
            this.verifyObject(employee);
        }
    }

    public void testBadGetReference() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        EntityNotFoundException caught = null;
        try {
            Employee employee = (Employee)em.getReference(Employee.class, (Object)-123);
            employee.getFirstName();
        }
        catch (EntityNotFoundException exception) {
            caught = exception;
        }
        if (caught == null) {
            EntityManagerJUnitTestSuite.fail((String)"getReference did not throw an error for a bad id");
        }
    }

    public void testGetReferenceUsedInUpdate() {
        Employee employee = this.createEmployee("testGetReference");
        int id = employee.getId();
        int version = employee.getVersion();
        this.clearCache();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        employee = (Employee)em.getReference(Employee.class, (Object)id);
        if (employee instanceof FetchGroupTracker && ((FetchGroupTracker)employee)._persistence_isAttributeFetched("firstName")) {
            EntityManagerJUnitTestSuite.fail((String)"getReference fetched object.");
        }
        Employee newEmployee = new Employee();
        newEmployee.setFirstName("new");
        newEmployee.setManager(employee);
        em.persist((Object)newEmployee);
        this.commitTransaction(em);
        if (employee instanceof FetchGroupTracker && ((FetchGroupTracker)employee)._persistence_isAttributeFetched("firstName")) {
            EntityManagerJUnitTestSuite.fail((String)"commit fetched object.");
        }
        if (em.contains((Object)employee) && employee.getVersion() != version) {
            EntityManagerJUnitTestSuite.fail((String)"un-fetched object was updated");
        }
        this.verifyObjectInCacheAndDatabase(newEmployee);
    }

    public void testClassInstanceConverter() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Address add = new Address();
        add.setCity("St. Louis");
        add.setType((AddressType)new Bungalow());
        em.persist((Object)add);
        this.commitTransaction(em);
        int assignedSequenceNumber = add.getID();
        em.clear();
        EntityManagerJUnitTestSuite.getServerSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        add = (Address)em.find(Address.class, (Object)assignedSequenceNumber);
        EntityManagerJUnitTestSuite.assertTrue((String)"Did not correctly persist a mapping using a class-instance converter", (boolean)(add.getType() instanceof Bungalow));
        this.beginTransaction(em);
        add = (Address)em.find(Address.class, (Object)assignedSequenceNumber);
        em.remove((Object)add);
        this.commitTransaction(em);
    }

    public void test210280EntityManagerFromPUwithSpaceInNameButNotInPath() {
        this.privateTest210280EntityManagerWithPossibleSpacesInPathOrName("A JPAADVProperties pu with spaces in the name", "with a name containing spaces was not found.");
    }

    public void test210280EntityManagerFromPUwithSpaceInPathButNotInName() {
        this.privateTest210280EntityManagerWithPossibleSpacesInPathOrName("eclipselink-pu-with-spaces-in-the-path-but-not-the-name", "with a path containing spaces was not found.");
    }

    public void test210280EntityManagerFromPUwithSpaceInNameAndPath() {
        this.privateTest210280EntityManagerWithPossibleSpacesInPathOrName("eclipselink-pu with spaces in the path and name", "with a path and name both containing spaces was not found.");
    }

    private void privateTest210280EntityManagerWithPossibleSpacesInPathOrName(String puName, String failureMessagePostScript) {
        EntityManager em = null;
        try {
            em = EntityManagerJUnitTestSuite.createEntityManager((String)puName);
        }
        catch (Exception exception) {
            throw new RuntimeException("A Persistence Unit [" + puName + "] " + failureMessagePostScript, exception);
        }
        finally {
            if (null != em) {
                this.closeEntityManager(em);
            }
        }
    }

    public void testConnectionPolicy() {
        this.internalTestConnectionPolicy(false);
    }

    public void testConnectionPolicySetProperty() {
        this.internalTestConnectionPolicy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestConnectionPolicy(boolean useSetProperty) {
        EntityManager em;
        String errorMsg;
        block22: {
            errorMsg = "";
            HashMap<String, String> properties = null;
            if (!useSetProperty) {
                properties = new HashMap<String, String>();
                properties.put("javax.persistence.jdbc.user", "em_user");
                properties.put("javax.persistence.jdbc.password", "em_password");
                properties.put("javax.persistence.jtaDataSource", "em_jta_datasource");
                properties.put("javax.persistence.nonJtaDataSource", "em_nonjta_datasource");
                properties.put("eclipselink.jdbc.exclusive-connection.mode", "Always");
            }
            em = null;
            boolean isInTransaction = false;
            try {
                String password;
                String user;
                ConnectionPolicy policy;
                ClientSession clientSession;
                boolean isEmInjected;
                boolean bl = isEmInjected = EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.getServerSession().getLogin().shouldUseExternalTransactionController();
                if (isEmInjected) {
                    em = this.createEntityManager();
                    this.beginTransaction(em);
                    isInTransaction = true;
                    ((EntityManagerImpl)em.getDelegate()).setProperties(properties);
                } else {
                    EntityManagerFactory emFactory = this.getEntityManagerFactory();
                    em = emFactory.createEntityManager(properties);
                }
                if (useSetProperty) {
                    em.setProperty("javax.persistence.jdbc.user", (Object)"em_user");
                    em.setProperty("javax.persistence.jdbc.password", (Object)"em_password");
                    em.setProperty("javax.persistence.jtaDataSource", (Object)"em_jta_datasource");
                    em.setProperty("javax.persistence.nonJtaDataSource", (Object)"em_nonjta_datasource");
                    em.setProperty("eclipselink.jdbc.exclusive-connection.mode", (Object)"Always");
                }
                if (!(clientSession = EntityManagerJUnitTestSuite.isOnServer() ? (ClientSession)((EntityManagerImpl)em.getDelegate()).getActivePersistenceContext(null).getParent() : (ClientSession)((EntityManagerImpl)em).getActivePersistenceContext(null).getParent()).isExclusiveIsolatedClientSession()) {
                    errorMsg = errorMsg + "ExclusiveIsolatedClientSession was expected\n";
                }
                if ((policy = clientSession.getConnectionPolicy()).isPooled()) {
                    errorMsg = errorMsg + "NOT pooled policy was expected\n";
                }
                if (!(user = (String)policy.getLogin().getProperty("user")).equals("em_user")) {
                    errorMsg = errorMsg + "em_user was expected\n";
                }
                if (!(password = (String)policy.getLogin().getProperty("password")).equals("em_password")) {
                    errorMsg = errorMsg + "em_password was expected\n";
                }
                if (!(((DatasourceLogin)policy.getLogin()).getConnector() instanceof JNDIConnector)) {
                    errorMsg = errorMsg + "JNDIConnector was expected\n";
                } else {
                    JNDIConnector jndiConnector = (JNDIConnector)((DatasourceLogin)policy.getLogin()).getConnector();
                    String dataSourceName = jndiConnector.getName();
                    if (dataSourceName == null) {
                        errorMsg = errorMsg + "NON null dataSourceName was expected\n";
                    } else if (clientSession.getParent().getLogin().shouldUseExternalTransactionController()) {
                        if (dataSourceName.equals("em_nonjta_datasource")) {
                            errorMsg = errorMsg + "em_jta_datasource was expected\n";
                        }
                    } else if (dataSourceName.equals("em_jta_datasource")) {
                        errorMsg = errorMsg + "em_nonjta_datasource was expected\n";
                    }
                }
                if (!isInTransaction) break block22;
            }
            catch (Throwable throwable) {
                if (isInTransaction) {
                    this.rollbackTransaction(em);
                }
                if (em != null) {
                    this.closeEntityManager(em);
                }
                throw throwable;
            }
            this.rollbackTransaction(em);
        }
        if (em != null) {
            this.closeEntityManager(em);
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testConverterIn() {
        EntityManager em = this.createEntityManager();
        List emps = em.createQuery("SELECT e FROM Employee e WHERE e.gender IN (:GENDER1, :GENDER2)").setParameter("GENDER1", (Object)Employee.Gender.Male).setParameter("GENDER2", (Object)Employee.Gender.Female).getResultList();
        emps.toString();
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testExceptionForPersistNonEntitySubclass() {
        EntityManager em = this.createEntityManager();
        IllegalArgumentException caughtException = null;
        try {
            this.beginTransaction(em);
            em.persist((Object)new SuperLargeProject());
        }
        catch (IllegalArgumentException e) {
            caughtException = e;
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        if (caughtException == null) {
            EntityManagerJUnitTestSuite.fail((String)"Caught an incorrect exception when persisting a non entity.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEnabledPersistNonEntitySubclass() {
        EntityManager em = this.createEntityManager();
        InheritancePolicy ip = EntityManagerJUnitTestSuite.getServerSession().getDescriptor(Project.class).getInheritancePolicy();
        boolean describesNonPersistentSubclasses = ip.getDescribesNonPersistentSubclasses();
        ip.setDescribesNonPersistentSubclasses(true);
        this.beginTransaction(em);
        SuperLargeProject s1 = new SuperLargeProject("Super 1");
        try {
            em.persist((Object)s1);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("Persist operation was not cascaded to related non-entity, thrown: " + e));
        }
        finally {
            this.rollbackTransaction(em);
            ip.setDescribesNonPersistentSubclasses(describesNonPersistentSubclasses);
            this.closeEntityManager(em);
        }
    }

    public void testCloneEmbeddable() {
        EmployeePopulator populator = new EmployeePopulator();
        EmploymentPeriod period = populator.employmentPeriodExample1();
        try {
            period.clone();
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Exception thrown when trying to clone an Embeddable: " + e.toString()));
        }
    }

    public void testEmbeddedNPE() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        Employee emp = new Employee();
        emp.setFirstName("testEmbeddedNPE");
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)emp);
        this.commitTransaction(em);
        EmploymentPeriod period = new EmploymentPeriod(java.sql.Date.valueOf("2007-01-01"), java.sql.Date.valueOf("2007-12-31"));
        try {
            emp.setPeriod(period);
        }
        catch (NullPointerException npe) {
            this.beginTransaction(em);
            em.remove((Object)emp);
            this.commitTransaction(em);
            em.close();
            throw npe;
        }
        this.beginTransaction(em);
        em.merge((Object)emp);
        this.commitTransaction(em);
        em.clear();
        this.clearCache();
        Employee readEmp = (Employee)em.find(Employee.class, (Object)emp.getId());
        boolean equal = EntityManagerJUnitTestSuite.getServerSession().compareObjects((Object)emp, (Object)readEmp);
        if (readEmp != null) {
            this.beginTransaction(em);
            em.remove((Object)readEmp);
            this.commitTransaction(em);
        }
        em.close();
        if (!equal) {
            EntityManagerJUnitTestSuite.fail((String)"The Employee wasn't updated correctly in the db");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMCloseAndOpen() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testEMCloseAndOpen skipped for this platform, Symfoware platform doesn't support failover.");
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isPervasive()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testEMCloseAndOpen skipped for this platform.");
            return;
        }
        boolean shouldForceFinest = false;
        int originalLogLevel = -1;
        ServerSession ss = ((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession();
        int id = ss.getNextSequenceNumberValue(Employee.class).intValue();
        String originalDriverName = ss.getLogin().getDriverClassName();
        String originalConnectionString = ss.getLogin().getConnectionString();
        String newDriverName = DriverWrapper.class.getName();
        String newConnectionString = DriverWrapper.codeUrl((String)originalConnectionString);
        DriverWrapper.initialize((String)originalDriverName);
        ss.logout();
        ss.getLogin().setDriverClassName(newDriverName);
        ss.getLogin().setConnectionString(newConnectionString);
        AcquireReleaseListener listener = new AcquireReleaseListener();
        ss.getEventManager().addListener((SessionEventListener)listener);
        if (shouldForceFinest && ss.getLogLevel() != 1) {
            originalLogLevel = ss.getLogLevel();
            ss.setLogLevel(1);
        }
        ss.login();
        String errorMsg = "";
        String[] exclusiveConnectionModeArray = new String[]{"Transactional", "Isolated", "Always"};
        ReadObjectQuery employeeFindQuery = ss.getDescriptor(Employee.class).getQueryManager().getReadObjectQuery();
        int originalQueryTimeout = employeeFindQuery.getQueryTimeout();
        if (originalQueryTimeout > 0) {
            ss.setQueryTimeoutDefault(0);
            employeeFindQuery.setQueryTimeout(0);
            employeeFindQuery.setIsPrepared(false);
            employeeFindQuery.checkPrepare((AbstractSession)ss, null);
        }
        HashMap<String, Integer> noTimeOutHint = new HashMap<String, Integer>(1);
        noTimeOutHint.put("eclipselink.jdbc.timeout", 0);
        try {
            for (int i = 0; i < 3; ++i) {
                String exclusiveConnectionMode = exclusiveConnectionModeArray[i];
                for (int j = 0; j < 2; ++j) {
                    boolean hasUnexpectedlyCommitted;
                    Employee emp;
                    EntityManager em;
                    boolean useSequencing;
                    block27: {
                        useSequencing = j == 0;
                        ss.log(1, "connection", "testEMCloseAndOpen: " + (useSequencing ? "sequencing" : "no sequencing"), (Object[])null, null, false);
                        HashMap<String, String> emProperties = new HashMap<String, String>(1);
                        emProperties.put("eclipselink.jdbc.exclusive-connection.mode", exclusiveConnectionMode);
                        em = this.createEntityManager(emProperties);
                        em.find(Employee.class, (Object)1, noTimeOutHint);
                        emp = null;
                        hasUnexpectedlyCommitted = false;
                        try {
                            em.getTransaction().begin();
                            ss.log(1, "connection", "testEMCloseAndOpen: DriverWrapper.breakDriver(); DriverWrapper.breakOldConnections();", (Object[])null, null, false);
                            DriverWrapper.breakDriver();
                            DriverWrapper.breakOldConnections();
                            emp = new Employee();
                            if (!useSequencing) {
                                emp.setId(Integer.valueOf(id));
                            }
                            em.persist((Object)emp);
                            em.getTransaction().commit();
                            hasUnexpectedlyCommitted = true;
                            errorMsg = errorMsg + "useSequencing = " + useSequencing + "; exclusiveConnectionMode = " + exclusiveConnectionMode + ": Commit has unexpectedly succeeded - should have failed because all connections broken. driver = " + ss.getLogin().getDriverClassName() + "; url = " + ss.getLogin().getConnectionString();
                        }
                        catch (Exception e) {
                            if (!em.getTransaction().isActive()) break block27;
                            em.getTransaction().rollback();
                        }
                    }
                    this.closeEntityManager(em);
                    String localErrorMsg = "";
                    if (listener.nAcquredWriteConnections() > 0) {
                        localErrorMsg = localErrorMsg + "writeConnection not released; ";
                    }
                    if (listener.nAcquredReadConnections() > 0) {
                        localErrorMsg = localErrorMsg + "readConnection not released; ";
                    }
                    if (localErrorMsg.length() > 0) {
                        localErrorMsg = exclusiveConnectionMode + " useSequencing=" + useSequencing + ": " + localErrorMsg;
                        errorMsg = errorMsg + localErrorMsg;
                        listener.clear();
                    }
                    DriverWrapper.repairDriver();
                    ss.log(1, "connection", "testEMCloseAndOpen: DriverWrapper.repairDriver();", (Object[])null, null, false);
                    boolean failed = true;
                    try {
                        em = this.createEntityManager();
                        em.find(Employee.class, (Object)1);
                        if (!hasUnexpectedlyCommitted) {
                            em.getTransaction().begin();
                            emp = new Employee();
                            if (!useSequencing) {
                                emp.setId(Integer.valueOf(id));
                            }
                            em.persist((Object)emp);
                            em.getTransaction().commit();
                            failed = false;
                        }
                    }
                    finally {
                        if (failed) {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            this.closeEntityManager(em);
                            if (errorMsg.length() > 0) {
                                ss.log(1, "connection", "testEMCloseAndOpen: errorMsg: \n" + errorMsg, (Object[])null, null, false);
                            }
                        }
                    }
                    em.getTransaction().begin();
                    em.remove((Object)emp);
                    em.getTransaction().commit();
                    this.closeEntityManager(em);
                }
            }
        }
        finally {
            if (originalQueryTimeout > 0) {
                ss.setQueryTimeoutDefault(originalQueryTimeout);
                employeeFindQuery.setQueryTimeout(originalQueryTimeout);
                employeeFindQuery.setIsPrepared(false);
                employeeFindQuery.checkPrepare((AbstractSession)ss, null);
            }
            DriverWrapper.clear();
            ss.getEventManager().removeListener((SessionEventListener)listener);
            ss.logout();
            if (originalLogLevel >= 0) {
                ss.setLogLevel(originalLogLevel);
            }
            ss.getLogin().setDriverClassName(originalDriverName);
            ss.getLogin().setConnectionString(originalConnectionString);
            ss.login();
            if (errorMsg.length() > 0) {
                EntityManagerJUnitTestSuite.fail((String)errorMsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMFactoryCloseAndOpen() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        ServerSession ss = ((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession();
        String driverName = ss.getLogin().getDriverClassName();
        String originalConnectionString = ss.getLogin().getConnectionString();
        this.closeEntityManagerFactory();
        DriverWrapper.initialize((String)driverName);
        HashMap<String, String> properties = new HashMap<String, String>(JUnitTestCaseHelper.getDatabaseProperties());
        properties.put("javax.persistence.jdbc.driver", DriverWrapper.class.getName());
        properties.put("javax.persistence.jdbc.url", DriverWrapper.codeUrl((String)originalConnectionString));
        this.getEntityManagerFactory(properties);
        EntityManager em = this.createEntityManager();
        DriverWrapper.breakDriver();
        DriverWrapper.breakOldConnections();
        try {
            this.closeEntityManagerFactory();
        }
        finally {
            DriverWrapper.clear();
        }
        String errorMsg = "";
        em = this.createEntityManager();
        for (ConnectionPool pool : ((EntityManagerImpl)em).getServerSession().getConnectionPools().values()) {
            int disconnected = 0;
            for (int i = 0; i < pool.getConnectionsAvailable().size(); ++i) {
                if (((Accessor)pool.getConnectionsAvailable().get(i)).isConnected()) continue;
                ++disconnected;
            }
            if (disconnected <= 0) continue;
            errorMsg = errorMsg + pool.getName() + " has " + disconnected + " connections; ";
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEMFTargetServerEnforcing() {
        EntityManagerFactory emf = null;
        try {
            System.setProperty("eclipselink.target-server.enforce", "true");
            HashMap<String, String> properties = new HashMap<String, String>(JUnitTestCaseHelper.getDatabaseProperties());
            properties.put("eclipselink.target-server", Platform.class.getName());
            properties.put("eclipselink.session-name", "dummy-default-session");
            PersistenceProvider provider = new PersistenceProvider();
            JPAInitializer initializer = provider.getInitializer(this.getPersistenceUnitName(), properties);
            SEPersistenceUnitInfo sePUImpl = initializer.findPersistenceUnitInfo(this.getPersistenceUnitName(), properties);
            emf = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)sePUImpl, properties);
            ServerPlatform server = ((JpaEntityManagerFactory)emf).getServerSession().getServerPlatform();
            EntityManagerJUnitTestSuite.assertNotNull((Object)server);
            EntityManagerJUnitTestSuite.assertFalse((String)"server should be overridden", (boolean)(server instanceof Platform));
        }
        finally {
            System.clearProperty("eclipselink.target-server.enforce");
            if (emf != null) {
                emf.close();
            }
        }
    }

    public void testPostAcquirePreReleaseEvents_InternalConnectionPool() {
        this.internalTestPostAcquirePreReleaseEvents(false);
    }

    public void testPostAcquirePreReleaseEvents_ExternalConnectionPool() {
        this.internalTestPostAcquirePreReleaseEvents(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalTestPostAcquirePreReleaseEvents(boolean useExternalConnectionPool) {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        ServerSession ss = ((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession();
        if (ss.getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testPostAcquirePreReleaseEvents skipped for this platform, Symfoware platform doesn't support failover.");
            return;
        }
        boolean shouldForceFinest = false;
        int originalLogLevel = -1;
        String originalDriverName = ss.getLogin().getDriverClassName();
        String originalConnectionString = ss.getLogin().getConnectionString();
        Connector originalConnector = ss.getLogin().getConnector();
        String newDriverName = DriverWrapper.class.getName();
        String newConnectionString = DriverWrapper.codeUrl((String)originalConnectionString);
        DriverWrapper.initialize((String)originalDriverName);
        ss.logout();
        if (useExternalConnectionPool) {
            ss.getLogin().setConnector((Connector)new JNDIConnector((DataSource)new DataSourceImpl(null, newConnectionString, null, null)));
            ss.getLogin().useExternalConnectionPooling();
        } else {
            ss.getLogin().setDriverClassName(newDriverName);
            ss.getLogin().setConnectionString(newConnectionString);
        }
        if (shouldForceFinest && ss.getLogLevel() != 1) {
            originalLogLevel = ss.getLogLevel();
            ss.setLogLevel(1);
        }
        boolean originalIsConnectionHealthValidatedOnError = ss.getLogin().isConnectionHealthValidatedOnError();
        ss.getLogin().setConnectionHealthValidatedOnError(false);
        AcquireRepair_ReleaseBreak_Listener listener = new AcquireRepair_ReleaseBreak_Listener();
        ss.getEventManager().addListener((SessionEventListener)listener);
        ss.log(1, "connection", "testPostAcquirePreReleaseEvents: DriverWrapper.breakOldConnections(); DriverWrapper.breakNewConnections();", (Object[])null, null, false);
        DriverWrapper.breakOldConnections();
        DriverWrapper.breakNewConnections();
        ss.login();
        String[] exclusiveConnectionModeArray = new String[]{"Transactional", "Isolated", "Always"};
        ConnectionPolicy connectionPolicy = (ConnectionPolicy)ss.getDefaultConnectionPolicy().clone();
        connectionPolicy.setLogin((Login)ss.getLogin());
        connectionPolicy.setPoolName(null);
        try {
            HashMap<String, Object> emProperties = new HashMap<String, Object>();
            String pooled = "";
            for (int k = 0; k < 2; ++k) {
                if (k == 1) {
                    pooled = "non pooled; ";
                    emProperties.put("eclipselink.jdbc.connection-policy", connectionPolicy);
                }
                for (int i = 0; i < exclusiveConnectionModeArray.length; ++i) {
                    String exclusiveConnectionMode = exclusiveConnectionModeArray[i];
                    for (int j = 0; j < 3; ++j) {
                        boolean shouldBeginEarlyTransaction = j == 2;
                        boolean shouldReadBeforeTransaction = j == 1;
                        String mode = pooled + exclusiveConnectionMode + (shouldBeginEarlyTransaction ? "; beginEarlyTransaction" : "") + (shouldReadBeforeTransaction ? "; readBeforeTransaction" : "");
                        ss.log(1, "connection", "testPostAcquirePreReleaseEvents: " + mode, (Object[])null, null, false);
                        emProperties.put("eclipselink.jdbc.exclusive-connection.mode", exclusiveConnectionMode);
                        EntityManager em = this.createEntityManager(emProperties);
                        if (shouldReadBeforeTransaction) {
                            em.find(Employee.class, (Object)1);
                        }
                        Employee emp = null;
                        try {
                            em.getTransaction().begin();
                            if (shouldBeginEarlyTransaction) {
                                ((UnitOfWorkImpl)em.unwrap(UnitOfWorkImpl.class)).beginEarlyTransaction();
                            }
                            emp = new Employee();
                            emp.setFirstName("testPostAcquirePreReleaseEvents");
                            em.persist((Object)emp);
                            em.getTransaction().commit();
                        }
                        finally {
                            if (em.getTransaction().isActive()) {
                                em.getTransaction().rollback();
                            }
                            this.closeEntityManager(em);
                        }
                        if (!listener.hasAcquiredConnections()) continue;
                        EntityManagerJUnitTestSuite.fail((String)(mode + " connection was not passed to preReleaseConnection event"));
                    }
                }
            }
        }
        finally {
            DriverWrapper.clear();
            ss.getEventManager().removeListener((SessionEventListener)listener);
            EntityManager em = this.createEntityManager();
            em.getTransaction().begin();
            try {
                em.createQuery("DELETE FROM Employee e WHERE e.firstName = 'testPostAcquirePreReleaseEvents'");
                em.getTransaction().commit();
            }
            finally {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                this.closeEntityManager(em);
                ss.logout();
                if (originalLogLevel >= 0) {
                    ss.setLogLevel(originalLogLevel);
                }
                if (useExternalConnectionPool) {
                    ss.getLogin().setConnector(originalConnector);
                    ss.getLogin().dontUseExternalConnectionPooling();
                } else {
                    ss.getLogin().setDriverClassName(originalDriverName);
                    ss.getLogin().setConnectionString(originalConnectionString);
                }
                ss.getLogin().setConnectionHealthValidatedOnError(originalIsConnectionHealthValidatedOnError);
                ss.login();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeadConnectionFailover() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware() || JUnitTestCase.getServerSession().getPlatform().isSybase()) {
            EntityManagerJUnitTestSuite.warning((String)"Test testDeadConnectionFailover skipped for this platform, Sybase, Symfoware platform doesn't support failover.");
            return;
        }
        ServerSession server = ((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession();
        String originalDriverName = server.getLogin().getDriverClassName();
        String originalConnectionString = server.getLogin().getConnectionString();
        String newDriverName = DriverWrapper.class.getName();
        String newConnectionString = DriverWrapper.codeUrl((String)originalConnectionString);
        DriverWrapper.initialize((String)originalDriverName);
        server.logout();
        server.getLogin().setDriverClassName(newDriverName);
        server.getLogin().setConnectionHealthValidatedOnError(true);
        server.getLogin().setConnectionString(newConnectionString);
        server.login();
        try {
            String[] exclusiveConnectionModes;
            EntityManager em = this.createEntityManager();
            em.createQuery("Select e from Employee e").getResultList();
            em.getTransaction().begin();
            em.persist((Object)new Employee());
            em.getTransaction().commit();
            for (String exclusiveConnectionMode : exclusiveConnectionModes = new String[]{"Transactional", "Isolated", "Always"}) {
                try {
                    HashMap<String, String> emProperties = new HashMap<String, String>(1);
                    emProperties.put("eclipselink.jdbc.exclusive-connection.mode", exclusiveConnectionMode);
                    em = this.createEntityManager(emProperties);
                    List employees = em.createQuery("Select e from Employee e").getResultList();
                    DriverWrapper.breakOldConnections();
                    List employees2 = em.createQuery("Select e from Employee e").getResultList();
                    if (employees.size() != employees2.size()) {
                        EntityManagerJUnitTestSuite.fail((String)"Query results not the same after failure.");
                    }
                    DriverWrapper.breakOldConnections();
                    em.getTransaction().begin();
                    em.persist((Object)new Employee());
                    DriverWrapper.breakOldConnections();
                    em.getTransaction().commit();
                    em.getTransaction().begin();
                    em.persist((Object)new Employee());
                    em.flush();
                    DriverWrapper.breakOldConnections();
                    boolean failed = false;
                    try {
                        em.getTransaction().commit();
                    }
                    catch (Exception shouldFail) {
                        failed = true;
                    }
                    if (failed) continue;
                    EntityManagerJUnitTestSuite.fail((String)"Retry should not work in a transaction.");
                }
                catch (Exception failed) {
                    EntityManagerJUnitTestSuite.fail((String)("Retry did not work, mode:" + exclusiveConnectionMode + " error:" + failed));
                }
                finally {
                    try {
                        em.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            DriverWrapper.clear();
            server.logout();
            server.getLogin().setDriverClassName(originalDriverName);
            server.getLogin().setConnectionString(originalConnectionString);
            server.login();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeadPoolFailover() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware() || JUnitTestCase.getServerSession().getPlatform().isSybase()) {
            EntityManagerJUnitTestSuite.warning((String)"Test testDeadConnectionFailover skipped for this platform, Sybase, Symfoware platform doesn't support failover.");
            return;
        }
        ServerSession server = ((JpaEntityManagerFactory)this.getEntityManagerFactory()).getServerSession();
        DatabaseLogin originalLogin = (DatabaseLogin)server.getLogin().clone();
        String newDriverName = DriverWrapper.class.getName();
        String newConnectionString = DriverWrapper.codeUrl((String)originalLogin.getConnectionString());
        DriverWrapper.initialize((String)originalLogin.getDriverClassName());
        server.logout();
        server.getLogin().setDriverClassName(newDriverName);
        server.getLogin().setConnectionHealthValidatedOnError(true);
        server.getLogin().setConnectionString(newConnectionString);
        server.addConnectionPool("backup", (Login)originalLogin, 2, 4);
        server.getDefaultConnectionPool().addFailoverConnectionPool("backup");
        server.getReadConnectionPool().addFailoverConnectionPool("backup");
        server.login();
        try {
            String[] exclusiveConnectionModes;
            EntityManager em = this.createEntityManager();
            em.createQuery("Select e from Employee e").getResultList();
            em.getTransaction().begin();
            em.persist((Object)new Employee());
            em.getTransaction().commit();
            for (String exclusiveConnectionMode : exclusiveConnectionModes = new String[]{"Transactional", "Isolated", "Always"}) {
                try {
                    HashMap<String, String> emProperties = new HashMap<String, String>(1);
                    emProperties.put("eclipselink.jdbc.exclusive-connection.mode", exclusiveConnectionMode);
                    em = this.createEntityManager(emProperties);
                    List employees = em.createQuery("Select e from Employee e").getResultList();
                    DriverWrapper.breakAll();
                    List employees2 = em.createQuery("Select e from Employee e").getResultList();
                    if (employees.size() != employees2.size()) {
                        EntityManagerJUnitTestSuite.fail((String)"Query results not the same after failure.");
                    }
                    em.getTransaction().begin();
                    em.persist((Object)new Employee());
                    em.getTransaction().commit();
                    em.getTransaction().begin();
                    em.persist((Object)new Employee());
                    em.flush();
                    em.getTransaction().commit();
                }
                catch (Exception failed) {
                    EntityManagerJUnitTestSuite.fail((String)("Retry did not work, mode:" + exclusiveConnectionMode + " error:" + failed));
                }
                finally {
                    try {
                        em.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            DriverWrapper.clear();
            server.logout();
            server.getConnectionPools().remove("backup");
            server.getDefaultConnectionPool().setFailoverConnectionPools(new ArrayList());
            server.getReadConnectionPool().setFailoverConnectionPools(new ArrayList());
            server.getLogin().setDriverClassName(originalLogin.getDriverClassName());
            server.getLogin().setConnectionString(originalLogin.getConnectionString());
            server.login();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForUOWInSharedCacheWithBatchQueryHint() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        int id1 = 0;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee manager = new Employee();
        manager.setFirstName("Marvin");
        manager.setLastName("Malone");
        PhoneNumber number = new PhoneNumber("cell", "613", "888-8888");
        manager.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-8880");
        manager.addPhoneNumber(number);
        em.persist((Object)manager);
        id1 = manager.getId();
        Employee emp = new Employee();
        emp.setFirstName("Melvin");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9888");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0880");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        emp = new Employee();
        emp.setFirstName("David");
        emp.setLastName("Malone");
        emp.setManager(manager);
        manager.addManagedEmployee(emp);
        number = new PhoneNumber("cell", "613", "888-9988");
        emp.addPhoneNumber(number);
        number = new PhoneNumber("home", "613", "888-0980");
        emp.addPhoneNumber(number);
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        JpaQuery query = (JpaQuery)em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone' order by e.firstName");
        query.setHint("eclipselink.batch", (Object)"e.phoneNumbers");
        List resultList = query.getResultList();
        emp = (Employee)resultList.get(0);
        emp.setFirstName("somethingelse" + System.currentTimeMillis());
        em.createQuery("SELECT e FROM Employee e WHERE e.lastName = 'Malone'").getResultList();
        ((Employee)resultList.get(1)).getPhoneNumbers().hashCode();
        this.commitTransaction(em);
        try {
            emp = (Employee)JpaHelper.getEntityManager((EntityManager)em).getServerSession().getIdentityMapAccessor().getFromIdentityMap((Object)emp);
            EntityManagerJUnitTestSuite.assertNotNull((String)"Error, phone numbers is empty.  Not Batch Read", (Object)emp.getPhoneNumbers());
            EntityManagerJUnitTestSuite.assertFalse((String)"PhoneNumbers was empty.  This should not be the case as the test created phone numbers", (boolean)emp.getPhoneNumbers().isEmpty());
            EntityManagerJUnitTestSuite.assertTrue((String)"Phonee numbers was not an indirectList", (boolean)(emp.getPhoneNumbers() instanceof IndirectList));
            EntityManagerJUnitTestSuite.assertNotNull((String)"valueholder was null in triggered batch attribute", (Object)((IndirectList)emp.getPhoneNumbers()).getValueHolder());
            QueryBasedValueHolder bvh = (QueryBasedValueHolder)((IndirectList)emp.getPhoneNumbers()).getValueHolder();
            if (!EntityManagerJUnitTestSuite.usesSOP() && !(bvh instanceof BatchValueHolder)) {
                EntityManagerJUnitTestSuite.fail((String)("BatchValueHolder was expected, instead got " + bvh));
            }
            if (bvh.getQuery() != null && bvh.getQuery().getSession() != null && bvh.getQuery().getSession().isUnitOfWork()) {
                EntityManagerJUnitTestSuite.fail((String)"In Shared Cache a UOW was set within a BatchValueHolder's query object");
            }
            this.closeEntityManager(em);
        }
        finally {
            em = this.createEntityManager();
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)id1);
            Iterator it = emp.getManagedEmployees().iterator();
            while (it.hasNext()) {
                Employee managedEmp = (Employee)it.next();
                it.remove();
                managedEmp.setManager(null);
                em.remove((Object)managedEmp);
            }
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLoaded() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Abe");
            emp.setLastName("Jones");
            Address addr = new Address();
            addr.setCity("Palo Alto");
            emp.setAddress(addr);
            PhoneNumber pn = new PhoneNumber();
            pn.setNumber("1234456");
            pn.setType("Home");
            emp.addPhoneNumber(pn);
            pn.setOwner(emp);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            PersistenceUnitUtil util = emf.getPersistenceUnitUtil();
            EntityManagerJUnitTestSuite.assertTrue((String)"PersistenceUnitUtil says employee is not loaded when it is.", (boolean)util.isLoaded((Object)emp));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLoadedAttribute() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Abe");
            emp.setLastName("Jones");
            Address addr = new Address();
            addr.setCity("Palo Alto");
            emp.setAddress(addr);
            PhoneNumber pn = new PhoneNumber();
            pn.setNumber("1234456");
            pn.setType("Home");
            emp.addPhoneNumber(pn);
            pn.setOwner(emp);
            SmallProject project = new SmallProject();
            project.setName("Utility Testing");
            project.addTeamMember(emp);
            emp.addProject((Project)project);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            PersistenceUnitUtil util = emf.getPersistenceUnitUtil();
            if (emp instanceof PersistenceWeaved) {
                EntityManagerJUnitTestSuite.assertFalse((String)"PersistenceUnitUtil says address is loaded when it is not", (boolean)util.isLoaded((Object)emp, "address"));
            } else {
                EntityManagerJUnitTestSuite.assertTrue((String)"Non-weaved PersistenceUnitUtil says address is not loaded", (boolean)util.isLoaded((Object)emp, "address"));
            }
            EntityManagerJUnitTestSuite.assertFalse((String)"PersistenceUnitUtil says projects is loaded when it is not", (boolean)util.isLoaded((Object)emp, "projects"));
            emp.getPhoneNumbers().size();
            EntityManagerJUnitTestSuite.assertTrue((String)"PersistenceUnitUtil says phoneNumbers is not loaded when it is", (boolean)util.isLoaded((Object)emp, "phoneNumbers"));
            EntityManagerJUnitTestSuite.assertTrue((String)"PersistenceUnitUtil says firstName is not loaded when it is", (boolean)util.isLoaded((Object)emp, "firstName"));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetIdentifier() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Abe");
            emp.setLastName("Jones");
            Address addr = new Address();
            addr.setCity("Palo Alto");
            emp.setAddress(addr);
            PhoneNumber pn = new PhoneNumber();
            pn.setNumber("1234456");
            pn.setType("Home");
            emp.addPhoneNumber(pn);
            pn.setOwner(emp);
            em.persist((Object)emp);
            em.flush();
            Integer id = emp.getId();
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            PersistenceUnitUtil util = emf.getPersistenceUnitUtil();
            Object retrievedId = util.getIdentifier((Object)emp);
            EntityManagerJUnitTestSuite.assertTrue((String)"Got an incorrect id from persistenceUtil.getIdentifier()", (boolean)id.equals(retrievedId));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLoadedWithReference() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Abe");
            emp.setLastName("Jones");
            Address addr = new Address();
            addr.setCity("Palo Alto");
            emp.setAddress(addr);
            PhoneNumber pn = new PhoneNumber();
            pn.setNumber("1234456");
            pn.setType("Home");
            emp.addPhoneNumber(pn);
            pn.setOwner(emp);
            Employee manager = new Employee();
            manager.addManagedEmployee(emp);
            emp.setManager(manager);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.getAddress().getCity();
            emp.getPhoneNumbers().size();
            ProviderUtil util = new PersistenceProvider().getProviderUtil();
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return LOADED for isLoaded for address when it should.", (boolean)util.isLoadedWithReference((Object)emp, "address").equals((Object)LoadState.LOADED));
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return LOADED for isLoaded for phoneNumbers when it should.", (boolean)util.isLoadedWithReference((Object)emp, "phoneNumbers").equals((Object)LoadState.LOADED));
            if (emp instanceof PersistenceWeaved) {
                EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return NOT_LOADED for isLoaded for manager when it should.", (boolean)util.isLoadedWithReference((Object)emp, "manager").equals((Object)LoadState.NOT_LOADED));
            } else {
                EntityManagerJUnitTestSuite.assertTrue((String)"(NonWeaved) ProviderUtil did not return LOADED for isLoaded for manager when it should.", (boolean)util.isLoadedWithReference((Object)emp, "manager").equals((Object)LoadState.LOADED));
            }
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return NOT_LOADED for isLoaded for projects when it should.", (boolean)util.isLoadedWithReference((Object)emp, "projects").equals((Object)LoadState.NOT_LOADED));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLoadedWithoutReference() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Abe");
            emp.setLastName("Jones");
            Address addr = new Address();
            addr.setCity("Palo Alto");
            emp.setAddress(addr);
            PhoneNumber pn = new PhoneNumber();
            pn.setNumber("1234456");
            pn.setType("Home");
            emp.addPhoneNumber(pn);
            pn.setOwner(emp);
            Employee manager = new Employee();
            manager.addManagedEmployee(emp);
            emp.setManager(manager);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            this.clearCache();
            ProviderUtil util = new PersistenceProvider().getProviderUtil();
            if (emp instanceof PersistenceWeaved) {
                EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return LOADED for isLoaded when it should.", (boolean)util.isLoaded((Object)emp).equals((Object)LoadState.LOADED));
                emp = (Employee)em.getReference(Employee.class, (Object)emp.getId());
                if (this.isWeavingForFetchGroupsEnabled()) {
                    EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return NOT_LOADED for isLoaded when it should.", (boolean)util.isLoaded((Object)emp).equals((Object)LoadState.NOT_LOADED));
                } else {
                    EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return LOADED for isLoaded when it should.", (boolean)util.isLoaded((Object)emp).equals((Object)LoadState.LOADED));
                }
            } else {
                EntityManagerJUnitTestSuite.assertTrue((String)"(NonWeaved) ProviderUtil did not return UNKNOWN for isLoaded when it should.", (boolean)util.isLoaded((Object)emp).equals((Object)LoadState.UNKNOWN));
                emp = (Employee)em.getReference(Employee.class, (Object)emp.getId());
                EntityManagerJUnitTestSuite.assertTrue((String)"(NonWeaved)  ProviderUtil did not return UNKNOWN for isLoaded when it should.", (boolean)util.isLoaded((Object)emp).equals((Object)LoadState.UNKNOWN));
            }
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return UNKNOWN for isLoaded when it should.", (boolean)util.isLoaded((Object)new NonEntity()).equals((Object)LoadState.UNKNOWN));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLoadedWithoutReferenceAttribute() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = new Employee();
            emp.setFirstName("Abe");
            emp.setLastName("Jones");
            Address addr = new Address();
            addr.setCity("Palo Alto");
            emp.setAddress(addr);
            PhoneNumber pn = new PhoneNumber();
            pn.setNumber("1234456");
            pn.setType("Home");
            emp.addPhoneNumber(pn);
            pn.setOwner(emp);
            Employee manager = new Employee();
            manager.addManagedEmployee(emp);
            emp.setManager(manager);
            em.persist((Object)emp);
            em.flush();
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.getAddress().getCity();
            emp.getPhoneNumbers().size();
            ProviderUtil util = new PersistenceProvider().getProviderUtil();
            if (emp instanceof PersistenceWeaved) {
                EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return LOADED for isLoaded for address when it should.", (boolean)util.isLoadedWithReference((Object)emp, "address").equals((Object)LoadState.LOADED));
                EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return NOT_LOADED for isLoaded for manager when it should.", (boolean)util.isLoadedWithReference((Object)emp, "manager").equals((Object)LoadState.NOT_LOADED));
            } else {
                EntityManagerJUnitTestSuite.assertTrue((String)"(Unweaved) ProviderUtil did not return LOADED for isLoaded for address when it should.", (boolean)util.isLoadedWithReference((Object)emp, "address").equals((Object)LoadState.LOADED));
                EntityManagerJUnitTestSuite.assertTrue((String)"(Unweaved) ProviderUtil did not return LOADED for isLoaded for manager when it should.", (boolean)util.isLoadedWithReference((Object)emp, "manager").equals((Object)LoadState.LOADED));
            }
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return LOADED for isLoaded for phoneNumbers when it should.", (boolean)util.isLoadedWithReference((Object)emp, "phoneNumbers").equals((Object)LoadState.LOADED));
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return NOT_LOADED for isLoaded for projects when it should.", (boolean)util.isLoadedWithReference((Object)emp, "projects").equals((Object)LoadState.NOT_LOADED));
            EntityManagerJUnitTestSuite.assertTrue((String)"ProviderUtil did not return UNKNOWN for isLoaded when it should.", (boolean)util.isLoaded((Object)new NonEntity()).equals((Object)LoadState.UNKNOWN));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    public void testGetHints() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        Query query = em.createQuery("Select e from Employee e");
        query.setHint("eclipselink.cache-usage", (Object)"DoNotCheckCache");
        query.setHint("eclipselink.jdbc.bind-parameters", (Object)"");
        Map hints = query.getHints();
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect number of hints.", (hints.size() == 2 ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"CacheUsage hint missing.", (boolean)hints.get("eclipselink.cache-usage").equals("DoNotCheckCache"));
        EntityManagerJUnitTestSuite.assertTrue((String)"Bind parameters hint missing.", (hints.get("eclipselink.jdbc.bind-parameters") != null ? 1 : 0) != 0);
        query = em.createQuery("Select a from Address a");
        hints = query.getHints();
        EntityManagerJUnitTestSuite.assertTrue((String)"Hints is not null when it should be.", (hints == null ? 1 : 0) != 0);
    }

    public void testTemporalOnClosedEm() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        Query numericParameterQuery = em.createQuery("Select e from Employee e where e.period.startDate = ?1");
        Query namedParameterQuery = em.createQuery("Select e from Employee e where e.period.startDate = :date");
        this.closeEntityManager(em);
        Exception caughtException = null;
        try {
            numericParameterQuery.setParameter(1, (Date)new java.sql.Date(System.currentTimeMillis()), TemporalType.DATE);
        }
        catch (Exception e) {
            caughtException = e;
        }
        EntityManagerJUnitTestSuite.assertTrue((String)("Wrong Exception was caught when setting a numeric temporal Date parameter on a query with a closed em. Caught " + caughtException), (boolean)(caughtException instanceof IllegalStateException));
        try {
            numericParameterQuery.setParameter(1, Calendar.getInstance(), TemporalType.DATE);
        }
        catch (Exception e) {
            caughtException = e;
        }
        EntityManagerJUnitTestSuite.assertTrue((String)("Wrong Exception was caught when setting a numeric temporal Calendar parameter on a query with a closed em. Caught " + caughtException), (boolean)(caughtException instanceof IllegalStateException));
        try {
            namedParameterQuery.setParameter("date", (Date)new java.sql.Date(System.currentTimeMillis()), TemporalType.DATE);
        }
        catch (Exception e) {
            caughtException = e;
        }
        EntityManagerJUnitTestSuite.assertTrue((String)("Wrong Exception was caught when setting a named temporal Date parameter on a query with a closed em.  Caught " + caughtException), (boolean)(caughtException instanceof IllegalStateException));
        try {
            namedParameterQuery.setParameter("date", Calendar.getInstance(), TemporalType.DATE);
        }
        catch (Exception e) {
            caughtException = e;
        }
        EntityManagerJUnitTestSuite.assertTrue((String)"Wrong Exception was caught when setting a named temporal Calendar parameter on a query with a closed em.", (boolean)(caughtException instanceof IllegalStateException));
    }

    public void testTransientMapping() {
        ServerSession session = EntityManagerJUnitTestSuite.getServerSession();
        ClassDescriptor descriptor = session.getClassDescriptor(Customer.class);
        EntityManagerJUnitTestSuite.assertTrue((String)"There should not be a mapping for transientField.", (descriptor.getMappingForAttributeName("transientField") == null ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGenerateSessionNameFromConnectionProperties() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        String errorMsg = "";
        String puName = "default";
        String customizer = "org.eclipse.persistence.testing.tests.jpa.advanced.EntityManagerJUnitTestSuite$SessionNameCustomizer";
        String myJtaDS = "myJtaDS";
        String myNonJtaDS = "myNonJtaDS";
        String myUrl = "myUrl";
        String myUser = "myUser";
        String myDriver = "myDriver";
        String myPassword = "myPassword";
        ServerSession originalSession = JUnitTestCase.getServerSession();
        String loggingLevel = originalSession.getSessionLog().getLevelString();
        SessionNameCustomizer.ss = null;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.session.customizer", customizer);
        properties.put("eclipselink.logging.level", loggingLevel);
        properties.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
        properties.put("javax.persistence.jtaDataSource", "");
        properties.put("javax.persistence.nonJtaDataSource", "");
        properties.put("javax.persistence.jdbc.url", myUrl);
        properties.put("javax.persistence.jdbc.user", myUser);
        properties.put("javax.persistence.jdbc.driver", myDriver);
        properties.put("javax.persistence.jdbc.password", myPassword);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)puName, properties);
        try {
            emf.createEntityManager();
        }
        catch (Exception exception) {
        }
        finally {
            emf.close();
            if (SessionNameCustomizer.ss != null && SessionNameCustomizer.ss != originalSession) {
                errorMsg = errorMsg + "0: Session name NOT overridden by an empty string - original session expected; ";
            }
            SessionNameCustomizer.ss = null;
        }
        properties = new HashMap();
        properties.put("eclipselink.session.customizer", customizer);
        properties.put("eclipselink.logging.level", loggingLevel);
        properties.put("eclipselink.session-name", "");
        properties.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
        properties.put("javax.persistence.jtaDataSource", "");
        properties.put("javax.persistence.nonJtaDataSource", "");
        properties.put("javax.persistence.jdbc.url", myUrl);
        properties.put("javax.persistence.jdbc.user", myUser);
        properties.put("javax.persistence.jdbc.driver", myDriver);
        properties.put("javax.persistence.jdbc.password", myPassword);
        emf = Persistence.createEntityManagerFactory((String)puName, properties);
        try {
            emf.createEntityManager();
        }
        catch (Exception connector) {
        }
        finally {
            emf.close();
            if (SessionNameCustomizer.ss == null && SessionNameCustomizer.ss == originalSession) {
                errorMsg = errorMsg + "1: New session expected; ";
            } else {
                if (SessionNameCustomizer.ss.getLogin().shouldUseExternalConnectionPooling()) {
                    errorMsg = errorMsg + "1: internal connection pooling expected; ";
                }
                if (SessionNameCustomizer.ss.getLogin().shouldUseExternalTransactionController()) {
                    errorMsg = errorMsg + "1: no externalTransactionController expected; ";
                }
                if (!myUser.equals(SessionNameCustomizer.ss.getLogin().getUserName())) {
                    errorMsg = errorMsg + "1: myUser expected; ";
                }
                if ((connector = SessionNameCustomizer.ss.getLogin().getConnector()) instanceof DefaultConnector) {
                    if (!myUrl.equals(((DefaultConnector)connector).getDatabaseURL())) {
                        errorMsg = errorMsg + "1: myUrl expected; ";
                    }
                    if (!myDriver.equals(((DefaultConnector)connector).getDriverClassName())) {
                        errorMsg = errorMsg + "1: myDriver expected; ";
                    }
                } else {
                    errorMsg = errorMsg + "1: DefaultConnector expected; ";
                }
            }
            SessionNameCustomizer.ss = null;
        }
        properties = new HashMap();
        properties.put("eclipselink.session.customizer", customizer);
        properties.put("eclipselink.logging.level", loggingLevel);
        properties.put("eclipselink.session-name", "");
        properties.put("javax.persistence.transactionType", "JTA");
        properties.put("javax.persistence.jtaDataSource", myJtaDS);
        properties.put("javax.persistence.nonJtaDataSource", myNonJtaDS);
        properties.put("javax.persistence.jdbc.user", "");
        emf = Persistence.createEntityManagerFactory((String)puName, properties);
        try {
            emf.createEntityManager();
        }
        catch (Exception connector) {
        }
        finally {
            emf.close();
            if (SessionNameCustomizer.ss == null && SessionNameCustomizer.ss == originalSession) {
                errorMsg = errorMsg + "2: New session expected; ";
            } else {
                Connector readConnector;
                if (!SessionNameCustomizer.ss.getLogin().shouldUseExternalConnectionPooling()) {
                    errorMsg = errorMsg + "2: external connection pooling expected; ";
                }
                if (!SessionNameCustomizer.ss.getLogin().shouldUseExternalTransactionController()) {
                    errorMsg = errorMsg + "2: externalTransactionController expected; ";
                }
                if (SessionNameCustomizer.ss.getLogin().getUserName().length() > 0) {
                    errorMsg = errorMsg + "2: empty string user expected; ";
                }
                if ((connector = SessionNameCustomizer.ss.getLogin().getConnector()) instanceof JNDIConnector) {
                    if (!myJtaDS.equals(((JNDIConnector)connector).getName())) {
                        errorMsg = errorMsg + "2: myJtaDS expected; ";
                    }
                } else {
                    errorMsg = errorMsg + "2: JNDIConnector expected; ";
                }
                if (!SessionNameCustomizer.ss.getReadConnectionPool().getLogin().shouldUseExternalConnectionPooling()) {
                    errorMsg = errorMsg + "2: resding: external connection pooling expected; ";
                }
                if (SessionNameCustomizer.ss.getReadConnectionPool().getLogin().shouldUseExternalTransactionController()) {
                    errorMsg = errorMsg + "2: reading no externalTransactionController expected; ";
                }
                if (SessionNameCustomizer.ss.getReadConnectionPool().getLogin().getUserName().length() > 0) {
                    errorMsg = errorMsg + "2: reading: empty string user expected; ";
                }
                if ((readConnector = ((DatasourceLogin)SessionNameCustomizer.ss.getReadConnectionPool().getLogin()).getConnector()) instanceof JNDIConnector) {
                    if (!myNonJtaDS.equals(((JNDIConnector)readConnector).getName())) {
                        errorMsg = errorMsg + "2: reading: myNonJtaDS expected; ";
                    }
                } else {
                    errorMsg = errorMsg + "2: reading: JNDIConnector expected; ";
                }
            }
            SessionNameCustomizer.ss = null;
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testPreupdateEmbeddable() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("testPreupdateEmbeddable");
        emp.setLastName("testPreupdateEmbeddable");
        EmploymentPeriod period = new EmploymentPeriod();
        period.setStartDate(java.sql.Date.valueOf("2002-01-01"));
        emp.setPeriod(period);
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setFirstName("testPreupdateEmbeddable1");
        emp = (Employee)em.merge((Object)emp);
        em.flush();
        this.clearCache();
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        EntityManagerJUnitTestSuite.assertTrue((String)"The endDate was not updated.", (boolean)emp.getPeriod().getEndDate().equals(EmployeeListener.UPDATE_DATE));
        em.remove((Object)emp);
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindReadOnlyIsolated() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("SELECT ro FROM ReadOnlyIsolated ro").getResultList();
            em.find(ReadOnlyIsolated.class, (Object)1);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testInheritanceQuery() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        LargeProject project = new LargeProject();
        em.persist((Object)project);
        this.commitTransaction(em);
        int id = project.getId();
        this.clearCache();
        ClassDescriptor descriptor = EntityManagerJUnitTestSuite.getServerSession().getClassDescriptor(Project.class);
        ReadAllQuery query = new ReadAllQuery(Project.class);
        ExpressionBuilder b = query.getExpressionBuilder();
        query.addArgument("id", Integer.class);
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(Project.class);
        SQLCall selectIdsCall = new SQLCall();
        String subSelect = "select p.PROJ_ID from CMP3_PROJECT p where p.PROJ_ID = #id";
        selectIdsCall.setSQLString(subSelect);
        subQuery.setCall((Call)selectIdsCall);
        Expression expr = b.get("id").in(subQuery);
        query.setSelectionCriteria(expr);
        Vector<Integer> params = new Vector<Integer>(1);
        params.add(id);
        List res = (List)EntityManagerJUnitTestSuite.getServerSession().executeQuery((DatabaseQuery)query, params);
        EntityManagerJUnitTestSuite.assertTrue((res.size() == 1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullBasicMap() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Buyer buyer = new Buyer();
            buyer.setName("Joe");
            buyer.setDescription("Test Buyer");
            buyer.setCreditCards(null);
            em.persist((Object)buyer);
            em.flush();
            this.clearCache();
            buyer = (Buyer)em.find(Buyer.class, (Object)buyer.getId());
            EntityManagerJUnitTestSuite.assertTrue((String)"Buyer was not properly persisted", (buyer != null ? 1 : 0) != 0);
        }
        catch (NullPointerException ex) {
            EntityManagerJUnitTestSuite.fail((String)"NPE caught when persisting a null Map.");
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlushClearFind() {
        HashMap properties = new HashMap();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Cesc");
        emp.setLastName("Fabergass");
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setLastName("Fabregas");
        em.flush();
        em.clear();
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        this.commitTransaction(em);
        try {
            EntityManagerJUnitTestSuite.assertTrue((String)"Employees name was returned from server cache, when it should not have been", (boolean)emp.getLastName().equals("Fabregas"));
        }
        finally {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlushClearFindNoCascadedLock() {
        HashMap properties = new HashMap();
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Address add = new Address();
        add.setCity("London");
        em.persist((Object)add);
        this.commitTransaction(em);
        this.beginTransaction(em);
        add = (Address)em.find(Address.class, (Object)add.getID());
        add.setCity("Barcelona");
        em.flush();
        em.clear();
        add = (Address)em.find(Address.class, (Object)add.getID());
        this.commitTransaction(em);
        try {
            EntityManagerJUnitTestSuite.assertTrue((String)"Address city was returned from server cache, when it should not have been", (boolean)add.getCity().equals("Barcelona"));
        }
        finally {
            this.clearCache();
            em.clear();
            this.beginTransaction(em);
            add = (Address)em.find(Address.class, (Object)add.getID());
            em.remove((Object)add);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlushClearQueryPk() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Cesc");
        emp.setLastName("Fabergass");
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setLastName("Fabregas");
        em.flush();
        em.clear();
        emp = (Employee)em.createQuery("select e from Employee e where e.id = :id").setParameter("id", (Object)emp.getId()).getSingleResult();
        this.commitTransaction(em);
        try {
            EntityManagerJUnitTestSuite.assertTrue((String)"Employees name was returned from server cache, when it should not have been", (boolean)emp.getLastName().equals("Fabregas"));
        }
        finally {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFlushClearQueryNonPK() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Cesc");
        emp.setLastName("Fabergass");
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setLastName("Fabregas");
        em.flush();
        em.clear();
        emp = (Employee)em.createQuery("select e from Employee e where e.firstName = :name").setParameter("name", (Object)emp.getFirstName()).getSingleResult();
        this.commitTransaction(em);
        try {
            EntityManagerJUnitTestSuite.assertTrue((String)"Employees name was returned from server cache, when it should not have been", (boolean)emp.getLastName().equals("Fabregas"));
        }
        finally {
            this.beginTransaction(em);
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
    }

    public void testSelectEmbeddable() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Robin");
        emp.setLastName("Van Persie");
        EmploymentPeriod period = new EmploymentPeriod();
        period.setStartDate(new java.sql.Date(new GregorianCalendar(2009, 1, 1).getTimeInMillis()));
        period.setEndDate(new java.sql.Date(new GregorianCalendar(2010, 1, 1).getTimeInMillis()));
        emp.setPeriod(period);
        em.persist((Object)emp);
        em.flush();
        em.clear();
        this.clearCache();
        EmployeeHolder results = (EmployeeHolder)em.createQuery("select new org.eclipse.persistence.testing.models.jpa.advanced.EmployeeHolder(e.id, e.period, e.firstName) from Employee e where e.id = :id").setParameter("id", (Object)emp.getId()).getSingleResult();
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect id", (boolean)emp.getId().equals(results.getId()));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect period start date", (boolean)emp.getPeriod().getStartDate().equals(results.getPeriod().getStartDate()));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect period end date", (boolean)emp.getPeriod().getEndDate().equals(results.getPeriod().getEndDate()));
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect name", (boolean)emp.getFirstName().equals(results.getName()));
        this.rollbackTransaction(em);
    }

    public void testNestedBatchQueryHint() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Department dept = new Department();
        dept.setName("Parents");
        Employee emp = new Employee();
        emp.setFirstName("Dave");
        emp.setLastName("Daddy");
        dept.setDepartmentHead(emp);
        emp.setDepartment(dept);
        PhoneNumber pn = new PhoneNumber();
        pn.setNumber("1234567");
        pn.setAreaCode("613");
        pn.setType("Home");
        emp.addPhoneNumber(pn);
        em.persist((Object)emp);
        em.persist((Object)dept);
        em.persist((Object)pn);
        em.flush();
        em.clear();
        this.clearCache();
        List results = em.createQuery("select d from ADV_DEPT d").setHint("eclipselink.join-fetch", (Object)"d.departmentHead").setHint("eclipselink.batch", (Object)"d.departmentHead.phoneNumbers").getResultList();
        EntityManagerJUnitTestSuite.assertTrue((String)"Wrong results returned.", (results.size() == 1 ? 1 : 0) != 0);
        dept = (Department)results.get(0);
        dept.getDepartmentHead().getPhoneNumbers().hashCode();
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonPooledConnection() {
        EntityManager em;
        boolean isSpring;
        ServerSession ss = EntityManagerJUnitTestSuite.getServerSession();
        ConnectionPolicy connectionPolicy = (ConnectionPolicy)ss.getDefaultConnectionPolicy().clone();
        connectionPolicy.setLogin((Login)ss.getLogin());
        connectionPolicy.setPoolName(null);
        boolean isEmInjected = EntityManagerJUnitTestSuite.isOnServer() && ss.getLogin().shouldUseExternalTransactionController();
        boolean bl = isSpring = EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.getServerPlatform().isSpring();
        if (isEmInjected) {
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.setProperty("eclipselink.jdbc.connection-policy", (Object)connectionPolicy);
        } else {
            EntityManagerFactory emFactory = this.getEntityManagerFactory();
            HashMap<String, ConnectionPolicy> properties = new HashMap<String, ConnectionPolicy>(1);
            properties.put("eclipselink.jdbc.connection-policy", connectionPolicy);
            em = emFactory.createEntityManager(properties);
            if (isSpring) {
                em.getTransaction().begin();
            } else {
                this.beginTransaction(em);
            }
        }
        try {
            em.createNativeQuery("SELECT F_NAME FROM CMP3_EMPLOYEE").getResultList();
            EntityManagerJUnitTestSuite.assertTrue((String)"Test problem: connection should be not pooled", (((UnitOfWork)em.unwrap(UnitOfWork.class)).getParent().getAccessor().getPool() == null ? 1 : 0) != 0);
        }
        finally {
            if (isSpring) {
                em.getTransaction().rollback();
            } else {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testExclusiveIsolatedLeaksConnectionOnClear() {
        EntityManager em;
        boolean isSpring;
        ServerSession ss = EntityManagerJUnitTestSuite.getServerSession();
        boolean isEmInjected = EntityManagerJUnitTestSuite.isOnServer() && ss.getLogin().shouldUseExternalTransactionController();
        boolean bl = isSpring = EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.getServerPlatform().isSpring();
        if (isEmInjected) {
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.setProperty("eclipselink.jdbc.exclusive-connection.mode", (Object)"Always");
        } else {
            EntityManagerFactory emFactory = this.getEntityManagerFactory();
            HashMap<String, String> properties = new HashMap<String, String>(1);
            properties.put("eclipselink.jdbc.exclusive-connection.mode", "Always");
            em = emFactory.createEntityManager(properties);
            if (isSpring) {
                em.getTransaction().begin();
            } else {
                this.beginTransaction(em);
            }
        }
        em.createQuery("SELECT e FROM Employee e").getResultList();
        Accessor accessor = ((UnitOfWork)em.unwrap(UnitOfWork.class)).getParent().getAccessor();
        if (isSpring) {
            em.getTransaction().commit();
        } else {
            this.commitTransaction(em);
        }
        em.clear();
        this.closeEntityManager(em);
        ConnectionPool pool = ss.getDefaultConnectionPool();
        boolean released = ss.getLogin().shouldUseExternalConnectionPooling() ? accessor.getConnection() == null : pool.getConnectionsAvailable().contains(accessor);
        if (!released) {
            pool.releaseConnection(accessor);
            EntityManagerJUnitTestSuite.fail((String)"Exclusive connection has not been released after the EntityManager has been closed.");
        }
    }

    public void testSetTargetQueryOneToMany() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager em = EntityManagerJUnitTestSuite.createEntityManager((String)"customizeAddTarget");
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Nick");
        em.persist((Object)emp);
        em.flush();
        emp.addDealer(new Dealer());
        em.flush();
        em.clear();
        EntityManagerJUnitTestSuite.clearCache((String)"customizeAddTarget");
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        this.rollbackTransaction(em);
        EntityManagerJUnitTestSuite.assertTrue((String)"The add Target Query was not correctly customized", (emp.getFirstName() == null ? 1 : 0) != 0);
    }

    public void testSettingDetachedObject() {
        EntityManager em = this.createEntityManager();
        List results = em.createQuery("Select a from Address a").getResultList();
        Department dept1 = new Department("Dept1");
        Department dept2 = new Department("Dept2");
        this.beginTransaction(em);
        em.persist((Object)dept1);
        em.persist((Object)dept2);
        this.commitTransaction(em);
        em.clear();
        Employee emp = new Employee("Bob", "Bob");
        this.beginTransaction(em);
        em.persist((Object)emp);
        emp.setDepartment(dept1);
        em.flush();
        emp.setDepartment(dept2);
        this.commitTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeOfEntityWithDetachedReferences() {
        EntityManager em = null;
        Dealer dealer = new Dealer();
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.persist((Object)dealer);
            this.commitTransaction(em);
            em.clear();
            em = this.createEntityManager();
            this.beginTransaction(em);
            dealer = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            Customer customer = new Customer();
            customer.setFirstName("p2");
            dealer.addCustomer(customer);
            customer = new Customer();
            customer.setFirstName("p3");
            dealer.addCustomer(customer);
            dealer = (Dealer)em.merge((Object)dealer);
            this.commitTransaction(em);
            this.beginTransaction(em);
            dealer = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            ((Customer)dealer.getCustomers().get(1)).setFirstName("SOMENUMBER");
            this.commitTransaction(em);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("En error occurred adding new customers: " + e.getMessage()));
        }
        finally {
            if (em != null) {
                this.closeEntityManager(em);
            }
        }
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            dealer = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
            boolean changedName = false;
            for (Customer customer : dealer.getCustomers()) {
                if (customer == null) {
                    EntityManagerJUnitTestSuite.fail((String)"A null Customer was found in the collection of Customers.");
                }
                if (customer.getFirstName() == null || customer.getFirstName().equals("")) {
                    EntityManagerJUnitTestSuite.fail((String)"Attributes not merged into collection");
                }
                if (dealer.getCustomers().lastIndexOf(customer) != dealer.getCustomers().indexOf(customer)) {
                    EntityManagerJUnitTestSuite.fail((String)"Customer instance referenced multiple times ");
                }
                if (!customer.getFirstName().equals("SOMENUMBER")) continue;
                changedName = true;
            }
            EntityManagerJUnitTestSuite.assertTrue((String)"Merge identiy lost ", (boolean)changedName);
        }
        catch (Exception e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("En error occurred fetching the results to verify: " + e.getMessage()));
        }
        finally {
            this.commitTransaction(em);
            if (em != null) {
                this.closeEntityManager(em);
            }
            try {
                em = this.createEntityManager();
                this.beginTransaction(em);
                dealer = (Dealer)em.find(Dealer.class, (Object)dealer.getId());
                em.remove((Object)dealer);
                for (Customer customer : dealer.getCustomers()) {
                    em.remove((Object)customer);
                }
                dealer.getCustomers().clear();
                this.commitTransaction(em);
            }
            finally {
                if (em != null) {
                    this.closeEntityManager(em);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshForFlush() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Al");
        em.persist((Object)emp);
        em.flush();
        em.clear();
        this.clearCache();
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setFirstName("Joe");
        em.refresh((Object)emp);
        emp.setLastName("Joseph");
        em.flush();
        em.refresh((Object)emp);
        try {
            EntityManagerJUnitTestSuite.assertFalse((String)"The first name was updated even though it was reverted.", (boolean)emp.getFirstName().equals("Joe"));
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshLazyRelationship() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager setupEm = this.createEntityManager();
        setupEm.getTransaction().begin();
        Employee emp = new Employee();
        setupEm.persist((Object)emp);
        Employee direct = new Employee("Managed", "EMployee");
        setupEm.persist((Object)direct);
        emp.getManagedEmployees().add(direct);
        direct.setManager(emp);
        setupEm.getTransaction().commit();
        this.clearCache();
        EntityManager em1 = this.createEntityManager();
        EntityManager em2 = this.createEntityManager();
        emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
        Employee emp2 = (Employee)em2.find(Employee.class, (Object)emp.getId());
        Employee direct2 = (Employee)em2.find(Employee.class, (Object)direct.getId());
        em1.getTransaction().begin();
        ((Employee)emp.getManagedEmployees().iterator().next()).setFirstName("something");
        em1.getTransaction().commit();
        em2.refresh((Object)emp2);
        try {
            EntityManagerJUnitTestSuite.assertEquals((String)"Did not cascade refresh across untriggered lazy", (String)((Employee)emp2.getManagedEmployees().iterator().next()).getFirstName(), (String)"something");
        }
        finally {
            try {
                em2.getTransaction().begin();
                em2.remove((Object)emp2);
                em2.remove((Object)direct2);
                em2.getTransaction().commit();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNonRefreshLazyRelationship() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManager setupEm = this.createEntityManager();
        setupEm.getTransaction().begin();
        Employee emp = new Employee();
        setupEm.persist((Object)emp);
        Employee direct = new Employee("Managed", "EMployee");
        setupEm.persist((Object)direct);
        emp.getManagedEmployees().add(direct);
        direct.setManager(emp);
        Dealer dealer = new Dealer("Jim", "Bob");
        emp.getDealers().add(dealer);
        setupEm.persist((Object)dealer);
        LargeProject project = new LargeProject("Alpha Alpha Zulu");
        setupEm.persist((Object)project);
        emp.getProjects().add(project);
        setupEm.getTransaction().commit();
        this.clearCache();
        EntityManager em1 = this.createEntityManager();
        EntityManager em2 = this.createEntityManager();
        emp = (Employee)em1.find(Employee.class, (Object)emp.getId());
        Employee emp2 = (Employee)em2.find(Employee.class, (Object)emp.getId());
        Employee direct2 = (Employee)em2.find(Employee.class, (Object)direct.getId());
        Dealer dealer2 = (Dealer)em2.find(Dealer.class, (Object)dealer.getId());
        Project project2 = (Project)em2.find(Project.class, (Object)project.getId());
        em1.getTransaction().begin();
        ((Employee)emp.getManagedEmployees().iterator().next()).setFirstName("something");
        ((Dealer)emp.getDealers().get(0)).setFirstName("Something");
        ((Project)emp.getProjects().iterator().next()).setName("Beta Beta Wiskey");
        em1.getTransaction().commit();
        em2.refresh((Object)emp2);
        try {
            EntityManagerJUnitTestSuite.assertEquals((String)"Did not cascade refresh across untriggered lazy", (String)((Employee)emp2.getManagedEmployees().iterator().next()).getFirstName(), (String)"something");
            EntityManagerJUnitTestSuite.assertEquals((String)"Cascaded refresh to non cascade refresh entity", (String)((Dealer)emp2.getDealers().get(0)).getFirstName(), (String)"Jim");
            EntityManagerJUnitTestSuite.assertEquals((String)"Cascade refresh to non cascade refresh", (String)((Project)emp2.getProjects().iterator().next()).getName(), (String)"Alpha Alpha Zulu");
        }
        finally {
            try {
                em2.getTransaction().begin();
                em2.remove((Object)emp2);
                em2.remove((Object)direct2);
                em2.remove((Object)dealer2);
                em2.remove((Object)project2);
                em2.getTransaction().commit();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshForCommit() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Al");
        em.persist((Object)emp);
        this.commitTransaction(em);
        em.clear();
        this.clearCache();
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setFirstName("Joe");
        em.refresh((Object)emp);
        emp.setLastName("Joseph");
        this.commitTransaction(em);
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            em.refresh((Object)emp);
            EntityManagerJUnitTestSuite.assertFalse((String)"The first name was updated even though it was reverted.", (boolean)emp.getFirstName().equals("Joe"));
        }
        finally {
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChangeFlushChangeRefresh() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("Al");
        em.persist((Object)emp);
        this.commitTransaction(em);
        em.clear();
        this.clearCache();
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        emp.setFirstName("Joe");
        em.flush();
        emp.setLastName("Joseph");
        em.refresh((Object)emp);
        this.commitTransaction(em);
        em.clear();
        this.clearCache();
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            EntityManagerJUnitTestSuite.assertTrue((String)"The first name was reverted even though it was written.", (boolean)emp.getFirstName().equals("Joe"));
        }
        finally {
            em.remove((Object)emp);
            this.commitTransaction(em);
        }
    }

    public void testChangeRecordKeepOldValue_Simple() {
        this.internalTestChangeRecordKeepOldValue(false);
    }

    public void testChangeRecordKeepOldValue_TwoStep() {
        this.internalTestChangeRecordKeepOldValue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void internalTestChangeRecordKeepOldValue(boolean addSecondStep) {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        ServerSession ss = EntityManagerJUnitTestSuite.getServerSession();
        ChangeRecordKeepOldValueListener listener = new ChangeRecordKeepOldValueListener();
        ss.getEventManager().addListener((SessionEventListener)listener);
        EntityManager em = this.createEntityManager();
        try {
            void var35_48;
            Employee emp = new Employee();
            emp.setFirstName("TestChangeRecordKeepOldValue");
            emp.setLastName("Manager_OriginalName");
            emp.setMale();
            emp.setSalary(35000);
            emp.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1996, (int)11, (int)31)));
            emp.setFormerEmployment(new FormerEmployment("Original", new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1990, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1993, (int)11, (int)31))));
            Address address = new Address();
            address.setCountry("Original");
            address.setProvince("Original");
            address.setCity("Original");
            address.setStreet("Original");
            address.setPostalCode("Original");
            emp.setAddress(address);
            Department dep = new Department();
            dep.setName("Original");
            emp.setDepartment(dep);
            emp.addResponsibility("Original_1");
            emp.addResponsibility("Original_2");
            PhoneNumber phone1 = new PhoneNumber("Original_1", "111", "1111111");
            emp.addPhoneNumber(phone1);
            PhoneNumber phone2 = new PhoneNumber("Original_2", "222", "2222222");
            emp.addPhoneNumber(phone2);
            emp.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)9, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)17, (int)0, (int)0)});
            Employee emp1 = new Employee();
            emp1.setFirstName("TestChangeRecordKeepOldValue");
            emp1.setLastName("Original_1");
            emp.addManagedEmployee(emp1);
            Employee emp2 = new Employee();
            emp2.setFirstName("TestChangeRecordKeepOldValue");
            emp2.setLastName("Original_2");
            emp.addManagedEmployee(emp2);
            SmallProject proj1 = new SmallProject();
            proj1.setName("Original_1");
            emp.addProject((Project)proj1);
            LargeProject proj2 = new LargeProject();
            proj2.setName("Original_2");
            emp.addProject((Project)proj2);
            LargeProject proj3 = new LargeProject();
            proj3.setName("Original_3");
            proj3.setTeamLeader(emp);
            emp1.addProject((Project)proj3);
            emp2.addProject((Project)proj3);
            this.beginTransaction(em);
            Equipment equipment1 = new Equipment();
            equipment1.setDescription("Original_1");
            em.persist((Object)equipment1);
            dep.addEquipment(equipment1);
            Equipment equipment2 = new Equipment();
            equipment2.setDescription("Original_2");
            em.persist((Object)equipment2);
            dep.addEquipment(equipment2);
            em.persist((Object)dep);
            em.persist((Object)emp);
            this.commitTransaction(em);
            CopyGroup copyGroupBackup = new CopyGroup();
            copyGroupBackup.cascadeAllParts();
            ss.copy((Object)emp, (AttributeGroup)copyGroupBackup);
            Map backupMap = copyGroupBackup.getCopies();
            for (Map.Entry entry : backupMap.entrySet()) {
                Object original = entry.getKey();
                ClassDescriptor descriptor = ss.getDescriptor(original);
                if (descriptor.isAggregateDescriptor()) continue;
                Object backup = entry.getValue();
                if (original == backup) {
                    EntityManagerJUnitTestSuite.fail((String)("Test problem: backup failed: original == backup: " + original));
                }
                if (ss.compareObjects(original, backup)) continue;
                EntityManagerJUnitTestSuite.fail((String)("Test problem: backup failed: compareObjects(original, backup) == false: " + original + "; " + backup));
            }
            this.beginTransaction(em);
            emp.setLastName("Manager_NewName");
            emp.setSalary(100);
            emp.getPeriod().setStartDate(Helper.dateFromYearMonthDate((int)2000, (int)0, (int)1));
            emp.getPeriod().setEndDate(Helper.dateFromYearMonthDate((int)2002, (int)0, (int)1));
            emp.getFormerEmployment().setFormerCompany("New");
            emp.getFormerEmployment().getPeriod().setStartDate(Helper.dateFromYearMonthDate((int)1989, (int)0, (int)1));
            emp.getFormerEmployment().getPeriod().setStartDate(Helper.dateFromYearMonthDate((int)1992, (int)11, (int)31));
            emp.setStartTime(Helper.timeFromHourMinuteSecond((int)10, (int)0, (int)0));
            emp.removeResponsibility("Original_1");
            emp.addResponsibility("New_1");
            PhoneNumber phone1New = new PhoneNumber("New_1", "111", "1111111");
            emp.addPhoneNumber(phone1New);
            emp.removePhoneNumber(phone1);
            emp.removeManagedEmployee(emp1);
            emp1.setManager(null);
            em.remove((Object)emp1);
            Employee emp1New = new Employee();
            emp1New.setFirstName("TestChangeRecordKeepOldValue");
            emp1New.setLastName("New_1");
            emp1New.addProject((Project)proj3);
            emp.addManagedEmployee(emp1New);
            emp.removeProject((Project)proj1);
            em.remove((Object)proj1);
            LargeProject proj1New = new LargeProject();
            proj1New.setName("New_1");
            emp.addProject((Project)proj1New);
            proj3.setTeamLeader(null);
            Address addressNew = new Address();
            addressNew.setCountry("New");
            addressNew.setProvince("New");
            addressNew.setCity("New");
            addressNew.setStreet("New");
            addressNew.setPostalCode("New");
            emp.setAddress(addressNew);
            em.remove((Object)address);
            dep.getEquipment().remove(equipment1.getId());
            Equipment equipment1New = new Equipment();
            equipment1New.setDescription("New_1");
            em.persist((Object)equipment1New);
            dep.addEquipment(equipment1New);
            if (addSecondStep) {
                emp.setPeriod(new EmploymentPeriod());
                emp.getPeriod().setStartDate(Helper.dateFromYearMonthDate((int)2001, (int)0, (int)1));
                emp.getPeriod().setEndDate(Helper.dateFromYearMonthDate((int)2003, (int)0, (int)1));
                emp.setFormerEmployment(new FormerEmployment("New_New", new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1988, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1991, (int)11, (int)31))));
                emp.getFormerEmployment().setPeriod(new EmploymentPeriod());
                emp.getFormerEmployment().getPeriod().setStartDate(Helper.dateFromYearMonthDate((int)1987, (int)0, (int)1));
                emp.getFormerEmployment().getPeriod().setEndDate(Helper.dateFromYearMonthDate((int)1990, (int)0, (int)1));
                emp.setEndTime(Helper.timeFromHourMinuteSecond((int)18, (int)0, (int)0));
                emp.setResponsibilities(new ArrayList());
                emp.addResponsibility("New_New_1");
                emp.setPhoneNumbers(new HashSet());
                PhoneNumber phone1NewNew = new PhoneNumber("New_New_1", "111", "1111111");
                emp.addPhoneNumber(phone1NewNew);
                emp1New.setManager(null);
                emp2.setManager(null);
                emp.setManagedEmployees(new Vector());
                Employee emp1NewNew = new Employee();
                emp1NewNew.setFirstName("TestChangeRecordKeepOldValue");
                emp1NewNew.setLastName("New_New_1");
                emp1NewNew.addProject((Project)proj3);
                emp.addManagedEmployee(emp1NewNew);
                em.remove((Object)emp1New);
                em.remove((Object)emp2);
                emp.setProjects(new ArrayList());
                LargeProject proj1NewNew = new LargeProject();
                proj1NewNew.setName("New_New_1");
                emp.addProject((Project)proj1NewNew);
                em.remove((Object)proj1New);
                em.remove((Object)proj2);
                Address addressNewNew = new Address();
                addressNewNew.setCountry("New_New");
                addressNewNew.setProvince("New_New");
                addressNewNew.setCity("New_New");
                addressNewNew.setStreet("New_New");
                addressNewNew.setPostalCode("New_New");
                emp.setAddress(addressNewNew);
                em.remove((Object)addressNew);
                em.remove((Object)equipment1New);
                dep.setEquipment(new HashMap());
                Equipment equipment1NewNew = new Equipment();
                equipment1NewNew.setDescription("New_New_1");
                em.persist((Object)equipment1NewNew);
                dep.addEquipment(equipment1NewNew);
            }
            this.commitTransaction(em);
            CopyGroup copyGroupUpdated = new CopyGroup();
            copyGroupUpdated.cascadeAllParts();
            ss.copy((Object)emp, (AttributeGroup)copyGroupUpdated);
            Map oldValueMap = copyGroupUpdated.getCopies();
            for (Map.Entry entry : ((UnitOfWorkChangeSet)listener.uowChangeSet).getCloneToObjectChangeSet().entrySet()) {
                List changes;
                org.eclipse.persistence.sessions.changesets.ObjectChangeSet changeSet;
                Object object = entry.getKey();
                ClassDescriptor descriptor = ss.getDescriptor(object);
                if (descriptor.isAggregateDescriptor() || ((ObjectChangeSet)(changeSet = (org.eclipse.persistence.sessions.changesets.ObjectChangeSet)entry.getValue())).shouldBeDeleted() || changeSet.isNew() || (changes = changeSet.getChanges()) == null || changes.isEmpty()) continue;
                Object oldValueObject = oldValueMap.get(object);
                for (org.eclipse.persistence.sessions.changesets.ChangeRecord changeRecord : changeSet.getChanges()) {
                    Object oldValue = changeRecord.getOldValue();
                    DatabaseMapping mapping = ((ChangeRecord)changeRecord).getMapping();
                    mapping.setRealAttributeValueInObject(oldValueObject, oldValue);
                }
            }
            String errorMsgOldValues = "";
            for (Map.Entry entry : ((UnitOfWorkChangeSet)listener.uowChangeSet).getCloneToObjectChangeSet().entrySet()) {
                Object v;
                Object oldValueObject;
                List changes;
                org.eclipse.persistence.sessions.changesets.ObjectChangeSet changeSet;
                Object object = entry.getKey();
                ClassDescriptor descriptor = ss.getDescriptor(object);
                if (descriptor.isAggregateDescriptor() || ((ObjectChangeSet)(changeSet = (org.eclipse.persistence.sessions.changesets.ObjectChangeSet)entry.getValue())).shouldBeDeleted() || changeSet.isNew() || (changes = changeSet.getChanges()) == null || changes.isEmpty() || ss.compareObjects(oldValueObject = oldValueMap.get(object), v = backupMap.get(object))) continue;
                errorMsgOldValues = errorMsgOldValues + '\t' + object.toString() + '\n';
            }
            HashSet updatedObjects = new HashSet();
            for (Object object : oldValueMap.keySet()) {
                ClassDescriptor descriptor = ss.getDescriptor(object);
                if (descriptor.isAggregateDescriptor()) continue;
                updatedObjects.add(object);
            }
            String errorMsgDb = "";
            this.clearCache();
            HashMap updatedToReadBack = new HashMap();
            EntityManager em2 = this.createEntityManager();
            this.beginTransaction(em2);
            RepeatableWriteUnitOfWork uow2 = ((EntityManagerImpl)em2.getDelegate()).getActivePersistenceContext(null);
            for (Object e : updatedObjects) {
                Object readBack = uow2.readObject(e);
                if (readBack instanceof Project) {
                    ((Project)readBack).getTeamMembers().clear();
                } else if (readBack instanceof Address) {
                    ((Address)readBack).getEmployees().clear();
                } else if (readBack instanceof PhoneNumber) {
                    ((PhoneNumber)readBack).setId(null);
                } else if (readBack instanceof Department) {
                    ((Department)readBack).getEmployees().clear();
                }
                updatedToReadBack.put(e, readBack);
            }
            for (Object object : updatedToReadBack.entrySet()) {
                Object readBack;
                Map.Entry entry = (Map.Entry)object;
                Object object2 = entry.getKey();
                if (ss.compareObjects(object2, readBack = entry.getValue())) continue;
                errorMsgDb = errorMsgDb + '\t' + object2.toString() + '\n';
            }
            this.rollbackTransaction(em2);
            this.beginTransaction(em);
            HashSet objectsToRemove = new HashSet();
            for (Object object : updatedObjects) {
                if (object instanceof Employee) {
                    ((Employee)object).getManagedEmployees().clear();
                    ((Employee)object).setManager(null);
                    ((Employee)object).setAddress((Address)null);
                    ((Employee)object).getProjects().clear();
                    ((Employee)object).setDepartment(null);
                    objectsToRemove.add(object);
                    continue;
                }
                if (object instanceof Project) {
                    ((Project)object).setTeamLeader(null);
                    objectsToRemove.add(object);
                    continue;
                }
                if (!(object instanceof Address) && !(object instanceof Department)) continue;
                objectsToRemove.add(object);
            }
            for (Object object : objectsToRemove) {
                em.remove(object);
            }
            this.commitTransaction(em);
            String string = "";
            if (errorMsgOldValues.length() > 0) {
                errorMsgOldValues = "Some old values and back up objects are not equal:\n" + errorMsgOldValues;
                String string2 = string + errorMsgOldValues;
            }
            if (errorMsgDb.length() > 0) {
                void var35_46;
                errorMsgDb = "\nSome values were incorrectly written into the db:\n" + errorMsgDb;
                String string3 = (String)var35_46 + errorMsgDb;
            }
            if (var35_48.length() > 0) {
                EntityManagerJUnitTestSuite.fail((String)var35_48);
            }
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            ss.getEventManager().removeListener((SessionEventListener)listener);
        }
    }

    public void testSetNewAggregate() {
        EntityManager em = this.createEntityManager();
        Employee emp = new Employee();
        emp.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1988, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1991, (int)11, (int)31)));
        this.beginTransaction(em);
        em.persist((Object)emp);
        this.commitTransaction(em);
        int id = emp.getId();
        this.beginTransaction(em);
        if (EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.isJTA()) {
            emp = (Employee)em.find(Employee.class, (Object)id);
        }
        emp.getPeriod().setStartDate(Helper.dateFromYearMonthDate((int)1989, (int)0, (int)1));
        emp.getPeriod().setEndDate(Helper.dateFromYearMonthDate((int)1992, (int)0, (int)1));
        emp.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1989, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1992, (int)11, (int)31)));
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Employee empRead = (Employee)em.find(Employee.class, (Object)id);
        em.remove((Object)empRead);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        EntityManagerJUnitTestSuite.assertTrue((String)"Wrong emp.getPeriod() inserted into db", (boolean)emp.getPeriod().equals((Object)empRead.getPeriod()));
    }

    public void testSetNewNestedAggregate() {
        EntityManager em = this.createEntityManager();
        Employee emp = new Employee();
        emp.setFormerEmployment(new FormerEmployment("A", new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1988, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1991, (int)11, (int)31))));
        this.beginTransaction(em);
        em.persist((Object)emp);
        this.commitTransaction(em);
        int id = emp.getId();
        this.beginTransaction(em);
        if (EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.isJTA()) {
            emp = (Employee)em.find(Employee.class, (Object)id);
        }
        emp.setFormerEmployment(new FormerEmployment("B", new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1987, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1990, (int)11, (int)31))));
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Employee empRead = (Employee)em.find(Employee.class, (Object)id);
        em.remove((Object)empRead);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        EntityManagerJUnitTestSuite.assertTrue((String)"Wrong emp.getFormerEmployment().getPeriod() inserted into db", (boolean)emp.getFormerEmployment().getPeriod().equals((Object)empRead.getFormerEmployment().getPeriod()));
    }

    public void testSetStartTime() {
        EntityManager em = this.createEntityManager();
        Employee emp = new Employee();
        emp.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)0, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)8, (int)0, (int)0)});
        this.beginTransaction(em);
        em.persist((Object)emp);
        this.commitTransaction(em);
        int id = emp.getId();
        this.beginTransaction(em);
        if (EntityManagerJUnitTestSuite.isOnServer() && EntityManagerJUnitTestSuite.isJTA()) {
            emp = (Employee)em.find(Employee.class, (Object)id);
        }
        emp.setStartTime(Helper.timeFromHourMinuteSecond((int)15, (int)0, (int)0));
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Employee empRead = (Employee)em.find(Employee.class, (Object)id);
        em.remove((Object)empRead);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        EntityManagerJUnitTestSuite.assertTrue((String)("inserted startTime: " + emp.getStartTime() + " != read back startTime: " + empRead.getStartTime()), (boolean)emp.getStartTime().equals(empRead.getStartTime()));
    }

    public void testObjectReferencedInBothEmAndSharedCache_ObjectReferenceMappingVH() {
        EntityManager em = this.createEntityManager();
        Employee emp = new Employee();
        emp.setFirstName("Manager");
        Employee emp1 = new Employee();
        emp1.setFirstName("1");
        emp.addManagedEmployee(emp1);
        Employee emp2 = new Employee();
        emp2.setFirstName("2");
        emp.addManagedEmployee(emp2);
        ServerSession ss = null;
        this.beginTransaction(em);
        em.persist((Object)emp);
        ss = EntityManagerJUnitTestSuite.getServerSession();
        this.commitTransaction(em);
        CopyGroup copyGroup = new CopyGroup();
        copyGroup.cascadeAllParts();
        ss.copy((Object)emp, (AttributeGroup)copyGroup);
        Set originalObjects = copyGroup.getCopies().keySet();
        EntityManagerJUnitTestSuite.assertTrue((originalObjects.size() == 3 ? 1 : 0) != 0);
    }

    public void testObjectReferencedInBothEmAndSharedCache_AggregateObjectMapping() {
        EntityManager em = this.createEntityManager();
        ServerSession ss = null;
        Employee emp = new Employee();
        emp.setFirstName("A");
        EmploymentPeriod period = new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1), Helper.dateFromYearMonthDate((int)1996, (int)11, (int)31));
        emp.setPeriod(period);
        this.beginTransaction(em);
        em.persist((Object)emp);
        ss = EntityManagerJUnitTestSuite.getServerSession();
        this.commitTransaction(em);
        this.closeEntityManager(em);
        Employee empShared = (Employee)ss.readObject((Object)emp);
        EntityManagerJUnitTestSuite.assertTrue((emp != empShared ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((emp.getPeriod() != empShared.getPeriod() ? 1 : 0) != 0);
    }

    public void testCharFieldDefaultNullValue() {
        Vegetable vegetable2;
        Vegetable vegetable;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        VegetablePK pk = new VegetablePK("Eggplant", "Purple");
        VegetablePK pk2 = new VegetablePK("Capsicum", "Green");
        String[] tags = new String[]{"California", "DE"};
        String[] tags2 = new String[]{"Florida", "FD"};
        try {
            vegetable = new Vegetable();
            vegetable.setId(pk);
            vegetable.setCost(2.09);
            vegetable.setTags(tags);
            vegetable.setType(' ');
            em.persist((Object)vegetable);
            vegetable2 = new Vegetable();
            vegetable2.setId(pk2);
            vegetable2.setCost(1.35);
            vegetable2.setTags(tags2);
            em.persist((Object)vegetable2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        em.clear();
        this.clearCache();
        this.beginTransaction(em);
        try {
            vegetable = (Vegetable)em.find(Vegetable.class, (Object)pk);
            vegetable2 = (Vegetable)em.find(Vegetable.class, (Object)pk2);
            this.commitTransaction(em);
            EntityManagerJUnitTestSuite.assertNotNull((Object)vegetable);
            EntityManagerJUnitTestSuite.assertNotNull((Object)vegetable2);
            EntityManagerJUnitTestSuite.assertTrue((vegetable.getType() == '\u0000' ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testMergeNewReferencingOldChanged() {
        this.internalTestMergeNewReferencingOldChanged(false);
    }

    void internalTestMergeNewReferencingOldChanged(boolean shouldClearCache) {
        Address address = new Address();
        address.setCountry("Original");
        address.setProvince("Original");
        address.setPostalCode("Original");
        address.setCity("Original");
        address.setStreet("Original");
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        em.persist((Object)address);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        if (shouldClearCache) {
            this.clearCache();
        }
        address.setCountry("Updated");
        address.setProvince("Updated");
        address.setPostalCode("Updated");
        address.setCity("Updated");
        address.setStreet("Updated");
        Employee emp = new Employee();
        emp.setFirstName("New");
        emp.setAddress(address);
        address.getEmployees().add(emp);
        em = this.createEntityManager();
        this.beginTransaction(em);
        Employee empMerged = (Employee)em.merge((Object)emp);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        Address addressMerged = empMerged.getAddress();
        emp.setId(empMerged.getId());
        emp.setVersion(Integer.valueOf(1));
        this.compareObjects(emp, empMerged);
        address.setVersion(addressMerged.getVersion());
        this.compareObjects(address, addressMerged);
        this.verifyObjectInCacheAndDatabase(empMerged);
        this.verifyObjectInCacheAndDatabase(addressMerged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddAndDeleteSameObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Employee emp = new Employee();
        emp.setFirstName("A");
        em.persist((Object)emp);
        SmallProject project = new SmallProject();
        project.setDescription("B");
        em.persist((Object)project);
        emp.addProject((Project)project);
        project.addTeamMember(emp);
        em.flush();
        em.clear();
        this.clearCache();
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            project = (Project)em.find(SmallProject.class, (Object)project.getId());
            emp.removeProject((Project)project);
            project.removeTeamMember(emp);
            em.flush();
            emp.addProject((Project)project);
            project.addTeamMember(emp);
            em.flush();
            em.clear();
            this.clearCache();
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            project = (Project)em.find(SmallProject.class, (Object)project.getId());
            EntityManagerJUnitTestSuite.assertTrue((String)"Employee projects were not the correct size", (emp.getProjects().size() == 1 ? 1 : 0) != 0);
            EntityManagerJUnitTestSuite.assertTrue((String)"Project did not have the correct number of team members", (project.getTeamMembers().size() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteAllProjects() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            EntityManagerJUnitTestSuite.getServerSession().logMessage("Test testDeleteAllProjects skipped for this platform, Symfoware doesn't support UpdateAll/DeleteAll on multi-table objects (see rfe 298193).");
            return;
        }
        String errorMsg = "";
        SmallProject sp = null;
        LargeProject lp = null;
        HugeProject hp = null;
        SpecialHugeProject slp = null;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        String[] classesToDelete = new String[]{"Project", "SmallProject", "LargeProject", "HugeProject", "SpecialHugeProject"};
        try {
            for (int i = 0; i < classesToDelete.length; ++i) {
                if (sp == null) {
                    sp = new SmallProject();
                    em.persist((Object)sp);
                }
                if (lp == null) {
                    lp = new LargeProject();
                    em.persist((Object)lp);
                }
                if (hp == null) {
                    hp = new HugeProject();
                    em.persist((Object)hp);
                }
                if (slp == null) {
                    slp = new SpecialHugeProject();
                    em.persist((Object)slp);
                }
                em.flush();
                String classToDelete = classesToDelete[i];
                em.createQuery("DELETE FROM " + classToDelete + " p").executeUpdate();
                em.clear();
                sp = (SmallProject)em.find(SmallProject.class, (Object)sp.getId());
                lp = (LargeProject)em.find(LargeProject.class, (Object)lp.getId());
                hp = (HugeProject)em.find(HugeProject.class, (Object)hp.getId());
                slp = (SpecialHugeProject)em.find(SpecialHugeProject.class, (Object)slp.getId());
                String unexpectedlyDeleted = "";
                String unexpectedlyNotDeleted = "";
                if (sp == null) {
                    if (classToDelete.equals("LargeProject") || classToDelete.equals("HugeProject") || classToDelete.equals("SpecialHugeProject")) {
                        unexpectedlyDeleted = unexpectedlyDeleted + "SmallProject; ";
                    }
                } else if (classToDelete.equals("Project") || classToDelete.equals("SmallProject")) {
                    unexpectedlyNotDeleted = unexpectedlyNotDeleted + "SmallProject; ";
                }
                if (lp == null) {
                    if (classToDelete.equals("SmallProject") || classToDelete.equals("HugeProject") || classToDelete.equals("SpecialHugeProject")) {
                        unexpectedlyDeleted = unexpectedlyDeleted + "LargeProject; ";
                    }
                } else if (classToDelete.equals("Project") || classToDelete.equals("LargeProject")) {
                    unexpectedlyNotDeleted = unexpectedlyNotDeleted + "LargeProject; ";
                }
                if (hp == null) {
                    if (classToDelete.equals("SmallProject") || classToDelete.equals("SpecialHugeProject")) {
                        unexpectedlyDeleted = unexpectedlyDeleted + "HugeProject; ";
                    }
                } else if (classToDelete.equals("Project") || classToDelete.equals("LargeProject") || classToDelete.equals("HugeProject")) {
                    unexpectedlyNotDeleted = unexpectedlyNotDeleted + "HugeProject; ";
                }
                if (slp == null) {
                    if (classToDelete.equals("SmallProject")) {
                        unexpectedlyDeleted = unexpectedlyDeleted + "SpecialHugeProject; ";
                    }
                } else if (classToDelete.equals("Project") || classToDelete.equals("LargeProject") || classToDelete.equals("HugeProject") || classToDelete.equals("SpecialHugeProject")) {
                    unexpectedlyNotDeleted = unexpectedlyNotDeleted + "SpecialHugeProject; ";
                }
                String localErrorMsg = "";
                if (unexpectedlyDeleted.length() > 0) {
                    localErrorMsg = localErrorMsg + "\n\t\tUnexpectedlyDeleted: " + unexpectedlyDeleted;
                }
                if (unexpectedlyNotDeleted.length() > 0) {
                    localErrorMsg = localErrorMsg + "\n\t\tUnexpectedlyNotDeleted: " + unexpectedlyNotDeleted;
                }
                if (localErrorMsg.length() <= 0) continue;
                errorMsg = errorMsg + "\n\tDELETE FROM " + classToDelete + " p" + localErrorMsg;
            }
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
        if (errorMsg.length() > 0) {
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    public void testEMFBuiltWithSession() {
        EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl((AbstractSession)JUnitTestCase.getServerSession());
        EntityManager em = null;
        try {
            em = emf.createEntityManager(new HashMap());
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Exception thrown while creating entity manager with entity manager factory created from session: " + e.getMessage()));
        }
        this.beginTransaction(em);
        Employee emp = new Employee();
        em.persist((Object)emp);
        this.commitTransaction(em);
        this.beginTransaction(em);
        emp = (Employee)em.find(Employee.class, (Object)emp.getId());
        em.remove((Object)emp);
        this.commitTransaction(em);
        PersistenceUnitLoadingException loadingException = null;
        try {
            JpaHelper.getEntityManagerFactory((EntityManagerFactory)emf).refreshMetadata(new HashMap());
        }
        catch (PersistenceUnitLoadingException e) {
            loadingException = e;
        }
        if (loadingException == null) {
            EntityManagerJUnitTestSuite.fail((String)"Proper exception not thrown when refreshing metadata: ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLazyOneToOneFetchInitialization() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        Room room = null;
        try {
            this.beginTransaction(em);
            room = new Room();
            room.setId(1);
            room.setLength(20);
            room.setHeight(10);
            room.setWidth(18);
            Door east = new Door();
            east.setId(100);
            east.setHeight(8);
            east.setWidth(5);
            int year = 2013;
            int month = 1;
            int day = 30;
            east.setSaleDate(Helper.dateFromYearMonthDate((int)year, (int)(month - 1), (int)day));
            east.setRoom(room);
            room.addDoor(east);
            em.persist((Object)room);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)"Failed to create data for testLazyOneToOneFetchInitialization");
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Door d = (Door)em.find(Door.class, (Object)100);
            EntityManagerJUnitTestSuite.assertTrue((String)"Lazy Field has been initialized referencing to an object of shared cache", (boolean)d.isRoomInstanceInitialized());
            Room r = d.getRoom();
            EntityManagerJUnitTestSuite.assertTrue((String)"Unable to fetch the lazy field.", (r != null ? 1 : 0) != 0);
            EntityManagerJUnitTestSuite.assertTrue((String)"The lazy field has been fetched incorrectly", (boolean)r.equals((Object)room));
        }
        catch (RuntimeException ex) {
            EntityManagerJUnitTestSuite.fail((String)"Failed to fetch data for testLazyOneToOneFetchInitialization");
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForNPEInCloning() {
        Door east;
        Hinge hinge2;
        Hinge hinge1;
        if (!this.isWeavingEnabled()) {
            return;
        }
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            hinge1 = new Hinge();
            hinge1.setId(1);
            hinge2 = new Hinge();
            hinge2.setId(2);
            east = new Door();
            east.setId(102);
            east.setSaleDate(Helper.dateFromYearMonthDate((int)2013, (int)1, (int)20));
            hinge1.setDoor(east);
            hinge2.setDoor(east);
            em.persist((Object)hinge1);
            em.persist((Object)hinge2);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityManagerJUnitTestSuite.fail((String)("Failed to create data for testForNPEInCloning" + ex));
            return;
        }
        finally {
            this.closeEntityManager(em);
        }
        em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Room room = new Room();
            room.setId(3);
            em.persist((Object)room);
            em.flush();
            Session session = (Session)em.unwrap(DatabaseSession.class);
            session.getIdentityMapAccessor().removeFromIdentityMap(session.getId((Object)hinge2), Hinge.class);
            TypedQuery q = em.createNamedQuery("loadHinges", Hinge.class);
            q.setParameter("doorid", (Object)east.getId());
            q.setHint("eclipselink.left-join-fetch", (Object)"h.door");
            List hinges = q.getResultList();
            Assert.assertEquals((long)2L, (long)hinges.size());
        }
        catch (Exception e) {
            EntityManagerJUnitTestSuite.fail((String)("Failed testForNPEInCloning due to " + e));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            try {
                this.beginTransaction(em);
                hinge1 = (Hinge)em.merge((Object)hinge1);
                hinge2 = (Hinge)em.merge((Object)hinge2);
                east = (Door)em.merge((Object)east);
                if (hinge1 != null) {
                    em.remove((Object)hinge1);
                }
                if (hinge2 != null) {
                    em.remove((Object)hinge2);
                }
                if (east != null) {
                    em.remove((Object)east);
                }
                this.commitTransaction(em);
            }
            catch (Exception exception) {
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProxyFetchDuringCommit() {
        if (!this.isWeavingEnabled()) {
            return;
        }
        Door door1 = null;
        Room room1 = null;
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            door1 = new Door();
            door1.setId(11);
            door1.setHeight(84);
            door1.setWidth(48);
            int year = 2013;
            int month = 1;
            int day = 30;
            door1.setSaleDate(Helper.dateFromYearMonthDate((int)year, (int)(month - 1), (int)day));
            em.persist((Object)door1);
            room1 = new Room();
            room1.setId(12);
            room1.setLength(20);
            room1.setHeight(10);
            room1.setWidth(18);
            em.persist((Object)room1);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.closeEntityManager(em);
            this.clearCache();
        }
        Door door2 = null;
        Room room2 = null;
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            door2 = (Door)em.find(Door.class, (Object)door1.getId());
            room2 = (Room)em.getReference(Room.class, (Object)room1.getId());
            door2.setRoom(room2);
            this.commitTransaction(em);
            EntityManagerJUnitTestSuite.assertFalse((String)"Room is LOADED", (boolean)room2.isHeightSetGreaterThanZero());
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            try {
                if (door1 != null) {
                    this.beginTransaction(em);
                    door1 = (Door)em.find(Door.class, (Object)door1.getId());
                    em.remove((Object)door1);
                    this.commitTransaction(em);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    public void testSequenceObjectWithSchemaName() {
        if (!EntityManagerJUnitTestSuite.getServerSession().getPlatform().supportsSequenceObjects() || EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        if (EntityManagerJUnitTestSuite.getServerSession().getPlatform().isDerby() || EntityManagerJUnitTestSuite.getServerSession().getPlatform().isDB2() || EntityManagerJUnitTestSuite.getServerSession().getPlatform().isPostgreSQL()) {
            return;
        }
        this.closeEntityManagerFactory();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(TableQualifierSessionCustomizer.database_properties);
        properties.put("eclipselink.session.customizer", TableQualifierSessionCustomizer.class.getName());
        EntityManager em = this.createEntityManager(properties);
        this.beginTransaction(em);
        Address address = new Address();
        try {
            em.persist((Object)address);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.createNativeQuery("DELETE FROM CMP3_ADDRESS WHERE ADDRESS_ID = " + address.getID()).executeUpdate();
            this.commitTransaction(em);
        }
        catch (RuntimeException exception) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw exception;
        }
        finally {
            this.closeEntityManager(em);
            this.closeEntityManagerFactory();
        }
    }

    public void testSharedExpressionInQueries() {
        int i;
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        EntityManagerJUnitTestSuite.getServerSession().getProject().getJPQLParseCache().getCache().clear();
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e");
        query.getResultList();
        em.close();
        Runnable[] runnables = new Runnable[]{new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.manager");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.address");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.manager");
                query.setHint("eclipselink.join-fetch", (Object)"e.address");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.manager");
                query.setHint("eclipselink.join-fetch", (Object)"e.address");
                query.setHint("eclipselink.join-fetch", (Object)"e.projects.teamLeader");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.address");
                query.setHint("eclipselink.join-fetch", (Object)"e.manager");
                query.setHint("eclipselink.join-fetch", (Object)"e.projects.teamMembers");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.managedEmployees");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.responsibilities");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.phoneNumbers");
                query.getResultList();
                em.close();
            }
        }, new Runnable(){

            @Override
            public void run() {
                EntityManager em = EntityManagerJUnitTestSuite.this.createEntityManager();
                Query query = em.createQuery("SELECT e FROM Employee e");
                query.setHint("eclipselink.join-fetch", (Object)"e.dealers");
                query.getResultList();
                em.close();
            }
        }};
        Thread[] threads = new Thread[runnables.length];
        Exception[] exceptions = new Exception[runnables.length];
        for (i = 0; i < runnables.length; ++i) {
            threads[i] = new Thread(runnables[i], Integer.toString(i));
        }
        for (i = 0; i < runnables.length; ++i) {
            threads[i].start();
        }
        boolean exceptionInThread = false;
        for (int i2 = 0; i2 < runnables.length; ++i2) {
            try {
                threads[i2].join();
                continue;
            }
            catch (Exception ex) {
                exceptionInThread = true;
                exceptions[i2] = ex;
            }
        }
        if (exceptionInThread) {
            String errorMsg = "";
            for (int i3 = 0; i3 < exceptions.length; ++i3) {
                if (exceptions[i3] == null) continue;
                errorMsg = errorMsg + i3 + ": " + exceptions[i3] + "\n";
            }
            EntityManagerJUnitTestSuite.fail((String)errorMsg);
        }
    }

    protected static String getCurrentSchemaName(Session session) {
        Map<String, String> properties = TableQualifierSessionCustomizer.database_properties;
        String driver = properties.get("javax.persistence.jdbc.driver");
        String url = properties.get("javax.persistence.jdbc.url");
        String user = properties.get("javax.persistence.jdbc.user");
        String pw = properties.get("javax.persistence.jdbc.password");
        TestDataSource dataSource = new TestDataSource(driver, url, new Properties());
        Connection conn = null;
        try {
            String schema;
            conn = dataSource.getConnection(user, pw);
            PreparedStatement stmt = conn.prepareStatement("SELECT ADDRESS_ID FROM CMP3_ADDRESS WHERE ADDRESS_ID = 1");
            ResultSet rs = stmt.executeQuery();
            String string = schema = rs.getMetaData().getSchemaName(1);
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInheritanceFetchJoinSecondCall() {
        EntityManager em = this.createEntityManager();
        LargeProject project = new LargeProject();
        project.setName("InheritanceFetchJoinSecondCall");
        this.beginTransaction(em);
        try {
            em.persist((Object)project);
            em.flush();
            TypedQuery queryFetchOne = em.createQuery("SELECT p FROM LargeProject p JOIN FETCH p.teamLeader", LargeProject.class);
            TypedQuery queryFetchMany = em.createQuery("SELECT p FROM LargeProject p JOIN FETCH p.teamMembers", LargeProject.class);
            em.clear();
            queryFetchOne.getResultList();
            em.clear();
            queryFetchOne.getResultList();
            em.clear();
            queryFetchMany.getResultList();
            em.clear();
            queryFetchMany.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testReplaceElementCollection() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Golfer golfer = new Golfer();
        GolferPK pk = new GolferPK(102);
        WorldRank rank = new WorldRank();
        rank.setId(102);
        golfer.setWorldRank(rank);
        golfer.getSponsorDollars().put("Oracle", 10000);
        golfer.setGolferPK(pk);
        em.persist((Object)golfer);
        em.persist((Object)rank);
        em.flush();
        golfer = (Golfer)em.find(Golfer.class, (Object)golfer.getGolferPK());
        golfer.getSponsorDollars().put("Callaway", 20000);
        em.flush();
        this.clearCache();
        em.clear();
        golfer = (Golfer)em.find(Golfer.class, (Object)golfer.getGolferPK());
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Number of sponsors", (golfer.getSponsorDollars().size() == 2 ? 1 : 0) != 0);
        EntityManagerJUnitTestSuite.assertTrue((String)"Missing Sponsor: Callaway", (boolean)((Integer)golfer.getSponsorDollars().get("Callaway")).equals(20000));
        EntityManagerJUnitTestSuite.assertTrue((String)"Missing Sponsor: Oracle", (boolean)((Integer)golfer.getSponsorDollars().get("Oracle")).equals(10000));
        golfer = (Golfer)em.find(Golfer.class, (Object)golfer.getGolferPK());
        golfer.setSponsorDollars(new HashMap());
        em.flush();
        this.clearCache();
        em.clear();
        golfer = (Golfer)em.find(Golfer.class, (Object)golfer.getGolferPK());
        EntityManagerJUnitTestSuite.assertTrue((String)"Incorrect Number of sponsors", (golfer.getSponsorDollars().size() == 0 ? 1 : 0) != 0);
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateDetachedEntityWithRelationshipCascadeRefresh() {
        EntityManager em;
        Canoe canoeTD = null;
        Lake lakeTD = null;
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            canoeTD = new Canoe();
            canoeTD.setColor("Red");
            lakeTD = new Lake();
            lakeTD.setName("Bob's Lake");
            canoeTD.setLake(lakeTD);
            em.persist((Object)canoeTD);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            Query query1 = em.createQuery("select c from Canoe c where c.id = :id");
            query1.setHint("eclipselink.refresh", (Object)"True");
            query1.setParameter("id", (Object)canoeTD.getId());
            Canoe canoe = (Canoe)query1.getSingleResult();
            EntityManagerJUnitTestSuite.assertNotNull((String)("Entity queried (Canoe) with id " + canoeTD.getId() + " should not be null"), (Object)canoe);
            Lake lake = canoe.getLake();
            EntityManagerJUnitTestSuite.assertNotNull((String)("Canoe->Lake for Canoe id " + canoeTD.getId() + " should be non-null"), (Object)lake);
            this.closeEntityManager(em);
            String newName = "Doug's Lake";
            lake.setName(newName);
            em = this.createEntityManager();
            this.beginTransaction(em);
            Canoe mergedCanoe = (Canoe)em.merge((Object)canoe);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            EntityManagerJUnitTestSuite.assertEquals((String)"Canoe->Lake.name should be changed", (String)newName, (String)mergedCanoe.getLake().getName());
        }
        finally {
            if (canoeTD != null) {
                em = this.createEntityManager();
                Canoe canoe = (Canoe)em.find(Canoe.class, (Object)canoeTD.getId());
                if (canoe != null) {
                    this.beginTransaction(em);
                    canoe = (Canoe)em.merge((Object)canoe);
                    em.remove((Object)canoe);
                    em.remove((Object)canoe.getLake());
                    this.commitTransaction(em);
                }
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopy() {
        EntityManager em = null;
        ConcreteJob job = new ConcreteJob();
        CopyGroup eventsCG = new CopyGroup();
        eventsCG.addAttribute("id");
        eventsCG.addAttribute("datef");
        CopyGroup jobCG = new CopyGroup();
        jobCG.addAttribute("id");
        eventsCG.addAttribute("job", jobCG);
        jobCG.addAttribute("events", eventsCG);
        try {
            em = this.createEntityManager();
            this.beginTransaction(em);
            em.persist((Object)job);
            em.flush();
            job = (Job)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)job, (AttributeGroup)jobCG);
            this.commitTransaction(em);
            for (int i = 0; i < 10; ++i) {
                this.beginTransaction(em);
                job = (Job)em.merge((Object)job);
                em.flush();
                Event e = new Event();
                e.setJob((Job)job);
                job.getEvents().add(e);
                em.flush();
                CopyGroup eventsCG2 = new CopyGroup();
                eventsCG2.addAttribute("id");
                eventsCG2.addAttribute("datef");
                CopyGroup jobCG2 = new CopyGroup();
                jobCG2.addAttribute("id");
                eventsCG2.addAttribute("job", jobCG2);
                jobCG2.addAttribute("events", eventsCG2);
                job = (Job)((JpaEntityManager)em.unwrap(JpaEntityManager.class)).copy((Object)job, (AttributeGroup)jobCG2);
                this.commitTransaction(em);
            }
        }
        finally {
            if (em != null) {
                this.closeEntityManagerAndTransaction(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testServerDetectionLogging() {
        if (EntityManagerJUnitTestSuite.isOnServer()) {
            return;
        }
        this.closeEntityManagerFactory();
        SessionLog original = AbstractSessionLog.getLog();
        try {
            AbstractSessionLog.setLog((SessionLog)new LogWrapper());
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.putAll(JUnitTestCaseHelper.getDatabaseProperties());
            properties.put("eclipselink.logging.level", original.getLevelString());
            properties.put("eclipselink.logging.logger", LogWrapper.class.getName());
            EntityManagerFactoryImpl emf = (EntityManagerFactoryImpl)Persistence.createEntityManagerFactory((String)this.getPersistenceUnitName(), properties);
            emf.refreshMetadata(properties);
            SimpleSessionLogWrapper wr = (SimpleSessionLogWrapper)emf.getServerSession().getSessionLog();
            EntityManagerJUnitTestSuite.assertEquals((String)"configured_server_platform should be printed at FINE level", (wr.getLevel() <= 3 ? 1 : 0) != 0, (boolean)wr.expected());
            LogWrapper lw = new LogWrapper("detect_server_platform");
            AbstractSessionLog.setLog((SessionLog)lw);
            AbstractSessionLog.getLog().setSession(null);
            lw.setSession(null);
            ServerPlatformUtils.detectServerPlatform(null);
            EntityManagerJUnitTestSuite.assertEquals((String)"detect_server_platform should be printed at FINER level", (lw.getLevel() <= 2 ? 1 : 0) != 0, (boolean)lw.expected());
            lw = new LogWrapper("detect_server_platform");
            AbstractSessionLog.setLog((SessionLog)lw);
            Session ss = wr.getSession();
            AbstractSessionLog.getLog().setSession(ss);
            AbstractSessionLog.getLog().getSession().setSessionLog((SessionLog)lw);
            lw.setSession(ss);
            ServerPlatformUtils.detectServerPlatform((AbstractSession)((ServerSession)ss));
            EntityManagerJUnitTestSuite.assertEquals((String)"detect_server_platform should be printed at FINER level", (lw.getLevel() <= 2 ? 1 : 0) != 0, (boolean)lw.expected());
        }
        finally {
            AbstractSessionLog.setLog((SessionLog)original);
            this.closeEntityManagerFactory();
        }
    }

    public static final class Platform
    extends ServerPlatformBase {
        public Platform(DatabaseSession newDatabaseSession) {
            super(newDatabaseSession);
        }

        public Class getExternalTransactionControllerClass() {
            return null;
        }
    }

    public static class TableQualifierSessionCustomizer
    implements SessionCustomizer {
        public static Map<String, String> database_properties = JUnitTestCaseHelper.getDatabaseProperties();

        public void customize(Session session) throws Exception {
            String schema = EntityManagerJUnitTestSuite.getCurrentSchemaName(session);
            session.getPlatform().setTableQualifier(schema);
        }
    }

    public static class ChangeRecordKeepOldValueListener
    extends SessionEventAdapter {
        public org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet uowChangeSet;

        public void postCalculateUnitOfWorkChangeSet(SessionEvent event) {
            this.uowChangeSet = (org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet)event.getProperty("UnitOfWorkChangeSet");
        }
    }

    public static class SessionNameCustomizer
    implements SessionCustomizer {
        static ServerSession ss;

        public void customize(Session session) throws Exception {
            ss = (ServerSession)session;
        }
    }

    static class AcquireRepair_ReleaseBreak_Listener
    extends SessionEventAdapter {
        HashSet<Accessor> acquiredConnections = new HashSet();

        AcquireRepair_ReleaseBreak_Listener() {
        }

        public void postAcquireConnection(SessionEvent event) {
            Accessor accessor = (Accessor)event.getResult();
            if (this.acquiredConnections.contains(accessor)) {
                ((AbstractSession)event.getSession()).log(1, "connection", "AcquireRepair_ReleaseBreak_Listener.postAcquireConnection: risen two or more times in a row;", (Object[])null, accessor, false);
                throw new RuntimeException("AcquireRepair_ReleaseBreak_Listener.postAcquireConnection: risen two or more times in a row");
            }
            this.acquiredConnections.add(accessor);
            ((AbstractSession)event.getSession()).log(1, "connection", "AcquireRepair_ReleaseBreak_Listener.postAcquireConnection: repairConnection;", (Object[])null, accessor, false);
            ((ConnectionWrapper)accessor.getConnection()).repairConnection();
        }

        public void preReleaseConnection(SessionEvent event) {
            Accessor accessor = (Accessor)event.getResult();
            if (!this.acquiredConnections.contains(accessor)) {
                ((AbstractSession)event.getSession()).log(1, "connection", "AcquireRepair_ReleaseBreak_Listener.preReleaseConnection: postAcquireConnection has not been risen;", (Object[])null, accessor, false);
                throw new RuntimeException("AcquireRepair_ReleaseBreak_Listener.preReleaseConnection: postAcquireConnection has not been risen");
            }
            this.acquiredConnections.remove(accessor);
            ((AbstractSession)event.getSession()).log(1, "connection", "AcquireRepair_ReleaseBreak_Listener.preReleaseConnection: breakConnection;", (Object[])null, accessor, false);
            ((ConnectionWrapper)accessor.getConnection()).breakConnection();
        }

        public boolean hasAcquiredConnections() {
            return !this.acquiredConnections.isEmpty();
        }
    }

    static class AcquireReleaseListener
    extends SessionEventAdapter {
        HashSet<Accessor> acquiredReadConnections = new HashSet();
        HashSet<Accessor> acquiredWriteConnections = new HashSet();

        AcquireReleaseListener() {
        }

        public void postAcquireConnection(SessionEvent event) {
            Accessor accessor = (Accessor)event.getResult();
            Session session = event.getSession();
            if (session.isServerSession()) {
                this.acquiredReadConnections.add(accessor);
                ((ServerSession)session).log(1, "connection", "AcquireReleaseListener.acquireReadConnection: " + this.nAcquredReadConnections(), (Object[])null, accessor, false);
            } else {
                this.acquiredWriteConnections.add(accessor);
                ((ClientSession)session).log(1, "connection", "AcquireReleaseListener.acquireWriteConnection: " + this.nAcquredWriteConnections(), (Object[])null, accessor, false);
            }
        }

        public void preReleaseConnection(SessionEvent event) {
            Accessor accessor = (Accessor)event.getResult();
            Session session = event.getSession();
            if (session.isServerSession()) {
                this.acquiredReadConnections.remove(accessor);
                ((ServerSession)session).log(1, "connection", "AcquireReleaseListener.releaseReadConnection: " + this.nAcquredReadConnections(), (Object[])null, accessor, false);
            } else {
                this.acquiredWriteConnections.remove(accessor);
                ((ClientSession)session).log(1, "connection", "AcquireReleaseListener.releaseWriteConnection: " + this.nAcquredWriteConnections(), (Object[])null, accessor, false);
            }
        }

        int nAcquredReadConnections() {
            return this.acquiredReadConnections.size();
        }

        int nAcquredWriteConnections() {
            return this.acquiredWriteConnections.size();
        }

        void clear() {
            this.acquiredReadConnections.clear();
            this.acquiredWriteConnections.clear();
        }
    }

    static class DummyExternalTransactionController
    extends AbstractTransactionController {
        DummyExternalTransactionController() {
        }

        public boolean isRolledBack_impl(Object status) {
            return false;
        }

        protected void registerSynchronization_impl(AbstractSynchronizationListener listener, Object txn) throws Exception {
        }

        protected Object getTransaction_impl() throws Exception {
            return null;
        }

        protected Object getTransactionKey_impl(Object transaction) throws Exception {
            return null;
        }

        protected Object getTransactionStatus_impl() throws Exception {
            return null;
        }

        protected void beginTransaction_impl() throws Exception {
        }

        protected void commitTransaction_impl() throws Exception {
        }

        protected void rollbackTransaction_impl() throws Exception {
        }

        protected void markTransactionForRollback_impl() throws Exception {
        }

        protected boolean canBeginTransaction_impl(Object status) {
            return false;
        }

        protected boolean canCommitTransaction_impl(Object status) {
            return false;
        }

        protected boolean canRollbackTransaction_impl(Object status) {
            return false;
        }

        protected boolean canIssueSQLToDatabase_impl(Object status) {
            return false;
        }

        protected boolean canMergeUnitOfWork_impl(Object status) {
            return false;
        }

        protected String statusToString_impl(Object status) {
            return "";
        }
    }

    class TransactionKiller
    extends Thread {
        EntityManager em;
        long timeToWait;
        boolean shouldKillTransaction = true;
        boolean isWaiting;
        boolean hasKilledTransaction;

        TransactionKiller(EntityManager em, long timeToWait) {
            this.em = em;
            this.timeToWait = timeToWait;
        }

        @Override
        public void run() {
            try {
                this.isWaiting = true;
                Thread.sleep(this.timeToWait);
            }
            catch (InterruptedException ex) {
                throw new TestProblemException("TestProblem: TransactionKiller.run: wait failed: " + ex);
            }
            finally {
                this.isWaiting = false;
            }
            if (this.shouldKillTransaction && EntityManagerJUnitTestSuite.this.isTransactionActive(this.em)) {
                this.hasKilledTransaction = true;
                EntityManagerJUnitTestSuite.this.rollbackTransaction(this.em);
            }
        }
    }
}

