/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.remote.rmi.IIOP;

import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.Test;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.remote.rmi.iiop.RMIConnection;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;
import org.eclipse.persistence.testing.tests.remote.TransporterGenerator;
import org.eclipse.persistence.testing.tests.remote.rmi.IIOP.RMIConnectionExceptionsTest;
import org.eclipse.persistence.testing.tests.remote.rmi.IIOP.RMIServerManager;
import org.eclipse.persistence.testing.tests.remote.rmi.IIOP.RMIServerManagerController;

public class RMIIIOPRemoteModel
extends RemoteModel {
    public RMIConnection createConnection() {
        RMIServerManager serverManager = null;
        InitialContext initialNamingContext = null;
        try {
            initialNamingContext = new InitialContext();
        }
        catch (NamingException exception) {
            System.out.println("Naming Exception " + exception.toString());
        }
        try {
            System.setSecurityManager(new RMISecurityManager());
        }
        catch (Exception exception) {
            System.out.println("Security violation " + exception.toString());
        }
        try {
            serverManager = (RMIServerManager)initialNamingContext.lookup("SERVER-MANAGER");
        }
        catch (Exception exception) {
            throw new TestProblemException(exception.toString());
        }
        RMIConnection rmiConnection = null;
        try {
            rmiConnection = new RMIConnection(serverManager.createRemoteSessionController());
        }
        catch (RemoteException exception) {
            System.out.println("Error in invocation " + exception.toString());
        }
        return rmiConnection;
    }

    @Override
    public void setup() {
        RemoteModel.originalSession = this.getSession();
        RMIServerManagerController.start(this.buildServerSession());
        RMIConnection connection = this.createConnection();
        Session remoteSession = connection.createRemoteSession();
        remoteSession.setLog(RemoteModel.originalSession.getLog());
        remoteSession.setLogLevel(RemoteModel.originalSession.getLogLevel());
        this.getExecutor().setSession(remoteSession);
    }

    @Override
    public void addTests() {
        super.addTests();
        this.addTest((Test)RMIIIOPRemoteModel.getExceptionsTestSuite());
    }

    public static TestSuite getExceptionsTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ExceptionsTestSuite");
        suite.setDescription("Verifies whether the right exceptions are thrown");
        suite.addTest((Test)new RMIConnectionExceptionsTest(TransporterGenerator.THROW_REMOTE_EXCEPTION));
        suite.addTest((Test)new RMIConnectionExceptionsTest(TransporterGenerator.SET_EXCEPTION_INTO_TRANSPORTER));
        return suite;
    }
}

