/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning.model;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;
import org.eclipse.persistence.sessions.changesets.ObjectChangeSet;
import org.eclipse.persistence.sessions.changesets.UnitOfWorkChangeSet;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.returning.model.Class1;
import org.eclipse.persistence.testing.tests.returning.model.ReturnObjectControl;

public class ReturningUpdateTestCase
extends TestCase {
    Class1 originalObject;
    Class1 changedObject;
    Class1 workingObject;
    Class1 cloneWorkingObject;
    Class1 objectBeforeChange;
    boolean useUOW;
    ReturnObjectControl control;
    UnitOfWorkChangeSet uowChangeSet;
    Listener listener = new Listener();

    public ReturningUpdateTestCase(Class1 originalObject, Class1 changedObject, boolean useUOW, ReturnObjectControl control) {
        this.originalObject = originalObject;
        this.changedObject = changedObject;
        this.useUOW = useUOW;
        this.setName(this.getName() + " " + originalObject);
        this.setName(this.getName() + " changed=" + changedObject);
        if (useUOW) {
            this.setName(this.getName() + " useUOW");
        }
        this.control = control;
    }

    protected void setup() {
        this.workingObject = (Class1)this.originalObject.clone();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.workingObject);
        uow.commit();
        this.objectBeforeChange = (Class1)this.workingObject.clone();
    }

    protected void test() {
        if (this.useUOW) {
            this.getSession().getEventManager().addListener((SessionEventListener)this.listener);
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.cloneWorkingObject = (Class1)uow.registerObject((Object)this.workingObject);
            this.cloneWorkingObject.updateWith(this.changedObject);
            uow.commit();
        } else {
            this.workingObject.updateWith(this.changedObject);
            this.getAbstractSession().writeObject((Object)this.workingObject);
        }
    }

    protected void verify() {
        Class1 controlObject = (Class1)this.control.getObjectForUpdate(this.getSession(), this.objectBeforeChange, this.changedObject, this.useUOW);
        if (!this.workingObject.isValid()) {
            throw new TestErrorException("Object is invalid");
        }
        if (!controlObject.compareWithoutId(this.workingObject)) {
            throw new TestErrorException("Object is wrong");
        }
        if (this.useUOW) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(Class1.class);
            ObjectChangeSet changeSet = this.uowChangeSet.getObjectChangeSetForClone((Object)this.cloneWorkingObject);
            for (ChangeRecord changeRecord : changeSet.getChanges()) {
                String attributeName = changeRecord.getAttribute();
                DatabaseMapping mapping = descriptor.getMappingForAttributeName(attributeName);
                Object beforeChangeValue = mapping.getAttributeValueFromObject((Object)this.objectBeforeChange);
                Object changeRecordOldValue = changeRecord.getOldValue();
                if (beforeChangeValue == null) {
                    if (changeRecordOldValue == null) continue;
                    throw new TestErrorException(attributeName + ": before change value was null, not " + changeRecordOldValue);
                }
                if (beforeChangeValue.getClass().isArray()) {
                    if (Helper.compareArrays((Object[])((Object[])beforeChangeValue), (Object[])((Object[])changeRecordOldValue))) continue;
                    throw new TestErrorException(attributeName + ": arrays are not equal");
                }
                if (beforeChangeValue.equals(changeRecordOldValue)) continue;
                throw new TestErrorException(attributeName + ": before change value was " + beforeChangeValue + ", not " + changeRecordOldValue);
            }
        }
    }

    public void reset() {
        if (this.useUOW) {
            this.getSession().getEventManager().removeListener((SessionEventListener)this.listener);
        }
    }

    class Listener
    extends SessionEventAdapter {
        Listener() {
        }

        public void postCalculateUnitOfWorkChangeSet(SessionEvent event) {
            ReturningUpdateTestCase.this.uowChangeSet = (UnitOfWorkChangeSet)event.getProperty("UnitOfWorkChangeSet");
        }
    }
}

