/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.schema;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.opti.SchemaDOM;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ExplicitSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWAttributeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroup;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWXmlSchema;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.ModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.HashBag;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWNamespace
extends MWModel {
    public static final Comparator COMPARATOR = new NamespaceComparator();
    private String namespaceUrl;
    public static final String NAMESPACE_URL_PROPERTY = "namespaceUrl";
    private String namespacePrefix;
    public static final String NAMESPACE_PREFIX_PROPERTY = "namespacePrefix";
    private boolean namespacePrefixIsUserDefined;
    public static final String NAME_XML_NAMESPACE_URL = "http://www.w3.org/XML/1998/namespace";
    private boolean declared;
    public static final String DECLARED_PROPERTY = "declared";
    private Map attributeDeclarations;
    private Map elementDeclarations;
    private Map typeDefinitions;
    private Map modelGroupDefinitions;

    static MWNamespace xsdNamespace(MWXmlSchema schema) {
        MWNamespace xsdNamespace = new MWNamespace(schema);
        xsdNamespace.namespaceUrl = "http://www.w3.org/2001/XMLSchema";
        xsdNamespace.namespacePrefix = "xsd";
        xsdNamespace.addBuiltInComplexType("anyType");
        xsdNamespace.addBuiltInSimpleType("anySimpleType");
        xsdNamespace.addBuiltInSimpleType("duration");
        xsdNamespace.addBuiltInSimpleType("date");
        xsdNamespace.addBuiltInSimpleType("time");
        xsdNamespace.addBuiltInSimpleType("dateTime");
        xsdNamespace.addBuiltInSimpleType("gDay");
        xsdNamespace.addBuiltInSimpleType("gMonth");
        xsdNamespace.addBuiltInSimpleType("gYear");
        xsdNamespace.addBuiltInSimpleType("gMonthDay");
        xsdNamespace.addBuiltInSimpleType("gYearMonth");
        xsdNamespace.addBuiltInSimpleType("string");
        xsdNamespace.addBuiltInSimpleType("normalizedString");
        xsdNamespace.addBuiltInSimpleType("token");
        xsdNamespace.addBuiltInSimpleType("language");
        xsdNamespace.addBuiltInSimpleType("Name");
        xsdNamespace.addBuiltInSimpleType("NMTOKEN");
        xsdNamespace.addBuiltInSimpleType("NMTOKENS");
        xsdNamespace.addBuiltInSimpleType("NCName");
        xsdNamespace.addBuiltInSimpleType("ID");
        xsdNamespace.addBuiltInSimpleType("IDREF");
        xsdNamespace.addBuiltInSimpleType("IDREFS");
        xsdNamespace.addBuiltInSimpleType("ENTITY");
        xsdNamespace.addBuiltInSimpleType("ENTITIES");
        xsdNamespace.addBuiltInSimpleType("boolean");
        xsdNamespace.addBuiltInSimpleType("base64Binary");
        xsdNamespace.addBuiltInSimpleType("hexBinary");
        xsdNamespace.addBuiltInSimpleType("float");
        xsdNamespace.addBuiltInSimpleType("double");
        xsdNamespace.addBuiltInSimpleType("decimal");
        xsdNamespace.addBuiltInSimpleType("integer");
        xsdNamespace.addBuiltInSimpleType("nonPositiveInteger");
        xsdNamespace.addBuiltInSimpleType("long");
        xsdNamespace.addBuiltInSimpleType("nonNegativeInteger");
        xsdNamespace.addBuiltInSimpleType("negativeInteger");
        xsdNamespace.addBuiltInSimpleType("int");
        xsdNamespace.addBuiltInSimpleType("short");
        xsdNamespace.addBuiltInSimpleType("byte");
        xsdNamespace.addBuiltInSimpleType("positiveInteger");
        xsdNamespace.addBuiltInSimpleType("unsignedLong");
        xsdNamespace.addBuiltInSimpleType("unsignedInt");
        xsdNamespace.addBuiltInSimpleType("unsignedShort");
        xsdNamespace.addBuiltInSimpleType("unsignedByte");
        xsdNamespace.addBuiltInSimpleType("anyURI");
        xsdNamespace.addBuiltInSimpleType("QName");
        xsdNamespace.addBuiltInSimpleType("NOTATION");
        return xsdNamespace;
    }

    static MWNamespace xsiNamespace(MWXmlSchema schema) {
        MWNamespace xsiNamespace = new MWNamespace(schema);
        xsiNamespace.namespaceUrl = "http://www.w3.org/2001/XMLSchema-instance";
        xsiNamespace.namespacePrefix = "xsi";
        xsiNamespace.addAttribute("nil");
        xsiNamespace.addAttribute("type");
        xsiNamespace.addAttribute("schemaLocation");
        xsiNamespace.addAttribute("noNamespaceSchemaLocation");
        return xsiNamespace;
    }

    protected MWNamespace() {
    }

    MWNamespace(MWXmlSchema parent) {
        super(parent);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWNamespace.class);
        descriptor.setDefaultRootElement("namespace");
        XMLDirectMapping namespacePrefixMapping = new XMLDirectMapping();
        namespacePrefixMapping.setNullValue((Object)"");
        namespacePrefixMapping.setAttributeName(NAMESPACE_PREFIX_PROPERTY);
        namespacePrefixMapping.setXPath("namespace-prefix/text()");
        descriptor.addMapping((DatabaseMapping)namespacePrefixMapping);
        descriptor.addDirectMapping("namespacePrefixIsUserDefined", "namespace-prefix-is-user-defined/text()");
        XMLDirectMapping namespaceUrlMapping = new XMLDirectMapping();
        namespaceUrlMapping.setNullValue((Object)"");
        namespaceUrlMapping.setAttributeName(NAMESPACE_URL_PROPERTY);
        namespaceUrlMapping.setXPath("namespace-url/text()");
        descriptor.addMapping((DatabaseMapping)namespaceUrlMapping);
        descriptor.addDirectMapping(DECLARED_PROPERTY, "getDeclaredForTopLink", "setDeclaredForTopLink", "declared/text()");
        XMLCompositeCollectionMapping attributeDeclarationsMapping = new XMLCompositeCollectionMapping();
        attributeDeclarationsMapping.setAttributeName("attributeDeclarations");
        attributeDeclarationsMapping.setGetMethodName("getAttributeDeclarationsForToplink");
        attributeDeclarationsMapping.setSetMethodName("setAttributeDeclarationsForToplink");
        attributeDeclarationsMapping.setXPath("attribute-declarations/attribute-declaration");
        attributeDeclarationsMapping.setReferenceClass(ExplicitAttributeDeclaration.class);
        attributeDeclarationsMapping.useMapClass(TreeMap.class, "getName");
        descriptor.addMapping((DatabaseMapping)attributeDeclarationsMapping);
        XMLCompositeCollectionMapping elementDeclarationsMapping = new XMLCompositeCollectionMapping();
        elementDeclarationsMapping.setAttributeName("elementDeclarations");
        elementDeclarationsMapping.setGetMethodName("getElementDeclarationsForToplink");
        elementDeclarationsMapping.setSetMethodName("setElementDeclarationsForToplink");
        elementDeclarationsMapping.setXPath("element-declarations/element-declaration");
        elementDeclarationsMapping.setReferenceClass(ExplicitElementDeclaration.class);
        elementDeclarationsMapping.useMapClass(TreeMap.class, "getName");
        descriptor.addMapping((DatabaseMapping)elementDeclarationsMapping);
        XMLCompositeCollectionMapping typeDefinitionsMapping = new XMLCompositeCollectionMapping();
        typeDefinitionsMapping.setAttributeName("typeDefinitions");
        typeDefinitionsMapping.setGetMethodName("getTypeDefinitionsForToplink");
        typeDefinitionsMapping.setSetMethodName("setTypeDefinitionsForToplink");
        typeDefinitionsMapping.setXPath("type-definitions/type-definition");
        typeDefinitionsMapping.setReferenceClass(ExplicitSchemaTypeDefinition.class);
        typeDefinitionsMapping.useMapClass(TreeMap.class, "getName");
        descriptor.addMapping((DatabaseMapping)typeDefinitionsMapping);
        XMLCompositeCollectionMapping modelGroupDefinitionsMapping = new XMLCompositeCollectionMapping();
        modelGroupDefinitionsMapping.setAttributeName("modelGroupDefinitions");
        modelGroupDefinitionsMapping.setGetMethodName("getModelGroupDefinitionsForToplink");
        modelGroupDefinitionsMapping.setSetMethodName("setModelGroupDefinitionsForToplink");
        modelGroupDefinitionsMapping.setXPath("model-group-definitions/model-group-definition");
        modelGroupDefinitionsMapping.setReferenceClass(ModelGroupDefinition.class);
        modelGroupDefinitionsMapping.useMapClass(TreeMap.class, "getName");
        descriptor.addMapping((DatabaseMapping)modelGroupDefinitionsMapping);
        return descriptor;
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.namespacePrefix = "";
        this.namespaceUrl = "";
        this.attributeDeclarations = new Hashtable();
        this.elementDeclarations = new Hashtable();
        this.typeDefinitions = new Hashtable();
        this.modelGroupDefinitions = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Map map = this.attributeDeclarations;
        synchronized (map) {
            children.addAll(this.attributeDeclarations.values());
        }
        map = this.elementDeclarations;
        synchronized (map) {
            children.addAll(this.elementDeclarations.values());
        }
        map = this.typeDefinitions;
        synchronized (map) {
            children.addAll(this.typeDefinitions.values());
        }
        map = this.modelGroupDefinitions;
        synchronized (map) {
            children.addAll(this.modelGroupDefinitions.values());
        }
    }

    public String getNamespaceUrl() {
        return this.namespaceUrl;
    }

    public String getNamespaceUrlForDisplay() {
        String namespace = this.getNamespaceUrl();
        if (namespace == null || namespace.equals("")) {
            return "(absent)";
        }
        return namespace;
    }

    private void setNamespaceUrl(String newNamespaceUrl) {
        String oldNamespaceUrl = this.namespaceUrl;
        this.namespaceUrl = newNamespaceUrl;
        this.firePropertyChanged(NAMESPACE_URL_PROPERTY, oldNamespaceUrl, newNamespaceUrl);
        if (NAME_XML_NAMESPACE_URL.equals(newNamespaceUrl)) {
            this.setNamespacePrefix("xml");
            this.namespacePrefixIsUserDefined = false;
        }
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public void setNamespacePrefixFromUser(String newNamespacePrefix) {
        this.setNamespacePrefix(newNamespacePrefix);
        this.setNamespacePrefixIsUserDefined(true);
    }

    public void setNamespacePrefixFromSchemaDoc(String newNamespacePrefix) {
        if (this.namespacePrefixIsUserDefined()) {
            return;
        }
        this.setNamespacePrefix(newNamespacePrefix);
        if (!this.isBuiltInNamespace()) {
            this.setDeclared(true);
        }
    }

    private void setNamespacePrefix(String newNamespacePrefix) {
        if (newNamespacePrefix == null) {
            newNamespacePrefix = "";
        }
        String oldNamespacePrefix = this.namespacePrefix;
        this.namespacePrefix = newNamespacePrefix;
        this.firePropertyChanged(NAMESPACE_PREFIX_PROPERTY, oldNamespacePrefix, newNamespacePrefix);
        ((MWXmlProject)this.getProject()).schemaChanged(SchemaChange.namespacePrefixesChanged(this.getSchema()));
    }

    public boolean namespacePrefixIsUserDefined() {
        return this.namespacePrefixIsUserDefined;
    }

    public void setNamespacePrefixIsUserDefined(boolean newValue) {
        this.namespacePrefixIsUserDefined = newValue;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public void setDeclared(boolean newValue) {
        boolean oldValue = this.declared;
        this.declared = newValue;
        this.firePropertyChanged(DECLARED_PROPERTY, oldValue, newValue);
    }

    public Iterator attributes() {
        return this.attributeDeclarations.values().iterator();
    }

    public int attributeCount() {
        return this.attributeDeclarations.size();
    }

    public Iterator elements() {
        return this.elementDeclarations.values().iterator();
    }

    public int elementCount() {
        return this.elementDeclarations.size();
    }

    public Iterator complexTypes() {
        ArrayList<MWSchemaTypeDefinition> complexTypeList = new ArrayList<MWSchemaTypeDefinition>();
        Iterator typesIter = this.types();
        while (typesIter.hasNext()) {
            MWSchemaTypeDefinition typeDefinition = (MWSchemaTypeDefinition)typesIter.next();
            if (!typeDefinition.isComplex()) continue;
            complexTypeList.add(typeDefinition);
        }
        return complexTypeList.iterator();
    }

    public Iterator simpleTypes() {
        ArrayList<MWSchemaTypeDefinition> simpleTypeList = new ArrayList<MWSchemaTypeDefinition>();
        Iterator typesIter = this.types();
        while (typesIter.hasNext()) {
            MWSchemaTypeDefinition typeDefinition = (MWSchemaTypeDefinition)typesIter.next();
            if (typeDefinition.isComplex()) continue;
            simpleTypeList.add(typeDefinition);
        }
        return simpleTypeList.iterator();
    }

    public Iterator types() {
        return this.typeDefinitions.values().iterator();
    }

    public int typeCount() {
        return this.typeDefinitions.size();
    }

    public Iterator modelGroupDefinitions() {
        return this.modelGroupDefinitions.values().iterator();
    }

    public int modelGroupDefinitionsCount() {
        return this.modelGroupDefinitions.size();
    }

    private ExplicitSimpleTypeDefinition addBuiltInSimpleType(String simpleTypeName) {
        ExplicitSimpleTypeDefinition simpleType = new ExplicitSimpleTypeDefinition(this, simpleTypeName, this.namespaceUrl, true);
        this.typeDefinitions.put(simpleTypeName, simpleType);
        return simpleType;
    }

    private ExplicitSimpleTypeDefinition addSimpleType(String simpleTypeName) {
        ExplicitSimpleTypeDefinition simpleType = new ExplicitSimpleTypeDefinition(this, simpleTypeName, this.namespaceUrl);
        this.typeDefinitions.put(simpleTypeName, simpleType);
        return simpleType;
    }

    private ExplicitComplexTypeDefinition addBuiltInComplexType(String complexTypeName) {
        ExplicitComplexTypeDefinition complexType = new ExplicitComplexTypeDefinition(this, complexTypeName, this.namespaceUrl, true);
        this.typeDefinitions.put(complexTypeName, complexType);
        return complexType;
    }

    private ExplicitComplexTypeDefinition addComplexType(String complexTypeName) {
        ExplicitComplexTypeDefinition complexType = new ExplicitComplexTypeDefinition(this, complexTypeName, this.namespaceUrl);
        this.typeDefinitions.put(complexTypeName, complexType);
        return complexType;
    }

    private void removeType(String typeName) {
        ExplicitSchemaTypeDefinition type = (ExplicitSchemaTypeDefinition)this.typeDefinitions.remove(typeName);
        this.getProject().nodeRemoved(type);
    }

    private ExplicitAttributeDeclaration addAttribute(String attributeName) {
        ExplicitAttributeDeclaration attribute = new ExplicitAttributeDeclaration(this, attributeName);
        this.attributeDeclarations.put(attributeName, attribute);
        return attribute;
    }

    private void removeAttribute(ExplicitAttributeDeclaration attribute) {
        this.attributeDeclarations.remove(attribute.getName());
        this.getProject().nodeRemoved(attribute);
    }

    private ExplicitElementDeclaration addElement(String elementName) {
        ExplicitElementDeclaration element = new ExplicitElementDeclaration(this, elementName);
        this.elementDeclarations.put(elementName, element);
        return element;
    }

    private void removeElement(ExplicitElementDeclaration element) {
        this.elementDeclarations.remove(element.getName());
        this.getProject().nodeRemoved(element);
    }

    private ModelGroupDefinition addGroup(String groupName) {
        ModelGroupDefinition group = new ModelGroupDefinition(this, groupName);
        this.modelGroupDefinitions.put(groupName, group);
        return group;
    }

    private void removeGroup(ModelGroupDefinition group) {
        this.modelGroupDefinitions.remove(group.getName());
        this.getProject().nodeRemoved(group);
    }

    public MWAttributeDeclaration attribute(String attributeName) {
        return (ExplicitAttributeDeclaration)this.attributeDeclarations.get(attributeName);
    }

    public MWElementDeclaration element(String elementName) {
        if (elementName != null) {
            return (ExplicitElementDeclaration)this.elementDeclarations.get(elementName);
        }
        return null;
    }

    public MWComplexTypeDefinition complexType(String complexTypeName) {
        return (ExplicitComplexTypeDefinition)this.typeDefinitions.get(complexTypeName);
    }

    public MWSimpleTypeDefinition simpleType(String simpleTypeName) {
        return (ExplicitSimpleTypeDefinition)this.typeDefinitions.get(simpleTypeName);
    }

    ModelGroupDefinition modelGroupDefinition(String modelGroupDefinitionName) {
        return (ModelGroupDefinition)this.modelGroupDefinitions.get(modelGroupDefinitionName);
    }

    public MWModelGroup modelGroup(String modelGroupDefinitionName) {
        return this.modelGroupDefinition(modelGroupDefinitionName).getModelGroup();
    }

    public Iterator structuralComponents() {
        return new CompositeIterator(new Iterator[]{this.elements(), this.modelGroupDefinitions(), this.attributes(), this.types()});
    }

    public int structuralComponentCount() {
        return this.elementCount() + this.modelGroupDefinitionsCount() + this.attributeCount() + this.typeCount();
    }

    public Iterator contextComponents() {
        return new CompositeIterator(new Iterator[]{this.elements(), this.types(), this.modelGroupDefinitions()});
    }

    public boolean isTargetNamespace() {
        return this.getSchema().targetNamespace() == this;
    }

    public boolean isBuiltInNamespace() {
        return CollectionTools.contains(this.getSchema().builtInNamespaces(), (Object)this);
    }

    public MWXmlSchema getSchema() {
        return (MWXmlSchema)this.getParent();
    }

    public void reload(XSModel xmlSchema, SchemaDOM schemaDOM, String namespaceUrl) {
        this.setNamespaceUrl(namespaceUrl);
        this.reloadTypes(xmlSchema.getComponents((short)3));
        this.reloadAttributes(xmlSchema.getComponents((short)1));
        this.reloadElements(xmlSchema.getComponents((short)2));
        this.reloadGroups(xmlSchema.getComponents((short)6));
        if ("".equals(this.namespaceUrl)) {
            this.setNamespacePrefix("");
            this.namespacePrefixIsUserDefined = false;
        }
    }

    private void reloadTypes(XSNamedMap typeDefs) {
        Collection removedTypeNames = CollectionTools.collection(this.typeDefinitions.keySet().iterator());
        for (int i = typeDefs.getLength() - 1; i >= 0; --i) {
            XSTypeDefinition typeDef = (XSTypeDefinition)typeDefs.item(i);
            ExplicitSchemaTypeDefinition type = null;
            String ns = typeDef.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(typeDef.getNamespace()) || !ns.equals(this.getNamespaceUrl())) continue;
            type = typeDef.getTypeCategory() == 16 ? this.reloadSimpleType((XSSimpleTypeDecl)typeDef) : this.reloadComplexType((XSComplexTypeDecl)typeDef);
            removedTypeNames.remove(type.getName());
        }
        Iterator stream = removedTypeNames.iterator();
        while (stream.hasNext()) {
            this.removeType((String)stream.next());
        }
    }

    private ExplicitSimpleTypeDefinition reloadSimpleType(XSSimpleTypeDecl simpleTypeDecl) {
        ExplicitSimpleTypeDefinition simpleType;
        String simpleTypeName = simpleTypeDecl.getName();
        ExplicitSchemaTypeDefinition type = (ExplicitSchemaTypeDefinition)this.typeDefinitions.get(simpleTypeName);
        try {
            simpleType = (ExplicitSimpleTypeDefinition)type;
        }
        catch (ClassCastException cce) {
            simpleType = null;
        }
        if (simpleType == null) {
            simpleType = this.addSimpleType(simpleTypeName);
        }
        simpleType.reload((XSObject)simpleTypeDecl);
        return simpleType;
    }

    private ExplicitComplexTypeDefinition reloadComplexType(XSComplexTypeDecl complexTypeDecl) {
        ExplicitComplexTypeDefinition complexType;
        String complexTypeName = complexTypeDecl.getName();
        ExplicitSchemaTypeDefinition type = (ExplicitSchemaTypeDefinition)this.typeDefinitions.get(complexTypeName);
        try {
            complexType = (ExplicitComplexTypeDefinition)type;
        }
        catch (ClassCastException cce) {
            complexType = null;
        }
        if (complexType == null) {
            complexType = this.addComplexType(complexTypeName);
        }
        complexType.reload((XSObject)complexTypeDecl);
        return complexType;
    }

    private void reloadAttributes(XSNamedMap attributeDeclarations) {
        HashBag removedAttributes = new HashBag(this.attributeDeclarations.values());
        for (int i = attributeDeclarations.getLength() - 1; i >= 0; --i) {
            XSAttributeDecl attrDecl = (XSAttributeDecl)attributeDeclarations.item(i);
            String ns = attrDecl.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if (!ns.equals(this.getNamespaceUrl())) continue;
            ExplicitAttributeDeclaration attribute = this.reloadAttribute(attrDecl);
            removedAttributes.remove(attribute);
        }
        Iterator stream = removedAttributes.iterator();
        while (stream.hasNext()) {
            this.removeAttribute((ExplicitAttributeDeclaration)stream.next());
        }
    }

    private ExplicitAttributeDeclaration reloadAttribute(XSAttributeDecl attributeDecl) {
        String attributeName = attributeDecl.getName();
        ExplicitAttributeDeclaration attribute = (ExplicitAttributeDeclaration)this.attributeDeclarations.get(attributeName);
        if (attribute == null) {
            attribute = this.addAttribute(attributeName);
        }
        attribute.reload((XSObject)attributeDecl);
        return attribute;
    }

    private void reloadElements(XSNamedMap elementDeclarations) {
        HashBag removedElements = new HashBag(this.elementDeclarations.values());
        for (int i = elementDeclarations.getLength() - 1; i >= 0; --i) {
            XSElementDecl elementDecl = (XSElementDecl)elementDeclarations.item(i);
            String ns = elementDecl.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if (!ns.equals(this.getNamespaceUrl())) continue;
            ExplicitElementDeclaration element = this.reloadElement(elementDecl);
            removedElements.remove(element);
        }
        Iterator stream = removedElements.iterator();
        while (stream.hasNext()) {
            this.removeElement((ExplicitElementDeclaration)stream.next());
        }
    }

    private ExplicitElementDeclaration reloadElement(XSElementDecl elementDecl) {
        String elementName = elementDecl.getName();
        ExplicitElementDeclaration element = (ExplicitElementDeclaration)this.elementDeclarations.get(elementName);
        if (element == null) {
            element = this.addElement(elementName);
        }
        element.reload((XSObject)elementDecl);
        return element;
    }

    private void reloadGroups(XSNamedMap modelGroupDefs) {
        HashBag removedGroups = new HashBag(this.modelGroupDefinitions.values());
        for (int i = modelGroupDefs.getLength() - 1; i >= 0; --i) {
            XSModelGroupDefinition modelGroupDef = (XSModelGroupDefinition)modelGroupDefs.item(i);
            String ns = modelGroupDef.getNamespace();
            if (ns == null) {
                ns = "";
            }
            if (!ns.equals(this.getNamespaceUrl())) continue;
            ModelGroupDefinition group = this.reloadGroup(modelGroupDef);
            removedGroups.remove(group);
        }
        Iterator stream = removedGroups.iterator();
        while (stream.hasNext()) {
            this.removeGroup((ModelGroupDefinition)stream.next());
        }
    }

    private ModelGroupDefinition reloadGroup(XSModelGroupDefinition groupDef) {
        String groupName = groupDef.getName();
        ModelGroupDefinition group = (ModelGroupDefinition)this.modelGroupDefinitions.get(groupName);
        if (group == null) {
            group = this.addGroup(groupName);
        }
        group.reload((XSObject)groupDef);
        return group;
    }

    public void resolveReferences() {
        Iterator stream = this.types();
        while (stream.hasNext()) {
            ((ExplicitSchemaTypeDefinition)stream.next()).resolveReferences();
        }
        stream = this.attributes();
        while (stream.hasNext()) {
            ((ExplicitAttributeDeclaration)stream.next()).resolveReferences();
        }
        stream = this.elements();
        while (stream.hasNext()) {
            ((ExplicitElementDeclaration)stream.next()).resolveReferences();
        }
        stream = this.modelGroupDefinitions();
        while (stream.hasNext()) {
            ((ModelGroupDefinition)stream.next()).resolveReferences();
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        String url = this.getNamespaceUrl().equals("") ? "(absent)" : this.getNamespaceUrl();
        sb.append("namespace: " + url);
    }

    @Override
    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        return this.getNamespaceUrl().compareTo(((MWNamespace)o).getNamespaceUrl());
    }

    private Boolean getDeclaredForTopLink() {
        return new Boolean(this.declared);
    }

    private void setDeclaredForTopLink(Boolean newValue) {
        if (newValue == null) {
            newValue = Boolean.TRUE;
        }
        this.declared = newValue;
    }

    private Map getAttributeDeclarationsForToplink() {
        return new TreeMap(this.attributeDeclarations);
    }

    private void setAttributeDeclarationsForToplink(Map map) {
        this.attributeDeclarations = this.mapFromNamedElements(map.values().iterator());
    }

    private Map getElementDeclarationsForToplink() {
        return new TreeMap(this.elementDeclarations);
    }

    private void setElementDeclarationsForToplink(Map map) {
        this.elementDeclarations = this.mapFromNamedElements(map.values().iterator());
    }

    private Map getTypeDefinitionsForToplink() {
        return new TreeMap(this.typeDefinitions);
    }

    private void setTypeDefinitionsForToplink(Map map) {
        this.typeDefinitions = this.mapFromNamedElements(map.values().iterator());
    }

    private Map getModelGroupDefinitionsForToplink() {
        return new TreeMap(this.modelGroupDefinitions);
    }

    private void setModelGroupDefinitionsForToplink(Map map) {
        this.modelGroupDefinitions = this.mapFromNamedElements(map.values().iterator());
    }

    private Map mapFromNamedElements(Iterator iter) {
        Hashtable<String, MWNamedSchemaComponent> elements = new Hashtable<String, MWNamedSchemaComponent>();
        while (iter.hasNext()) {
            MWNamedSchemaComponent next = (MWNamedSchemaComponent)iter.next();
            elements.put(next.getName(), next);
        }
        return elements;
    }

    public void setNamespacePrefixFromSchemaDocForTopLink(String newNamespacePrefix) {
        if (this.namespacePrefixIsUserDefined()) {
            return;
        }
        this.namespacePrefix = newNamespacePrefix;
    }

    public void setNamespaceIsDeclaredFromSchemaDocForTopLink(boolean newIsDeclared) {
        this.declared = newIsDeclared;
    }

    private static class NamespaceComparator
    implements Comparator {
        NamespaceComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return this.compare((MWNamespace)obj1, (MWNamespace)obj2);
        }

        public int compare(MWNamespace ns1, MWNamespace ns2) {
            if ("http://www.w3.org/2001/XMLSchema".equals(ns1.getNamespaceUrl())) {
                return -1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(ns2.getNamespaceUrl())) {
                return 1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(ns1.getNamespaceUrl())) {
                return -1;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(ns2.getNamespaceUrl())) {
                return 1;
            }
            if (ns1.isTargetNamespace()) {
                return -1;
            }
            if (ns2.isTargetNamespace()) {
                return 1;
            }
            return Collator.getInstance().compare(ns1.getNamespaceUrl(), ns2.getNamespaceUrl());
        }
    }
}

