/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.lang.reflect.Constructor;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;

public class ServerPlatform {
    private String platformId;

    public ServerPlatform(String shortClassName) {
        this.initialize(shortClassName);
    }

    private void initialize(String shortClassName) {
        this.platformId = ServerPlatformManager.instance().getIdFor(shortClassName);
    }

    public String getRuntimeClassName() {
        return this.getRuntimePlatformClassNameFor(this.platformId);
    }

    public String getConfigClassName() {
        return ClassTools.shortNameForClassNamed((String)ServerPlatformManager.instance().getRuntimePlatformConfigClassNameForPlatformId(this.platformId));
    }

    public Class getAdapterClass() {
        return SCAdapter.adapterClassNamed(this.getConfigClassName());
    }

    private String getRuntimePlatformClassNameFor(String platformId) {
        return ServerPlatformManager.instance().getRuntimePlatformClassNameForClass(platformId);
    }

    ServerPlatformAdapter buildAdapter(SessionAdapter parent) {
        if (this.platformId.equals("NoServerPlatform")) {
            return NullServerPlatformAdapter.instance();
        }
        Constructor adapterConstructor = SCAdapter.adapterConstructor(this.getAdapterClass());
        ServerPlatformAdapter adapter = (ServerPlatformAdapter)SCAdapter.buildsAdapterWith(adapterConstructor, new Object[]{parent});
        return adapter;
    }
}

