/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.meta;

import java.io.File;
import java.util.prefs.Preferences;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.ClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCClassRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.meta.SCSessionsPropertiesManager;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class SCSessionsProperties
extends AbstractModel {
    private volatile SCClassRepository classRepository;
    private int index;
    volatile SCSessionsPropertiesManager manager;
    private volatile File path;
    private volatile String pathString;
    public static final String CLASSPATH_NODE_TAG = "classpath";
    public static final String CLASSPATH_TAG = "classpath_";
    public static final String LOCATION_TAG = "location_";

    private SCSessionsProperties() {
    }

    SCSessionsProperties(SCSessionsPropertiesManager manager, File path, String[] classpath, int index) {
        this.manager = manager;
        this.initialize(path, classpath, index);
    }

    private SCClassRepository buildClassRepository(String[] classpath) {
        return new SCClassRepository(classpath);
    }

    private int findNextAvailableIndex(Preferences preferences) {
        int index = 0;
        String newLocation = LOCATION_TAG + index;
        try {
            Object[] names = preferences.keys();
            while (CollectionTools.contains((Object[])names, (Object)newLocation)) {
                newLocation = LOCATION_TAG + ++index;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public ClassRepository getClassRepository() {
        return this.classRepository;
    }

    public int getIndex() {
        return this.index;
    }

    public File getPath() {
        return this.path;
    }

    public String getPathString() {
        return this.pathString;
    }

    private void initialize(File path, String[] classpath, int index) {
        if (path == null) {
            throw new NullPointerException("The fully qualified path of the sessions.xml cannot be null");
        }
        this.pathChanged(path);
        this.classRepository = this.buildClassRepository(classpath);
        this.index = index;
    }

    public void pathChanged(File path) {
        this.path = path;
        this.pathString = path.getPath();
        this.pathString = this.pathString.replace('\\', '/');
        this.manager.pathChanged(this);
    }

    public void save(Preferences preferences) {
        preferences = preferences.node(CLASSPATH_NODE_TAG);
        if (this.shouldBeSaved()) {
            if (this.index == -1) {
                this.index = this.findNextAvailableIndex(preferences);
            }
            preferences.put(LOCATION_TAG + this.index, this.pathString);
            preferences.put(CLASSPATH_TAG + this.index, this.classRepository.entries());
        } else {
            preferences.remove(LOCATION_TAG + this.index);
            preferences.remove(CLASSPATH_TAG + this.index);
            this.index = -1;
        }
        this.manager.addSessionsProperties(this);
    }

    public void saveAs(Preferences preferences, File path) {
        this.pathChanged(path);
        this.save(preferences);
    }

    boolean shouldBeSaved() {
        return this.classRepository.shouldBeSaved();
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn((Object)((Object)this), (StringBuffer)sb);
        sb.append(" (");
        this.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    public void toString(StringBuffer buffer) {
        buffer.append("path=");
        buffer.append(this.path);
        buffer.append(", classRepository=");
        buffer.append(this.classRepository);
    }
}

