/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario5_2a
extends ReportQueryTestCase {
    CursoredStream stream;

    public Scenario5_2a() {
        this.setDescription("Cursored Stream using expressions");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Object[] result = new Object[]{emp.getFirstName(), emp.getLastName()};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("firstName");
        this.reportQuery.addAttribute("lastName");
        this.reportQuery.useCursoredStream(1, 1);
    }

    @Override
    public void test() {
        this.stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)this.reportQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void verify() {
        try {
            this.results = new Vector();
            while (!this.stream.atEnd()) {
                this.results.addElement(this.stream.read());
            }
            if (this.results.size() != this.expectedResults.size()) {
                throw new TestErrorException("ReportQuery test failed: The result size are different");
            }
            Vector cloneResults = (Vector)this.expectedResults.clone();
            Enumeration e = this.results.elements();
            while (e.hasMoreElements()) {
                this.removeFromResult((ReportQueryResult)e.nextElement(), cloneResults);
            }
            if (cloneResults.size() != 0) {
                throw new TestErrorException("ReportQuery test failed: The result didn't match");
            }
        }
        finally {
            if (!this.stream.isClosed()) {
                this.stream.close();
            }
        }
    }
}

