/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class UTF8Constant
extends Constant {
    private String value;

    UTF8Constant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.value = this.readStringFrom(stream);
    }

    private String readStringFrom(ClassFileDataInputStream stream) throws IOException {
        short len = stream.readU2();
        StringBuffer sb = new StringBuffer(len);
        for (short count = 0; count < len; count = (short)(count + 1)) {
            short s;
            byte b = stream.readU1();
            if ((b & 0x80) == 0) {
                sb.append((char)b);
                continue;
            }
            if ((b & 0x40) == 0) {
                throw this.badByte(b);
            }
            if ((b & 0x20) == 0) {
                s = (short)((b & 0x1F) << 6);
            } else {
                s = (short)((b & 0xF) << 12);
                b = stream.readU1();
                this.checkContinuation(b);
                count = (short)(count + 1);
                s = (short)(s | (b & 0x3F) << 6);
            }
            b = stream.readU1();
            this.checkContinuation(b);
            count = (short)(count + 1);
            s = (short)(s | b & 0x3F);
            sb.append((char)s);
        }
        return sb.toString();
    }

    private final IOException badByte(byte b) {
        return new IOException("Invalid UTF-8 byte: " + Byte.toString(b));
    }

    private final void checkContinuation(byte b) throws IOException {
        if ((b & 0x80) == 0 || (b & 0x40) != 0) {
            throw this.badByte(b);
        }
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" value: \"");
        writer.print(this.value);
        writer.println("\"");
    }

    @Override
    public String description() {
        return "UTF8";
    }

    public String string() {
        return this.value;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

