/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooser;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ColumnCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TableCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalMappingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.uitools.swing.CachingComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.ExtendedComboBoxModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.IndirectComboBoxModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class TableDescriptorSequencingPanel
extends AbstractPanel {
    private PropertyValueModel relationalDescriptorHolder;
    private PropertyValueModel useSequencingHolder;
    private PropertyValueModel sequenceTableHolder;

    TableDescriptorSequencingPanel(PropertyValueModel relationalDescriptorHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.relationalDescriptorHolder = relationalDescriptorHolder;
        this.useSequencingHolder = this.buildUseSequencingHolder();
        this.sequenceTableHolder = this.buildSequenceTableHolder();
        this.initializeLayout();
    }

    private PropertyValueModel buildUseSequencingHolder() {
        return new PropertyAspectAdapter(this.relationalDescriptorHolder, "usesSequencing"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).usesSequencing();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWTableDescriptor)this.subject).setUsesSequencing(((Boolean)value).booleanValue());
            }
        };
    }

    private PropertyValueModel buildSequenceTableHolder() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.relationalDescriptorHolder, "sequenceNumberTable"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getSequenceNumberTable();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWTableDescriptor)this.subject).setSequenceNumberTable((MWTable)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyValueModel, "qualifiedName");
    }

    private void initializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        GroupBox groupBox = new GroupBox(this.buildUseSequencingCheckBox(), (JComponent)this.buildSequencingPanel());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)groupBox, constraints);
    }

    protected JPanel buildSequencingPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        Vector<JComponent> components = new Vector<JComponent>();
        Pane panel = new Pane(new GridBagLayout());
        JComponent sequenceNameWidgets = this.buildLabeledTextField("name", this.buildSequencingNameTextFieldDocument(this.buildSequencingNameHolder()));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)sequenceNameWidgets, constraints);
        components.add(sequenceNameWidgets);
        JComponent sequenceTableWidgets = this.buildLabeledComponent("table", this.buildSequenceTableListChooser());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)sequenceTableWidgets, constraints);
        components.add(sequenceTableWidgets);
        JComponent sequenceFieldWidgets = this.buildLabeledComponent("field*", this.buildSequenceColumnListChooser());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)sequenceFieldWidgets, constraints);
        components.add(sequenceFieldWidgets);
        new ComponentEnabler((ValueModel)this.useSequencingHolder, components);
        return panel;
    }

    private JCheckBox buildUseSequencingCheckBox() {
        return this.buildCheckBox("useSequencing", new CheckBoxModelAdapter(this.useSequencingHolder));
    }

    private PropertyValueModel buildSequencingNameHolder() {
        return new PropertyAspectAdapter(this.relationalDescriptorHolder, "sequenceNumberName"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getSequenceNumberName();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWTableDescriptor)this.subject).setSequenceNumberName((String)value);
            }
        };
    }

    private Document buildSequencingNameTextFieldDocument(PropertyValueModel sequencingNameHolder) {
        return new DocumentAdapter(sequencingNameHolder);
    }

    private ListChooser buildSequenceTableListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildTableComboBoxModel(), this.getWorkbenchContextHolder(), RelationalProjectComponentFactory.buildTableNodeSelector(this.getWorkbenchContextHolder()), this.buildSequenceTableChooserDialogBuilder());
        listChooser.setRenderer(this.buildTableListRenderer());
        return listChooser;
    }

    private CachingComboBoxModel buildTableComboBoxModel() {
        return new ExtendedComboBoxModel(new IndirectComboBoxModel(this.sequenceTableHolder, this.relationalDescriptorHolder){

            @Override
            protected ListIterator listValueFromSubject(Object subject) {
                return TableDescriptorSequencingPanel.this.orderedTableChoices((MWRelationalDescriptor)subject);
            }
        });
    }

    ListIterator orderedTableChoices(MWRelationalDescriptor descriptor) {
        return CollectionTools.sort((Iterator)descriptor.associatedTables(), (Comparator)this.buildTableComparator()).listIterator();
    }

    private Comparator buildTableComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((MWTable)o1).getName().compareTo(((MWTable)o2).getName());
            }
        };
    }

    private DefaultListChooserDialog.Builder buildSequenceTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableStringConverter());
        return builder;
    }

    private StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWTable)o).getName();
            }
        };
    }

    private ListCellRenderer buildTableListRenderer() {
        return new AdaptableListCellRenderer(new TableCellRendererAdapter(this.resourceRepository()));
    }

    private ListChooser buildSequenceColumnListChooser() {
        DefaultListChooser listChooser = new DefaultListChooser(this.buildExtendedSequenceColumnComboBoxModel(), this.getWorkbenchContextHolder(), RelationalMappingComponentFactory.buildColumnNodeSelector(this.getWorkbenchContextHolder()), this.buildSequenceColumnChooserDialogBuilder());
        listChooser.setRenderer(this.buildColumnListRenderer());
        return listChooser;
    }

    private ComboBoxModel buildExtendedSequenceColumnComboBoxModel() {
        return new ExtendedComboBoxModel(this.buildSequenceColumnComboBoxModel());
    }

    private ComboBoxModel buildSequenceColumnComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildSortedColumnsListHolder(), this.buildSequenceColumnAdapter());
    }

    private ListValueModel buildSortedColumnsListHolder() {
        return new SortedListValueModelAdapter(this.buildUpdatingColumnsListHolder(), this.buildColumnComparator());
    }

    private ListValueModel buildUpdatingColumnsListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildColumnsAdapter(), "name");
    }

    private CollectionValueModel buildColumnsAdapter() {
        return new CollectionAspectAdapter(this.sequenceTableHolder, "columns"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWTable)this.subject).columns();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWTable)this.subject).columnsSize();
            }
        };
    }

    private Comparator buildColumnComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((MWColumn)o1).getName().compareTo(((MWColumn)o2).getName());
            }
        };
    }

    private PropertyValueModel buildSequenceColumnAdapter() {
        PropertyAspectAdapter propertyValueModel = new PropertyAspectAdapter(this.relationalDescriptorHolder, "sequenceNumberColumn"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getSequenceNumberColumn();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWTableDescriptor)this.subject).setSequenceNumberColumn((MWColumn)value);
            }
        };
        return new ValuePropertyPropertyValueModelAdapter(propertyValueModel, "qualifiedName", "databaseType");
    }

    private DefaultListChooserDialog.Builder buildSequenceColumnChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("SEQUENCE_FIELD_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("SEQUENCE_FIELD_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildColumnStringConverter());
        return builder;
    }

    private StringConverter buildColumnStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWColumn)o).getName();
            }
        };
    }

    private ListCellRenderer buildColumnListRenderer() {
        return new AdaptableListCellRenderer(new ColumnCellRendererAdapter(this.resourceRepository(), false));
    }
}

