/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.Project;

public class TransactionIsolationM2MBatchReadTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
    }

    public void test() {
        this.unitOfWork.beginEarlyTransaction();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addBatchReadAttribute("projects");
        Expression workersExp = new ExpressionBuilder().notEmpty("projects");
        query.setSelectionCriteria(workersExp);
        Vector workers = (Vector)this.unitOfWork.executeQuery((DatabaseQuery)query);
        Employee worker = (Employee)workers.elementAt(0);
        Employee otherWorker = (Employee)workers.elementAt(1);
        Vector workerProjects = worker.getProjects();
        Vector otherWorkerProjects = otherWorker.getProjects();
        this.strongAssert(workerProjects != otherWorkerProjects, "Everyone is getting back the same batched result.");
        this.strongAssert(workerProjects != null, "The batched attribute [projects] was null.");
        this.strongAssert(workerProjects.size() > 0, "The batched attribute [projects] was empty.");
        Employee originalWorker = (Employee)this.getSession().readObject((Object)worker);
        this.verifyCloneHasSameProjectsAsOriginal(workerProjects, originalWorker.getProjects());
    }

    private void verifyCloneHasSameProjectsAsOriginal(Vector clones, Vector originals) {
        this.strongAssert(clones.size() == originals.size(), "The clones collections was of a different size than the original. " + clones.size() + " instead of: " + originals.size());
        for (int i = 0; i < clones.size(); ++i) {
            Project clone = (Project)clones.elementAt(i);
            boolean match = false;
            for (int j = 0; j < originals.size(); ++j) {
                Project original = (Project)originals.elementAt(j);
                if (!clone.getId().equals(original.getId())) continue;
                match = true;
                break;
            }
            this.strongAssert(match, "The project's contents are different");
        }
    }
}

