/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryUnitOfWorkUpdateTest
extends CacheExpiryTest {
    protected Employee employee = null;
    protected String employeeName = null;

    public CacheExpiryUnitOfWorkUpdateTest() {
        this.setDescription("Test to ensure UnitOfWork updates work when an object expires between registration and commit.");
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        this.getSession().getIdentityMapAccessor().invalidateObject((Object)this.employee);
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
        this.employeeName = employeeClone.getFirstName();
        employeeClone.setFirstName(this.employee.getFirstName() + "-mutated");
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.employee = (Employee)this.getSession().readObject((Object)this.employee);
        if (!this.employee.getFirstName().equals(this.employeeName + "-mutated")) {
            throw new TestErrorException("UnitOfWork update did not work correctly when expiry occurred between registration and commit.");
        }
    }
}

