/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.localization;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.persistence.internal.localization.i18n.DMSLocalizationResource;
import org.eclipse.persistence.internal.localization.i18n.EclipseLinkLocalizationResource;
import org.eclipse.persistence.internal.localization.i18n.JAXBLocalizationResource;
import org.eclipse.persistence.internal.localization.i18n.LoggingLocalizationResource;
import org.eclipse.persistence.internal.localization.i18n.ToStringLocalizationResource;
import org.eclipse.persistence.testing.framework.ReflectionHelper;
import org.junit.Test;

public class LocalizationResourcesTest
extends TestCase {
    public LocalizationResourcesTest() {
    }

    public LocalizationResourcesTest(String name) {
        super(name);
    }

    private static String buildMessageWithList(String message, List<String> list) {
        int size = 0;
        for (String item : list) {
            size += item.length();
        }
        StringBuilder sb = new StringBuilder(message.length() + list.size() + size + 3);
        boolean notFirst = false;
        sb.append(message);
        sb.append(" [");
        for (String item : list) {
            if (notFirst) {
                sb.append(',');
            } else {
                notFirst = true;
            }
            sb.append(item);
        }
        sb.append(']');
        return sb.toString();
    }

    private static void verifyBundle(Class c) {
        Object[][] bundle;
        LinkedList<String> nonStringKeys = new LinkedList<String>();
        LinkedList<String> duplicateKeys = new LinkedList<String>();
        String bundleName = c.getSimpleName();
        HashSet<String> keys = new HashSet<String>();
        try {
            Object instance = ReflectionHelper.getInstance((Class)c, (Class[])new Class[0], (Object[])new Object[0]);
            bundle = (Object[][])ReflectionHelper.invokeMethod((String)"getContents", (Object)instance, (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException e) {
            LocalizationResourcesTest.fail((String)("Could not access " + bundleName + "#getContents()"));
            bundle = null;
        }
        if (bundle != null) {
            for (Object[] message : bundle) {
                if (message[0] instanceof String) {
                    String key = (String)message[0];
                    if (keys.contains(key)) {
                        StringBuilder sb = new StringBuilder(bundleName.length() + key.length() + 1);
                        sb.append(bundleName);
                        sb.append(':');
                        sb.append(key);
                        duplicateKeys.add(sb.toString());
                        continue;
                    }
                    keys.add(key);
                    continue;
                }
                nonStringKeys.add(bundleName);
            }
        }
        if (nonStringKeys.size() > 0) {
            LocalizationResourcesTest.fail((String)LocalizationResourcesTest.buildMessageWithList("Non String key found in bundle: ", nonStringKeys));
        }
        if (duplicateKeys.size() > 0) {
            LocalizationResourcesTest.fail((String)LocalizationResourcesTest.buildMessageWithList("Duplicate bundle keys found: ", duplicateKeys));
        }
    }

    @Test
    public void testLoggingLocalizationResource() {
        LocalizationResourcesTest.verifyBundle(LoggingLocalizationResource.class);
    }

    @Test
    public void testDMSLocalizationResource() {
        LocalizationResourcesTest.verifyBundle(DMSLocalizationResource.class);
    }

    @Test
    public void testEclipseLinkLocalizationResource() {
        LocalizationResourcesTest.verifyBundle(EclipseLinkLocalizationResource.class);
    }

    @Test
    public void testJAXBLocalizationResource() {
        LocalizationResourcesTest.verifyBundle(JAXBLocalizationResource.class);
    }

    @Test
    public void testToStringLocalizationResource() {
        LocalizationResourcesTest.verifyBundle(ToStringLocalizationResource.class);
    }
}

