/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class LinkedHashMapTest
extends PerformanceComparisonTestCase {
    public static int ITERATIONS = 50000;
    protected Object[] values;

    public LinkedHashMapTest() {
        this.setName("LinkedHashMap vs LinkedList PerformanceComparisonTest");
        this.setDescription("Compares the performance between LinkedHashMap and Hashtable with LinkedList.");
        this.addLinkedListTest();
        this.values = new Object[100];
        for (int size = 0; size < 100; ++size) {
            this.values[size] = new Object();
        }
    }

    public void test() throws Exception {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(10);
        for (int size = 0; size < 100; ++size) {
            map.put(this.values[size], this.values[size]);
        }
    }

    public void addLinkedListTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                LinkedList<Object> list = new LinkedList<Object>();
                for (int size = 0; size < 100; ++size) {
                    list.add(LinkedHashMapTest.this.values[size]);
                    if (list.size() <= 10) continue;
                    list.removeFirst();
                }
            }
        };
        test.setName("LinkedListTest");
        test.setAllowableDecrease(40.0);
        this.addTest((TestCase)test);
    }
}

