/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.reading;

import java.util.List;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.models.performance.toplink.Employee;
import org.eclipse.persistence.testing.tests.performance.PerformanceTest;

public class ReadAllCompletelyJoinedEmployeeTest
extends PerformanceTest {
    public ReadAllCompletelyJoinedEmployeeTest() {
        this.setDescription("This tests the performance of read-all queries with joining.");
    }

    @Override
    public void test() throws Exception {
        super.test();
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.addJoinedAttribute("address");
        query.addJoinedAttribute(query.getExpressionBuilder().getAllowingNull("manager"));
        query.addJoinedAttribute(query.getExpressionBuilder().anyOf("phoneNumbers"));
        query.addJoinedAttribute(query.getExpressionBuilder().anyOfAllowingNone("managedEmployees"));
        query.addJoinedAttribute(query.getExpressionBuilder().anyOfAllowingNone("projects"));
        this.allObjects = (List)this.getSession().executeQuery((DatabaseQuery)query);
        for (Employee employee : this.allObjects) {
            employee.getAddress();
            employee.getManager();
            employee.getManagedEmployees().size();
            employee.getProjects().size();
            employee.getPhoneNumbers().size();
        }
    }
}

