/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ColumnResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.FieldResult;
import org.eclipse.persistence.queries.ResultSetMappingQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Buyer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.SmallProject;

public class SQLResultSetMappingTestSuite
extends JUnitTestCase {
    protected boolean m_reset = false;

    public SQLResultSetMappingTestSuite() {
    }

    public SQLResultSetMappingTestSuite(String name) {
        super(name);
    }

    public void setUp() {
        this.m_reset = true;
        super.setUp();
        SQLResultSetMappingTestSuite.clearCache((String)"fieldaccess");
        if (SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").getPlatform().isPostgreSQL()) {
            SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SQLResultSetMappingTestSuite");
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testSetup"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testInheritanceNoDiscriminatorColumn"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testComplicateResultWithInheritance"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testRefresh"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testBindParameters"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testBindParametersWithPostitional"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testSimpleInheritance"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testPessimisticLocking"));
        suite.addTest((Test)new SQLResultSetMappingTestSuite("testComplicateResults"));
        return suite;
    }

    public String getPersistenceUnitName() {
        return "fieldaccess";
    }

    public void testSetup() {
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)"fieldaccess"));
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess"));
        SQLResultSetMappingTestSuite.clearCache((String)"fieldaccess");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInheritanceNoDiscriminatorColumn() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("testInheritanceNoDiscriminatorColumn");
        EntityResult entityResult = new EntityResult(Buyer.class);
        resultSetMapping.addResult((SQLResult)entityResult);
        entityResult.setDiscriminatorColumn("DTYPE_DESCRIM");
        SQLCall call = new SQLCall("SELECT t0.BUYER_ID, t0.DTYPE AS DTYPE_DESCRIM, t0.BUYER_NAME, t0.DESCRIP, t0.VERSION, t1.PURCHASES FROM CMP3_FA_BUYER t0, CMP3_FA_PBUYER t1 WHERE t1.BUYER_ID = t0.BUYER_ID");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        query.setShouldRefreshIdentityMapResult(true);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            List results = (List)((JpaEntityManager)em.getDelegate()).getActiveSession().executeQuery((DatabaseQuery)query);
            SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
            Buyer buyer = (Buyer)results.get(0);
            buyer.setDescription("To A new changed description");
            results = (List)((JpaEntityManager)em.getDelegate()).getActiveSession().executeQuery((DatabaseQuery)query);
            SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
            SQLResultSetMappingTestSuite.assertFalse((String)"Object was not refreshed", (boolean)buyer.getDescription().equals("To A new changed description"));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
        }
    }

    public void testComplicateResultWithInheritance() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("ComplicatedInheritance");
        resultSetMapping.addResult((SQLResult)new ColumnResult("BUDGET_SUM"));
        EntityResult entityResult = new EntityResult(Project.class);
        resultSetMapping.addResult((SQLResult)entityResult);
        entityResult = new EntityResult(SmallProject.class);
        entityResult.addFieldResult(new FieldResult("id", "SMALL_ID"));
        entityResult.addFieldResult(new FieldResult("name", "SMALL_NAME"));
        entityResult.addFieldResult(new FieldResult("description", "SMALL_DESCRIPTION"));
        entityResult.addFieldResult(new FieldResult("teamLeader", "SMALL_TEAMLEAD"));
        entityResult.addFieldResult(new FieldResult("version", "SMALL_VERSION"));
        entityResult.setDiscriminatorColumn("SMALL_DESCRIM");
        resultSetMapping.addResult((SQLResult)entityResult);
        SQLCall call = new SQLCall("SELECT (t1.BUDGET/t0.PROJ_ID) AS BUDGET_SUM, t0.PROJ_ID, t0.PROJ_TYPE, t0.PROJ_NAME, t0.DESCRIP, t0.LEADER_ID, t0.VERSION, t1.BUDGET, t2.PROJ_ID AS SMALL_ID, t2.PROJ_TYPE AS SMALL_DESCRIM, t2.PROJ_NAME AS SMALL_NAME, t2.DESCRIP AS SMALL_DESCRIPTION, t2.LEADER_ID AS SMALL_TEAMLEAD, t2.VERSION AS SMALL_VERSION FROM CMP3_FA_PROJECT t0, CMP3_FA_PROJECT t2, CMP3_FA_LPROJECT t1 WHERE t1.PROJ_ID = t0.PROJ_ID AND t2.PROJ_TYPE='S'");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        List results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
        SQLResultSetMappingTestSuite.assertTrue((String)"Empty list returned", (results.size() != 0 ? 1 : 0) != 0);
        for (Object[] resultElement : results) {
            SQLResultSetMappingTestSuite.assertTrue((String)"Failed to Return 3 items", (resultElement.length == 3 ? 1 : 0) != 0);
            SQLResultSetMappingTestSuite.assertTrue((String)"Failed to return column", (boolean)(resultElement[0] instanceof Number));
            SQLResultSetMappingTestSuite.assertTrue((String)"Failed to return LargeProject", (boolean)(resultElement[1] instanceof LargeProject));
            SQLResultSetMappingTestSuite.assertTrue((String)"Failed To Return SmallProject", (boolean)(resultElement[2] instanceof SmallProject));
            SQLResultSetMappingTestSuite.assertFalse((String)"Returned same data in both result elements", (boolean)((SmallProject)resultElement[2]).getName().equals(((LargeProject)resultElement[1]).getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefresh() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("ComplicatedInheritance");
        EntityResult entityResult = new EntityResult(Project.class);
        resultSetMapping.addResult((SQLResult)entityResult);
        entityResult.setDiscriminatorColumn("SMALL_DESCRIM");
        SQLCall call = new SQLCall("SELECT t0.PROJ_ID, t0.PROJ_TYPE AS SMALL_DESCRIM, t0.PROJ_NAME, t0.DESCRIP, t0.LEADER_ID, t0.VERSION, t1.BUDGET FROM CMP3_FA_PROJECT t0, CMP3_FA_PROJECT t2, CMP3_FA_LPROJECT t1 WHERE t1.PROJ_ID = t0.PROJ_ID");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        query.setShouldRefreshIdentityMapResult(true);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            List results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
            SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
            Project project = (Project)results.get(0);
            project.setDescription("To A new changed description");
            results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
            SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
            SQLResultSetMappingTestSuite.assertTrue((String)"Empty list returned", (results.size() != 0 ? 1 : 0) != 0);
            SQLResultSetMappingTestSuite.assertFalse((String)"Object was not refreshed", (boolean)project.getDescription().equals("To A new changed description"));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testBindParameters() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("BindParameters");
        EntityResult entityResult = new EntityResult(Project.class);
        resultSetMapping.addResult((SQLResult)entityResult);
        entityResult.setDiscriminatorColumn("SMALL_DESCRIM");
        SQLCall call = new SQLCall("SELECT t0.PROJ_ID, t0.PROJ_TYPE AS SMALL_DESCRIM, t0.PROJ_NAME, t0.DESCRIP, t0.LEADER_ID, t0.VERSION, t1.BUDGET FROM CMP3_FA_PROJECT t0, CMP3_FA_LPROJECT t1 WHERE t1.PROJ_ID = t0.PROJ_ID AND t1.BUDGET > ? AND t1.BUDGET < 30000000");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        query.setShouldRefreshIdentityMapResult(false);
        query.setShouldBindAllParameters(true);
        query.addArgument("1");
        Vector<Integer> params = new Vector<Integer>();
        params.add(new Integer(4000));
        List results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query, params);
        SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
        SQLResultSetMappingTestSuite.assertTrue((String)"Empty list returned", (results.size() != 0 ? 1 : 0) != 0);
    }

    public void testBindParametersWithPostitional() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("BindParameters");
        EntityResult entityResult = new EntityResult(Project.class);
        resultSetMapping.addResult((SQLResult)entityResult);
        entityResult.setDiscriminatorColumn("SMALL_DESCRIM");
        SQLCall call = new SQLCall("SELECT t0.PROJ_ID, t0.PROJ_TYPE AS SMALL_DESCRIM, t0.PROJ_NAME, t0.DESCRIP, t0.LEADER_ID, t0.VERSION, t1.BUDGET FROM CMP3_FA_PROJECT t0, CMP3_FA_LPROJECT t1 WHERE t1.PROJ_ID = t0.PROJ_ID AND t1.BUDGET > ? AND t1.BUDGET < 30000000");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        query.setShouldRefreshIdentityMapResult(false);
        query.setShouldBindAllParameters(true);
        query.addArgument("1");
        Vector<Integer> params = new Vector<Integer>();
        params.add(new Integer(4000));
        List results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query, params);
        SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
        SQLResultSetMappingTestSuite.assertTrue((String)"Empty list returned", (results.size() != 0 ? 1 : 0) != 0);
    }

    public void testSimpleInheritance() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("SimpleInheritance");
        EntityResult entityResult = new EntityResult(Project.class);
        entityResult.setDiscriminatorColumn("SMALL_DESCRIM");
        resultSetMapping.addResult((SQLResult)entityResult);
        SQLCall call = new SQLCall("SELECT t0.PROJ_ID, t0.PROJ_TYPE AS SMALL_DESCRIM,  t0.PROJ_NAME, t0.DESCRIP, t0.LEADER_ID, t0.VERSION, t1.BUDGET FROM CMP3_FA_PROJECT t0 left outer join CMP3_FA_LPROJECT t1 on t1.PROJ_ID = t0.PROJ_ID");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        List results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
        SQLResultSetMappingTestSuite.assertTrue((String)"Empty list returned", (results.size() != 0 ? 1 : 0) != 0);
        for (Object project : results) {
            SQLResultSetMappingTestSuite.assertTrue((String)"Failed to return a project", (boolean)(project instanceof Project));
        }
    }

    public void testPessimisticLocking() throws Exception {
        if (!this.getDatabaseSession().getPlatform().isOracle() && !this.getDatabaseSession().getPlatform().isMySQL()) {
            SQLResultSetMappingTestSuite.warning((String)"FOR UPDATE syntax not supported.");
            return;
        }
        EntityManager em = this.createEntityManager();
        SmallProject smallProject = (SmallProject)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").readObject(SmallProject.class);
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("PessimisticLocking");
        EntityResult entityResult = new EntityResult(SmallProject.class);
        resultSetMapping.addResult((SQLResult)entityResult);
        SQLCall call = new SQLCall("SELECT t0.PROJ_ID, t0.PROJ_TYPE, t0.PROJ_NAME, t0.DESCRIP, t0.LEADER_ID, t0.VERSION FROM CMP3_FA_PROJECT t0 WHERE t0.PROJ_ID = " + smallProject.getId() + " FOR UPDATE");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        query.setLockMode((short)1);
        this.beginTransaction(em);
        try {
            List results = (List)((JpaEntityManager)em.getDelegate()).getActiveSession().executeQuery((DatabaseQuery)query);
            SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
            SQLResultSetMappingTestSuite.assertTrue((String)"Empty list returned", (results.size() != 0 ? 1 : 0) != 0);
            smallProject = (SmallProject)results.get(0);
            smallProject.setDescription("A relatively new Description");
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        smallProject = (SmallProject)em.find(SmallProject.class, (Object)smallProject.getId());
        this.closeEntityManager(em);
        SQLResultSetMappingTestSuite.assertTrue((String)"Failed to update the new description", (boolean)smallProject.getDescription().equals("A relatively new Description"));
    }

    public void testComplicateResults() throws Exception {
        SQLResultSetMapping resultSetMapping = new SQLResultSetMapping("ComplicatedInheritance");
        EntityResult entityResult = new EntityResult(Employee.class);
        entityResult.addFieldResult(new FieldResult("period.startDate", "STARTDATE"));
        entityResult.addFieldResult(new FieldResult("address.id", "EMP_ADDR"));
        resultSetMapping.addResult((SQLResult)entityResult);
        SQLCall call = new SQLCall("SELECT t0.EMP_ID, t1.EMP_ID, t0.F_NAME, t0.L_NAME, t0.VERSION, t1.SALARY, t0.START_DATE AS STARTDATE, t0.END_DATE, t0.ADDR_ID AS EMP_ADDR, t0.MANAGER_EMP_ID FROM CMP3_FA_EMPLOYEE t0, CMP3_FA_SALARY t1 WHERE ((t1.EMP_ID = t0.EMP_ID) AND ( t0.L_NAME = 'Smith' ))");
        ResultSetMappingQuery query = new ResultSetMappingQuery((Call)call);
        query.setSQLResultSetMapping(resultSetMapping);
        List results = (List)SQLResultSetMappingTestSuite.getServerSession((String)"fieldaccess").executeQuery((DatabaseQuery)query);
        SQLResultSetMappingTestSuite.assertNotNull((String)"No result returned", (Object)results);
        SQLResultSetMappingTestSuite.assertTrue((String)("Incorrect number of results returned, expected 2 got " + results.size()), (results.size() == 2 ? 1 : 0) != 0);
        for (Object resultElement : results) {
            SQLResultSetMappingTestSuite.assertTrue((String)"Failed to return Employee", (boolean)(resultElement instanceof Employee));
            Employee emp = (Employee)resultElement;
            SQLResultSetMappingTestSuite.assertNotNull((String)("Failed to get an address for Employee " + emp.getFirstName()), (Object)emp.getAddress());
        }
    }

    public void tearDown() {
        if (this.m_reset) {
            this.m_reset = false;
        }
        super.tearDown();
    }
}

