/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection.netty;

import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.netty.NettyStream;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;

public class NettyStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final EventLoopGroup eventLoopGroup;
    private final ByteBufAllocator allocator;

    public NettyStreamFactory(SocketSettings settings, SslSettings sslSettings, EventLoopGroup eventLoopGroup, ByteBufAllocator allocator) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
        this.allocator = Assertions.notNull("allocator", allocator);
    }

    public NettyStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this(settings, sslSettings, (EventLoopGroup)new NioEventLoopGroup(), (ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        return new NettyStream(serverAddress, this.settings, this.sslSettings, this.eventLoopGroup, this.allocator);
    }
}

