/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import java.util.ArrayList;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.inheritance.Apple;
import org.eclipse.persistence.testing.models.inheritance.Pear;
import org.eclipse.persistence.testing.models.inheritance.Teacher;

public class NestedUnitOfWorkMergeIntoParentTest
extends TestCase {
    protected static final int numberOfTimesToRepeatTest = 10;

    public NestedUnitOfWorkMergeIntoParentTest() {
        this.setDescription("Use original object from nested uow for registration in parent uow");
    }

    public void test() {
        for (int runNumber = 0; runNumber < 10; ++runNumber) {
            UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
            UnitOfWork nestedUnitOfWork = unitOfWork.acquireUnitOfWork();
            Teacher teacher = new Teacher();
            teacher.setName("Mrs. Crabapple");
            Apple apple = new Apple();
            apple.setQuality("high");
            apple.setTeacher(teacher);
            nestedUnitOfWork.registerObject((Object)teacher);
            nestedUnitOfWork.registerObject((Object)apple);
            int numberOfPearsToInsert = 10;
            ArrayList<Pear> pearsList = new ArrayList<Pear>(numberOfPearsToInsert);
            for (int pearNumber = 0; pearNumber < numberOfPearsToInsert; ++pearNumber) {
                Pear pear = new Pear();
                pearsList.add(pear);
                pear.setQuality("medium");
                nestedUnitOfWork.registerObject((Object)pear);
            }
            nestedUnitOfWork.commit();
            unitOfWork.commit();
            Teacher teacherRead = (Teacher)this.getSession().readObject(Teacher.class, new ExpressionBuilder().get("id").equal(teacher.getId()));
            NestedUnitOfWorkMergeIntoParentTest.assertNotNull((String)"Teacher should not be null", (Object)teacherRead);
            NestedUnitOfWorkMergeIntoParentTest.assertFalse((String)"Teacher id should not be zero", (teacherRead.getId() == 0L ? 1 : 0) != 0);
            Apple appleRead = (Apple)this.getSession().readObject(Apple.class, new ExpressionBuilder().get("id").equal(apple.getId()));
            NestedUnitOfWorkMergeIntoParentTest.assertNotNull((String)"Apple read should not be null", (Object)appleRead);
            NestedUnitOfWorkMergeIntoParentTest.assertFalse((String)"Apple id should not be zero", (appleRead.getId() == 0L ? 1 : 0) != 0);
            NestedUnitOfWorkMergeIntoParentTest.assertNotNull((String)"Teacher referenced by Apple should not be null", (Object)appleRead.getTeacher());
            NestedUnitOfWorkMergeIntoParentTest.assertEquals((String)"Teacher read should have same pk as the teacher referenced by apple", (long)teacherRead.getId(), (long)appleRead.getTeacher().getId());
            for (Pear pearInList : pearsList) {
                Pear pearRead = (Pear)this.getSession().readObject(Pear.class, new ExpressionBuilder().get("id").equal(pearInList.getId()));
                NestedUnitOfWorkMergeIntoParentTest.assertNotNull((String)"Pear read should not be null", (Object)pearRead);
                NestedUnitOfWorkMergeIntoParentTest.assertFalse((String)"Pear id should not be zero", (pearRead.getId() == 0L ? 1 : 0) != 0);
            }
        }
    }
}

