/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionManagerGetSessionNotFoundTest
extends AutoVerifyTestCase {
    DatabaseSession m_session;
    ValidationException m_exception;

    public SessionManagerGetSessionNotFoundTest() {
        this.setDescription("Tests that the proper exception is thrown when a session is not found in the session.xml file");
    }

    public void reset() {
        if (this.m_session != null && this.m_session.isConnected()) {
            this.m_session.logout();
            SessionManager.getManager().getSessions().remove("SessionShouldNotBeFound");
            this.m_session = null;
        }
    }

    protected void setup() {
        this.m_session = null;
        this.m_exception = null;
    }

    public void test() {
        try {
            XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaSession.xml");
            this.m_session = (DatabaseSession)SessionManager.getManager().getSession(loader, "SessionShouldNotBeFound", ((Object)((Object)this)).getClass().getClassLoader(), false, false);
        }
        catch (ValidationException e) {
            this.m_exception = e;
        }
    }

    protected void verify() {
        if (this.m_exception == null) {
            throw new TestErrorException("No exception was caught on the getSession call");
        }
        if (this.m_exception.getErrorCode() != 7100) {
            throw new TestErrorException("The wrong exception was caught. Caught (" + this.m_exception.getErrorCode() + "), wanted (" + 7100 + ")");
        }
    }
}

