/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.feature.BatchWritingTest;
import org.eclipse.persistence.testing.tests.feature.CacheStatementBatchWritingTest;
import org.eclipse.persistence.testing.tests.optimisticlocking.OptimisticLockingTestModel;

public class NativeBatchWritingTestModel
extends OptimisticLockingTestModel {
    public boolean usesBinding;

    public void addForcedRequiredSystems() {
        DatabasePlatform platform = this.getSession().getPlatform();
        try {
            this.getSession().getLog().write("WARNING, some JDBC drivers may fail BatchUpdates.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.usesBinding = platform.shouldBindAllParameters();
        if (!platform.isOracle()) {
            throw new TestWarningException("Native batch writing is not supported on this database.");
        }
        platform.setUsesBatchWriting(true);
        platform.setShouldBindAllParameters(true);
        platform.setShouldCacheAllStatements(true);
        platform.setUsesJDBCBatchWriting(true);
        platform.setUsesNativeBatchWriting(true);
        platform.setMaxBatchWritingSize(100);
        this.getExecutor().removeConfigureSystem((TestSystem)new EmployeeSystem());
        this.addForcedRequiredSystem(new EmployeeSystem());
    }

    public void reset() {
        DatabasePlatform platform = this.getSession().getPlatform();
        if (platform.isOracle()) {
            platform.setUsesBatchWriting(false);
            platform.setUsesJDBCBatchWriting(true);
            platform.setShouldBindAllParameters(this.usesBinding);
            platform.setShouldCacheAllStatements(false);
            platform.setUsesNativeBatchWriting(false);
        }
    }

    @Override
    public void addTests() {
        this.addTest((Test)NativeBatchWritingTestModel.getOptimisticLockingTestSuite());
        this.addTest((Test)NativeBatchWritingTestModel.getCascadeOptimisticLockingTestSuite());
        TestSuite suite = new TestSuite();
        suite.setName("NativeBatchWriteTests");
        suite.addTest((Test)new BatchWritingTest());
        this.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getUpdateObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getInsertObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)new CacheStatementBatchWritingTest());
        this.addTest((Test)suite);
    }
}

