/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.aggregate;

import java.math.BigDecimal;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.aggregate.Transport;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Vehicle {
    public String colour;
    public int capacity;
    private transient String transientValue;

    public String getTransientValue() {
        return this.transientValue;
    }

    public void setTransientValue(String transientValue) {
        this.transientValue = transientValue;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String getColour() {
        return this.colour;
    }

    public static void loadTables(Session session) {
        try {
            UnitOfWork uow = session.acquireUnitOfWork();
            uow.registerNewObject((Object)Transport.example2());
            uow.registerNewObject((Object)Transport.example3());
            uow.registerNewObject((Object)Transport.example4());
            uow.registerNewObject((Object)Transport.example5());
            uow.commit();
            session.getIdentityMapAccessor().initializeIdentityMaps();
        }
        catch (Exception e) {
            System.out.println("An exception ocurred loading the database -> " + e);
        }
    }

    public void setCapacity(int newValue) {
        this.capacity = newValue;
    }

    public void setColour(String newValue) {
        this.colour = newValue;
    }

    public static void setupDatabase(Session session) {
        try {
            SchemaManager schemaManager = new SchemaManager((DatabaseSession)session);
            schemaManager.replaceObject((DatabaseObjectDefinition)Vehicle.tableDefinition());
        }
        catch (Exception e) {
            System.out.println("Replace object failed because -> " + e);
        }
        try {
            Vehicle.loadTables(session);
        }
        catch (DatabaseException dbe) {
            System.out.println("an exception was caught setting up the db -> " + (Object)((Object)dbe));
        }
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("AGGVEHICLE");
        definition.addPrimaryKeyField("ID", BigDecimal.class, 15);
        definition.addField("TYPE", BigDecimal.class, 4);
        definition.addField("COLOUR", String.class, 255);
        definition.addField("CAPACITY", BigDecimal.class, 2);
        definition.addField("BICYCLE_DESC", String.class, 255);
        definition.addField("CAR_MAKE", String.class, 255);
        definition.addField("CAR_MODEL", String.class, 255);
        return definition;
    }
}

