/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced.concurrency;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Department;

public class LifecycleJUnitTest
extends JUnitTestCase {
    public LifecycleJUnitTest() {
    }

    public LifecycleJUnitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("LifecycleJUnitTestSuite");
        suite.addTest((Test)new LifecycleJUnitTest("testSetup"));
        suite.addTest((Test)new LifecycleJUnitTest("testClearWhileEntityManagerInFakeMergePendingState4"));
        suite.addTest((Test)new LifecycleJUnitTest("testClearWhileEntityManagerInFakeBirthState0"));
        suite.addTest((Test)new LifecycleJUnitTest("testClearWhileEntityManagerInCommitPendingStateWithClearAfterCommit"));
        suite.addTest((Test)new LifecycleJUnitTest("testClearWhileEntityManagerInCommitPendingStateWithNoClearAfterCommit"));
        suite.addTest((Test)new LifecycleJUnitTest("testClearAfterEntityManagerCommitFinished"));
        return suite;
    }

    private UnitOfWorkImpl getUnitOfWorkFromEntityManager(EntityManager em) {
        return ((UnitOfWorkImpl)((JpaEntityManager)em).getActiveSession()).acquireUnitOfWork();
    }

    public void testSetup() {
        this.clearCache();
        new AdvancedTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public void finalize() {
    }

    public void testClearWhileEntityManagerInFakeMergePendingState4() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = null;
        UnitOfWorkImpl uow = null;
        Map cloneToOriginalsMap = null;
        Department dept = null;
        try {
            em = emf.createEntityManager();
            uow = this.getUnitOfWorkFromEntityManager(em);
            cloneToOriginalsMap = uow.getCloneToOriginals();
            LifecycleJUnitTest.assertEquals((String)"cloneToOriginalsMap must be size 0", (int)0, (int)cloneToOriginalsMap.size());
            dept = new Department();
            cloneToOriginalsMap.put(null, dept);
            LifecycleJUnitTest.assertEquals((String)"cloneToOriginalsMap must be size 1", (int)1, (int)cloneToOriginalsMap.size());
            int lifecycleBefore = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set ", (int)0, (int)lifecycleBefore);
            uow.setPendingMerge();
            int lifecycleInMerge = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"MergePending state 4 is not set ", (int)4, (int)lifecycleInMerge);
            em.clear();
            int lifecycleAfter = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"UnModified MergePending state 4 should still be 4 and not Birth state 0 after a clear() ", (int)4, (int)lifecycleAfter);
            LifecycleJUnitTest.assertNotNull((String)"cloneToOriginals Map must not be null after a clear in *Pending state", (Object)cloneToOriginalsMap);
            LifecycleJUnitTest.assertEquals((String)"cloneToOriginalsMap must be size 1", (int)1, (int)cloneToOriginalsMap.size());
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testClearWhileEntityManagerInFakeBirthState0() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = null;
        UnitOfWorkImpl uow = null;
        Map cloneToOriginalsMap = null;
        Department dept = null;
        try {
            em = emf.createEntityManager();
            uow = this.getUnitOfWorkFromEntityManager(em);
            cloneToOriginalsMap = uow.getCloneToOriginals();
            LifecycleJUnitTest.assertEquals((String)"cloneToOriginalsMap must be size 0", (int)0, (int)cloneToOriginalsMap.size());
            dept = new Department();
            cloneToOriginalsMap.put(null, dept);
            LifecycleJUnitTest.assertEquals((String)"cloneToOriginalsMap must be size 1", (int)1, (int)cloneToOriginalsMap.size());
            int lifecycleBefore = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set ", (int)0, (int)lifecycleBefore);
            em.clear();
            int lifecycleAfter = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Unchanged Birth state 0 is not set ", (int)0, (int)lifecycleAfter);
            cloneToOriginalsMap = uow.getCloneToOriginals();
            LifecycleJUnitTest.assertNotNull((String)"cloneToOriginals Map must not be null after a clear in Birth state", (Object)cloneToOriginalsMap);
            LifecycleJUnitTest.assertEquals((String)"cloneToOriginalsMap must be not be cleared to size 0", (int)1, (int)cloneToOriginalsMap.size());
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testClearWhileEntityManagerInFakeAfterExternalTransactionRolledBackState6() {
    }

    public void testClearWhileEntityManagerInCommitPendingStateWithClearAfterCommit() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        Department dept = null;
        try {
            em.getTransaction().begin();
            dept = new Department();
            em.persist((Object)dept);
            UnitOfWorkImpl uow = this.getUnitOfWorkFromEntityManager(em);
            int lifecycleBefore = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set ", (int)0, (int)lifecycleBefore);
            em.clear();
            int lifecycleAfter = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set after a clear on state Birth  ", (int)0, (int)lifecycleAfter);
            em.getTransaction().commit();
            em.clear();
            int lifecycleAfterCommit = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set after commit ", (int)0, (int)lifecycleAfterCommit);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testClearWhileEntityManagerInCommitPendingStateWithNoClearAfterCommit() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        Department dept = null;
        try {
            em.getTransaction().begin();
            dept = new Department();
            em.persist((Object)dept);
            UnitOfWorkImpl uow = this.getUnitOfWorkFromEntityManager(em);
            int lifecycleBefore = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set ", (int)0, (int)lifecycleBefore);
            em.clear();
            int lifecycleAfter = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set after a clear on state Birth  ", (int)0, (int)lifecycleAfter);
            em.getTransaction().commit();
            int lifecycleAfterCommit = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set after commit ", (int)0, (int)lifecycleAfterCommit);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testClearAfterEntityManagerCommitFinished() {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        EntityManager em = emf.createEntityManager();
        Department dept = null;
        try {
            em.getTransaction().begin();
            dept = new Department();
            em.persist((Object)dept);
            UnitOfWorkImpl uow = this.getUnitOfWorkFromEntityManager(em);
            int lifecycleBefore = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set ", (int)0, (int)lifecycleBefore);
            em.clear();
            int lifecycleAfter = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set after a clear on state Birth  ", (int)0, (int)lifecycleAfter);
            em.getTransaction().commit();
            em.clear();
            int lifecycleAfterCommit = uow.getLifecycle();
            LifecycleJUnitTest.assertEquals((String)"Birth state 0 is not set after commit ", (int)0, (int)lifecycleAfterCommit);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

