/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.jms;

import javax.jms.Connection;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.resource.cci.ConnectionFactory;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSAdapterMetaData;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnection;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSConnectionSpec;
import org.eclipse.persistence.internal.eis.adapters.jms.CciJMSRecordFactory;

public class CciJMSConnectionFactory
implements ConnectionFactory {
    public javax.resource.cci.Connection getConnection() throws EISException {
        return this.getConnection(new CciJMSConnectionSpec());
    }

    public javax.resource.cci.Connection getConnection(ConnectionSpec spec) throws EISException {
        CciJMSConnectionSpec jmsSpec = null;
        QueueSession session = null;
        QueueConnection conn = null;
        try {
            javax.jms.ConnectionFactory factory;
            jmsSpec = (CciJMSConnectionSpec)spec;
            if (jmsSpec.hasConnectionFactoryURL()) {
                factory = (javax.jms.ConnectionFactory)new InitialContext().lookup(jmsSpec.getConnectionFactoryURL());
            } else {
                factory = jmsSpec.getConnectionFactory();
                if (factory == null) {
                    throw EISException.noConnectionFactorySpecified();
                }
            }
            conn = jmsSpec.hasUsername() ? ((QueueConnectionFactory)factory).createQueueConnection(jmsSpec.getUsername(), jmsSpec.getPassword()) : ((QueueConnectionFactory)factory).createQueueConnection();
            conn.start();
            session = conn.createQueueSession(true, 1);
        }
        catch (Exception e) {
            throw EISException.createException((Exception)e);
        }
        return new CciJMSConnection((Session)session, (Connection)conn, jmsSpec);
    }

    public ResourceAdapterMetaData getMetaData() {
        return new CciJMSAdapterMetaData();
    }

    public RecordFactory getRecordFactory() {
        return new CciJMSRecordFactory();
    }

    public Reference getReference() {
        return new Reference(this.getClass().getName());
    }

    public void setReference(Reference reference) {
    }
}

