/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionEventTracker
implements SessionEventListener {
    public static final String[] eventNames = new String[]{"PreExecuteQuery ", "PostExecuteQuery", "PreBeginTransaction", "PostBeginTransaction", "PreCommitTransaction", "PostCommitTransaction", "PreRollbackTransaction", "PostRollbackTransaction", "PostAcquireUnitOfWork", "PreCommitUnitOfWork", "PostCommitUnitOfWork", "PreReleaseUnitOfWork", "PostReleaseUnitOfWork", "PrepareUnitOfWork", "PostResumeUnitOfWork", "PostAcquireClientSession", "PreReleaseClientSession", "PostReleaseClientSession", "OutputParametersDetected", "MoreRowsDetected", "PostConnect", "PostAcquireConnection", "PreReleaseConnection", "PreLogin", "PostLogin", "PreMergeUnitOfWorkChangeSet", "PreDistributedMergeUnitOfWorkChangeSet", "PostMergeUnitOfWorkChangeSet", "PostDistributedMergeUnitOfWorkChangeSet", "PreCalculateUnitOfWorkChangeSet", "PostCalculateUnitOfWorkChangeSet", "MissingDescriptor", "PostAcquireExclusiveConnection", "PreReleaseExclusiveConnection", "NoRowsModified"};
    public static int nEvents = eventNames.length;
    public static boolean isTracking;
    public static boolean[] shouldTrackEvent;
    protected static List<Handling> handlings;
    protected static List<Handling> errors;
    protected String name = "";

    public SessionEventTracker() {
    }

    public SessionEventTracker(String name) {
        this.name = name;
    }

    public static void startTracking() {
        isTracking = true;
    }

    public static void stopTracking() {
        isTracking = false;
    }

    public static boolean isTracking() {
        return isTracking;
    }

    public static boolean isTrackingEvent(SessionEvent event) {
        if (isTracking) {
            return shouldTrackEvent[event.getEventCode()];
        }
        return false;
    }

    public static int size() {
        return handlings.size();
    }

    public static void clearLog() {
        handlings = new ArrayList<Handling>();
        errors = new ArrayList<Handling>();
    }

    public static void allEvents() {
        for (int i = 1; i < nEvents; ++i) {
            SessionEventTracker.shouldTrackEvent[i] = true;
        }
    }

    public static void noneEvents() {
        for (int i = 1; i < nEvents; ++i) {
            SessionEventTracker.shouldTrackEvent[i] = false;
        }
    }

    public static void addEvent(int eventCode) {
        if (eventCode <= 0) {
            throw new TestErrorException("event code " + eventCode + " is wrong - should be a positive number");
        }
        if (eventCode > eventNames.length) {
            throw new TestErrorException("event code " + eventCode + " is unknown - add event name for it to SessionEventTracker.eventNames array");
        }
        SessionEventTracker.shouldTrackEvent[eventCode] = true;
    }

    public static void removeEvent(int eventCode) {
        if (eventCode <= 0) {
            throw new TestErrorException("event code " + eventCode + " is wrong - should be a positive number");
        }
        if (eventCode > eventNames.length) {
            throw new TestErrorException("event code " + eventCode + " is unknown - add event name for it to SessionEventTracker.eventNames array");
        }
        SessionEventTracker.shouldTrackEvent[eventCode] = false;
    }

    public static List<Handling> getHandlings() {
        return handlings;
    }

    public static List<Handling> getErrors() {
        return errors;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void missingDescriptor(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void moreRowsDetected(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void noRowsModified(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void outputParametersDetected(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postAcquireClientSession(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postAcquireConnection(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postAcquireExclusiveConnection(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postAcquireUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postBeginTransaction(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preCalculateUnitOfWorkChangeSet(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postCalculateUnitOfWorkChangeSet(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postCommitTransaction(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postCommitUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postConnect(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postExecuteCall(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postExecuteQuery(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postReleaseClientSession(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postReleaseUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postResumeUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postRollbackTransaction(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postDistributedMergeUnitOfWorkChangeSet(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postMergeUnitOfWorkChangeSet(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preBeginTransaction(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preCommitTransaction(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preCommitUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preExecuteCall(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preExecuteQuery(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void prepareUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preReleaseClientSession(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preReleaseConnection(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preReleaseExclusiveConnection(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preReleaseUnitOfWork(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preRollbackTransaction(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preDistributedMergeUnitOfWorkChangeSet(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preMergeUnitOfWorkChangeSet(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void preLogin(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        Handling handling = this.log(event);
        if (((DatabaseSessionImpl)event.getSession()).isLoggedIn()) {
            handling.setError("session is already logged in");
        }
    }

    public void preLogout(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postLogout(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        this.log(event);
    }

    public void postLogin(SessionEvent event) {
        if (!SessionEventTracker.isTrackingEvent(event)) {
            return;
        }
        Handling handling = this.log(event);
        String errorMsg = "";
        for (ClassDescriptor descriptor : event.getSession().getDescriptors().values()) {
            if (descriptor.isAggregateDescriptor() || descriptor.isFullyInitialized()) continue;
            errorMsg = errorMsg + descriptor.getJavaClass().getName() + "; ";
        }
        if (errorMsg.length() > 0) {
            errorMsg = "Some descriptors are not initialized: " + errorMsg;
            handling.setError(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Handling log(SessionEvent event) {
        Handling handling = new Handling(this, event);
        List<Handling> list = handlings;
        synchronized (list) {
            handlings.add(handling);
        }
        return handling;
    }

    public String toString() {
        return Helper.getShortClassName((Object)this) + "(" + (this.name != null ? this.name : "") + ")";
    }

    public static String eventToString(SessionEvent event) {
        return SessionEventTracker.getEventName(event.getEventCode()) + "[" + SessionEventTracker.sessionToString(event.getSession()) + "]";
    }

    public static String getEventName(int eventCode) {
        if (eventCode <= 0) {
            throw new TestErrorException("event code " + eventCode + " is wrong - should be a positive number");
        }
        if (eventCode > eventNames.length) {
            throw new TestErrorException("event code " + eventCode + " is unknown - add event name for it to SessionEventTracker.eventNames array");
        }
        return eventNames[eventCode - 1];
    }

    public static String sessionToString(Session session) {
        return Helper.getShortClassName((Object)session) + "(" + session.getName() + ")";
    }

    static {
        shouldTrackEvent = new boolean[nEvents];
        SessionEventTracker.allEvents();
        handlings = new ArrayList<Handling>();
        errors = new ArrayList<Handling>();
    }

    public static class Handling {
        long time = System.currentTimeMillis();
        SessionEventTracker listener;
        SessionEvent event;
        String error = "";

        public Handling(SessionEventTracker listener, SessionEvent event) {
            this.listener = listener;
            this.event = event;
        }

        public String toString() {
            return this.listener.name + " -> " + SessionEventTracker.eventToString(this.event) + (this.error.length() == 0 ? "" : " Error: " + this.error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setError(String error) {
            this.error = error;
            if (error.length() > 0) {
                List<Handling> list = errors;
                synchronized (list) {
                    errors.add(this);
                }
            }
            List<Handling> list = errors;
            synchronized (list) {
                errors.remove(this);
            }
        }

        public String getError() {
            return this.error;
        }

        public SessionEvent getEvent() {
            return this.event;
        }

        public SessionEventTracker getListener() {
            return this.listener;
        }
    }
}

