/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.failover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.tests.junit.failover.Address;
import org.eclipse.persistence.testing.tests.junit.failover.FailoverBase;
import org.eclipse.persistence.testing.tests.junit.failover.emulateddriver.EmulatedConnection;
import org.eclipse.persistence.testing.tests.junit.failover.emulateddriver.EmulatedDriver;
import org.junit.Assert;
import org.junit.Test;

public class ConnectionPoolFailoverTest
extends FailoverBase<ServerSession> {
    @Override
    protected ServerSession createSession(Project p) {
        return (ServerSession)p.createServerSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void fullDatabaseFailureTest() {
        try {
            List list = ((ServerSession)this.getEmulatedSession()).getReadConnectionPool().getConnectionsAvailable();
            for (Accessor accessor : list) {
                ((EmulatedConnection)accessor.getConnection()).causeCommError();
            }
            EmulatedDriver.fullFailure = true;
            ((ServerSession)this.getEmulatedSession()).acquireClientSession().readObject(Address.class);
        }
        catch (DatabaseException ex) {
            return;
        }
        finally {
            EmulatedDriver.fullFailure = false;
        }
        Assert.fail((String)"Should have thrown exception as database connection is unavailable.");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void connectionPoolFailureTest() {
        void var3_13;
        void var3_9;
        void var3_7;
        ArrayList<Accessor> connections = new ArrayList<Accessor>();
        for (int i2 = 0; i2 < 10; ++i2) {
            connections.add(((ServerSession)this.getEmulatedSession()).getConnectionPool("default").acquireConnection());
        }
        for (Accessor accessor : connections) {
            ((ServerSession)this.getEmulatedSession()).getConnectionPool("default").releaseConnection(accessor);
        }
        List list = ((ServerSession)this.getEmulatedSession()).getReadConnectionPool().getConnectionsAvailable();
        for (Accessor accessor : list) {
            ((EmulatedConnection)accessor.getConnection()).causeCommError();
        }
        boolean bl = false;
        while (var3_7 < 4) {
            try {
                ((ServerSession)this.getEmulatedSession()).acquireClientSession().readObject(Address.class);
            }
            catch (DatabaseException ex) {
                Assert.fail((String)"Should have reconnected an not thrown exception.");
            }
            ++var3_7;
        }
        connections = new ArrayList();
        boolean bl2 = false;
        while (var3_9 < 10) {
            connections.add(((ServerSession)this.getEmulatedSession()).getConnectionPool("default").acquireConnection());
            ++var3_9;
        }
        for (Accessor accessor : connections) {
            ((ServerSession)this.getEmulatedSession()).getConnectionPool("default").releaseConnection(accessor);
        }
        list = ((ServerSession)this.getEmulatedSession()).getReadConnectionPool().getConnectionsAvailable();
        for (Accessor accessor : list) {
            ((EmulatedConnection)accessor.getConnection()).causeCommError();
        }
        boolean bl3 = false;
        while (var3_13 < 4) {
            block12: {
                try {
                    ReadObjectQuery query = new ReadObjectQuery(Address.class);
                    query.setQueryTimeout(10000);
                    ((ServerSession)this.getEmulatedSession()).acquireClientSession().executeQuery((DatabaseQuery)query);
                }
                catch (DatabaseException ex) {
                    if (var3_13 == false) break block12;
                    Assert.fail((String)"Should have reconnected and not thrown exception.");
                }
            }
            ++var3_13;
        }
    }
}

