/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.jpql.JPQLParameterTestCase;

public class BinaryOperatorWithParameterTest
extends JPQLParameterTestCase {
    private Vector expressionParameters;

    public static BinaryOperatorWithParameterTest getNumericParameterGreaterThanTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Greater than with parameter test");
        String parameterName = "id";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").greaterThan(builder.getParameter(parameterName));
        theTest.setOriginalObjectExpression(whereClause);
        Object ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = (String)ejbqlString + "emp.id > ?1 ";
        theTest.setEjbqlString((String)ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterGreaterThanEqualTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Greater than equal to with parameter test");
        String parameterName = "id";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").greaterThanEqual(builder.getParameter(parameterName));
        theTest.setOriginalObjectExpression(whereClause);
        Object ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = (String)ejbqlString + "emp.id >= ?1 ";
        theTest.setEjbqlString((String)ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterLessThanTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Less than with parameter test");
        String parameterName = "id";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").lessThan(builder.getParameter(parameterName));
        theTest.setOriginalObjectExpression(whereClause);
        Object ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = (String)ejbqlString + "emp.id < ?1 ";
        theTest.setEjbqlString((String)ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterLessThanEqualTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Less than equal to with parameter test");
        String parameterName = "id";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("id").lessThanEqual(builder.getParameter(parameterName));
        theTest.setOriginalObjectExpression(whereClause);
        Object ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE ";
        ejbqlString = (String)ejbqlString + "emp.id <= ?1 ";
        theTest.setEjbqlString((String)ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterPlusTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Plus with parameter test");
        String parameterName = "amountToAdd";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.add((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary + ?1 <= 50000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(1000));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterPlusTestWithBracketsBeforeComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Plus with parameter test with brackets before comparison");
        String parameterName = "amountToAdd";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.add((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary + ?1) <= 50000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(1000));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterPlusTestWithBracketsAfterComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Plus with parameter test with brackets after comparison");
        String parameterName = "amountToAdd";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(50000), (Expression)builder).greaterThan(ExpressionMath.add((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)));
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE 50000 > (emp.salary + ?1)";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(1000));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterMinusTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Minus with parameter test");
        String parameterName = "amountToSubtract";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.subtract((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary - ?1 <= 50000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(1000));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterMinusTestWithBracketsBeforeComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Minus with parameter test with brackets before comparison");
        String parameterName = "amountToSubtract";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.subtract((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary - ?1) <= 50000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(1000));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterMinusTestWithBracketsAfterComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Minus with parameter test with brackets after comparison");
        String parameterName = "amountToSubtract";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(50000), (Expression)builder).greaterThan(ExpressionMath.subtract((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)));
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE 50000 > (emp.salary - ?1)";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(1000));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterMultiplyTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Multiply with parameter test");
        String parameterName = "amountToMultiply";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.multiply((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(100000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary * ?1 <= 100000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterMultiplyTestWithBracketsBeforeComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Multiply with parameter test with brackets before comparison");
        String parameterName = "amountToMultiply";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.multiply((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(100000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary * ?1) <= 100000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterMultiplyTestWithBracketsAfterComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Multiply with parameter test with brackets after comparison");
        String parameterName = "amountToMultiply";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(100000), (Expression)builder).greaterThan(ExpressionMath.multiply((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)));
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE 100000 > (emp.salary * ?1)";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterDivideTest() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Divide with parameter test");
        String parameterName = "amountToDivide";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.divide((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(20000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary / ?1 <= 20000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterDivideTestWithBracketsBeforeComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Divide with parameter test with brackets before comparison");
        String parameterName = "amountToDivide";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.divide((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)).lessThanEqual(20000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary / ?1) <= 20000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericParameterDivideTestWithBracketsAfterComparison() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Divide with parameter test with brackets after comparison");
        String parameterName = "amountToDivide";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterName);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionBuilder.fromConstant((Object)new Integer(20000), (Expression)builder).greaterThan(ExpressionMath.divide((Expression)builder.get("salary"), (Object)builder.getParameter(parameterName)));
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE 20000 > (emp.salary / ?1)";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericTwoParameterMultipleOperators() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Multiple operators with two parameters");
        String parameterNameForDivide = "amountToDivide";
        String parameterNameForMultiply = "amountToMultiply";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterNameForDivide);
        theTest.getExpressionParameters().add(parameterNameForMultiply);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.subtract((Expression)ExpressionMath.add((Expression)builder.get("salary"), (int)10000), (Object)ExpressionMath.multiply((Expression)ExpressionMath.divide((Expression)ExpressionBuilder.fromConstant((Object)new Integer(10000), (Expression)builder), (Object)builder.getParameter(parameterNameForDivide)), (Object)builder.getParameter(parameterNameForMultiply))).greaterThanEqual(50000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary + 10000 - 10000 / ?1 * ?2 >= 50000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        myArgumentNames.add("2");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        theTest.getArguments().addElement(new Integer(3));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericTwoParameterMultipleOperatorsWithBracketsAroundPlusMinus() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Multiple operators with two parameters with brackets around plus/minus");
        String parameterNameForDivide = "amountToDivide";
        String parameterNameForMultiply = "amountToMultiply";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterNameForDivide);
        theTest.getExpressionParameters().add(parameterNameForMultiply);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.multiply((Expression)ExpressionMath.divide((Expression)ExpressionMath.subtract((Expression)ExpressionMath.add((Expression)builder.get("salary"), (int)10), (int)20), (Object)builder.getParameter(parameterNameForDivide)), (Object)builder.getParameter(parameterNameForMultiply)).greaterThanEqual(70000);
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE (emp.salary + 10 - 20) / ?1 * ?2 >= 70000";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        myArgumentNames.add("2");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        theTest.getArguments().addElement(new Integer(3));
        return theTest;
    }

    public static BinaryOperatorWithParameterTest getNumericTwoParameterMultipleOperatorsWithBracketsAroundMultiply() {
        BinaryOperatorWithParameterTest theTest = new BinaryOperatorWithParameterTest();
        theTest.setName("Multiple operators with two parameters with brackets around multiply");
        String parameterNameForDivide = "amountToDivide";
        String parameterNameForMultiply = "amountToMultiply";
        theTest.setExpressionParameters(new Vector());
        theTest.getExpressionParameters().add(parameterNameForDivide);
        theTest.getExpressionParameters().add(parameterNameForMultiply);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("salary").greaterThan(ExpressionMath.subtract((Expression)ExpressionMath.add((Expression)ExpressionBuilder.fromConstant((Object)new Integer(50000), (Expression)builder), (int)10000), (Object)ExpressionMath.divide((Expression)ExpressionBuilder.fromConstant((Object)new Integer(10000), (Expression)builder), (Object)ExpressionMath.multiply((Expression)builder.getParameter(parameterNameForMultiply), (Object)builder.getParameter(parameterNameForDivide)))));
        theTest.setOriginalObjectExpression(whereClause);
        String ejbqlString = "SELECT OBJECT(emp) FROM Employee emp WHERE emp.salary > (50000 + 10000 - 10000 / (?1 * ?2))";
        theTest.setEjbqlString(ejbqlString);
        Vector<String> myArgumentNames = new Vector<String>();
        myArgumentNames.add("1");
        myArgumentNames.add("2");
        theTest.setArgumentNames(myArgumentNames);
        theTest.setArguments(new Vector());
        theTest.getArguments().addElement(new Integer(2));
        theTest.getArguments().addElement(new Integer(5));
        return theTest;
    }

    public static TestSuite getParameterBinaryOperatorTests() {
        TestSuite theSuite = new TestSuite();
        theSuite.setName("Parameter Binary Operator Test Suite");
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterGreaterThanTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterGreaterThanEqualTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterLessThanTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterLessThanEqualTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterPlusTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterPlusTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterPlusTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterMinusTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterMinusTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterMinusTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterMultiplyTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterMultiplyTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterMultiplyTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterDivideTest());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterDivideTestWithBracketsBeforeComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericParameterDivideTestWithBracketsAfterComparison());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericTwoParameterMultipleOperators());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericTwoParameterMultipleOperatorsWithBracketsAroundPlusMinus());
        theSuite.addTest((Test)BinaryOperatorWithParameterTest.getNumericTwoParameterMultipleOperatorsWithBracketsAroundMultiply());
        return theSuite;
    }

    private void setArgumentsForTestUsing(Vector employees) {
        this.setArguments(new Vector());
        Enumeration names = this.getExpressionParameters().elements();
        Enumeration employeeEnum = employees.elements();
        while (names.hasMoreElements()) {
            Employee emp = (Employee)employeeEnum.nextElement();
            this.getArguments().add(emp.getId());
            names.nextElement();
        }
    }

    @Override
    public void setup() {
        if (!this.hasArguments()) {
            this.setArgumentsForTestUsing(this.getSomeEmployees());
        }
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(this.getOriginalObjectExpression());
        Enumeration enumtr = this.getExpressionParameters().elements();
        while (enumtr.hasMoreElements()) {
            raq.addArgument((String)enumtr.nextElement());
        }
        this.setOriginalOject(this.getSession().executeQuery((DatabaseQuery)raq, (List)this.getArguments()));
        super.setup();
    }

    private void setExpressionParameters(Vector theArgumentNames) {
        this.expressionParameters = theArgumentNames;
    }

    private Vector getExpressionParameters() {
        return this.expressionParameters;
    }
}

