/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class NestedUnitOfWorkDeleteNestedNewObjectTest
extends AutoVerifyTestCase {
    public NestedUnitOfWorkDeleteNestedNewObjectTest() {
        this.setDescription("Test designed to verify that a new object registered in a nested unit of work is unregistered when deleted in same unit of work.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UnitOfWork nestedUow1 = uow.acquireUnitOfWork();
        Employee employee = (Employee)new EmployeePopulator().basicEmployeeExample1();
        Employee nestedEmployee = (Employee)nestedUow1.registerObject((Object)employee);
        nestedUow1.deleteObject((Object)nestedEmployee);
        nestedUow1.commit();
        uow.commit();
        if (((UnitOfWorkImpl)uow).getNewObjectsCloneToOriginal().containsKey(employee)) {
            throw new TestErrorException("Failed to unregister the Object in the nested unit of work");
        }
        if (((UnitOfWorkImpl)uow).getPrimaryKeyToNewObjects().values().stream().anyMatch(c -> c.contains(employee))) {
            throw new TestErrorException("Failed to move the deleted new object into the parent UOW");
        }
    }

    public void reset() {
        this.getAbstractSession().commitTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

