/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.merge.advanced;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.eclipse.persistence.testing.models.jpa.xml.merge.advanced.Employee;

@Entity(name="AnnMergeProject")
@Table(name="CMP3_ANN_MERGE_PROJECT")
@Inheritance(strategy=InheritanceType.JOINED)
@DiscriminatorColumn(name="ANN_MERGE_PROJ_TYPE", discriminatorType=DiscriminatorType.INTEGER)
@DiscriminatorValue(value="0")
@NamedQuery(name="ann_merge_findProjectByName", query="SELECT OBJECT(project) FROM Project project WHERE project.name = :name")
public class Project
implements Serializable {
    public int pre_update_count = 0;
    public int post_update_count = 0;
    public int pre_remove_count = 0;
    public int post_remove_count = 0;
    public int pre_persist_count = 0;
    public int post_persist_count = 0;
    public int post_load_count = 0;
    private Integer id;
    private int version;
    private String name;
    private String description;
    private Employee teamLeader;
    private Collection<Employee> teamMembers = new Vector<Employee>();

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ANN_MERGE_PROJECT_SEQUENCE_GENERATOR")
    @SequenceGenerator(name="ANN_MERGE_PROJECT_SEQUENCE_GENERATOR", sequenceName="ANN_MERGE_PROJECT_SEQ", allocationSize=10)
    @Column(name="ANN_MERGE_PROJ_ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Version
    @Column(name="ANN_MERGE_VERSION")
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    @Column(name="ANN_MERGE_PROJ_NAME")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="ANN_MERGE_DESCRIP")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @OneToOne
    @JoinColumn(name="ANN_MERGE_LEADER_ID")
    public Employee getTeamLeader() {
        return this.teamLeader;
    }

    public void setTeamLeader(Employee teamLeader) {
        this.teamLeader = teamLeader;
    }

    @ManyToMany(mappedBy="projects")
    public Collection<Employee> getTeamMembers() {
        return this.teamMembers;
    }

    public void setTeamMembers(Collection<Employee> employees) {
        this.teamMembers = employees;
    }

    public void addTeamMember(Employee employee) {
        this.getTeamMembers().add(employee);
    }

    public void removeTeamMember(Employee employee) {
        this.getTeamMembers().remove(employee);
    }

    public String displayString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("Project ").append(this.getId()).append(": ").append(this.getName()).append(", ").append(this.getDescription());
        return sbuff.toString();
    }

    public void prePersist() {
        ++this.pre_persist_count;
    }

    @PrePersist
    public void ignoredPrePersistMethod() {
    }

    @PostPersist
    public void postPersist() {
        ++this.post_persist_count;
    }

    @PreRemove
    public void preRemove() {
        ++this.pre_remove_count;
    }

    @PostRemove
    public void postRemove() {
        ++this.post_remove_count;
    }

    @PreUpdate
    public void preUpdate() {
        ++this.pre_update_count;
    }

    @PostUpdate
    public void postUpdate() {
        ++this.post_update_count;
    }

    @PostLoad
    public void postLoad() {
        ++this.post_load_count;
    }
}

