/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class RegisterInIdentityMapTest
extends TestCase {
    protected Class identityMapClass;
    protected Class originalIdentityMapClass;
    protected int originalIdentityMapSize;
    protected Vector employees;

    public RegisterInIdentityMapTest(Class mapClass) {
        this.identityMapClass = mapClass;
    }

    public void checkIdentityMap(Vector cachedEmployees) {
        if (this.getIdentityMap().getSize() != cachedEmployees.size()) {
            throw new TestErrorException("Unexpected identity map size, expecting:  " + cachedEmployees.size() + " found: " + this.getIdentityMap());
        }
        Enumeration enumtr = this.employees.elements();
        while (enumtr.hasMoreElements()) {
            Object test = enumtr.nextElement();
            Object result = this.getObjectFromIdentityMap(test);
            if (cachedEmployees.contains(test) && result != test) {
                throw new TestErrorException("Test object: " + test + " did not match identity map object: " + result);
            }
            if (cachedEmployees.contains(test) || result == null) continue;
            throw new TestErrorException("Found object: " + test + " which should not have been in the cache");
        }
    }

    public String getDescription() {
        return "This test verifies an object was properly registerted in the identity map";
    }

    protected IdentityMap getIdentityMap() {
        return this.getAbstractSession().getIdentityMapAccessorInstance().getIdentityMap(Employee.class);
    }

    protected Object getObjectFromIdentityMap(Object domainObject) {
        return this.getAbstractSession().getIdentityMapAccessorInstance().getFromIdentityMap(this.getSession().getId(domainObject), domainObject.getClass());
    }

    protected boolean isCacheIdentityMap() {
        return this.identityMapClass == CacheIdentityMap.class;
    }

    protected boolean isFullIdentityMap() {
        return this.identityMapClass == FullIdentityMap.class;
    }

    protected boolean isNoIdentityMap() {
        return this.identityMapClass == NoIdentityMap.class;
    }

    public void setup() {
        this.originalIdentityMapClass = this.getSession().getDescriptor(Employee.class).getIdentityMapClass();
        this.originalIdentityMapSize = this.getSession().getDescriptor(Employee.class).getIdentityMapSize();
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.identityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(10);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void reset() {
        this.getSession().getDescriptor(Employee.class).setIdentityMapClass(this.originalIdentityMapClass);
        this.getSession().getDescriptor(Employee.class).setIdentityMapSize(this.originalIdentityMapSize);
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        this.employees = this.getSession().readAllObjects(Employee.class);
    }

    public void verify() {
        if (this.isNoIdentityMap()) {
            this.verifyNoIdentityMap();
        } else if (this.isCacheIdentityMap()) {
            this.verifyCacheIdentityMap();
        } else {
            this.verifyFullIdentityMap();
        }
    }

    public void verifyCacheIdentityMap() {
        Vector cache = (Vector)this.employees.clone();
        while (cache.size() > 10) {
            cache.removeElementAt(0);
        }
        this.checkIdentityMap(cache);
    }

    public void verifyFullIdentityMap() {
        this.checkIdentityMap(this.employees);
    }

    public void verifyNoIdentityMap() {
        this.checkIdentityMap(new Vector());
    }
}

