/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.inheritance.Bicycle;
import org.eclipse.persistence.testing.models.inheritance.Boat;
import org.eclipse.persistence.testing.models.inheritance.Bus;
import org.eclipse.persistence.testing.models.inheritance.Car;
import org.eclipse.persistence.testing.models.inheritance.Company;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;

public class UnitOfWorkCommitResumeTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;
    public Vector persons;

    public UnitOfWorkCommitResumeTest() {
    }

    public UnitOfWorkCommitResumeTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Company company = (Company)this.unitOfWorkWorkingCopy;
        Vector vehicles = (Vector)company.getVehicles().getValue();
        vehicles.removeElement(vehicles.firstElement());
        Vehicle aVehicle = (Vehicle)vehicles.lastElement();
        aVehicle.setPassengerCapacity(15);
        Car car = Car.example2();
        car.setOwner(company);
        vehicles.addElement(car);
        vehicles.addElement(Bicycle.example3(company));
        vehicles.addElement(Bicycle.example2(company));
        vehicles.addElement(Bus.example2(company));
    }

    protected void changeUnitOfWorkWorkingCopyAgain() {
        Company company = (Company)this.unitOfWorkWorkingCopy;
        Vector vehicles = (Vector)company.getVehicles().getValue();
        company.setName(company.name + "0");
        vehicles.removeElement(vehicles.firstElement());
        Vehicle aVehicle = (Vehicle)vehicles.firstElement();
        aVehicle.setPassengerCapacity(15);
        Car car = Car.example2();
        car.setOwner(company);
        vehicles.addElement(car);
        vehicles.addElement(Bus.example4(company));
        vehicles.addElement(Bicycle.example1(company));
        vehicles.addElement(Boat.example3(company));
        vehicles.addElement(Bus.example2(company));
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!((AbstractSession)this.getSession()).compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        this.unitOfWork.commitAndResume();
        this.changeUnitOfWorkWorkingCopyAgain();
        this.unitOfWork.commitAndResume();
    }

    protected void verify() {
        try {
            if (!((AbstractSession)this.getSession()).compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
                throw new TestErrorException("The object in the unit of work has not been commited properly to its parent");
            }
        }
        catch (DatabaseException exception) {
            if (this.getSession().getPlatform().isDBase()) {
                throw new TestWarningException("This fails because of some strange bug in the DBase driver. " + exception.getMessage());
            }
            throw exception;
        }
        super.verify();
    }
}

