/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.HashMap;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ReportQueryRetrievePrimaryKeysCursorTest
extends TestCase {
    protected ReportQuery reportQuery;
    protected HashMap<Object, ReportQueryResult> expectedResults;
    protected HashMap<Object, ReportQueryResult> cursoredResults;

    public ReportQueryRetrievePrimaryKeysCursorTest() {
        this.setDescription("Test retrieving primary keys with a ReportQuery, using a Cursor");
    }

    protected void queryForExpectedResults() {
        this.expectedResults = new HashMap();
        ReportQuery expectedResultsReportQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        ExpressionBuilder builder = expectedResultsReportQuery.getExpressionBuilder();
        expectedResultsReportQuery.retrievePrimaryKeys();
        expectedResultsReportQuery.addAttribute("idResult", builder.get("id"));
        expectedResultsReportQuery.addAttribute("firstNameResult", builder.get("firstName"));
        expectedResultsReportQuery.addAttribute("lastNameResult", builder.get("lastName"));
        expectedResultsReportQuery.addAttribute("addressResult", builder.get("address").get("id"));
        Vector someResults = (Vector)this.getSession().executeQuery((DatabaseQuery)expectedResultsReportQuery);
        for (ReportQueryResult result : someResults) {
            this.expectedResults.put(result.getId(), result);
        }
    }

    protected void buildCursoredResultsReportQuery() {
        this.cursoredResults = new HashMap();
        this.reportQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        ExpressionBuilder builder = this.reportQuery.getExpressionBuilder();
        this.reportQuery.retrievePrimaryKeys();
        this.reportQuery.addAttribute("idResult", builder.get("id"));
        this.reportQuery.addAttribute("firstNameResult", builder.get("firstName"));
        this.reportQuery.addAttribute("lastNameResult", builder.get("lastName"));
        this.reportQuery.addAttribute("addressResult", builder.get("address").get("id"));
        this.reportQuery.useCursoredStream(5, 5);
    }

    protected void setup() throws Throwable {
        if (this.getSession().isRemoteSession()) {
            this.throwWarning("Report queries with objects are not supported on remote session.");
        }
        super.setup();
        this.queryForExpectedResults();
        this.buildCursoredResultsReportQuery();
    }

    public void test() {
        CursoredStream stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)this.reportQuery);
        while (!stream.atEnd()) {
            ReportQueryResult result = (ReportQueryResult)stream.read();
            this.cursoredResults.put(result.getId(), result);
            stream.releasePrevious();
        }
        stream.close();
    }

    public void verify() {
        ReportQueryRetrievePrimaryKeysCursorTest.assertNotNull((String)"Expected results should be non-null", this.expectedResults);
        ReportQueryRetrievePrimaryKeysCursorTest.assertFalse((String)"Expected results should not be zero", (this.expectedResults.size() == 0 ? 1 : 0) != 0);
        ReportQueryRetrievePrimaryKeysCursorTest.assertNotNull((String)"Cursored results should be non-null", this.cursoredResults);
        ReportQueryRetrievePrimaryKeysCursorTest.assertFalse((String)"Cursored results should not be zero", (this.cursoredResults.size() == 0 ? 1 : 0) != 0);
        ReportQueryRetrievePrimaryKeysCursorTest.assertEquals((String)"Cursored results differs from expected results", (int)this.expectedResults.size(), (int)this.cursoredResults.size());
        for (Object id : this.expectedResults.keySet()) {
            if (this.cursoredResults.containsKey(id)) continue;
            ReportQueryRetrievePrimaryKeysCursorTest.fail((String)("Cursored results does not contain entry for id: " + id));
        }
    }

    public void reset() {
        this.cursoredResults = null;
        this.expectedResults = null;
        this.reportQuery = null;
    }
}

