/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.metadata;

import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeBase;

public abstract class PrecisionType
extends ScalarDatabaseTypeBase
implements ScalarDatabaseType {
    protected long precision;
    protected long scale;

    public PrecisionType(String typeName, long precision) {
        super(typeName);
        this.precision = precision;
        this.scale = 0L;
    }

    public PrecisionType(String typeName, long precision, long scale) {
        this(typeName, precision);
        this.scale = scale;
    }

    public long getPrecision() {
        return this.precision;
    }

    public long getScale() {
        return this.scale;
    }

    public abstract long getDefaultPrecision();

    public boolean isSimple() {
        return true;
    }

    @Override
    public boolean isPrecisionType() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.precision != this.getDefaultPrecision()) {
            sb.append('(');
            sb.append(this.precision);
            if (this.scale != 0L) {
                sb.append(',');
                sb.append(this.scale);
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

