/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.commons;

import java.util.List;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.TypePath;
import org.eclipse.persistence.internal.libraries.asm.commons.AnnotationRemapper;
import org.eclipse.persistence.internal.libraries.asm.commons.FieldRemapper;
import org.eclipse.persistence.internal.libraries.asm.commons.MethodRemapper;
import org.eclipse.persistence.internal.libraries.asm.commons.ModuleHashesAttribute;
import org.eclipse.persistence.internal.libraries.asm.commons.ModuleRemapper;
import org.eclipse.persistence.internal.libraries.asm.commons.Remapper;

public class ClassRemapper
extends ClassVisitor {
    protected final Remapper remapper;
    protected String className;

    public ClassRemapper(ClassVisitor classVisitor, Remapper remapper) {
        this(393216, classVisitor, remapper);
    }

    protected ClassRemapper(int n, ClassVisitor classVisitor, Remapper remapper) {
        super(n, classVisitor);
        this.remapper = remapper;
    }

    @Override
    public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
        this.className = string;
        super.visit(n, n2, this.remapper.mapType(string), this.remapper.mapSignature(string2, false), this.remapper.mapType(string3), stringArray == null ? null : this.remapper.mapTypes(stringArray));
    }

    @Override
    public ModuleVisitor visitModule(String string, int n, String string2) {
        ModuleVisitor moduleVisitor = super.visitModule(this.remapper.mapModuleName(string), n, string2);
        return moduleVisitor == null ? null : this.createModuleRemapper(moduleVisitor);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        AnnotationVisitor annotationVisitor = super.visitAnnotation(this.remapper.mapDesc(string), bl);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        AnnotationVisitor annotationVisitor = super.visitTypeAnnotation(n, typePath, this.remapper.mapDesc(string), bl);
        return annotationVisitor == null ? null : this.createAnnotationRemapper(annotationVisitor);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        if (attribute instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute moduleHashesAttribute = new ModuleHashesAttribute();
            List<String> list = moduleHashesAttribute.modules;
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.remapper.mapModuleName(list.get(i)));
            }
        }
        super.visitAttribute(attribute);
    }

    @Override
    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        FieldVisitor fieldVisitor = super.visitField(n, this.remapper.mapFieldName(this.className, string, string2), this.remapper.mapDesc(string2), this.remapper.mapSignature(string3, true), this.remapper.mapValue(object));
        return fieldVisitor == null ? null : this.createFieldRemapper(fieldVisitor);
    }

    @Override
    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        String string4 = this.remapper.mapMethodDesc(string2);
        MethodVisitor methodVisitor = super.visitMethod(n, this.remapper.mapMethodName(this.className, string, string2), string4, this.remapper.mapSignature(string3, false), stringArray == null ? null : this.remapper.mapTypes(stringArray));
        return methodVisitor == null ? null : this.createMethodRemapper(methodVisitor);
    }

    @Override
    public void visitInnerClass(String string, String string2, String string3, int n) {
        super.visitInnerClass(this.remapper.mapType(string), string2 == null ? null : this.remapper.mapType(string2), string3, n);
    }

    @Override
    public void visitOuterClass(String string, String string2, String string3) {
        super.visitOuterClass(this.remapper.mapType(string), string2 == null ? null : this.remapper.mapMethodName(string, string2, string3), string3 == null ? null : this.remapper.mapMethodDesc(string3));
    }

    protected FieldVisitor createFieldRemapper(FieldVisitor fieldVisitor) {
        return new FieldRemapper(this.api, fieldVisitor, this.remapper);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor methodVisitor) {
        return new MethodRemapper(this.api, methodVisitor, this.remapper);
    }

    protected AnnotationVisitor createAnnotationRemapper(AnnotationVisitor annotationVisitor) {
        return new AnnotationRemapper(this.api, annotationVisitor, this.remapper);
    }

    protected ModuleVisitor createModuleRemapper(ModuleVisitor moduleVisitor) {
        return new ModuleRemapper(this.api, moduleVisitor, this.remapper);
    }
}

