/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.HugeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.advanced.SmallProject;
import org.eclipse.persistence.testing.models.jpa.inheritance.Car;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.Person;
import org.eclipse.persistence.testing.models.jpa.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.jpa.inherited.BeerConsumer;
import org.eclipse.persistence.testing.models.jpa.inherited.Blue;
import org.eclipse.persistence.testing.models.jpa.inherited.BlueLight;
import org.eclipse.persistence.testing.models.jpa.inherited.InheritedTableManager;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitJPQLComplexTestSuite;

public abstract class JUnitCriteriaSimpleTestSuiteBase<T>
extends JUnitTestCase {
    protected CriteriaQueryWrapper wrapper;
    protected Map<Attributes, T> attributes;
    static JUnitDomainObjectComparer comparer;

    protected abstract void setWrapper();

    protected abstract void populateAttributes();

    public JUnitCriteriaSimpleTestSuiteBase() {
        this.setWrapper();
        this.populateAttributes();
    }

    public JUnitCriteriaSimpleTestSuiteBase(String name) {
        super(name);
        this.setWrapper();
        this.populateAttributes();
    }

    public void tearDown() {
        this.clearCache();
    }

    public static <T extends JUnitCriteriaSimpleTestSuiteBase> Test suite(Class<T> implementingClass) {
        TestSuite suite = new TestSuite();
        suite.setName("JUnitCriteriaSimpleTestSuite");
        try {
            Constructor<T> constructor = implementingClass.getConstructor(String.class);
            suite.addTest((Test)constructor.newInstance("testSetup"));
            suite.addTest((Test)constructor.newInstance("simpleJoinFetchTest"));
            suite.addTest((Test)constructor.newInstance("simpleJoinFetchTest2"));
            suite.addTest((Test)constructor.newInstance("executeSameCriteriaQueryWithJoinTwice"));
            suite.addTest((Test)constructor.newInstance("baseTestCase"));
            suite.addTest((Test)constructor.newInstance("simpleABSTest"));
            suite.addTest((Test)constructor.newInstance("simpleBetweenTest"));
            suite.addTest((Test)constructor.newInstance("simpleConcatTest"));
            suite.addTest((Test)constructor.newInstance("simpleConcatTestWithParameters"));
            suite.addTest((Test)constructor.newInstance("simpleConcatTestWithConstants1"));
            suite.addTest((Test)constructor.newInstance("simpleCountTest"));
            suite.addTest((Test)constructor.newInstance("simpleThreeArgConcatTest"));
            suite.addTest((Test)constructor.newInstance("simpleDistinctTest"));
            suite.addTest((Test)constructor.newInstance("simpleDistinctNullTest"));
            suite.addTest((Test)constructor.newInstance("simpleDistinctMultipleResultTest"));
            suite.addTest((Test)constructor.newInstance("simpleDoubleOrTest"));
            suite.addTest((Test)constructor.newInstance("simpleEqualsTest"));
            suite.addTest((Test)constructor.newInstance("simpleEqualsTestWithJoin"));
            suite.addTest((Test)constructor.newInstance("collectionMemberIdentifierEqualsTest"));
            suite.addTest((Test)constructor.newInstance("abstractSchemaIdentifierEqualsTest"));
            suite.addTest((Test)constructor.newInstance("abstractSchemaIdentifierNotEqualsTest"));
            suite.addTest((Test)constructor.newInstance("simpleInOneDotTest"));
            suite.addTest((Test)constructor.newInstance("simpleInTest"));
            suite.addTest((Test)constructor.newInstance("simpleInListTest"));
            suite.addTest((Test)constructor.newInstance("simpleLengthTest"));
            suite.addTest((Test)constructor.newInstance("simpleLikeTest"));
            suite.addTest((Test)constructor.newInstance("simpleLikeTestWithParameter"));
            suite.addTest((Test)constructor.newInstance("simpleLikeEscapeTestWithParameter"));
            suite.addTest((Test)constructor.newInstance("simpleNotBetweenTest"));
            suite.addTest((Test)constructor.newInstance("simpleNotEqualsVariablesInteger"));
            suite.addTest((Test)constructor.newInstance("simpleNotInTest"));
            suite.addTest((Test)constructor.newInstance("simpleNotLikeTest"));
            suite.addTest((Test)constructor.newInstance("simpleOrFollowedByAndTest"));
            suite.addTest((Test)constructor.newInstance("simpleOrFollowedByAndTestWithStaticNames"));
            suite.addTest((Test)constructor.newInstance("simpleOrTest"));
            suite.addTest((Test)constructor.newInstance("simpleParameterTest"));
            suite.addTest((Test)constructor.newInstance("simpleParameterTestChangingParameters"));
            suite.addTest((Test)constructor.newInstance("simpleReverseAbsTest"));
            suite.addTest((Test)constructor.newInstance("simpleReverseConcatTest"));
            suite.addTest((Test)constructor.newInstance("simpleReverseEqualsTest"));
            suite.addTest((Test)constructor.newInstance("simpleReverseLengthTest"));
            suite.addTest((Test)constructor.newInstance("simpleReverseParameterTest"));
            suite.addTest((Test)constructor.newInstance("simpleReverseSqrtTest"));
            suite.addTest((Test)constructor.newInstance("simpleReverseSubstringTest"));
            suite.addTest((Test)constructor.newInstance("simpleSqrtTest"));
            suite.addTest((Test)constructor.newInstance("simpleSubstringTest"));
            suite.addTest((Test)constructor.newInstance("simpleNullTest"));
            suite.addTest((Test)constructor.newInstance("simpleNotNullTest"));
            suite.addTest((Test)constructor.newInstance("distinctTest"));
            suite.addTest((Test)constructor.newInstance("simpleModTest"));
            suite.addTest((Test)constructor.newInstance("simpleIsEmptyTest"));
            suite.addTest((Test)constructor.newInstance("simpleIsNotEmptyTest"));
            suite.addTest((Test)constructor.newInstance("simpleEscapeUnderscoreTest"));
            suite.addTest((Test)constructor.newInstance("simpleEnumTest"));
            suite.addTest((Test)constructor.newInstance("smallProjectMemberOfProjectsTest"));
            suite.addTest((Test)constructor.newInstance("smallProjectNOTMemberOfProjectsTest"));
            suite.addTest((Test)constructor.newInstance("selectCountOneToOneTest"));
            suite.addTest((Test)constructor.newInstance("selectOneToOneTest"));
            suite.addTest((Test)constructor.newInstance("selectPhonenumberDeclaredInINClauseTest"));
            suite.addTest((Test)constructor.newInstance("selectPhoneUsingALLTest"));
            suite.addTest((Test)constructor.newInstance("selectSimpleMemberOfWithParameterTest"));
            suite.addTest((Test)constructor.newInstance("selectSimpleNotMemberOfWithParameterTest"));
            suite.addTest((Test)constructor.newInstance("selectSimpleBetweenWithParameterTest"));
            suite.addTest((Test)constructor.newInstance("selectSimpleInWithParameterTest"));
            suite.addTest((Test)constructor.newInstance("selectAverageQueryForByteColumnTest"));
            suite.addTest((Test)constructor.newInstance("multipleExecutionOfCriteriaQueryTest"));
            suite.addTest((Test)constructor.newInstance("simpleTypeTest"));
            suite.addTest((Test)constructor.newInstance("simpleAsOrderByTest"));
            suite.addTest((Test)constructor.newInstance("simpleCaseInWhereTest"));
            suite.addTest((Test)constructor.newInstance("simpleCaseInSelectTest"));
            suite.addTest((Test)constructor.newInstance("caseConditionInWhereTest"));
            suite.addTest((Test)constructor.newInstance("caseConditionInSelectTest"));
            suite.addTest((Test)constructor.newInstance("simpleCoalesceInWhereTest"));
            suite.addTest((Test)constructor.newInstance("simpleCoalesceInSelectTest"));
            suite.addTest((Test)constructor.newInstance("largeProjectCastTest"));
            suite.addTest((Test)constructor.newInstance("mapCastTest"));
            suite.addTest((Test)constructor.newInstance("oneToOneCastTest"));
            suite.addTest((Test)constructor.newInstance("testTupleQuery"));
            suite.addTest((Test)constructor.newInstance("testTupleIndexValidation"));
            suite.addTest((Test)constructor.newInstance("testTupleIndexTypeValidation"));
            suite.addTest((Test)constructor.newInstance("testTupleStringValidation"));
            suite.addTest((Test)constructor.newInstance("testTupleStringTypeValidation"));
            suite.addTest((Test)constructor.newInstance("testCriteriaBuilderTupleValidation"));
            suite.addTest((Test)constructor.newInstance("testCriteriaBuilderArrayValidation"));
            suite.addTest((Test)constructor.newInstance("testCriteriaBuilderConstructValidation"));
            suite.addTest((Test)constructor.newInstance("testLiteralValidation"));
            suite.addTest((Test)constructor.newInstance("testCompoundSelectionAliasValidation"));
            suite.addTest((Test)constructor.newInstance("testEmptyLeftJoinInCriteriaQuery"));
        }
        catch (Exception x) {
            JUnitCriteriaSimpleTestSuiteBase.fail((String)Helper.printStackTraceToString((Throwable)x));
        }
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        new InheritedTableManager().replaceTables((DatabaseSession)session);
        new InheritanceTableCreator().replaceTables((DatabaseSession)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParameterEqualsParameter() throws Exception {
        DatabasePlatform databasePlatform = JUnitTestCase.getServerSession().getPlatform();
        if (databasePlatform.isSymfoware()) {
            JUnitCriteriaSimpleTestSuiteBase.getServerSession().logMessage("Test testParameterEqualsParameter skipped for this platform, Symfoware doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 304897)");
            return;
        }
        if (databasePlatform.isMaxDB()) {
            JUnitCriteriaSimpleTestSuiteBase.getServerSession().logMessage("Test testParameterEqualsParameter skipped for this platform, MaxDB doesn't allow dynamic parameters on both sides of the equals operator at the same time. (bug 326962)");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            TypedQuery query = em.createQuery(qb.createQuery(Employee.class));
            List emps = query.getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertNotNull((Object)emps);
            int numRead = emps.size();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)qb.parameter(Integer.class, "arg1"), (javax.persistence.criteria.Expression)qb.parameter(Integer.class, "arg2")));
            query = em.createQuery(cq);
            query.setParameter("arg1", (Object)1);
            query.setParameter("arg2", (Object)1);
            emps = query.getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertNotNull((Object)emps);
            JUnitCriteriaSimpleTestSuiteBase.assertEquals((int)numRead, (int)emps.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void simpleJoinFetchTest() throws Exception {
        if (JUnitCriteriaSimpleTestSuiteBase.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        this.simpleJoinFetchTest(em);
    }

    public void simpleJoinFetchTest2() throws Exception {
        if (JUnitCriteriaSimpleTestSuiteBase.isOnServer()) {
            return;
        }
        JpaEntityManager em = (JpaEntityManager)this.createEntityManager();
        String ejbqlString = "SELECT e FROM Employee e";
        List result = em.createQuery(ejbqlString).getResultList();
        result.size();
        this.simpleJoinFetchTest(em);
    }

    public void simpleJoinFetchTest(JpaEntityManager em) throws Exception {
        em.createQuery("select e from Employee e left join fetch e.phoneNumbers").getResultList();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        this.wrapper.fetch(root, Attributes.Employee_phoneNumbers, JoinType.LEFT);
        List result = em.createQuery(cq).getResultList();
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(byteStream);
        stream.writeObject(result);
        stream.flush();
        byte[] arr = byteStream.toByteArray();
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
        ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
        List deserialResult = (List)inObjStream.readObject();
        for (Object aDeserialResult : deserialResult) {
            Employee emp = (Employee)aDeserialResult;
            emp.getPhoneNumbers().size();
        }
        ReportQuery reportQuery = new ReportQuery();
        reportQuery.setShouldReturnWithoutReportQueryResult(true);
        reportQuery.setReferenceClass(Employee.class);
        ExpressionBuilder builder = reportQuery.getExpressionBuilder();
        ArrayList<Expression> joins = new ArrayList<Expression>(1);
        joins.add(builder.anyOfAllowingNone("phoneNumbers"));
        reportQuery.addItem("emp", (Expression)builder, joins);
        Vector expectedResult = (Vector)em.getUnitOfWork().executeQuery((DatabaseQuery)reportQuery);
        if (!comparer.compareObjects(result, (Collection)expectedResult)) {
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("simpleJoinFetchTest Failed when using cache, collections do not match: " + result + " expected: " + expectedResult));
        }
        this.clearCache();
        em.clear();
        result = em.createQuery(cq).getResultList();
        byteStream = new ByteArrayOutputStream();
        stream = new ObjectOutputStream(byteStream);
        stream.writeObject(result);
        stream.flush();
        arr = byteStream.toByteArray();
        inByteStream = new ByteArrayInputStream(arr);
        inObjStream = new ObjectInputStream(inByteStream);
        deserialResult = (List)inObjStream.readObject();
        for (Object aDeserialResult : deserialResult) {
            Employee emp = (Employee)aDeserialResult;
            emp.getPhoneNumbers().size();
        }
        this.clearCache();
        expectedResult = (Vector)em.getUnitOfWork().executeQuery((DatabaseQuery)reportQuery);
        if (!comparer.compareObjects(result, (Collection)expectedResult)) {
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("simpleJoinFetchTest Failed when not using cache, collections do not match: " + result + " expected: " + expectedResult));
        }
    }

    public void executeSameCriteriaQueryWithJoinTwice() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        this.wrapper.fetch(root, Attributes.Employee_phoneNumbers, JoinType.LEFT);
        em.createQuery(cq).getResultList();
        em.createQuery(cq).getResultList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void baseTestCase() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Vector expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
            this.clearCache();
            List result = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class)).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Base Test Case Failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleABSTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(qb.abs(this.wrapper.get(root, Attributes.Employee_salary)), (Object)expectedResult.getSalary()));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"ABS test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleBetweenTest() {
        BigDecimal empId = new BigDecimal(0);
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).lastElement();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression whereClause = builder.get("id").between((Object)empId, (Object)employee.getId());
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(Employee.class);
            raq.setSelectionCriteria(whereClause);
            Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.between(this.wrapper.get(root, Attributes.Employee_id), qb.literal((Object)empId), qb.literal((Object)employee.getId())));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Between test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleConcatTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            this.clearCache();
            String partOne = expectedResult.getFirstName().substring(0, 2);
            String partTwo = expectedResult.getFirstName().substring(2);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), qb.concat(qb.literal((Object)partOne), qb.literal((Object)partTwo))));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleConcatTestWithParameters() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            this.clearCache();
            String partOne = expectedResult.getFirstName().substring(0, 2);
            String partTwo = expectedResult.getFirstName().substring(2);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), qb.concat((javax.persistence.criteria.Expression)qb.parameter(String.class, "partOne"), (javax.persistence.criteria.Expression)qb.parameter(String.class, "partTwo"))));
            TypedQuery query = em.createQuery(cq);
            query.setParameter("partOne", (Object)partOne).setParameter("partTwo", (Object)partTwo);
            List result = query.getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleConcatTestWithConstants1() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            String partOne = emp.getFirstName();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression whereClause = builder.get("firstName").concat((Object)"Smith").like(partOne + "Smith");
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(Employee.class);
            raq.setSelectionCriteria(whereClause);
            Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.like(qb.concat(this.wrapper.get(root, Attributes.Employee_firstName), qb.literal((Object)"Smith")), partOne + "Smith"));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Concat test with constraints failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCountTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(PhoneNumber.class);
        query.addCount("COUNT", new ExpressionBuilder().get("owner").get("id"), Long.class);
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.setName("selectPhoneNumbersAssociatedToEmployees");
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Long.class);
        Root<PhoneNumber> root = cq.from(PhoneNumber.class);
        cq.select((Selection)qb.count((javax.persistence.criteria.Expression)root.get(this.getEntityManagerFactory().getMetamodel().entity(PhoneNumber.class).getSingularAttribute("owner", Employee.class)).get(this.getEntityManagerFactory().getMetamodel().entity(Employee.class).getSingularAttribute("id", Integer.class))));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            System.out.println(" results are :" + result);
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Long.class);
            root = this.wrapper.from(cq, PhoneNumber.class);
            cq.select((Selection)qb.count(this.wrapper.get((Path)this.wrapper.get(root, Attributes.PhoneNumber_owner), Attributes.Employee_id)));
            result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Count test failed", (boolean)expectedResult.elementAt(0).equals(result.get(0)));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleThreeArgConcatTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            this.clearCache();
            String partOne = expectedResult.getFirstName().substring(0, 1);
            String partTwo = expectedResult.getFirstName().substring(1, 2);
            String partThree = expectedResult.getFirstName().substring(2);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), qb.concat(qb.literal((Object)partOne), qb.concat(qb.literal((Object)partTwo), qb.literal((Object)partThree)))));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.distinct(true);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            this.wrapper.fetch(root, Attributes.Employee_phoneNumbers, JoinType.INNER);
            List result = em.createQuery(cq).getResultList();
            HashSet<Employee> testSet = new HashSet<Employee>();
            for (Employee emp : result) {
                JUnitCriteriaSimpleTestSuiteBase.assertFalse((String)"Result was not distinct", (boolean)testSet.contains(emp));
                testSet.add(emp);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctNullTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)em.createQuery("SELECT e from Employee e").getResultList().get(0);
        String oldFirstName = emp.getFirstName();
        this.beginTransaction(em);
        try {
            emp = (Employee)em.find(Employee.class, (Object)emp.getId());
            emp.setFirstName(null);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(String.class);
            cq.distinct(true);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.select(this.wrapper.get(root, Attributes.Employee_firstName));
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_lastName), qb.literal((Object)emp.getLastName())));
            this.beginTransaction(em);
            try {
                List result = em.createQuery(cq).getResultList();
                JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Failed to return null value", (boolean)result.contains(null));
            }
            finally {
                this.rollbackTransaction(em);
            }
        }
        finally {
            try {
                this.beginTransaction(em);
                emp = (Employee)em.find(Employee.class, (Object)emp.getId());
                emp.setFirstName(oldFirstName);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDistinctMultipleResultTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createTupleQuery();
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            this.wrapper.join(root, Attributes.Employee_phoneNumbers);
            cq.distinct(true);
            cq.multiselect(new Selection[]{root, this.wrapper.get(root, Attributes.Employee_firstName)});
            List result = em.createQuery(cq).getResultList();
            HashSet<String> testSet = new HashSet<String>();
            for (Tuple row : result) {
                Employee emp = (Employee)row.get(0, Employee.class);
                String string = (String)row.get(1, String.class);
                String ids = "_" + emp.getId() + "_" + string;
                JUnitCriteriaSimpleTestSuiteBase.assertFalse((String)"Result was not distinct", (boolean)testSet.contains(ids));
                testSet.add(ids);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleDoubleOrTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(1);
            Employee emp3 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(2);
            this.clearCache();
            Vector<Employee> expectedResult = new Vector<Employee>();
            expectedResult.add(emp1);
            expectedResult.add(emp2);
            expectedResult.add(emp3);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            Predicate firstOr = qb.or((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_id), (Object)emp1.getId()), (javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_id), (Object)emp2.getId()));
            cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)firstOr, (javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_id), (Object)emp3.getId())));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Double OR test failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEqualsTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)expectedResult.getFirstName()));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Equals test failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEqualsTestWithJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression whereClause = builder.anyOf("managedEmployees").get("address").get("city").equal((Object)"Ottawa");
            Vector expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class, whereClause);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Join managedEmp = this.wrapper.join(this.wrapper.from(cq, Employee.class), Attributes.Employee_managedEmployees);
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get((Path)this.wrapper.get(managedEmp, Attributes.Employee_address), Attributes.Address_city), (Object)"Ottawa"));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Equals test with Join failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectionMemberIdentifierEqualsTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ExpressionBuilder employees = new ExpressionBuilder();
            Expression exp = employees.get("firstName").equal((Object)"Bob");
            exp = exp.and(employees.get("lastName").equal((Object)"Smith"));
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class, exp).firstElement();
            this.clearCache();
            PhoneNumber phoneNumber = (PhoneNumber)((Vector)expectedResult.getPhoneNumbers()).firstElement();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Join phones = this.wrapper.join(this.wrapper.from(cq, Employee.class), Attributes.Employee_phoneNumbers);
            cq.where((javax.persistence.criteria.Expression)qb.equal(phones, (javax.persistence.criteria.Expression)qb.parameter(PhoneNumber.class, "1")));
            List result = em.createQuery(cq).setParameter("1", (Object)phoneNumber).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"CollectionMemberIdentifierEqualsTest failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abstractSchemaIdentifierEqualsTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(root, (javax.persistence.criteria.Expression)qb.parameter(Employee.class, "1")));
            List result = em.createQuery(cq).setParameter("1", (Object)expectedResult).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"abstractSchemaIdentifierEqualsTest failed", (boolean)comparer.compareObjects((Object)expectedResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abstractSchemaIdentifierNotEqualsTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Vector expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
            this.clearCache();
            Employee emp = (Employee)expectedResult.firstElement();
            expectedResult.removeElementAt(0);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.notEqual(root, (javax.persistence.criteria.Expression)qb.parameter(Employee.class, "1")));
            List result = em.createQuery(cq).setParameter("1", (Object)emp).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"abstractSchemaIdentifierNotEqualsTest failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInOneDotTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            ReadObjectQuery roq = new ReadObjectQuery(Employee.class);
            ExpressionBuilder empBldr = new ExpressionBuilder();
            Expression exp1 = empBldr.get("firstName").equal((Object)"Bob");
            Expression exp2 = empBldr.get("lastName").equal((Object)"Smith");
            roq.setSelectionCriteria(exp1.and(exp2));
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)roq);
            this.clearCache();
            PhoneNumber empPhoneNumbers = (PhoneNumber)((Vector)expectedResult.getPhoneNumbers()).firstElement();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            Join phone = this.wrapper.join(root, Attributes.Employee_phoneNumbers);
            Predicate firstAnd = qb.and((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(phone, Attributes.PhoneNumber_areaCode), (Object)empPhoneNumbers.getAreaCode()), (javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)expectedResult.getFirstName()));
            cq.where((javax.persistence.criteria.Expression)qb.and((javax.persistence.criteria.Expression)firstAnd, (javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_lastName), (Object)expectedResult.getLastName())));
            Employee result = (Employee)em.createQuery(cq).getSingleResult();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple In Dot Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAverageQueryForByteColumnTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Double.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.select((Selection)qb.avg(this.wrapper.get(root, Attributes.Employee_salary)));
            Object result = em.createQuery(cq).getSingleResult();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)("AVG result type [" + result.getClass() + "] not of type Double"), (result.getClass() == Double.class ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.in(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_id)).value((Object)expectedResult.getId()));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple In Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleInListTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            ArrayList<Integer> expectedResultList = new ArrayList<Integer>();
            expectedResultList.add(expectedResult.getId());
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((javax.persistence.criteria.Expression)this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_id).in(new javax.persistence.criteria.Expression[]{qb.parameter(List.class, "result")}));
            List result = em.createQuery(cq).setParameter("result", expectedResultList).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple In Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLengthTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSQLServer()) {
            JUnitCriteriaSimpleTestSuiteBase.getServerSession().logMessage("Warning SQL doesnot support LENGTH function");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(qb.length(this.wrapper.get(root, Attributes.Employee_firstName)), (Object)expectedResult.getFirstName().length()));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Length Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLikeTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            this.clearCache();
            String partialFirstName = expectedResult.getFirstName().substring(0, 3) + "%";
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.like(this.wrapper.get(root, Attributes.Employee_firstName), partialFirstName));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Like Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLikeTestWithParameter() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            String partialFirstName = "%" + emp.getFirstName().substring(0, 3) + "%";
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(Employee.class);
            ExpressionBuilder eb = new ExpressionBuilder();
            Expression whereClause = eb.get("firstName").like(partialFirstName);
            raq.setSelectionCriteria(whereClause);
            Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.like(this.wrapper.get(root, Attributes.Employee_firstName), (javax.persistence.criteria.Expression)qb.parameter(String.class, "1")));
            List result = em.createQuery(cq).setParameter("1", (Object)partialFirstName).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Like Test with Parameter failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleLikeEscapeTestWithParameter() {
        Character escChar;
        String patternString;
        EntityManager em = this.createEntityManager();
        Address expectedResult = new Address();
        expectedResult.setCity("TAIYUAN");
        expectedResult.setCountry("CHINA");
        expectedResult.setProvince("SHANXI");
        expectedResult.setPostalCode("030024");
        expectedResult.setStreet("234 RUBY _Way");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)expectedResult);
        uow.commit();
        uow.release();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Address.class);
        Root<Address> root = this.wrapper.from(cq, Address.class);
        cq.where((javax.persistence.criteria.Expression)qb.like(this.wrapper.get(root, Attributes.Address_street), (javax.persistence.criteria.Expression)qb.parameter(String.class, "pattern"), (javax.persistence.criteria.Expression)qb.parameter(Character.class, "esc")));
        if (JUnitCriteriaSimpleTestSuiteBase.getServerSession().getPlatform().isMySQL()) {
            patternString = "234 RUBY $_Way";
            escChar = Character.valueOf('$');
        } else {
            patternString = "234 RUBY \\_Way";
            escChar = Character.valueOf('\\');
        }
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("pattern", (Object)patternString).setParameter("esc", (Object)escChar).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Escape Underscore test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotBetweenTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
            Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).lastElement();
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(Employee.class);
            ExpressionBuilder eb = new ExpressionBuilder();
            Expression whereClause = eb.get("id").between((Object)emp1.getId(), (Object)emp2.getId()).not();
            raq.setSelectionCriteria(whereClause);
            Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.not((javax.persistence.criteria.Expression)qb.between(this.wrapper.get(root, Attributes.Employee_id), (Comparable)emp1.getId(), (Comparable)emp2.getId())));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Not Between Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotEqualsVariablesInteger() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Vector expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
            this.clearCache();
            Employee emp = (Employee)expectedResult.elementAt(0);
            expectedResult.removeElementAt(0);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.notEqual(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_id), (Object)emp.getId()));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Like Test with Parameter failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotInTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            ExpressionBuilder builder = new ExpressionBuilder();
            Vector<Integer> idVector = new Vector<Integer>();
            idVector.add(emp.getId());
            Expression whereClause = builder.get("id").notIn(idVector);
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(Employee.class);
            raq.setSelectionCriteria(whereClause);
            Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.not((javax.persistence.criteria.Expression)qb.in(this.wrapper.get(root, Attributes.Employee_id)).value((Object)emp.getId())));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Not In Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotLikeTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
            String partialFirstName = emp.getFirstName().substring(0, 3) + "%";
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression whereClause = builder.get("firstName").notLike(partialFirstName);
            ReadAllQuery raq = new ReadAllQuery();
            raq.setReferenceClass(Employee.class);
            raq.setSelectionCriteria(whereClause);
            Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
            this.clearCache();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root<Employee> root = this.wrapper.from(cq, Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.notLike(this.wrapper.get(root, Attributes.Employee_firstName), partialFirstName));
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Not Like Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleOrFollowedByAndTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Employee emp3 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(2);
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        Predicate andOpp = qb.and((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_id), (Object)emp2.getId()), (javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_id), (Object)emp3.getId()));
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_id), (Object)emp1.getId()), (javax.persistence.criteria.Expression)andOpp));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Or followed by And Test failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleOrFollowedByAndTestWithStaticNames() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal((Object)"John").or(builder.get("firstName").equal((Object)"Bob").and(builder.get("lastName").equal((Object)"Smith")));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        javax.persistence.criteria.Expression empFName = this.wrapper.get(root, Attributes.Employee_firstName);
        Predicate andOpp = qb.and((javax.persistence.criteria.Expression)qb.equal(empFName, (Object)"Bob"), (javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_lastName), (Object)"Smith"));
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)qb.equal(empFName, (Object)"John"), (javax.persistence.criteria.Expression)andOpp));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Or followed by And With Static Names Test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleOrTest() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(1);
        Vector<Employee> expectedResult = new Vector<Employee>();
        expectedResult.add(emp1);
        expectedResult.add(emp2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        javax.persistence.criteria.Expression empId = this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_id);
        cq.where((javax.persistence.criteria.Expression)qb.or((javax.persistence.criteria.Expression)qb.equal(empId, (Object)emp1.getId()), (javax.persistence.criteria.Expression)qb.equal(empId, (Object)emp2.getId())));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            this.clearCache();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Or Test failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(expectedResult.getFirstName());
        List employees = (List)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        employees.size();
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName), (javax.persistence.criteria.Expression)qb.parameter(String.class, parameterName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter(parameterName, (Object)expectedResult.getFirstName()).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Parameter Test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleParameterTestChangingParameters() {
        EntityManager em = this.createEntityManager();
        Employee emp1 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        Employee emp2 = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(1);
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> firstParameters = new Vector<String>();
        firstParameters.add(emp1.getFirstName());
        Vector<String> secondParameters = new Vector<String>();
        secondParameters.add(emp2.getFirstName());
        Vector firstEmployees = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq, firstParameters);
        this.clearCache();
        Vector secondEmployees = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq, secondParameters);
        this.clearCache();
        Vector expectedResult = new Vector();
        expectedResult.addAll(firstEmployees);
        expectedResult.addAll(secondEmployees);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName), (javax.persistence.criteria.Expression)qb.parameter(String.class, "1")));
        this.beginTransaction(em);
        try {
            List firstResultSet = em.createQuery(cq).setParameter("1", firstParameters.get(0)).getResultList();
            this.clearCache();
            List secondResultSet = em.createQuery(cq).setParameter("1", secondParameters.get(0)).getResultList();
            this.clearCache();
            Vector result = new Vector();
            result.addAll(firstResultSet);
            result.addAll(secondResultSet);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Parameter Test Changing Parameters failed", (boolean)comparer.compareObjects(result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseAbsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)expectedResult.getSalary()), qb.abs(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_salary))));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse Abs test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseConcatTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String partOne = expectedResult.getFirstName().substring(0, 2);
        String partTwo = expectedResult.getFirstName().substring(2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.concat(partOne, qb.literal((Object)partTwo)), this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse Concat test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseEqualsTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)expectedResult.getFirstName()), this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse Equals test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseLengthTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        javax.persistence.criteria.Expression length = qb.length(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)expectedResult.getFirstName().length()), length));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse Length test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String parameterName = "firstName";
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").equal(builder.getParameter(parameterName));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.addArgument(parameterName);
        Vector<String> parameters = new Vector<String>();
        parameters.add(emp.getFirstName());
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq, parameters);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)qb.parameter(String.class, "1"), this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", parameters.get(0)).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse Parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseSqrtTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitCriteriaSimpleTestSuiteBase.getServerSession().logMessage("Test simpleReverseSqrtTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause = expbldr.get("firstName").equal((Object)"SquareRoot").and(expbldr.get("lastName").equal((Object)"TestCase1"));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        double salarySquareRoot = Math.sqrt(((Employee)expectedResult.firstElement()).getSalary());
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        javax.persistence.criteria.Expression sqrt = qb.sqrt(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_salary));
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)salarySquareRoot), sqrt));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleReverseSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        javax.persistence.criteria.Expression substring = qb.substring(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName), 1, 2);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.literal((Object)firstNamePart), substring));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Reverse SubString test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleSqrtTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isSymfoware()) {
            JUnitCriteriaSimpleTestSuiteBase.getServerSession().logMessage("Test simpleSqrtTest skipped for this platform, Symfoware doesn't support SQRT, COS, SIN, TAN functions.");
            return;
        }
        EntityManager em = this.createEntityManager();
        ExpressionBuilder expbldr = new ExpressionBuilder();
        Expression whereClause = expbldr.get("firstName").equal((Object)"SquareRoot").and(expbldr.get("lastName").equal((Object)"TestCase1"));
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        double salarySquareRoot = Math.sqrt(((Employee)expectedResult.firstElement()).getSalary());
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.sqrt(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_salary)), (Object)salarySquareRoot));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Square Root test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleSubstringTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).elementAt(0);
        this.clearCache();
        String firstNamePart = expectedResult.getFirstName().substring(0, 2);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        javax.persistence.criteria.Expression substring = qb.substring(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName), 1, 2);
        cq.where((javax.persistence.criteria.Expression)qb.equal(substring, (Object)firstNamePart));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple SubString test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNullTest() {
        EntityManager em = this.createEntityManager();
        Employee nullEmployee = new Employee();
        nullEmployee.setFirstName(null);
        nullEmployee.setLastName("Test");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)nullEmployee);
        uow.commit();
        uow.release();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNull(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName)));
        List result = null;
        this.beginTransaction(em);
        try {
            result = em.createQuery(cq).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)nullEmployee);
        uow.commit();
        uow.release();
        JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Null test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleNotNullTest() {
        EntityManager em = this.createEntityManager();
        Employee nullEmployee = new Employee();
        nullEmployee.setFirstName(null);
        nullEmployee.setLastName("Test");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)nullEmployee);
        uow.commit();
        uow.release();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.get("firstName").isNull().not();
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotNull(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_firstName)));
        List result = null;
        this.beginTransaction(em);
        try {
            result = em.createQuery(cq).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)nullEmployee);
        uow.commit();
        uow.release();
        JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Not Null test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distinctTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = employee.get("lastName").equal((Object)"Smith");
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        raq.useDistinct();
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.distinct(true);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_lastName), (Object)"Smith"));
        List result = null;
        this.beginTransaction(em);
        try {
            result = em.createQuery(cq).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Distinct test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multipleExecutionOfCriteriaQueryTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get((Path)this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_address), Attributes.Address_postalCode), (javax.persistence.criteria.Expression)qb.parameter(String.class, "postalCode")));
            TypedQuery query = em.createQuery(cq);
            query.setParameter("postalCode", (Object)"K1T3B9");
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuiteBase.fail((String)"Failed to execute query, exception resulted on first execution, not expected");
            }
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuiteBase.fail((String)"Failed to execute query, exception resulted on second execution");
            }
            query = em.createNamedQuery("findEmployeeByPostalCode", Employee.class);
            query.setParameter("postalCode", (Object)"K1T3B9");
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuiteBase.fail((String)"Failed to execute query, exception resulted on first execution, of second use of named query");
            }
            query.setMaxResults(100000);
            try {
                query.getResultList();
            }
            catch (RuntimeException ex) {
                JUnitCriteriaSimpleTestSuiteBase.fail((String)"Failed to execute query, exception resulted after setting max results (forcing reprepare)");
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleModTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery raq = new ReadAllQuery();
        ExpressionBuilder employee = new ExpressionBuilder();
        Expression whereClause = ExpressionMath.mod((Expression)employee.get("salary"), (int)2).greaterThan(0);
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.gt(qb.mod(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_salary), Integer.valueOf(2)), (Number)0));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Mod test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
            expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
            this.clearCache();
            qb = em.getCriteriaBuilder();
            cq = qb.createQuery(Employee.class);
            javax.persistence.criteria.Expression salaryExp = this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_salary);
            cq.where((javax.persistence.criteria.Expression)qb.equal(qb.mod(salaryExp, salaryExp), (Object)0));
            result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Mod test(2) failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleIsEmptyTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.isEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isEmpty(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_phoneNumbers)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Is empty test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleIsNotEmptyTest() {
        EntityManager em = this.createEntityManager();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression whereClause = builder.notEmpty("phoneNumbers");
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotEmpty(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_phoneNumbers)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple is not empty test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEscapeUnderscoreTest() {
        EntityManager em = this.createEntityManager();
        Address expectedResult = new Address();
        expectedResult.setCity("Perth");
        expectedResult.setCountry("Canada");
        expectedResult.setProvince("ONT");
        expectedResult.setPostalCode("Y3Q2N9");
        expectedResult.setStreet("234 Wandering _Way");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        uow.registerObject((Object)expectedResult);
        uow.commit();
        uow.release();
        Character escapeChar = JUnitCriteriaSimpleTestSuiteBase.getServerSession().getPlatform().isMySQL() || JUnitCriteriaSimpleTestSuiteBase.getServerSession().getPlatform().isPostgreSQL() ? Character.valueOf('$') : Character.valueOf('\\');
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Address.class);
        cq.where((javax.persistence.criteria.Expression)qb.like(this.wrapper.get(this.wrapper.from(cq, Address.class), Attributes.Address_street), "234 Wandering " + escapeChar + "_Way", escapeChar.charValue()));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Escape Underscore test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void smallProjectMemberOfProjectsTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        Expression selectionCriteria = new ExpressionBuilder().anyOf("projects").equal((Expression)new ExpressionBuilder(SmallProject.class));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        query.dontUseDistinct();
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isMember(this.wrapper.from(cq, SmallProject.class), this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_projects)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple small Project Member Of Projects test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void smallProjectNOTMemberOfProjectsTest() {
        EntityManager em = this.createEntityManager();
        ReadObjectQuery smallProjectQuery = new ReadObjectQuery();
        smallProjectQuery.setReferenceClass(SmallProject.class);
        smallProjectQuery.setSelectionCriteria(new ExpressionBuilder().get("name").equal((Object)"Enterprise"));
        SmallProject smallProject = (SmallProject)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)smallProjectQuery);
        ReadAllQuery query = new ReadAllQuery();
        query.addArgument("smallProject");
        Expression selectionCriteria = new ExpressionBuilder().noneOf("projects", new ExpressionBuilder().equal(new ExpressionBuilder().getParameter("smallProject")));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        Vector<SmallProject> arguments = new Vector<SmallProject>();
        arguments.add(smallProject);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query, arguments);
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotMember((javax.persistence.criteria.Expression)qb.parameter(Project.class, "1"), this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_projects)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)smallProject).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple small Project NOT Member Of Projects test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectCountOneToOneTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(PhoneNumber.class);
        query.addCount("COUNT", new ExpressionBuilder().get("owner").distinct(), Long.class);
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.setName("selectEmployeesThatHavePhoneNumbers");
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Long.class);
        cq.select((Selection)qb.countDistinct(this.wrapper.get(this.wrapper.from(cq, PhoneNumber.class), Attributes.PhoneNumber_owner)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Select Count One To One test failed", (boolean)expectedResult.elementAt(0).equals(result.get(0)));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectOneToOneTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Address.class);
        query.useDistinct();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression selectionCriteria = new ExpressionBuilder(Address.class).equal(employeeBuilder.get("address")).and(employeeBuilder.get("lastName").like("%Way%"));
        query.setSelectionCriteria(selectionCriteria);
        if (JUnitCriteriaSimpleTestSuiteBase.usesSOP() && JUnitCriteriaSimpleTestSuiteBase.getServerSession().getPlatform().isOracle()) {
            query.setShouldUseSerializedObjectPolicy(false);
        }
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Address.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        cq.distinct(true);
        cq.select(this.wrapper.get(root, Attributes.Employee_address));
        cq.where((javax.persistence.criteria.Expression)qb.like(this.wrapper.get(root, Attributes.Employee_lastName), "%Way%"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple Select One To One test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPhonenumberDeclaredInINClauseTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        Expression phoneAnyOf = employeeBuilder.anyOf("phoneNumbers");
        ExpressionBuilder phoneBuilder = new ExpressionBuilder(PhoneNumber.class);
        Expression selectionCriteria = phoneBuilder.equal(employeeBuilder.anyOf("phoneNumbers")).and(phoneAnyOf.get("number").notNull());
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(PhoneNumber.class);
        query.addAscendingOrdering("number");
        query.addAscendingOrdering("areaCode");
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(PhoneNumber.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        Join phone = this.wrapper.join(root, Attributes.Employee_phoneNumbers);
        cq.select(phone);
        cq.where((javax.persistence.criteria.Expression)qb.isNotNull((javax.persistence.criteria.Expression)phone.get("number")));
        cq.orderBy(new Order[]{qb.asc((javax.persistence.criteria.Expression)phone.get("number")), qb.asc((javax.persistence.criteria.Expression)phone.get("areaCode"))});
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple select Phonenumber Declared In IN Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPhoneUsingALLTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        ExpressionBuilder employeeBuilder = new ExpressionBuilder(Employee.class);
        ReportQuery subQuery = new ReportQuery();
        subQuery.setReferenceClass(PhoneNumber.class);
        subQuery.addMinimum("number");
        Expression selectionCriteria = employeeBuilder.anyOf("phoneNumbers").get("number").equal(employeeBuilder.all(subQuery));
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        if (JUnitCriteriaSimpleTestSuiteBase.usesSOP() && JUnitCriteriaSimpleTestSuiteBase.getServerSession().getPlatform().isOracle()) {
            query.dontUseDistinct();
        }
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.distinct(true);
        Subquery sq = cq.subquery(Number.class);
        Root subroot = sq.from(PhoneNumber.class);
        sq.select(qb.min((javax.persistence.criteria.Expression)subroot.get("number")));
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        Join phone = this.wrapper.join(root, Attributes.Employee_phoneNumbers);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(phone, Attributes.PhoneNumber_number), qb.all(sq)));
        this.beginTransaction(em);
        try {
            TypedQuery jpqlQuery = em.createQuery(cq);
            jpqlQuery.setMaxResults(10);
            if (JUnitCriteriaSimpleTestSuiteBase.usesSOP() && JUnitCriteriaSimpleTestSuiteBase.getServerSession().getPlatform().isOracle()) {
                jpqlQuery.setHint("eclipselink.serialized-object", (Object)"false");
            }
            List result = jpqlQuery.getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple select Phonenumber Declared In IN Clause test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleMemberOfWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Employee expectedResult = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readObject(Employee.class);
        PhoneNumber phone = new PhoneNumber();
        phone.setAreaCode("613");
        phone.setNumber("1234567");
        phone.setType("cell");
        ServerSession serverSession = JUnitTestCase.getServerSession();
        ClientSession clientSession = serverSession.acquireClientSession();
        UnitOfWork uow = clientSession.acquireUnitOfWork();
        PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
        Employee empClone = (Employee)uow.registerObject((Object)expectedResult);
        phoneClone.setOwner(empClone);
        empClone.addPhoneNumber(phoneClone);
        uow.registerObject((Object)phone);
        uow.commit();
        uow.release();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isMember((javax.persistence.criteria.Expression)qb.parameter(PhoneNumber.class, "1"), this.wrapper.get(root, Attributes.Employee_phoneNumbers)));
        List result = null;
        this.beginTransaction(em);
        try {
            result = em.createQuery(cq).setParameter("1", (Object)phone).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        uow = clientSession.acquireUnitOfWork();
        uow.deleteObject((Object)phone);
        uow.commit();
        uow.release();
        JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Select simple member of with parameter test failed", (boolean)comparer.compareObjects((Object)result, expectedResult));
        this.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleNotMemberOfWithParameterTest() {
        PhoneNumber phone;
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
        this.clearCache();
        Employee emp = (Employee)expectedResult.get(0);
        expectedResult.remove(0);
        boolean shouldCleanUp = false;
        if (emp.getPhoneNumbers().isEmpty()) {
            phone = new PhoneNumber();
            phone.setAreaCode("613");
            phone.setNumber("1234567");
            phone.setType("cell");
            ServerSession serverSession = JUnitTestCase.getServerSession();
            ClientSession clientSession = serverSession.acquireClientSession();
            UnitOfWork uow = clientSession.acquireUnitOfWork();
            emp = (Employee)uow.readObject((Object)emp);
            PhoneNumber phoneClone = (PhoneNumber)uow.registerObject((Object)phone);
            emp.addPhoneNumber(phoneClone);
            if (JUnitCriteriaSimpleTestSuiteBase.usesSOP()) {
                phoneClone.setId(emp.getId());
            }
            uow.commit();
            uow.release();
            phone = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
            shouldCleanUp = true;
        } else {
            phone = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
        }
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.isNotMember((javax.persistence.criteria.Expression)qb.parameter(PhoneNumber.class, "1"), this.wrapper.get(root, Attributes.Employee_phoneNumbers)));
        List result = null;
        this.beginTransaction(em);
        try {
            result = em.createQuery(cq).setParameter("1", (Object)phone).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        boolean ok = comparer.compareObjects(result, (Collection)expectedResult);
        if (shouldCleanUp) {
            ServerSession serverSession = JUnitTestCase.getServerSession();
            ClientSession clientSession = serverSession.acquireClientSession();
            UnitOfWork uow = clientSession.acquireUnitOfWork();
            emp = (Employee)uow.readObject((Object)emp);
            PhoneNumber phoneToRemove = (PhoneNumber)emp.getPhoneNumbers().iterator().next();
            emp.removePhoneNumber(phoneToRemove);
            uow.deleteObject((Object)phoneToRemove);
            uow.commit();
            uow.release();
        }
        if (!ok) {
            JUnitCriteriaSimpleTestSuiteBase.fail((String)"unexpected query result");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleBetweenWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
        BigDecimal empId1 = new BigDecimal(0);
        Employee emp2 = (Employee)employees.lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("id").between((Object)empId1, (Object)emp2.getId());
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.between(this.wrapper.get(root, Attributes.Employee_id).as(Comparable.class), qb.parameter(BigDecimal.class, "1").as(Comparable.class), qb.parameter(Integer.class, "2").as(Comparable.class)));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)empId1).setParameter("2", (Object)emp2.getId()).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple select between with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectSimpleInWithParameterTest() {
        EntityManager em = this.createEntityManager();
        Vector employees = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class);
        BigDecimal empId1 = new BigDecimal(0);
        Employee emp2 = (Employee)employees.lastElement();
        ReadAllQuery raq = new ReadAllQuery();
        raq.setReferenceClass(Employee.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Vector<Number> vec = new Vector<Number>();
        vec.add(empId1);
        vec.add(emp2.getId());
        Expression whereClause = eb.get("id").in(vec);
        raq.setSelectionCriteria(whereClause);
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)raq);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        CriteriaBuilder.In inExp = qb.in(this.wrapper.get(root, Attributes.Employee_id));
        inExp.value((javax.persistence.criteria.Expression)qb.parameter(BigDecimal.class, "1"));
        inExp.value((javax.persistence.criteria.Expression)qb.parameter(Integer.class, "2"));
        cq.where((javax.persistence.criteria.Expression)inExp);
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).setParameter("1", (Object)empId1).setParameter("2", (Object)emp2.getId()).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Simple select between with parameter test failed", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleEnumTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(this.wrapper.from(cq, Employee.class), Attributes.Employee_status), (Object)Employee.EmployeeStatus.FULL_TIME));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            result.size();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleTypeTest() {
        EntityManager em = this.createEntityManager();
        Vector expectedResult = JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(LargeProject.class);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Project.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.from(cq, Project.class).type(), LargeProject.class));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"SimpleTypeTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleAsOrderByTest() {
        EntityManager em = this.createEntityManager();
        ReportQuery query = new ReportQuery();
        query.setReferenceClass(Employee.class);
        query.addItem("firstName", query.getExpressionBuilder().get("firstName"));
        query.returnSingleAttribute();
        query.dontRetrievePrimaryKeys();
        query.addOrdering(query.getExpressionBuilder().get("firstName").ascending());
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(String.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        cq.select(this.wrapper.get(root, Attributes.Employee_firstName));
        cq.orderBy(new Order[]{qb.asc(this.wrapper.get(root, Attributes.Employee_firstName))});
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"SimpleTypeTest", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCoalesceInWhereTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        cq.where((javax.persistence.criteria.Expression)qb.equal(qb.coalesce(this.wrapper.get(root, Attributes.Employee_firstName), this.wrapper.get(root, Attributes.Employee_lastName)), (Object)"Bob"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect number of results returned.", (result.size() == 1 ? 1 : 0) != 0);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect Employee returned", (boolean)((Employee)result.get(0)).getFirstName().equals("Bob"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCoalesceInSelectTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Object.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        CriteriaBuilder.Coalesce coalesce = qb.coalesce();
        coalesce.value(this.wrapper.get(root, Attributes.Employee_firstName));
        coalesce.value(this.wrapper.get(root, Attributes.Employee_lastName));
        coalesce.value((Object)"Bobby");
        cq.select((Selection)coalesce);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Bob"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect number of results returned.", (result.size() == 1 ? 1 : 0) != 0);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect Employee returned", (boolean)result.get(0).equals("Bob"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseConditionInWhereTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        CriteriaBuilder.Case selectCase = qb.selectCase();
        selectCase.when((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Bob"), (Object)"Robert");
        selectCase.when((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Rob"), (Object)"Robbie");
        selectCase.otherwise((Object)"Not Bob");
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)selectCase, (Object)"Robert"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect number of results returned.", (result.size() == 1 ? 1 : 0) != 0);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect Employee returned", (boolean)((Employee)result.get(0)).getFirstName().equals("Bob"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void caseConditionInSelectTest() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Object.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        CriteriaBuilder.Case selectCase = qb.selectCase();
        selectCase.when((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Bob"), (Object)"Robert");
        selectCase.when((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Rob"), (Object)"Robbie");
        selectCase.otherwise((Object)"Not Bob");
        cq.select((Selection)selectCase);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Bob"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect number of results returned.", (result.size() == 1 ? 1 : 0) != 0);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect Employee returned", (boolean)result.get(0).equals("Robert"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCaseInWhereTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            JUnitCriteriaSimpleTestSuiteBase.warning((String)"The test simpleCaseInWhereTest is not supported on Derby, because Derby does not support simple CASE");
            return;
        }
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Employee.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        CriteriaBuilder.SimpleCase selectCase = qb.selectCase(this.wrapper.get(root, Attributes.Employee_firstName));
        selectCase.otherwise((Object)"Not Bob");
        selectCase.when((Object)"Bob", (Object)"Robert");
        selectCase.when((Object)"Rob", (Object)"Robbie");
        cq.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)selectCase, (Object)"Robert"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect number of results returned.", (result.size() == 1 ? 1 : 0) != 0);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect Employee returned", (boolean)((Employee)result.get(0)).getFirstName().equals("Bob"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleCaseInSelectTest() {
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            JUnitCriteriaSimpleTestSuiteBase.warning((String)"The test simpleCaseInSelectTest is not supported on Derby, because Derby does not support simple CASE");
            return;
        }
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(Object.class);
        Root<Employee> root = this.wrapper.from(cq, Employee.class);
        CriteriaBuilder.SimpleCase selectCase = qb.selectCase(this.wrapper.get(root, Attributes.Employee_firstName));
        selectCase.when((Object)"Bob", (Object)"Robert");
        selectCase.when((Object)"Rob", (Object)"Robbie");
        selectCase.otherwise((Object)"Not Bob");
        cq.select((Selection)selectCase);
        cq.where((javax.persistence.criteria.Expression)qb.equal(this.wrapper.get(root, Attributes.Employee_firstName), (Object)"Bob"));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect number of results returned.", (result.size() == 1 ? 1 : 0) != 0);
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"Incorrect Employee returned", (boolean)result.get(0).equals("Robert"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void largeProjectCastTest() {
        EntityManager em = this.createEntityManager();
        ReadAllQuery query = new ReadAllQuery();
        Expression selectionCriteria = new ExpressionBuilder().anyOf("projects").treat(LargeProject.class).get("budget").equal(5000);
        query.setSelectionCriteria(selectionCriteria);
        query.setReferenceClass(Employee.class);
        query.dontUseDistinct();
        Vector expectedResult = (Vector)JUnitCriteriaSimpleTestSuiteBase.getServerSession().executeQuery((DatabaseQuery)query);
        this.clearCache();
        CriteriaBuilder qb1 = em.getCriteriaBuilder();
        CriteriaQuery cq1 = qb1.createQuery(Employee.class);
        Root<Employee> empRoot = this.wrapper.from(cq1, Employee.class);
        Join join = this.wrapper.join(empRoot, Attributes.Employee_projects);
        javax.persistence.criteria.Expression exp = this.wrapper.get((Path)join.as(LargeProject.class), Attributes.LargeProject_budget);
        cq1.where((javax.persistence.criteria.Expression)qb1.equal(exp, (Object)5000));
        this.beginTransaction(em);
        try {
            List result = em.createQuery(cq1).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"LargeProject cast failed.", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapCastTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            BeerConsumer bc1 = new BeerConsumer();
            bc1.setName("George");
            em.persist((Object)bc1);
            Blue blue = new Blue();
            blue.setUniqueKey(new BigInteger("1"));
            em.persist((Object)blue);
            bc1.addBlueBeerToConsume(blue);
            blue.setBeerConsumer(bc1);
            BeerConsumer bc2 = new BeerConsumer();
            bc2.setName("Scott");
            em.persist((Object)bc2);
            BlueLight blueLight = new BlueLight();
            blueLight.setDiscount(10);
            blueLight.setUniqueKey(new BigInteger("2"));
            em.persist((Object)blueLight);
            blueLight.setBeerConsumer(bc2);
            bc2.addBlueBeerToConsume((Blue)blueLight);
            em.flush();
            em.clear();
            this.clearCache();
            ReadAllQuery query = new ReadAllQuery();
            Expression selectionCriteria = new ExpressionBuilder().anyOf("blueBeersToConsume").treat(BlueLight.class).get("discount").equal(10);
            query.setSelectionCriteria(selectionCriteria);
            query.setReferenceClass(BeerConsumer.class);
            query.dontUseDistinct();
            Query jpaQuery = ((EntityManagerImpl)em.getDelegate()).createQuery((DatabaseQuery)query);
            List expectedResult = jpaQuery.getResultList();
            this.clearCache();
            em.clear();
            CriteriaBuilder qb1 = em.getCriteriaBuilder();
            CriteriaQuery cq1 = qb1.createQuery(BeerConsumer.class);
            Root<BeerConsumer> root = this.wrapper.from(cq1, BeerConsumer.class);
            Join join = this.wrapper.join(root, Attributes.BeerConsumer_blueBeersToConsume);
            javax.persistence.criteria.Expression exp = this.wrapper.get((Path)join.as(BlueLight.class), Attributes.BlueLight_discount);
            cq1.where((javax.persistence.criteria.Expression)qb1.equal(exp, (Object)10));
            List result = em.createQuery(cq1).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"LargeProject cast failed.", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneToOneCastTest() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Person rudy = new Person();
            rudy.setName("Rudy");
            em.persist((Object)rudy);
            SportsCar sportsCar = new SportsCar();
            sportsCar.setMaxSpeed(200);
            em.persist((Object)sportsCar);
            rudy.setCar((Car)sportsCar);
            Person theo = new Person();
            theo.setName("Theo");
            em.persist((Object)theo);
            Car car = new Car();
            em.persist((Object)car);
            theo.setCar(car);
            em.flush();
            em.clear();
            this.clearCache();
            ReadAllQuery query = new ReadAllQuery();
            Expression selectionCriteria = new ExpressionBuilder().get("car").treat(SportsCar.class).get("maxSpeed").equal(200);
            query.setSelectionCriteria(selectionCriteria);
            query.setReferenceClass(Person.class);
            query.dontUseDistinct();
            Query jpaQuery = ((EntityManagerImpl)em.getDelegate()).createQuery((DatabaseQuery)query);
            List expectedResult = jpaQuery.getResultList();
            this.clearCache();
            em.clear();
            CriteriaBuilder qb1 = em.getCriteriaBuilder();
            CriteriaQuery cq1 = qb1.createQuery(Person.class);
            Root<Person> root = this.wrapper.from(cq1, Person.class);
            Join join = this.wrapper.join(root, Attributes.Person_car);
            javax.persistence.criteria.Expression exp = this.wrapper.get((Path)join.as(SportsCar.class), Attributes.SportsCar_maxSpeed);
            cq1.where((javax.persistence.criteria.Expression)qb1.equal(exp, (Object)200));
            List result = em.createQuery(cq1).getResultList();
            JUnitCriteriaSimpleTestSuiteBase.assertTrue((String)"OneToOne cast failed.", (boolean)comparer.compareObjects(result, (Collection)expectedResult));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testTupleQuery() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(criteria, Employee.class);
        javax.persistence.criteria.Expression exp = this.wrapper.get(emp, Attributes.Employee_lastName);
        criteria.multiselect(new Selection[]{exp, qb.count(exp)});
        criteria.where((javax.persistence.criteria.Expression)qb.conjunction());
        criteria.groupBy(new javax.persistence.criteria.Expression[]{exp});
        TypedQuery query = em.createQuery(criteria);
        query.getResultList();
    }

    public void testTupleIndexValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(criteria, Employee.class);
        criteria.multiselect(new Selection[]{this.wrapper.get(emp, Attributes.Employee_lastName), this.wrapper.get(emp, Attributes.Employee_firstName)});
        TypedQuery query = em.createQuery(criteria);
        List list = query.getResultList();
        Tuple row = (Tuple)list.get(0);
        try {
            Object result = row.get(-1);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException not thrown when using index of -1 on a Tuple.  returned: " + result));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        try {
            row.get(2);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected. Array:" + Arrays.toString(row.toArray())));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
    }

    public void testTupleIndexTypeValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(criteria, Employee.class);
        criteria.multiselect(new Selection[]{this.wrapper.get(emp, Attributes.Employee_lastName), this.wrapper.get(emp, Attributes.Employee_firstName)});
        criteria.where((javax.persistence.criteria.Expression)qb.isNotNull(this.wrapper.get(emp, Attributes.Employee_firstName)));
        TypedQuery query = em.createQuery(criteria);
        List list = query.getResultList();
        Tuple row = (Tuple)list.get(0);
        row.get(0, String.class);
        try {
            Object result = row.get(1, Date.class);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using a Date to get a String. Result returned:" + result));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        try {
            row.get(2, Object.class);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected for index=2. Array:" + Arrays.toString(row.toArray())));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
    }

    public void testTupleStringValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(criteria, Employee.class);
        criteria.multiselect(new Selection[]{this.wrapper.get(emp, Attributes.Employee_lastName).alias("lastName"), this.wrapper.get(emp, Attributes.Employee_firstName)});
        TypedQuery query = em.createQuery(criteria);
        List list = query.getResultList();
        Tuple row = (Tuple)list.get(0);
        row.get("lastName");
        try {
            Object result = row.get("non-existing-name");
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value. Result returned:" + result));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
    }

    public void testTupleStringTypeValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(criteria, Employee.class);
        criteria.multiselect(new Selection[]{this.wrapper.get(emp, Attributes.Employee_lastName).alias("lastName"), this.wrapper.get(emp, Attributes.Employee_firstName).alias("firstName")});
        criteria.where((javax.persistence.criteria.Expression)qb.isNotNull(this.wrapper.get(emp, Attributes.Employee_firstName)));
        TypedQuery query = em.createQuery(criteria);
        List list = query.getResultList();
        Tuple row = (Tuple)list.get(0);
        row.get("lastName", String.class);
        try {
            Object result = row.get("firstName", Date.class);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value. Result returned:" + result));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        this.closeEntityManager(em);
    }

    public void testCriteriaBuilderTupleValidation() {
        CompoundSelection unexpectedResult;
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cquery = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(cquery, Employee.class);
        Selection[] s = new Selection[]{this.wrapper.get(emp, Attributes.Employee_id), this.wrapper.get(emp, Attributes.Employee_lastName), this.wrapper.get(emp, Attributes.Employee_firstName)};
        CompoundSelection item = qb.tuple(s);
        cquery.select((Selection)item);
        TypedQuery query = em.createQuery(cquery);
        List list = query.getResultList();
        list.get(0);
        try {
            unexpectedResult = qb.tuple(new Selection[]{item});
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value to CriteriaBuilder.tuple(). Result returned:" + unexpectedResult));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        try {
            unexpectedResult = qb.array(new Selection[]{item});
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value to CriteriaBuilder.array(). Result returned:" + unexpectedResult));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        this.closeEntityManager(em);
    }

    public void testCriteriaBuilderArrayValidation() {
        CompoundSelection unexpectedResult;
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cquery = qb.createQuery(Object[].class);
        Root<Employee> emp = this.wrapper.from(cquery, Employee.class);
        Selection[] s = new Selection[]{this.wrapper.get(emp, Attributes.Employee_id), this.wrapper.get(emp, Attributes.Employee_lastName), this.wrapper.get(emp, Attributes.Employee_firstName)};
        CompoundSelection item = qb.array(s);
        cquery.select((Selection)item);
        TypedQuery query = em.createQuery(cquery);
        List list = query.getResultList();
        list.get(0);
        try {
            unexpectedResult = qb.tuple(new Selection[]{item});
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value to CriteriaBuilder.tuple(). Result returned:" + unexpectedResult));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        try {
            unexpectedResult = qb.array(new Selection[]{item});
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value to CriteriaBuilder.array(). Result returned:" + unexpectedResult));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        this.closeEntityManager(em);
    }

    public void testCriteriaBuilderConstructValidation() {
        CompoundSelection unexpectedResult;
        EntityManager em = this.createEntityManager();
        Employee emp = (Employee)JUnitCriteriaSimpleTestSuiteBase.getServerSession().readAllObjects(Employee.class).firstElement();
        JUnitJPQLComplexTestSuite.EmployeeDetail expectedResult = new JUnitJPQLComplexTestSuite.EmployeeDetail(emp.getFirstName(), emp.getLastName());
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery cquery = qb.createQuery(JUnitJPQLComplexTestSuite.EmployeeDetail.class);
        Root<Employee> root = this.wrapper.from(cquery, Employee.class);
        Selection[] s = new Selection[]{this.wrapper.get(root, Attributes.Employee_firstName), this.wrapper.get(root, Attributes.Employee_lastName)};
        CompoundSelection item = qb.construct(JUnitJPQLComplexTestSuite.EmployeeDetail.class, s);
        cquery.select((Selection)item);
        cquery.where((javax.persistence.criteria.Expression)qb.equal((javax.persistence.criteria.Expression)root.get("id"), (Object)emp.getId()));
        TypedQuery query = em.createQuery(cquery);
        List list = query.getResultList();
        JUnitJPQLComplexTestSuite.EmployeeDetail result = (JUnitJPQLComplexTestSuite.EmployeeDetail)list.get(0);
        JUnitCriteriaSimpleTestSuiteBase.assertEquals((String)"Constructor criteria query Failed", (Object)expectedResult, (Object)result);
        try {
            unexpectedResult = qb.construct(JUnitJPQLComplexTestSuite.EmployeeDetail.class, new Selection[]{qb.array(s)});
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value to CriteriaBuilder.tuple(). Result returned:" + unexpectedResult));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        try {
            unexpectedResult = qb.construct(JUnitJPQLComplexTestSuite.EmployeeDetail.class, new Selection[]{qb.tuple(s)});
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected using an invalid value to CriteriaBuilder.tuple(). Result returned:" + unexpectedResult));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        this.closeEntityManager(em);
    }

    public void testLiteralValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        try {
            javax.persistence.criteria.Expression result = qb.literal(null);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)("IllegalArgumentException expected calling literal(null). Result returned:" + result));
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        this.closeEntityManager(em);
    }

    public void testCompoundSelectionAliasValidation() {
        EntityManager em = this.createEntityManager();
        CriteriaBuilder qb = em.getCriteriaBuilder();
        CriteriaQuery criteria = qb.createTupleQuery();
        Root<Employee> emp = this.wrapper.from(criteria, Employee.class);
        Selection[] s = new Selection[]{this.wrapper.get(emp, Attributes.Employee_lastName).alias("duplicateAlias"), this.wrapper.get(emp, Attributes.Employee_firstName).alias("duplicateAlias")};
        try {
            criteria.multiselect(s);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)"IllegalArgumentException expected using multiselect on items using duplicate aliases");
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        CompoundSelection tupleItem = qb.tuple(s);
        try {
            criteria.select((Selection)tupleItem);
            JUnitCriteriaSimpleTestSuiteBase.fail((String)"IllegalArgumentException expected on select using a Tuple with items using duplicate aliases");
        }
        catch (Exception iae) {
            JUnitCriteriaSimpleTestSuiteBase.assertEquals(iae.getClass(), IllegalArgumentException.class);
        }
        this.closeEntityManager(em);
    }

    public void testEmptyLeftJoinInCriteriaQuery() {
        EntityManager em = this.createEntityManager();
        TypedQuery q1 = em.createQuery("SELECT COUNT(hp.id) FROM HugeProject hp", Long.class);
        Long count = (Long)q1.getSingleResult();
        JUnitCriteriaSimpleTestSuiteBase.assertEquals((String)"There should be no HugeProject", (int)0, (int)count.intValue());
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(EntityDTO.class);
        Root<Employee> rootEmployee = this.wrapper.from(criteriaQuery, Employee.class);
        Join joinHugeProject = this.wrapper.join(rootEmployee, Attributes.Employee_hugeProject, JoinType.LEFT);
        criteriaQuery.select((Selection)builder.construct(EntityDTO.class, new Selection[]{rootEmployee, joinHugeProject}));
        TypedQuery query = em.createQuery(criteriaQuery);
        query.getResultList();
        this.closeEntityManager(em);
    }

    public static class EntityDTO {
        public EntityDTO(Employee employee, HugeProject hugeProject) {
        }
    }

    protected static interface CriteriaQueryWrapper {
        public <X, Y> Root<X> from(CriteriaQuery<Y> var1, Class<X> var2);

        public <X, Y> Fetch<X, Y> fetch(Root<X> var1, Attributes var2, JoinType var3);

        public <X, Y> javax.persistence.criteria.Expression<Y> get(Path<X> var1, Attributes var2);

        public <X, Y> Join<X, Y> join(Root<X> var1, Attributes var2);

        public <X, Y> Join<X, Y> join(Root<X> var1, Attributes var2, JoinType var3);
    }

    public static enum Attributes {
        Employee_id,
        Employee_firstName,
        Employee_lastName,
        Employee_salary,
        Employee_normalHours,
        Employee_phoneNumbers,
        Employee_managedEmployees,
        Employee_projects,
        Employee_address,
        Employee_status,
        Employee_hugeProject,
        PhoneNumber_number,
        PhoneNumber_areaCode,
        PhoneNumber_owner,
        Address_street,
        Address_postalCode,
        Address_city,
        LargeProject_budget,
        BeerConsumer_blueBeersToConsume,
        BlueLight_discount,
        Person_car,
        SportsCar_maxSpeed;

    }
}

