/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.jpa.JPAQuery;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.NamedPLSQLStoredProcedureQueryMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredFunctionCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class NamedPLSQLStoredFunctionQueryMetadata
extends NamedPLSQLStoredProcedureQueryMetadata {
    private PLSQLParameterMetadata returnParameter;

    public NamedPLSQLStoredFunctionQueryMetadata() {
        super("<named-plsql-stored-function-query>");
    }

    public NamedPLSQLStoredFunctionQueryMetadata(MetadataAnnotation namedStoredProcedureQuery, MetadataAccessor accessor) {
        super(namedStoredProcedureQuery, accessor);
        this.returnParameter = new PLSQLParameterMetadata(namedStoredProcedureQuery.getAttributeAnnotation("returnParameter"), accessor);
        this.setProcedureName(namedStoredProcedureQuery.getAttributeString("functionName"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof NamedPLSQLStoredFunctionQueryMetadata) {
            NamedPLSQLStoredFunctionQueryMetadata query = (NamedPLSQLStoredFunctionQueryMetadata)objectToCompare;
            return this.valuesMatch(this.returnParameter, query.getReturnParameter());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.returnParameter != null ? this.returnParameter.hashCode() : 0);
        return result;
    }

    public PLSQLParameterMetadata getReturnParameter() {
        return this.returnParameter;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.returnParameter, accessibleObject);
    }

    @Override
    public void process(AbstractSession session) {
        PLSQLStoredFunctionCall call = new PLSQLStoredFunctionCall();
        if (this.getReturnParameter() != null) {
            this.getReturnParameter().process((PLSQLStoredProcedureCall)call, true);
        }
        for (PLSQLParameterMetadata parameter : this.getParameters()) {
            parameter.process((PLSQLStoredProcedureCall)call, false);
        }
        call.setProcedureName(this.getProcedureName());
        JPAQuery query = new JPAQuery(this.getName(), (StoredProcedureCall)call, this.processQueryHints(session));
        if (!this.getResultClass().isVoid()) {
            query.setResultClassName(this.getJavaClassName(this.getResultClass()));
        } else if (this.hasResultSetMapping(session)) {
            query.addResultSetMapping(this.getResultSetMapping());
        }
        this.addJPAQuery(query, session);
    }

    public void setReturnParameter(PLSQLParameterMetadata returnParameter) {
        this.returnParameter = returnParameter;
    }
}

