/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.clientserver.EmployeeClient;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerConcurrentWriteTest
extends AutoVerifyTestCase {
    protected DatabaseLogin login;
    protected Vector clients = new Vector();
    protected Server server;
    public static int NUM_CLIENTS = 2;
    public Vector allSequenceNumbers = new Vector();

    public ClientServerConcurrentWriteTest() {
        this.setDescription("The test tests writing mutliple concurrent threads with pre-allocation");
    }

    public Vector getAllSequenceNumbers() {
        return this.allSequenceNumbers;
    }

    public Vector getClients() {
        if (this.clients == null) {
            this.setClients(new Vector());
        }
        return this.clients;
    }

    public void reset() {
        this.server.serverSession.rollbackTransaction();
        this.server.logout();
        this.stopThreads(this.getClients());
        this.setClients(new Vector());
    }

    public void setClients(Vector newClients) {
        this.clients = newClients;
    }

    public void setup() {
        this.login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.server = new Server(this.login);
        this.server.serverSession.getLogin().getDefaultSequence().setPreallocationSize(1);
        this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.server.login();
        this.server.copyDescriptors(this.getSession());
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            this.getClients().addElement(new EmployeeClient(this.server, this.getSession(), "EmployeeClient" + i, 25));
        }
        this.server.serverSession.beginTransaction();
    }

    public void startThreads(Vector threads) {
        Enumeration enumtr = threads.elements();
        while (enumtr.hasMoreElements()) {
            EmployeeClient thread = (EmployeeClient)enumtr.nextElement();
            thread.start();
        }
    }

    public void stopThreads(Vector threads) {
        Enumeration enumtr = threads.elements();
        while (enumtr.hasMoreElements()) {
            EmployeeClient thread = (EmployeeClient)enumtr.nextElement();
            thread.pleaseStop();
        }
    }

    public void test() {
        this.startThreads(this.getClients());
        this.waitForThreads(this.getClients());
    }

    public void verify() {
        Enumeration enumtr = this.getClients().elements();
        while (enumtr.hasMoreElements()) {
            EmployeeClient thread = (EmployeeClient)enumtr.nextElement();
            if (thread.anErrorOccurred()) {
                throw new TestErrorException("An exception " + thread.getTestException() + " occurred in client " + thread.toString());
            }
            Enumeration sequences = thread.getSequenceNumbers().elements();
            while (sequences.hasMoreElements()) {
                Object sequence = sequences.nextElement();
                if (this.getAllSequenceNumbers().contains(sequence)) {
                    this.setClients(new Vector());
                    throw new TestErrorException("A duplicate sequence number has been detected -> " + sequence);
                }
                this.getAllSequenceNumbers().addElement(sequence);
            }
        }
    }

    public void waitForThreads(Vector threads) {
        Enumeration enumtr = threads.elements();
        while (enumtr.hasMoreElements()) {
            try {
                ((Thread)enumtr.nextElement()).join();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.stopThreads(this.getClients());
                throw new TestErrorException("Client:" + this.toString() + "caught exception -> " + ex);
            }
        }
    }
}

