/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimisticlocking.cascaded;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.optimisticlocking.cascaded.Bar;

public class CascadedOptimisticLockingTest
extends AutoVerifyTestCase {
    protected int m_id;
    protected int m_originalVersion;

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    protected void verify() {
        Expression readExpression = new ExpressionBuilder().get("id").equal(this.m_id);
        Bar bar = (Bar)this.getSession().readObject(Bar.class, readExpression);
        if (bar.getVersion() <= this.m_originalVersion) {
            throw new TestErrorException("The parent version lock field was not updated in the cache.");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        bar = (Bar)this.getSession().readObject(Bar.class, readExpression);
        if (bar.getVersion() <= this.m_originalVersion) {
            throw new TestErrorException("The parent version lock field was not updated in the database.");
        }
    }
}

