/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.StupidRedirector;

public class RedirectQueryOnUOWTest
extends TestCase {
    Exception m_exceptionCaught;

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.m_exceptionCaught = null;
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        ReadAllQuery r = new ReadAllQuery(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Jill"));
        r.setRedirector((QueryRedirector)new StupidRedirector());
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        try {
            Vector vector = (Vector)uow.executeQuery((DatabaseQuery)r);
        }
        catch (NullPointerException e) {
            this.m_exceptionCaught = e;
        }
    }

    protected void verify() {
        if (this.m_exceptionCaught != null) {
            throw new TestErrorException("NullPointerException was thrown when executing a query with a redirect", (Throwable)this.m_exceptionCaught);
        }
    }
}

