/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;

public class JavaFieldImpl
implements JavaField {
    protected Field jField;
    private JavaModelImpl javaModelImpl;
    protected boolean isMetadataComplete;

    public JavaFieldImpl(Field javaField, JavaModelImpl javaModelImpl) {
        this(javaField, javaModelImpl, false);
    }

    public JavaFieldImpl(Field javaField, JavaModelImpl javaModelImpl, Boolean isMetadataComplete) {
        this.jField = javaField;
        this.javaModelImpl = javaModelImpl;
        if (isMetadataComplete != null) {
            this.isMetadataComplete = isMetadataComplete;
        }
    }

    @Override
    public JavaAnnotation getAnnotation(JavaClass arg0) {
        if (arg0 != null && !this.isMetadataComplete) {
            Class annotationClass = ((JavaClassImpl)arg0).getJavaClass();
            if (this.javaModelImpl.getAnnotationHelper().isAnnotationPresent(this.getAnnotatedElement(), annotationClass)) {
                return new JavaAnnotationImpl(this.javaModelImpl.getAnnotationHelper().getAnnotation(this.getAnnotatedElement(), annotationClass));
            }
        }
        return null;
    }

    @Override
    public Collection getAnnotations() {
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        if (!this.isMetadataComplete) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = this.javaModelImpl.getAnnotationHelper().getAnnotations(this.getAnnotatedElement())) {
                annotationCollection.add(new JavaAnnotationImpl(annotation));
            }
        }
        return annotationCollection;
    }

    @Override
    public int getModifiers() {
        return this.jField.getModifiers();
    }

    @Override
    public String getName() {
        return this.jField.getName();
    }

    public JavaClass getOwningClass() {
        return this.javaModelImpl.getClass(this.jField.getDeclaringClass());
    }

    @Override
    public JavaClass getResolvedType() {
        Class<?> fieldType = this.jField.getType();
        Type genericType = this.jField.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)genericType;
            return new JavaClassImpl(pType, (Class)pType.getRawType(), this.javaModelImpl);
        }
        return this.javaModelImpl.getClass(fieldType);
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public boolean isSynthetic() {
        return this.jField.isSynthetic();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.jField;
    }

    public Object get(Object obj) throws IllegalAccessException {
        return PrivilegedAccessHelper.getValueFromField(this.jField, obj);
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    @Override
    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isEnumConstant() {
        return this.jField.isEnumConstant();
    }

    @Override
    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    @Override
    public Collection getDeclaredAnnotations() {
        return null;
    }
}

