/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.kv.Operation;
import oracle.kv.OperationExecutionException;
import oracle.kv.OperationResult;
import oracle.kv.Value;
import oracle.kv.Version;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.ResultIndexKeys;
import oracle.kv.impl.api.ops.ResultIndexRows;
import oracle.kv.impl.api.ops.ResultKey;
import oracle.kv.impl.api.ops.ResultKeyValueVersion;
import oracle.kv.impl.api.ops.ResultValue;
import oracle.kv.impl.api.ops.ResultValueVersion;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldDefSerialization;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FieldValueSerialization;
import oracle.kv.impl.api.table.SequenceImpl;
import oracle.kv.impl.query.runtime.ResumeInfo;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

public abstract class Result
implements OperationResult,
FastExternalizable {
    private final int readKB;
    private final int writeKB;
    private final InternalOperation.OpCode opCode;
    private int metadataSeqNum;

    private Result(InternalOperation.OpCode op, int readKB, int writeKB) {
        this.opCode = op;
        assert (op.checkResultType(this)) : "Incorrect type " + this.getClass().getName() + " for " + op;
        this.readKB = readKB;
        this.writeKB = writeKB;
        this.metadataSeqNum = 0;
    }

    Result(InternalOperation.OpCode op, int readKB, int writeKB, DataInput in, short serialVersion) {
        this(op, readKB, writeKB);
    }

    public static Result readFastExternal(DataInput in, short serialVersion) throws IOException {
        InternalOperation.OpCode op = InternalOperation.OpCode.readFastExternal(in, serialVersion);
        int readKB = 0;
        int writeKB = 0;
        if (serialVersion >= 16) {
            readKB = in.readInt();
            writeKB = in.readInt();
        }
        int seqNum = 0;
        if (serialVersion >= 16) {
            seqNum = in.readInt();
        }
        Result result = op.readResult(in, readKB, writeKB, serialVersion);
        if (serialVersion >= 16) {
            result.setMetadataSeqNum(seqNum);
        }
        return result;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        this.opCode.writeFastExternal(out, serialVersion);
        if (serialVersion >= 16) {
            out.writeInt(this.readKB);
            out.writeInt(this.writeKB);
        }
        if (serialVersion >= 16) {
            out.writeInt(this.metadataSeqNum);
        }
    }

    @Override
    public abstract boolean getSuccess();

    public int getReadKB() {
        return this.readKB;
    }

    public int getWriteKB() {
        return this.writeKB;
    }

    public void setMetadataSeqNum(int seqNum) {
        this.metadataSeqNum = seqNum;
    }

    public int getMetadataSeqNum() {
        return this.metadataSeqNum;
    }

    public byte[] getPrimaryResumeKey() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a primary resume key");
    }

    public byte[] getSecondaryResumeKey() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a secondary resume key");
    }

    @Override
    public Value getPreviousValue() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a Value");
    }

    @Override
    public Version getPreviousVersion() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a previous Version");
    }

    @Override
    public Version getNewVersion() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a new Version");
    }

    @Override
    public long getNewExpirationTime() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an expiration time");
    }

    @Override
    public long getPreviousExpirationTime() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a previous expiration time");
    }

    public int getNDeletions() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a boolean");
    }

    public OperationExecutionException getExecuteException(List<Operation> ops) {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an OperationExecutionException");
    }

    public List<OperationResult> getExecuteResult() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ExecuteResult");
    }

    public List<ResultKeyValueVersion> getKeyValueVersionList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultKeyValueVersion list");
    }

    public List<ResultKey> getKeyList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a key list");
    }

    public List<ResultIndexKeys> getIndexKeyList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultIndexKeys list");
    }

    public List<ResultIndexRows> getIndexRowList() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a ResultIndexRows list");
    }

    public List<FieldValueImpl> getQueryResults() {
        throw new IllegalStateException("result of type: " + this.getClass() + " is not a query result");
    }

    public boolean hasMoreElements() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain an iteration result");
    }

    public int getResumeParentKeyIndex() {
        throw new IllegalStateException("result of type: " + this.getClass() + " does not contain a resume parent key index");
    }

    public int getNumRecords() {
        return 1;
    }

    public String toString() {
        return "Result[" + this.opCode + " numRecords=" + this.getNumRecords() + " readKB=" + this.readKB + " writeKB=" + this.writeKB + "]";
    }

    static void writeExpirationTime(DataOutput out, long expirationTime, short serialVersion) throws IOException {
        if (serialVersion >= 10) {
            if (expirationTime == 0L) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeLong(expirationTime);
            }
        }
    }

    static long readExpirationTime(DataInput in, short serialVersion) throws IOException {
        if (serialVersion >= 10 && in.readBoolean()) {
            return in.readLong();
        }
        return 0L;
    }

    public static class GetIdentityResult
    extends Result {
        private final SequenceImpl.SGAttrsAndValues attrsAndValues;

        GetIdentityResult(InternalOperation.OpCode op, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(op, readKB, writeKB, in, serialVersion);
            this.attrsAndValues = in.readByte() != 0 ? new SequenceImpl.SGAttrsAndValues(in, serialVersion) : null;
        }

        GetIdentityResult(InternalOperation.OpCode op, int readKB, int writeKB, SequenceImpl.SGAttrsAndValues attrsAndValues) {
            super(op, readKB, writeKB);
            this.attrsAndValues = attrsAndValues;
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.attrsAndValues);
        }

        @Override
        public boolean getSuccess() {
            return this.attrsAndValues != null;
        }

        public SequenceImpl.SGAttrsAndValues getSGAttrsAndValues() {
            return this.attrsAndValues;
        }
    }

    public static class QueryResult
    extends Result {
        private final List<FieldValueImpl> results;
        private final FieldDefImpl resultDef;
        private final boolean mayReturnNULL;
        private final boolean moreElements;
        private final ResumeInfo resumeInfo;
        private final boolean exceededSizeLimit;

        QueryResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<FieldValueImpl> results, FieldDefImpl resultDef, boolean mayReturnNULL, boolean moreElements, ResumeInfo resumeInfo, boolean exceededSizeLimit) {
            super(opCode, readKB, writeKB);
            if (moreElements && !exceededSizeLimit && resumeInfo.getPrimResumeKey() == null && resumeInfo.getSecResumeKey() == null) {
                throw new IllegalArgumentException("Most have resume key when more elements");
            }
            ObjectUtil.checkNull("results", results);
            for (FieldValueImpl element : results) {
                ObjectUtil.checkNull("results element", element);
            }
            ObjectUtil.checkNull("resultDef", resultDef);
            this.results = results;
            this.resultDef = resultDef;
            this.mayReturnNULL = mayReturnNULL;
            this.moreElements = moreElements;
            this.resumeInfo = resumeInfo;
            this.exceededSizeLimit = exceededSizeLimit;
        }

        QueryResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            try {
                FieldValueImpl val;
                int i;
                this.resultDef = FieldDefSerialization.readFieldDef(in, serialVersion);
                this.mayReturnNULL = serialVersion >= 12 ? in.readBoolean() : false;
                FieldDefImpl valDef = this.resultDef.isWildcard() ? null : this.resultDef;
                int listSize = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
                this.results = new ArrayList<FieldValueImpl>(listSize);
                if (this.mayReturnNULL) {
                    for (i = 0; i < listSize; ++i) {
                        val = (FieldValueImpl)FieldValueSerialization.readFieldValue(valDef, in, serialVersion);
                        this.results.add(val);
                    }
                } else {
                    for (i = 0; i < listSize; ++i) {
                        val = (FieldValueImpl)FieldValueSerialization.readNonNullFieldValue(valDef, null, in, serialVersion);
                        this.results.add(val);
                    }
                }
                this.moreElements = in.readBoolean();
                if (serialVersion >= 16) {
                    this.resumeInfo = new ResumeInfo(in, serialVersion);
                    this.exceededSizeLimit = in.readBoolean();
                } else if (this.moreElements) {
                    this.resumeInfo = new ResumeInfo(null);
                    this.resumeInfo.setNumResultsComputed(this.results.size());
                    if (serialVersion >= 15) {
                        this.resumeInfo.setCurrentIndexRange(in.readInt());
                    } else {
                        this.resumeInfo.setCurrentIndexRange(0);
                    }
                    if (serialVersion >= 14) {
                        this.resumeInfo.setPrimResumeKey(SerializationUtil.readByteArray(in));
                        this.resumeInfo.setSecResumeKey(SerializationUtil.readByteArray(in));
                    } else {
                        byte[] key;
                        short keyLen = in.readShort();
                        if (keyLen > 0) {
                            key = new byte[keyLen];
                            in.readFully(key);
                            this.resumeInfo.setPrimResumeKey(key);
                        } else {
                            this.resumeInfo.setPrimResumeKey(null);
                        }
                        keyLen = in.readShort();
                        if (keyLen > 0) {
                            key = new byte[keyLen];
                            in.readFully(key);
                            this.resumeInfo.setSecResumeKey(key);
                        } else {
                            this.resumeInfo.setSecResumeKey(null);
                        }
                    }
                    this.exceededSizeLimit = serialVersion >= 16 ? in.readBoolean() : false;
                } else {
                    this.resumeInfo = new ResumeInfo(null);
                    this.exceededSizeLimit = false;
                }
            }
            catch (IOException e) {
                System.out.println("Failed to deserialize result");
                e.printStackTrace();
                throw e;
            }
            catch (ClassCastException e) {
                System.out.println("Failed to deserialize result");
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            try {
                super.writeFastExternal(out, serialVersion);
                FieldDefSerialization.writeFieldDef(this.resultDef, out, serialVersion);
                if (serialVersion >= 12) {
                    out.writeBoolean(this.mayReturnNULL);
                }
                if (serialVersion >= 14) {
                    SerializationUtil.writeNonNullSequenceLength(out, this.results.size());
                } else {
                    out.writeInt(this.results.size());
                }
                boolean isWildcard = this.resultDef.isWildcard();
                if (this.mayReturnNULL) {
                    for (FieldValueImpl res : this.results) {
                        FieldValueSerialization.writeFieldValue(res, isWildcard, out, serialVersion);
                    }
                } else {
                    for (FieldValueImpl res : this.results) {
                        FieldValueSerialization.writeNonNullFieldValue(res, isWildcard, true, out, serialVersion);
                    }
                }
                out.writeBoolean(this.moreElements);
                if (serialVersion >= 16) {
                    if (!this.moreElements) {
                        this.resumeInfo.setCurrentIndexRange(0);
                    }
                    this.resumeInfo.writeFastExternal(out, serialVersion);
                    out.writeBoolean(this.exceededSizeLimit);
                } else if (this.moreElements) {
                    if (serialVersion >= 15) {
                        out.writeInt(this.resumeInfo.getCurrentIndexRange());
                    }
                    byte[] primKey = this.resumeInfo.getPrimResumeKey();
                    byte[] secKey = this.resumeInfo.getSecResumeKey();
                    if (serialVersion >= 14) {
                        SerializationUtil.writeByteArray(out, primKey);
                        SerializationUtil.writeByteArray(out, secKey);
                    } else {
                        if (primKey != null) {
                            out.writeShort(primKey.length);
                            out.write(primKey);
                        } else {
                            out.writeShort(0);
                        }
                        if (secKey != null) {
                            out.writeShort(secKey.length);
                            out.write(secKey);
                        } else {
                            out.writeShort(0);
                        }
                    }
                    if (serialVersion >= 16) {
                        out.writeBoolean(this.exceededSizeLimit);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Failed to serialize result");
                e.printStackTrace();
                throw e;
            }
            catch (ClassCastException e) {
                System.out.println("Failed to deserialize result");
                e.printStackTrace();
                throw e;
            }
        }

        @Override
        public boolean getSuccess() {
            return this.results.size() > 0;
        }

        @Override
        public List<FieldValueImpl> getQueryResults() {
            return this.results;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.results.size();
        }

        public ResumeInfo getResumeInfo() {
            return this.resumeInfo;
        }

        public boolean getExceededSizeLimit() {
            return this.exceededSizeLimit;
        }
    }

    static class BulkGetKeysIterateResult
    extends KeysIterateResult {
        private final int resumeParentKeyIndex;

        BulkGetKeysIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<ResultKey> elements, boolean moreElements, int lastParentKeyIndex) {
            super(opCode, readKB, writeKB, elements, moreElements);
            this.resumeParentKeyIndex = lastParentKeyIndex;
        }

        BulkGetKeysIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            this.resumeParentKeyIndex = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.resumeParentKeyIndex);
        }

        @Override
        public int getResumeParentKeyIndex() {
            return this.resumeParentKeyIndex;
        }
    }

    static class BulkGetIterateResult
    extends IterateResult {
        private final int resumeParentKeyIndex;

        BulkGetIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<ResultKeyValueVersion> elements, boolean moreElements, int resumeParentKeyIndex) {
            super(opCode, readKB, writeKB, elements, moreElements);
            this.resumeParentKeyIndex = resumeParentKeyIndex;
        }

        BulkGetIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            this.resumeParentKeyIndex = in.readInt();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.resumeParentKeyIndex);
        }

        @Override
        public int getResumeParentKeyIndex() {
            return this.resumeParentKeyIndex;
        }
    }

    static class IndexRowsIterateResult
    extends Result {
        private final List<ResultIndexRows> elements;
        private final boolean moreElements;

        IndexRowsIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<ResultIndexRows> elements, boolean moreElements) {
            super(opCode, readKB, writeKB);
            ObjectUtil.checkNull("elements", elements);
            for (ResultIndexRows element : elements) {
                ObjectUtil.checkNull("elements element", element);
            }
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IndexRowsIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            int listSize = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
            this.elements = new ArrayList<ResultIndexRows>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultIndexRows(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullCollection(out, serialVersion, this.elements);
            } else {
                out.writeInt(this.elements.size());
                for (ResultIndexRows elem : this.elements) {
                    elem.writeFastExternal(out, serialVersion);
                }
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultIndexRows> getIndexRowList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getKeyBytes();
        }

        @Override
        public byte[] getSecondaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getIndexKeyBytes();
        }
    }

    static class IndexKeysIterateResult
    extends Result {
        private final List<ResultIndexKeys> elements;
        private final boolean moreElements;

        IndexKeysIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<ResultIndexKeys> elements, boolean moreElements) {
            super(opCode, readKB, writeKB);
            ObjectUtil.checkNull("elements", elements);
            for (ResultIndexKeys element : elements) {
                ObjectUtil.checkNull("elements element", element);
            }
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IndexKeysIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            int listSize = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
            this.elements = new ArrayList<ResultIndexKeys>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultIndexKeys(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullCollection(out, serialVersion, this.elements);
            } else {
                out.writeInt(this.elements.size());
                for (ResultIndexKeys elem : this.elements) {
                    elem.writeFastExternal(out, serialVersion);
                }
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultIndexKeys> getIndexKeyList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getPrimaryKeyBytes();
        }

        @Override
        public byte[] getSecondaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getIndexKeyBytes();
        }
    }

    static class KeysIterateResult
    extends Result {
        private final List<ResultKey> elements;
        private final boolean moreElements;

        KeysIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<ResultKey> elements, boolean moreElements) {
            super(opCode, readKB, writeKB);
            ObjectUtil.checkNull("elements", elements);
            for (ResultKey element : elements) {
                ObjectUtil.checkNull("elements element", element);
            }
            this.elements = elements;
            this.moreElements = moreElements;
        }

        KeysIterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            int listSize = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
            this.elements = new ArrayList<ResultKey>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultKey(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullCollection(out, serialVersion, this.elements);
            } else {
                out.writeInt(this.elements.size());
                for (ResultKey rkey : this.elements) {
                    rkey.writeFastExternal(out, serialVersion);
                }
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultKey> getKeyList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getKeyBytes();
        }
    }

    static class IterateResult
    extends Result {
        private final List<ResultKeyValueVersion> elements;
        private final boolean moreElements;

        IterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<ResultKeyValueVersion> elements, boolean moreElements) {
            super(opCode, readKB, writeKB);
            ObjectUtil.checkNull("elements", elements);
            for (ResultKeyValueVersion element : elements) {
                ObjectUtil.checkNull("elements element", element);
            }
            this.elements = elements;
            this.moreElements = moreElements;
        }

        IterateResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            int listSize = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
            this.elements = new ArrayList<ResultKeyValueVersion>(listSize);
            for (int i = 0; i < listSize; ++i) {
                this.elements.add(new ResultKeyValueVersion(in, serialVersion));
            }
            this.moreElements = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullCollection(out, serialVersion, this.elements);
            } else {
                out.writeInt(this.elements.size());
                for (ResultKeyValueVersion elem : this.elements) {
                    elem.writeFastExternal(out, serialVersion);
                }
            }
            out.writeBoolean(this.moreElements);
        }

        @Override
        public boolean getSuccess() {
            return this.elements.size() > 0;
        }

        @Override
        public List<ResultKeyValueVersion> getKeyValueVersionList() {
            return this.elements;
        }

        @Override
        public boolean hasMoreElements() {
            return this.moreElements;
        }

        @Override
        public int getNumRecords() {
            return this.elements.size();
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            if (!this.moreElements || this.elements == null || this.elements.isEmpty()) {
                return null;
            }
            return this.elements.get(this.elements.size() - 1).getKeyBytes();
        }
    }

    public static class PutBatchResult
    extends Result {
        private int numKVPairs;
        private List<Integer> keysPresent;

        PutBatchResult(int readKB, int writeKB, int numKVPairs, List<Integer> keysPresent) {
            super(InternalOperation.OpCode.PUT_BATCH, readKB, writeKB);
            ObjectUtil.checkNull("keysPresent", keysPresent);
            for (Integer element : keysPresent) {
                ObjectUtil.checkNull("keysPresent element", element);
            }
            this.numKVPairs = numKVPairs;
            this.keysPresent = keysPresent;
        }

        PutBatchResult(InternalOperation.OpCode op, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(op, readKB, writeKB, in, serialVersion);
            int count;
            this.numKVPairs = in.readInt();
            int n = count = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
            if (count == 0) {
                this.keysPresent = Collections.emptyList();
                return;
            }
            this.keysPresent = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                this.keysPresent.add(in.readInt());
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.numKVPairs);
            if (serialVersion >= 14) {
                SerializationUtil.writeNonNullSequenceLength(out, this.keysPresent.size());
            } else {
                out.writeInt(this.keysPresent.size());
            }
            for (int position : this.keysPresent) {
                out.writeInt(position);
            }
        }

        @Override
        public boolean getSuccess() {
            return true;
        }

        public List<Integer> getKeysPresent() {
            return this.keysPresent;
        }

        @Override
        public int getNumRecords() {
            return this.numKVPairs - this.keysPresent.size();
        }
    }

    static class ExecuteResult
    extends Result {
        private final boolean success;
        private final List<Result> successResults;
        private final int failureIndex;
        private final Result failureResult;

        ExecuteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, List<Result> successResults) {
            super(opCode, readKB, writeKB);
            ObjectUtil.checkNull("successResults", successResults);
            for (Result r : successResults) {
                ObjectUtil.checkNull("successResults element", r);
            }
            this.successResults = successResults;
            this.failureIndex = -1;
            this.failureResult = null;
            this.success = true;
        }

        ExecuteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, int failureIndex, Result failureResult) {
            super(opCode, readKB, writeKB);
            ObjectUtil.checkNull("failureResult", failureResult);
            this.failureIndex = failureIndex;
            this.failureResult = failureResult;
            this.successResults = null;
            this.success = false;
        }

        ExecuteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            this.success = in.readBoolean();
            if (this.success) {
                int listSize = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : in.readInt();
                this.successResults = new ArrayList<Result>(listSize);
                for (int i = 0; i < listSize; ++i) {
                    Result result = Result.readFastExternal(in, serialVersion);
                    this.successResults.add(result);
                }
                this.failureIndex = -1;
                this.failureResult = null;
            } else {
                this.failureIndex = in.readInt();
                this.failureResult = Result.readFastExternal(in, serialVersion);
                this.successResults = null;
            }
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeBoolean(this.success);
            if (this.success) {
                if (serialVersion >= 14) {
                    SerializationUtil.writeNonNullCollection(out, serialVersion, this.successResults);
                } else {
                    out.writeInt(this.successResults.size());
                    for (Result result : this.successResults) {
                        result.writeFastExternal(out, serialVersion);
                    }
                }
            } else {
                out.writeInt(this.failureIndex);
                this.failureResult.writeFastExternal(out, serialVersion);
            }
        }

        @Override
        public boolean getSuccess() {
            return this.success;
        }

        @Override
        public OperationExecutionException getExecuteException(List<Operation> ops) {
            if (this.success) {
                return null;
            }
            return new OperationExecutionException(ops.get(this.failureIndex), this.failureIndex, this.failureResult);
        }

        @Override
        public List<OperationResult> getExecuteResult() {
            if (!this.success) {
                return null;
            }
            return Collections.unmodifiableList(this.successResults);
        }

        @Override
        public int getNumRecords() {
            if (!this.success) {
                return 0;
            }
            return this.successResults.size();
        }
    }

    static class NOPResult
    extends Result {
        NOPResult(DataInput in, short serialVersion) {
            super(InternalOperation.OpCode.NOP, 0, 0, in, serialVersion);
        }

        NOPResult() {
            super(InternalOperation.OpCode.NOP, 0, 0);
        }

        @Override
        public boolean getSuccess() {
            return true;
        }

        @Override
        public int getNumRecords() {
            return 0;
        }
    }

    public static abstract class ValueVersionResult
    extends Result {
        private final ResultValue resultValue;
        protected Version version;
        private final long expirationTime;

        ValueVersionResult(InternalOperation.OpCode op, int readKB, int writeKB, ResultValueVersion valueVersion) {
            super(op, readKB, writeKB);
            if (valueVersion != null) {
                this.resultValue = valueVersion.getValueBytes() != null ? new ResultValue(valueVersion.getValueBytes()) : null;
                this.version = valueVersion.getVersion();
                this.expirationTime = valueVersion.getExpirationTime();
            } else {
                this.resultValue = null;
                this.version = null;
                this.expirationTime = 0L;
            }
        }

        ValueVersionResult(InternalOperation.OpCode op, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(op, readKB, writeKB, in, serialVersion);
            this.resultValue = in.readByte() != 0 ? new ResultValue(in, serialVersion) : null;
            this.version = in.readByte() != 0 ? Version.createVersion(in, serialVersion) : null;
            this.expirationTime = ValueVersionResult.readExpirationTime(in, serialVersion);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.resultValue);
            SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.version);
            ValueVersionResult.writeExpirationTime(out, this.expirationTime, serialVersion);
        }

        @Override
        public Value getPreviousValue() {
            return this.resultValue == null ? null : this.resultValue.getValue();
        }

        @Override
        public Version getPreviousVersion() {
            return this.version;
        }

        @Override
        public long getPreviousExpirationTime() {
            return this.expirationTime;
        }
    }

    static class MultiDeleteResult
    extends Result {
        private final int nDeletions;
        private final byte[] resumeKey;

        MultiDeleteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, int nDeletions) {
            this(opCode, readKB, writeKB, nDeletions, null);
        }

        MultiDeleteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, int nDeletions, byte[] resumeKey) {
            super(opCode, readKB, writeKB);
            this.nDeletions = nDeletions;
            this.resumeKey = resumeKey;
        }

        MultiDeleteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            this.nDeletions = in.readInt();
            this.resumeKey = (byte[])(serialVersion >= 16 ? SerializationUtil.readByteArray(in) : null);
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeInt(this.nDeletions);
            if (serialVersion >= 16) {
                SerializationUtil.writeByteArray(out, this.resumeKey);
            }
        }

        @Override
        public int getNDeletions() {
            return this.nDeletions;
        }

        @Override
        public boolean getSuccess() {
            return this.nDeletions > 0;
        }

        @Override
        public int getNumRecords() {
            return this.nDeletions;
        }

        @Override
        public byte[] getPrimaryResumeKey() {
            return this.resumeKey;
        }
    }

    static class DeleteResult
    extends ValueVersionResult {
        private final boolean success;

        DeleteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, ResultValueVersion prevVal, boolean success) {
            super(opCode, readKB, writeKB, prevVal);
            this.success = success;
        }

        DeleteResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            this.success = in.readBoolean();
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            out.writeBoolean(this.success);
        }

        @Override
        public boolean getSuccess() {
            return this.success;
        }
    }

    public static class PutResult
    extends ValueVersionResult {
        private final Version newVersion;
        private final long newExpirationTime;
        private final boolean wasUpdate;

        PutResult(InternalOperation.OpCode opCode, int readKB, int writeKB, ResultValueVersion prevVal, Version version, long expTime, boolean wasUpdate) {
            super(opCode, readKB, writeKB, prevVal);
            this.wasUpdate = wasUpdate;
            this.newVersion = version;
            this.newExpirationTime = expTime;
        }

        PutResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
            this.newVersion = in.readByte() != 0 ? Version.createVersion(in, serialVersion) : null;
            this.newExpirationTime = PutResult.readExpirationTime(in, serialVersion);
            this.wasUpdate = serialVersion >= 18 ? in.readBoolean() : false;
        }

        @Override
        public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
            super.writeFastExternal(out, serialVersion);
            SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.newVersion);
            PutResult.writeExpirationTime(out, this.newExpirationTime, serialVersion);
            if (serialVersion >= 18) {
                out.writeBoolean(this.wasUpdate);
            }
        }

        @Override
        public boolean getSuccess() {
            return this.newVersion != null;
        }

        @Override
        public Version getNewVersion() {
            return this.newVersion;
        }

        @Override
        public long getNewExpirationTime() {
            return this.newExpirationTime;
        }

        public boolean getWasUpdate() {
            return this.wasUpdate;
        }
    }

    public static class GetResult
    extends ValueVersionResult {
        public GetResult(InternalOperation.OpCode opCode, int readKB, int writeKB, ResultValueVersion valueVersion) {
            super(opCode, readKB, writeKB, valueVersion);
        }

        GetResult(InternalOperation.OpCode opCode, int readKB, int writeKB, DataInput in, short serialVersion) throws IOException {
            super(opCode, readKB, writeKB, in, serialVersion);
        }

        @Override
        public boolean getSuccess() {
            return this.getPreviousValue() != null;
        }
    }
}

