/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.BitSet;

public class SortableString {
    private static final char[] BASE_64_DIGITS;
    private static final byte[] LOOKUP_BYTE_64;
    private static final int BASE_128_DIGITS_OFFSET = 48;
    private static final char[] BASE_128_DIGITS;
    private static final short[] LOOKUP_BYTE_128;
    private static final int[] INTEGER_MASK_64;
    private static final int[] INTEGER_MASK_128;
    private static final int[] INTEGER_SIGN_BIT_64;
    private static final int[] INTEGER_SIGN_BIT_128;
    private static final long[] LONG_MASK_64;
    private static final long[] LONG_MASK_128;
    private static final long[] LONG_SIGN_BIT_64;
    private static final long[] LONG_SIGN_BIT_128;
    private static final long SIGN_BIT = Long.MIN_VALUE;
    private static final int SIGN_BIT_32 = Integer.MIN_VALUE;
    private static final int MASK_64 = 63;
    private static final int MASK_128 = 127;
    private static final int BASE_64_SHIFT = 6;
    private static final int BASE_128_SHIFT = 7;
    private static final int LONG_STRING_LEN_64 = 11;
    private static final int LONG_STRING_LEN_128 = 10;
    private static final int INT_STRING_LEN_64 = 6;
    private static final int INT_STRING_LEN_128 = 5;

    private static String toString(long l, int stringLen) {
        char[] buf = new char[stringLen];
        do {
            buf[--stringLen] = BASE_128_DIGITS[(int)(l & 0x7FL)];
            l >>>= 7;
        } while (stringLen > 0);
        return new String(buf);
    }

    private static long fromString(String s) {
        long out = 0L;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '0' || c > LOOKUP_BYTE_128.length + 48 - 1) {
                throw new IllegalArgumentException("Unexpected character found: " + c);
            }
            out <<= 7;
            out ^= (long)LOOKUP_BYTE_128[(short)c];
        }
        return out;
    }

    public static String toSortable(long l) {
        return SortableString.toString(l ^ Long.MIN_VALUE, 10);
    }

    public static String toSortable(long l, int stringLen) {
        return SortableString.toString(l & LONG_MASK_128[stringLen] ^ LONG_SIGN_BIT_128[stringLen], stringLen != 0 ? stringLen : 10);
    }

    public static long longFromSortable(String s) {
        if (s.length() > 10) {
            throw new IllegalArgumentException("Invalid sortable string, length " + s.length());
        }
        long out = SortableString.fromString(s);
        long mask = LONG_MASK_128[s.length()];
        long signBit = LONG_SIGN_BIT_128[s.length()];
        if ((out & signBit) == 0L) {
            out |= mask ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return out ^ signBit;
    }

    public static String toSortable(double d) {
        long tmp = Double.doubleToRawLongBits(d);
        return SortableString.toString(tmp < 0L ? tmp ^ 0xFFFFFFFFFFFFFFFFL : tmp ^ Long.MIN_VALUE, 10);
    }

    public static double doubleFromSortable(String s) {
        long tmp = SortableString.fromString(s);
        tmp = tmp < 0L ? tmp ^ Long.MIN_VALUE : tmp ^ 0xFFFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(tmp);
    }

    public static String toSortable(float f) {
        int tmp = Float.floatToRawIntBits(f);
        return SortableString.toString(tmp < 0 ? (long)(~tmp) : (long)(tmp ^ Integer.MIN_VALUE), 5);
    }

    public static float floatFromSortable(String s) {
        int tmp = (int)SortableString.fromString(s);
        tmp = tmp < 0 ? tmp ^ Integer.MIN_VALUE : ~tmp;
        return Float.intBitsToFloat(tmp);
    }

    public static String toSortable(int i) {
        return SortableString.toString(i ^ Integer.MIN_VALUE, 5);
    }

    public static String toSortable(int i, int stringLen) {
        return SortableString.toString(i & INTEGER_MASK_128[stringLen] ^ INTEGER_SIGN_BIT_128[stringLen], stringLen != 0 ? stringLen : 5);
    }

    public static int intFromSortable(String s) {
        int out = (int)SortableString.fromString(s);
        int mask = INTEGER_MASK_128[s.length()];
        int signBit = INTEGER_SIGN_BIT_128[s.length()];
        if ((out & signBit) == 0) {
            out |= ~mask;
        }
        return out ^ signBit;
    }

    public static String toSortable(byte[] bytes) {
        int nBits = bytes.length * 8;
        int stringLen = (nBits + 7 - 1) / 7;
        char[] buf = new char[stringLen];
        BitSet bs = new BitSet(nBits);
        int bitIdx = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            int j = 0;
            while (j < 8) {
                bs.set(bitIdx, (b & 1 << 7 - j) > 0);
                ++j;
                ++bitIdx;
            }
        }
        int bufIdx = 0;
        int i = 0;
        while (i < bs.length()) {
            int b = 0;
            for (int j = 0; j < 7; ++j) {
                if (!bs.get(i++)) continue;
                b = (byte)(b | 1 << 6 - j);
            }
            buf[bufIdx] = BASE_128_DIGITS[b & 0x7F];
            ++bufIdx;
        }
        while (bufIdx < buf.length) {
            buf[bufIdx++] = BASE_128_DIGITS[0];
        }
        return new String(buf);
    }

    public static byte[] bytesFromSortable(String s) {
        int j;
        byte b;
        int nBits = s.length() * 7;
        int nBytes = nBits / 8;
        byte[] out = new byte[nBytes];
        BitSet bs = new BitSet(nBits);
        int bitIdx = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            b = (byte)LOOKUP_BYTE_128[(short)c];
            for (j = 1; j < 8; ++j) {
                bs.set(bitIdx, (b & 1 << 7 - j) > 0);
                ++bitIdx;
            }
        }
        int i = 0;
        for (int bufIdx = 0; i < bs.length() && bufIdx < out.length; ++bufIdx) {
            b = 0;
            for (j = 0; j < 8; ++j) {
                if (!bs.get(i++)) continue;
                b = (byte)(b | 1 << 7 - j);
            }
            out[bufIdx] = b;
        }
        return out;
    }

    public static int encodingLength(Integer value) {
        if (value == null) {
            return 5;
        }
        if (value == 0) {
            return 1;
        }
        int ret = 0;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                return 5;
            }
            value = -value.intValue();
        }
        if (value < 0x3FFFFFFF) {
            value = value << 1;
        } else {
            return 5;
        }
        while (value != 0) {
            value = value >> 7;
            ++ret;
        }
        return ret;
    }

    public static int encodingLength(Integer min, Integer max) {
        if (min == null) {
            min = Integer.MIN_VALUE;
        }
        if (max == null) {
            max = Integer.MAX_VALUE;
        }
        int larger = max;
        if (min < 0) {
            larger = max <= 0 ? min.intValue() : (max > -min.intValue() ? max : min).intValue();
        }
        return SortableString.encodingLength(larger);
    }

    public static int encodingLength(Long value) {
        if (value == null) {
            return 10;
        }
        if (value == 0L) {
            return 1;
        }
        int ret = 0;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                return 10;
            }
            value = -value.longValue();
        }
        if (value < 0x3FFFFFFFFFFFFFFFL) {
            value = value << 1;
        } else {
            return 10;
        }
        while (value != 0L) {
            value = value >> 7;
            ++ret;
        }
        return ret;
    }

    public static int encodingLength(Long min, Long max) {
        if (min == null) {
            min = Long.MIN_VALUE;
        }
        if (max == null) {
            max = Long.MAX_VALUE;
        }
        long larger = max;
        if (min < 0L) {
            larger = max <= 0L ? min.longValue() : (max > -min.longValue() ? max : min).longValue();
        }
        return SortableString.encodingLength(larger);
    }

    static {
        int i;
        BASE_64_DIGITS = new char[]{'+', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        LOOKUP_BYTE_64 = new byte[123];
        for (i = 0; i < BASE_64_DIGITS.length; ++i) {
            SortableString.LOOKUP_BYTE_64[SortableString.BASE_64_DIGITS[i]] = (byte)i;
        }
        BASE_128_DIGITS = new char[128];
        LOOKUP_BYTE_128 = new short[256];
        for (i = 0; i < BASE_128_DIGITS.length; ++i) {
            SortableString.BASE_128_DIGITS[i] = (char)(i + 48);
            SortableString.LOOKUP_BYTE_128[(short)SortableString.BASE_128_DIGITS[i]] = (short)i;
        }
        INTEGER_MASK_64 = new int[]{-1, 63, 4095, 262143, 0xFFFFFF, 0x3FFFFFFF, -1};
        INTEGER_MASK_128 = new int[]{-1, 127, 16383, 0x1FFFFF, 0xFFFFFFF, -1};
        INTEGER_SIGN_BIT_64 = new int[]{Integer.MIN_VALUE, 32, 2048, 131072, 0x800000, 0x20000000, Integer.MIN_VALUE};
        INTEGER_SIGN_BIT_128 = new int[]{Integer.MIN_VALUE, 64, 8192, 0x100000, 0x8000000, Integer.MIN_VALUE};
        LONG_MASK_64 = new long[]{-1L, 63L, 4095L, 262143L, 0xFFFFFFL, 0x3FFFFFFFL, 0xFFFFFFFFFL, 0x3FFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0x3FFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFFL, -1L};
        LONG_MASK_128 = new long[]{-1L, 127L, 16383L, 0x1FFFFFL, 0xFFFFFFFL, -1L, 0x3FFFFFFFFFFL, 0x1FFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, Long.MAX_VALUE, -1L};
        LONG_SIGN_BIT_64 = new long[]{Long.MIN_VALUE, 32L, 2048L, 131072L, 0x800000L, 0x20000000L, 0x800000000L, 0x20000000000L, 0x800000000000L, 0x20000000000000L, 0x800000000000000L, Long.MIN_VALUE};
        LONG_SIGN_BIT_128 = new long[]{Long.MIN_VALUE, 64L, 8192L, 0x100000L, 0x8000000L, 0x400000000L, 0x20000000000L, 0x1000000000000L, 0x80000000000000L, 0x4000000000000000L, Long.MIN_VALUE};
    }
}

