/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.adapters.jms;

import jakarta.jms.ConnectionFactory;
import jakarta.resource.cci.ConnectionSpec;

public class CciJMSConnectionSpec
implements ConnectionSpec {
    protected String username;
    protected char[] password;
    protected String connectionFactoryURL;
    protected ConnectionFactory connectionFactory;

    public CciJMSConnectionSpec() {
        this.username = "";
        this.password = new char[0];
        this.connectionFactoryURL = "";
        this.connectionFactory = null;
    }

    public CciJMSConnectionSpec(String url) {
        this.username = "";
        this.password = new char[0];
        this.connectionFactoryURL = url;
        this.connectionFactory = null;
    }

    public CciJMSConnectionSpec(ConnectionFactory factory) {
        this.username = "";
        this.password = new char[0];
        this.connectionFactoryURL = "";
        this.connectionFactory = factory;
    }

    public CciJMSConnectionSpec(String url, String name, String pass) {
        this.username = name;
        this.setPassword(pass);
        this.connectionFactoryURL = url;
        this.connectionFactory = null;
    }

    public CciJMSConnectionSpec(ConnectionFactory factory, String name, String pass) {
        this.username = name;
        this.setPassword(pass);
        this.connectionFactoryURL = "";
        this.connectionFactory = factory;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String name) {
        this.username = name;
    }

    public String getPassword() {
        if (this.password != null) {
            return new String(this.password);
        }
        return null;
    }

    public void setPassword(String pass) {
        this.password = (char[])(pass != null ? pass.toCharArray() : null);
    }

    public boolean hasUsername() {
        return this.username != null && this.username.length() > 0;
    }

    public boolean hasConnectionFactoryURL() {
        return this.connectionFactoryURL != null && this.connectionFactoryURL.length() > 0;
    }

    public String getConnectionFactoryURL() {
        return this.connectionFactoryURL;
    }

    public void setConnectionFactoryURL(String jndiName) {
        this.connectionFactoryURL = jndiName;
    }

    public void setConnectionFactory(ConnectionFactory connFactory) {
        this.connectionFactory = connFactory;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }
}

