/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryReadObjectQueryTest
extends CacheExpiryTest {
    protected boolean shouldExpire = false;
    protected Employee employee = null;
    protected String firstName = null;
    protected Employee queriedEmployee = null;
    protected ReadObjectQuery query = null;

    public CacheExpiryReadObjectQueryTest(Employee employee, ReadObjectQuery query, boolean shouldExpire) {
        this.setDescription("Test Cache Expiry a read Object Query.");
        this.employee = employee;
        this.shouldExpire = shouldExpire;
        this.query = query;
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(100000L));
    }

    public void test() {
        Employee readEmployee = (Employee)this.getSession().readObject((Object)this.employee);
        this.firstName = readEmployee.getFirstName();
        Employee mutatedEmployee = (Employee)((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getFromIdentityMap((Object)this.employee);
        mutatedEmployee.setFirstName(this.firstName + "-mutated");
        if (this.shouldExpire) {
            this.getAbstractSession().getIdentityMapAccessor().invalidateObject((Object)mutatedEmployee);
        }
        this.queriedEmployee = (Employee)this.getSession().executeQuery((DatabaseQuery)this.query);
    }

    public void verify() {
        if (this.shouldExpire && !this.firstName.equals(this.queriedEmployee.getFirstName())) {
            throw new TestErrorException("Expiring Read Object Query did not properly expire.  Please ensure this system is not running with a heavy load prior to filing a bug since the cache expiry tests rely to a certain degree on timing.");
        }
        if (!this.shouldExpire && this.firstName.equals(this.queriedEmployee.getFirstName())) {
            throw new TestErrorException("Non-Expiring Read Object Query did not properly cache results.  Please ensure this system is not running with a heavy load prior to filing a bug since the cache expiry tests rely to a certain degree on timing.");
        }
    }
}

