/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.multipletable;

import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class MultipleTableTest
extends AutoVerifyTestCase {
    private Object m_testObject;
    private Exception m_exception;
    private DatabaseSession m_session;

    public MultipleTableTest(Object testObject) {
        this.m_testObject = testObject;
        this.setName("Multiple table test [" + Helper.getShortClassName((Object)this.m_testObject) + "]");
    }

    public void reset() {
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
        this.rollbackTransaction();
    }

    protected void setup() {
        this.m_session = (DatabaseSession)this.getSession();
        this.m_exception = null;
        this.beginTransaction();
        this.m_session.getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void test() {
        try {
            UnitOfWork uow = this.m_session.acquireUnitOfWork();
            uow.registerObject(this.m_testObject);
            uow.commit();
        }
        catch (Exception e) {
            this.m_exception = e;
        }
    }

    protected void verify() {
        if (this.m_exception != null) {
            throw new TestErrorException("An exception was throw when committing the test object [" + this.m_testObject + "]: " + this.m_exception);
        }
        if (this.m_session.readObject(this.m_testObject.getClass()) == null) {
            throw new TestErrorException("The test object was not read back, hence not written to the database");
        }
    }
}

