/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.sessionsxml.RcmBasicTest;

public class RcmWithRmiAndJndiTest
extends RcmBasicTest {
    public RcmWithRmiAndJndiTest() {
        this.sessionsXmlFileName = "org/eclipse/persistence/testing/models/sessionsxml/sessions_rcm_rmi_jndi.xml";
    }

    public void verify() {
        String contextFactory;
        String userName;
        RemoteCommandManager rcm = (RemoteCommandManager)((AbstractSession)this.loadedSession).getCommandManager();
        TransportManager transportMgr = rcm.getTransportManager();
        Vector<String> errors = new Vector<String>();
        if (!rcm.getChannel().equals("new_channel")) {
            errors.add("channel = " + rcm.getChannel());
        }
        if (!((AbstractSession)this.loadedSession).shouldPropagateChanges()) {
            errors.add("cache sync is not enable");
        }
        if (rcm.getTransportManager().shouldRemoveConnectionOnError()) {
            errors.add("remove connection on error");
        }
        if (rcm.shouldPropagateAsynchronously()) {
            errors.add("send mode is asynchronous");
        }
        if (!rcm.getDiscoveryManager().getMulticastGroupAddress().equals("new_address")) {
            errors.add("DM multicast address = " + rcm.getDiscoveryManager().getMulticastGroupAddress());
        }
        if (rcm.getDiscoveryManager().getMulticastPort() != 3333) {
            errors.add("DM multicast port = " + rcm.getDiscoveryManager().getMulticastPort());
        }
        if (rcm.getDiscoveryManager().getAnnouncementDelay() != 1111) {
            errors.add("DM announcement delay = " + rcm.getDiscoveryManager().getAnnouncementDelay());
        }
        if (transportMgr.getNamingServiceType() != 0) {
            errors.add("Naming service type (not JNDI) = " + transportMgr.getNamingServiceType());
        }
        if (!rcm.getUrl().equals("new_jndi_url")) {
            errors.add("Url = " + rcm.getUrl());
        }
        if ((userName = (String)transportMgr.getRemoteContextProperties().get("java.naming.security.principal")) == null || !userName.equals("new_user_name")) {
            errors.add("user name = " + userName);
        }
        String password = (String)transportMgr.getRemoteContextProperties().get("java.naming.security.credentials");
        password = new SecurableObjectHolder().getSecurableObject().decryptPassword(password);
        if (password == null || !password.equals("new_password")) {
            errors.add("password = " + password);
        }
        if ((contextFactory = (String)transportMgr.getRemoteContextProperties().get("java.naming.factory.initial")) == null || !contextFactory.equals("new_initial_context_factory_name")) {
            errors.add("initial context factory name = " + contextFactory);
        }
        String propertyValue1 = (String)transportMgr.getRemoteContextProperties().get("name1");
        String propertyValue2 = (String)transportMgr.getRemoteContextProperties().get("name2");
        if (propertyValue1 == null || !propertyValue1.equals("value1")) {
            errors.add("extra property name =  name1, value = " + propertyValue1);
        }
        if (propertyValue2 == null || !propertyValue2.equals("value2")) {
            errors.add("extra property name =  name2, value = " + propertyValue2);
        }
        if (!errors.isEmpty()) {
            String errorString = "The following RCM elements's value do not match their expected values:";
            Enumeration enumtr = errors.elements();
            while (enumtr.hasMoreElements()) {
                errorString = errorString + "\n   " + enumtr.nextElement();
            }
            throw new TestErrorException(errorString);
        }
    }
}

