/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.StringRangeValue;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.StringDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
public class StringDefImpl
extends FieldDefImpl
implements StringDef {
    private static final long serialVersionUID = 1L;
    private String min;
    private String max;
    private Boolean minInclusive;
    private Boolean maxInclusive;

    StringDefImpl(String description, String min, String max, Boolean minInclusive, Boolean maxInclusive) {
        super(FieldDef.Type.STRING, description);
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        this.validate();
    }

    StringDefImpl(String description) {
        this(description, null, null, null, null);
    }

    StringDefImpl() {
        super(FieldDef.Type.STRING);
        this.min = null;
        this.max = null;
        this.minInclusive = null;
        this.maxInclusive = null;
    }

    private StringDefImpl(StringDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
        this.minInclusive = impl.minInclusive;
        this.maxInclusive = impl.maxInclusive;
    }

    @Override
    public StringDefImpl clone() {
        if (this == FieldDefImpl.stringDef) {
            return this;
        }
        return new StringDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof StringDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public StringDef asString() {
        return this;
    }

    @Override
    public StringValueImpl createString(String value) {
        return this.hasMin() || this.hasMax() ? new StringRangeValue(value, this) : new StringValueImpl(value);
    }

    @Override
    public String getMin() {
        return this.min;
    }

    @Override
    public String getMax() {
        return this.max;
    }

    @Override
    public boolean isMinInclusive() {
        return this.minInclusive != null ? this.minInclusive : true;
    }

    @Override
    public boolean isMaxInclusive() {
        return this.maxInclusive != null ? this.maxInclusive : true;
    }

    @Override
    public boolean hasMin() {
        return this.min != null;
    }

    @Override
    public boolean hasMax() {
        return this.max != null;
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isString() || superType.isAny() || superType.isAnyJsonAtomic() || superType.isAnyAtomic() || superType.isJson();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
            node.put("min_inclusive", this.minInclusive);
        }
        if (this.max != null) {
            node.put("max", this.max);
            node.put("max_inclusive", this.maxInclusive);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isTextual()) {
            throw new IllegalArgumentException("Default value for type STRING is not a string");
        }
        return this.createString(node.asText());
    }

    @Override
    public short getRequiredSerialVersion() {
        return 4;
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min.compareTo(this.max) > 0) {
            throw new IllegalArgumentException("Invalid min or max value");
        }
    }

    void validateValue(String val) {
        if (val == null) {
            throw new IllegalArgumentException("String values cannot be null");
        }
        if (this.min != null && (this.isMinInclusive() && this.min.compareTo(val) > 0 || !this.isMinInclusive() && this.min.compareTo(val) >= 0) || this.max != null && (this.isMaxInclusive() && this.max.compareTo(val) < 0 || !this.isMaxInclusive() && this.max.compareTo(val) <= 0)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            if (this.min != null && this.isMinInclusive()) {
                sb.append("[");
            } else {
                sb.append("(");
            }
            if (this.min != null) {
                sb.append(this.min);
            } else {
                sb.append("-INF");
            }
            if (this.max != null) {
                sb.append(this.max);
            } else {
                sb.append("+INF");
            }
            if (this.max != null && this.isMaxInclusive()) {
                sb.append("]");
            } else {
                sb.append(")");
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

