/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async;

import java.util.HashMap;
import java.util.Map;
import oracle.kv.impl.async.AsyncOption;
import oracle.kv.impl.security.ssl.SSLControl;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.util.ObjectUtil;

public class EndpointConfig {
    private final Map<AsyncOption<?>, Object> options = new HashMap();
    private final Map<AsyncOption<?>, Object> optionDefaults = new HashMap();
    private final SSLControl sslControl;
    private final Object configId;

    EndpointConfig(Map<AsyncOption<?>, Object> options, Map<AsyncOption<?>, Object> optionDefaults, SSLControl sslControl, Object configId) {
        ObjectUtil.checkNull("options", options);
        ObjectUtil.checkNull("optionDefaults", optionDefaults);
        this.options.putAll(options);
        this.optionDefaults.putAll(optionDefaults);
        if (TestStatus.isActive()) {
            this.optionDefaults.put(AsyncOption.SO_REUSEADDR, true);
        }
        this.sslControl = sslControl;
        this.configId = configId;
    }

    public <T> T getOption(AsyncOption<T> option) {
        if (!this.optionDefaults.containsKey(option)) {
            throw new IllegalArgumentException(String.format("Not a suitable option for endpoint: %s", option));
        }
        Object value = this.options.get(option);
        if (value == null) {
            value = this.optionDefaults.get(option);
        }
        return option.type().cast(value);
    }

    public SSLControl getSSLControl() {
        return this.sslControl;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EndpointConfig)) {
            return false;
        }
        EndpointConfig that = (EndpointConfig)obj;
        return this.options.equals(that.options) && this.optionDefaults.equals(that.optionDefaults) && ObjectUtil.safeEquals(this.sslControl, that.sslControl) && ObjectUtil.safeEquals(this.configId, that.configId);
    }

    public int hashCode() {
        int prime = 31;
        int hash = this.options.hashCode();
        hash = prime * hash + this.optionDefaults.hashCode();
        hash = this.sslControl == null ? hash : prime * hash + this.sslControl.hashCode();
        hash = this.configId == null ? hash : prime * hash + this.configId.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("EndpointConfig[%s%s%s]", this.options, this.sslControl == null ? "" : " sslControl=" + this.sslControl, this.configId == null ? "" : " configId=" + this.configId);
    }
}

