/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.impl.query.types.ExprType;
import oracle.kv.impl.query.types.TypeManager;

class ExprConst
extends Expr {
    private FieldValueImpl theValue;

    ExprConst(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, FieldValueImpl value) {
        super(qcb, sctx, Expr.ExprKind.CONST, location);
        this.setValue(value);
    }

    ExprConst(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, boolean value) {
        super(qcb, sctx, Expr.ExprKind.CONST, location);
        this.setValue(FieldDefImpl.booleanDef.createBoolean(value));
    }

    ExprConst(QueryControlBlock qcb, StaticContext sctx, QueryException.Location location, double value) {
        super(qcb, sctx, Expr.ExprKind.CONST, location);
        this.setValue(FieldDefImpl.doubleDef.createDouble(value));
    }

    @Override
    int getNumChildren() {
        return 0;
    }

    FieldValueImpl getValue() {
        return this.theValue;
    }

    void setValue(FieldValueImpl val) {
        this.theValue = val;
        if (!val.isNull()) {
            this.setType(TypeManager.createValueType(val));
        }
    }

    @Override
    ExprType computeType() {
        return this.getTypeInternal();
    }

    @Override
    public boolean mayReturnNULL() {
        return this.theValue.isNull();
    }

    @Override
    void display(StringBuilder sb, QueryFormatter formatter) {
        formatter.indent(sb);
        sb.append((Object)this.theKind);
        sb.append("[");
        this.displayContent(sb, formatter);
        sb.append("]");
    }

    @Override
    void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theValue.toStringBuilder(sb);
    }
}

